"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .individualnameupdate import IndividualNameUpdate, IndividualNameUpdateTypedDict
from moovio_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
import pydantic
from pydantic import model_serializer
from typing import Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class PhoneTypedDict(TypedDict):
    number: NotRequired[str]
    country_code: NotRequired[str]


class Phone(BaseModel):
    number: Optional[str] = None

    country_code: Annotated[Optional[str], pydantic.Field(alias="countryCode")] = None


class TwoTypedDict(TypedDict):
    pass


class Two(BaseModel):
    pass


EmailTypedDict = TypeAliasType("EmailTypedDict", Union[TwoTypedDict, str])


Email = TypeAliasType("Email", Union[Two, str])


class UpdateRepresentativeAddressTypedDict(TypedDict):
    address_line1: NotRequired[str]
    address_line2: NotRequired[str]
    city: NotRequired[str]
    state_or_province: NotRequired[str]
    postal_code: NotRequired[str]
    country: NotRequired[str]


class UpdateRepresentativeAddress(BaseModel):
    address_line1: Annotated[Optional[str], pydantic.Field(alias="addressLine1")] = None

    address_line2: Annotated[Optional[str], pydantic.Field(alias="addressLine2")] = None

    city: Optional[str] = None

    state_or_province: Annotated[
        Optional[str], pydantic.Field(alias="stateOrProvince")
    ] = None

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None

    country: Optional[str] = None


class UpdateRepresentativeBirthDateTypedDict(TypedDict):
    day: NotRequired[int]
    month: NotRequired[int]
    year: NotRequired[int]


class UpdateRepresentativeBirthDate(BaseModel):
    day: Optional[int] = None

    month: Optional[int] = None

    year: Optional[int] = None


class UpdateRepresentativeSsnTypedDict(TypedDict):
    full: NotRequired[str]
    last_four: NotRequired[str]


class UpdateRepresentativeSsn(BaseModel):
    full: Optional[str] = None

    last_four: Annotated[Optional[str], pydantic.Field(alias="lastFour")] = None


class UpdateRepresentativeItinTypedDict(TypedDict):
    full: NotRequired[str]
    last_four: NotRequired[str]


class UpdateRepresentativeItin(BaseModel):
    full: Optional[str] = None

    last_four: Annotated[Optional[str], pydantic.Field(alias="lastFour")] = None


class UpdateRepresentativeGovernmentIDTypedDict(TypedDict):
    ssn: NotRequired[UpdateRepresentativeSsnTypedDict]
    itin: NotRequired[UpdateRepresentativeItinTypedDict]


class UpdateRepresentativeGovernmentID(BaseModel):
    ssn: Optional[UpdateRepresentativeSsn] = None

    itin: Optional[UpdateRepresentativeItin] = None


class ResponsibilitiesTypedDict(TypedDict):
    r"""Describes the job responsibilities of a business representative."""

    is_controller: NotRequired[bool]
    r"""Indicates whether this individual has significant management responsibilities within the business."""
    is_owner: NotRequired[bool]
    r"""If `true`, this field indicates that the individual has a business ownership stake of at least 25% in the
    business. If the representative does not own at least 25% of the business, this field should be `false`.
    """
    ownership_percentage: NotRequired[int]
    r"""The percentage of ownership this individual has in the business (required if `isOwner` is `true`)."""
    job_title: NotRequired[str]


class Responsibilities(BaseModel):
    r"""Describes the job responsibilities of a business representative."""

    is_controller: Annotated[Optional[bool], pydantic.Field(alias="isController")] = (
        None
    )
    r"""Indicates whether this individual has significant management responsibilities within the business."""

    is_owner: Annotated[Optional[bool], pydantic.Field(alias="isOwner")] = None
    r"""If `true`, this field indicates that the individual has a business ownership stake of at least 25% in the
    business. If the representative does not own at least 25% of the business, this field should be `false`.
    """

    ownership_percentage: Annotated[
        Optional[int], pydantic.Field(alias="ownershipPercentage")
    ] = None
    r"""The percentage of ownership this individual has in the business (required if `isOwner` is `true`)."""

    job_title: Annotated[Optional[str], pydantic.Field(alias="jobTitle")] = None


class UpdateRepresentativeTypedDict(TypedDict):
    name: NotRequired[IndividualNameUpdateTypedDict]
    phone: NotRequired[Nullable[PhoneTypedDict]]
    email: NotRequired[Nullable[EmailTypedDict]]
    address: NotRequired[Nullable[UpdateRepresentativeAddressTypedDict]]
    birth_date: NotRequired[Nullable[UpdateRepresentativeBirthDateTypedDict]]
    government_id: NotRequired[Nullable[UpdateRepresentativeGovernmentIDTypedDict]]
    responsibilities: NotRequired[Nullable[ResponsibilitiesTypedDict]]


class UpdateRepresentative(BaseModel):
    name: Optional[IndividualNameUpdate] = None

    phone: OptionalNullable[Phone] = UNSET

    email: OptionalNullable[Email] = UNSET

    address: OptionalNullable[UpdateRepresentativeAddress] = UNSET

    birth_date: Annotated[
        OptionalNullable[UpdateRepresentativeBirthDate],
        pydantic.Field(alias="birthDate"),
    ] = UNSET

    government_id: Annotated[
        OptionalNullable[UpdateRepresentativeGovernmentID],
        pydantic.Field(alias="governmentID"),
    ] = UNSET

    responsibilities: OptionalNullable[Responsibilities] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "phone",
            "email",
            "address",
            "birthDate",
            "governmentID",
            "responsibilities",
        ]
        nullable_fields = [
            "phone",
            "email",
            "address",
            "birthDate",
            "governmentID",
            "responsibilities",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
