"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
from datetime import datetime
import httpx
from moovio_sdk.models.components import (
    amount as components_amount,
    cancellation as components_cancellation,
    cardacquiringdispute as components_cardacquiringdispute,
    cardacquiringrefund as components_cardacquiringrefund,
    facilitatorfee as components_facilitatorfee,
    moovfee as components_moovfee,
    moovfeedetails as components_moovfeedetails,
    transferdestination as components_transferdestination,
    transferfailurereason as components_transferfailurereason,
    transferlineitems as components_transferlineitems,
    transfersource as components_transfersource,
    transferstatus as components_transferstatus,
)
from moovio_sdk.models.errors import MoovError
from moovio_sdk.types import BaseModel
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated


class TransferData(BaseModel):
    transfer_id: Annotated[str, pydantic.Field(alias="transferID")]

    created_on: Annotated[datetime, pydantic.Field(alias="createdOn")]

    source: components_transfersource.TransferSource

    destination: components_transferdestination.TransferDestination

    status: components_transferstatus.TransferStatus
    r"""Status of a transfer."""

    amount: components_amount.Amount

    completed_on: Annotated[Optional[datetime], pydantic.Field(alias="completedOn")] = (
        None
    )

    failure_reason: Annotated[
        Optional[components_transferfailurereason.TransferFailureReason],
        pydantic.Field(alias="failureReason"),
    ] = None
    r"""Reason for a transfer's failure."""

    description: Optional[str] = None
    r"""An optional description of the transfer that is used on receipts and for your own internal use."""

    metadata: Optional[Dict[str, str]] = None
    r"""Free-form key-value pair list. Useful for storing information that is not captured elsewhere."""

    facilitator_fee: Annotated[
        Optional[components_facilitatorfee.FacilitatorFee],
        pydantic.Field(alias="facilitatorFee"),
    ] = None
    r"""Total or markup fee."""

    moov_fee: Annotated[Optional[int], pydantic.Field(alias="moovFee")] = None
    r"""Fees charged to your platform account for transfers."""

    moov_fee_decimal: Annotated[
        Optional[str], pydantic.Field(alias="moovFeeDecimal")
    ] = None
    r"""Same as `moovFee`, but a decimal-formatted numerical string that represents up to 9 decimal place precision."""

    moov_fee_details: Annotated[
        Optional[components_moovfeedetails.MoovFeeDetails],
        pydantic.Field(alias="moovFeeDetails"),
    ] = None
    r"""Processing and pass-through costs that add up to the moovFee."""

    moov_fees: Annotated[
        Optional[List[components_moovfee.MoovFee]], pydantic.Field(alias="moovFees")
    ] = None
    r"""Fees charged to accounts involved in the transfer."""

    group_id: Annotated[Optional[str], pydantic.Field(alias="groupID")] = None

    cancellations: Optional[List[components_cancellation.Cancellation]] = None

    refunded_amount: Annotated[
        Optional[components_amount.Amount], pydantic.Field(alias="refundedAmount")
    ] = None

    refunds: Optional[List[components_cardacquiringrefund.CardAcquiringRefund]] = None

    disputed_amount: Annotated[
        Optional[components_amount.Amount], pydantic.Field(alias="disputedAmount")
    ] = None

    disputes: Optional[List[components_cardacquiringdispute.CardAcquiringDispute]] = (
        None
    )

    sweep_id: Annotated[Optional[str], pydantic.Field(alias="sweepID")] = None
    r"""ID of the sweep that created this transfer."""

    schedule_id: Annotated[Optional[str], pydantic.Field(alias="scheduleID")] = None

    occurrence_id: Annotated[Optional[str], pydantic.Field(alias="occurrenceID")] = None

    payment_link_code: Annotated[
        Optional[str], pydantic.Field(alias="paymentLinkCode")
    ] = None

    sales_tax_amount: Annotated[
        Optional[components_amount.Amount], pydantic.Field(alias="salesTaxAmount")
    ] = None
    r"""Optional sales tax amount. `transfer.amount.value` should be inclusive of any sales tax and represents the total amount charged."""

    foreign_id: Annotated[Optional[str], pydantic.Field(alias="foreignID")] = None
    r"""Optional alias from a foreign/external system which can be used to reference this resource."""

    line_items: Annotated[
        Optional[components_transferlineitems.TransferLineItems],
        pydantic.Field(alias="lineItems"),
    ] = None
    r"""An optional collection of line items for a transfer.
    When line items are provided, their total plus sales tax must equal the transfer amount.
    """


@dataclass(unsafe_hash=True)
class Transfer(MoovError):
    r"""Details of a Transfer."""

    data: TransferData = field(hash=False)

    def __init__(
        self,
        data: TransferData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
