"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetPublicImageRequestTypedDict(TypedDict):
    public_id: str
    if_none_match: NotRequired[str]
    size: NotRequired[str]
    r"""Optional parameter to request a resized version of the image (WxH).

    If either dimension is 0, the image will be scaled proportionally based on
    the non-zero dimension. Dimensions are capped at 2048 pixels. A default size
    of 400x400 will be used if this parameter is omitted.
    """


class GetPublicImageRequest(BaseModel):
    public_id: Annotated[
        str,
        pydantic.Field(alias="publicID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    if_none_match: Annotated[
        Optional[str],
        pydantic.Field(alias="if-none-match"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None

    size: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = "400x400"
    r"""Optional parameter to request a resized version of the image (WxH).

    If either dimension is 0, the image will be scaled proportionally based on
    the non-zero dimension. Dimensions are capped at 2048 pixels. A default size
    of 400x400 will be used if this parameter is omitted.
    """


GetPublicImageResponseResultTypedDict = TypeAliasType(
    "GetPublicImageResponseResultTypedDict",
    Union[httpx.Response, httpx.Response, httpx.Response],
)


GetPublicImageResponseResult = TypeAliasType(
    "GetPublicImageResponseResult",
    Union[httpx.Response, httpx.Response, httpx.Response],
)


class GetPublicImageResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: GetPublicImageResponseResultTypedDict


class GetPublicImageResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: GetPublicImageResponseResult
