"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from moovio_sdk.models.components import statement as components_statement
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata, HeaderMetadata, PathParamMetadata
import pydantic
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetStatementGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class GetStatementGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Moov-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class GetStatementRequestTypedDict(TypedDict):
    account_id: str
    statement_id: str


class GetStatementRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    statement_id: Annotated[
        str,
        pydantic.Field(alias="statementID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]


GetStatementResponseResultTypedDict = TypeAliasType(
    "GetStatementResponseResultTypedDict",
    Union[components_statement.StatementTypedDict, httpx.Response],
)


GetStatementResponseResult = TypeAliasType(
    "GetStatementResponseResult", Union[components_statement.Statement, httpx.Response]
)


class GetStatementResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: GetStatementResponseResultTypedDict


class GetStatementResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: GetStatementResponseResult
