"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import (
    termsofservicetoken as components_termsofservicetoken,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import FieldMetadata, HeaderMetadata
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetTermsOfServiceTokenGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class GetTermsOfServiceTokenGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Moov-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class GetTermsOfServiceTokenRequestTypedDict(TypedDict):
    origin: NotRequired[str]
    r"""Indicates the domain from which the request originated. Required if referer header is not present."""
    referer: NotRequired[str]
    r"""Specifies the URL of the resource from which the request originated. Required if origin header is not present."""


class GetTermsOfServiceTokenRequest(BaseModel):
    origin: Annotated[
        Optional[str],
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Indicates the domain from which the request originated. Required if referer header is not present."""

    referer: Annotated[
        Optional[str],
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specifies the URL of the resource from which the request originated. Required if origin header is not present."""


class GetTermsOfServiceTokenResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: components_termsofservicetoken.TermsOfServiceTokenTypedDict


class GetTermsOfServiceTokenResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: components_termsofservicetoken.TermsOfServiceToken
