"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import (
    cardacquiringrefund as components_cardacquiringrefund,
    createrefund as components_createrefund,
    createrefundresponse as components_createrefundresponse,
    transferwaitfor as components_transferwaitfor,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class InitiateRefundGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class InitiateRefundGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Moov-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class InitiateRefundRequestTypedDict(TypedDict):
    x_idempotency_key: str
    r"""Prevents duplicate refunds from being created."""
    account_id: str
    r"""The merchant's Moov account ID."""
    transfer_id: str
    r"""Identifier for the transfer."""
    x_wait_for: NotRequired[components_transferwaitfor.TransferWaitFor]
    r"""Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an
    asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
    """
    create_refund: NotRequired[components_createrefund.CreateRefundTypedDict]


class InitiateRefundRequest(BaseModel):
    x_idempotency_key: Annotated[
        str,
        pydantic.Field(alias="x-idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ]
    r"""Prevents duplicate refunds from being created."""

    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The merchant's Moov account ID."""

    transfer_id: Annotated[
        str,
        pydantic.Field(alias="transferID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Identifier for the transfer."""

    x_wait_for: Annotated[
        Optional[components_transferwaitfor.TransferWaitFor],
        pydantic.Field(alias="x-wait-for"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Optional header that indicates whether to return a synchronous response that includes full transfer and rail-specific details or an
    asynchronous response indicating the transfer was created (this is the default response if the header is omitted). A timeout will occur after 15 seconds.
    """

    create_refund: Annotated[
        Optional[components_createrefund.CreateRefund],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


InitiateRefundResponseResultTypedDict = TypeAliasType(
    "InitiateRefundResponseResultTypedDict",
    Union[
        components_cardacquiringrefund.CardAcquiringRefundTypedDict,
        components_createrefundresponse.CreateRefundResponseTypedDict,
    ],
)


InitiateRefundResponseResult = TypeAliasType(
    "InitiateRefundResponseResult",
    Union[
        components_cardacquiringrefund.CardAcquiringRefund,
        components_createrefundresponse.CreateRefundResponse,
    ],
)


class InitiateRefundResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: InitiateRefundResponseResultTypedDict


class InitiateRefundResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: InitiateRefundResponseResult
