"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from moovio_sdk.models.components import (
    dispute as components_dispute,
    disputestatus as components_disputestatus,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListDisputesGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListDisputesGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Moov-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListDisputesRequestTypedDict(TypedDict):
    account_id: str
    skip: NotRequired[int]
    count: NotRequired[int]
    start_date_time: NotRequired[datetime]
    r"""Optional date-time parameter to filter all disputes created on and after the provided date and time."""
    end_date_time: NotRequired[datetime]
    r"""Optional date-time parameter to filter all disputes created on and before the provided date and time."""
    respond_start_date_time: NotRequired[datetime]
    r"""Optional date-time which exclusively filters all disputes with respond by before this date-time."""
    respond_end_date_time: NotRequired[datetime]
    r"""Optional date-time which exclusively filters all disputes with respond by before this date-time."""
    status: NotRequired[components_disputestatus.DisputeStatus]
    r"""Optional dispute status by which to filter the disputes."""
    merchant_account_id: NotRequired[str]
    r"""Optional parameter to filter by merchant account ID."""
    cardholder_account_id: NotRequired[str]
    r"""Optional parameter to filter by cardholder account ID."""
    dispute_i_ds: NotRequired[List[str]]
    r"""Optional parameter to filter by a comma separated list of dispute IDs."""
    transfer_i_ds: NotRequired[List[str]]
    r"""Optional parameter to filter by a comma separated list of transfer IDs."""
    order_by: NotRequired[str]


class ListDisputesRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    skip: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    count: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    start_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="startDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time parameter to filter all disputes created on and after the provided date and time."""

    end_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="endDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time parameter to filter all disputes created on and before the provided date and time."""

    respond_start_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="respondStartDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which exclusively filters all disputes with respond by before this date-time."""

    respond_end_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="respondEndDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which exclusively filters all disputes with respond by before this date-time."""

    status: Annotated[
        Optional[components_disputestatus.DisputeStatus],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional dispute status by which to filter the disputes."""

    merchant_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="merchantAccountID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional parameter to filter by merchant account ID."""

    cardholder_account_id: Annotated[
        Optional[str],
        pydantic.Field(alias="cardholderAccountID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional parameter to filter by cardholder account ID."""

    dispute_i_ds: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="disputeIDs"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional parameter to filter by a comma separated list of dispute IDs."""

    transfer_i_ds: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="transferIDs"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional parameter to filter by a comma separated list of transfer IDs."""

    order_by: Annotated[
        Optional[str],
        pydantic.Field(alias="orderBy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None


class ListDisputesResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: List[components_dispute.DisputeTypedDict]


class ListDisputesResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: List[components_dispute.Dispute]
