"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import (
    feeplanagreement as components_feeplanagreement,
    feeplanagreementstatus as components_feeplanagreementstatus,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListFeePlanAgreementsGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListFeePlanAgreementsGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Moov-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListFeePlanAgreementsRequestTypedDict(TypedDict):
    account_id: str
    skip: NotRequired[int]
    count: NotRequired[int]
    agreement_id: NotRequired[List[str]]
    r"""A comma-separated list of agreement IDs to filter the results by."""
    status: NotRequired[List[components_feeplanagreementstatus.FeePlanAgreementStatus]]
    r"""A comma-separated list of statuses to filter the results by."""


class ListFeePlanAgreementsRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    skip: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    count: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    agreement_id: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="agreementID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""A comma-separated list of agreement IDs to filter the results by."""

    status: Annotated[
        Optional[List[components_feeplanagreementstatus.FeePlanAgreementStatus]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""A comma-separated list of statuses to filter the results by."""


class ListFeePlanAgreementsResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: List[components_feeplanagreement.FeePlanAgreementTypedDict]


class ListFeePlanAgreementsResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: List[components_feeplanagreement.FeePlanAgreement]
