"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import incurredfee as components_incurredfee
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListFeeRevenueGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListFeeRevenueGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Moov-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListFeeRevenueRequestTypedDict(TypedDict):
    account_id: str
    r"""The Partner's AccountID."""
    skip: NotRequired[int]
    count: NotRequired[int]
    start_date_time: NotRequired[str]
    r"""Optional date-time to inclusively filter all fees created after this date-time."""
    end_date_time: NotRequired[str]
    r"""Optional date-time to exclusively filter all fees created before this date-time."""


class ListFeeRevenueRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The Partner's AccountID."""

    skip: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    count: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    start_date_time: Annotated[
        Optional[str],
        pydantic.Field(alias="startDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time to inclusively filter all fees created after this date-time."""

    end_date_time: Annotated[
        Optional[str],
        pydantic.Field(alias="endDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time to exclusively filter all fees created before this date-time."""


class ListFeeRevenueResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: List[components_incurredfee.IncurredFeeTypedDict]


class ListFeeRevenueResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: List[components_incurredfee.IncurredFee]
