"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from moovio_sdk.models.components import (
    issuedcardtransaction as components_issuedcardtransaction,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListIssuedCardTransactionsGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListIssuedCardTransactionsGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Moov-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListIssuedCardTransactionsRequestTypedDict(TypedDict):
    account_id: str
    r"""The Moov business account for which cards have been issued."""
    skip: NotRequired[int]
    count: NotRequired[int]
    issued_card_id: NotRequired[str]
    r"""Optional ID of the issued card to filter results."""
    start_date_time: NotRequired[datetime]
    r"""Optional date-time which inclusively filters all card transactions created after this date-time."""
    end_date_time: NotRequired[datetime]
    r"""Optional date-time which exclusively filters all card transactions created before this date-time."""


class ListIssuedCardTransactionsRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""The Moov business account for which cards have been issued."""

    skip: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    count: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    issued_card_id: Annotated[
        Optional[str],
        pydantic.Field(alias="issuedCardID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional ID of the issued card to filter results."""

    start_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="startDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which inclusively filters all card transactions created after this date-time."""

    end_date_time: Annotated[
        Optional[datetime],
        pydantic.Field(alias="endDateTime"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
    r"""Optional date-time which exclusively filters all card transactions created before this date-time."""


class ListIssuedCardTransactionsResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: List[components_issuedcardtransaction.IssuedCardTransactionTypedDict]


class ListIssuedCardTransactionsResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: List[components_issuedcardtransaction.IssuedCardTransaction]
