"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import (
    itemlistnextpage as components_itemlistnextpage,
    ticket as components_ticket,
    ticketstatus as components_ticketstatus,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    QueryParamMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListTicketsGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListTicketsGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Moov-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class ListTicketsRequestTypedDict(TypedDict):
    account_id: str
    cursor: NotRequired[str]
    count: NotRequired[int]
    status: NotRequired[components_ticketstatus.TicketStatus]
    foreign_id: NotRequired[str]


class ListTicketsRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    count: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    status: Annotated[
        Optional[components_ticketstatus.TicketStatus],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    foreign_id: Annotated[
        Optional[str],
        pydantic.Field(alias="foreignID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None


class ListTicketsResponseBodyTypedDict(TypedDict):
    r"""A paginated list of items. The `nextPage` field is omitted if there are no more pages available."""

    items: List[components_ticket.TicketTypedDict]
    next_page: NotRequired[components_itemlistnextpage.ItemListNextPageTypedDict]


class ListTicketsResponseBody(BaseModel):
    r"""A paginated list of items. The `nextPage` field is omitted if there are no more pages available."""

    items: List[components_ticket.Ticket]

    next_page: Annotated[
        Optional[components_itemlistnextpage.ItemListNextPage],
        pydantic.Field(alias="nextPage"),
    ] = None


class ListTicketsResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: ListTicketsResponseBodyTypedDict


class ListTicketsResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: ListTicketsResponseBody
