"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from moovio_sdk.models.components import (
    patchsweepconfig as components_patchsweepconfig,
    sweepconfig as components_sweepconfig,
)
from moovio_sdk.types import BaseModel
from moovio_sdk.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateSweepConfigGlobalsTypedDict(TypedDict):
    x_moov_version: NotRequired[str]
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class UpdateSweepConfigGlobals(BaseModel):
    x_moov_version: Annotated[
        Optional[str],
        pydantic.Field(alias="X-Moov-Version"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""Specify an API version.

    API versioning follows the format `vYYYY.QQ.BB`, where
    - `YYYY` is the year
    - `QQ` is the two-digit month for the first month of the quarter (e.g., 01, 04, 07, 10)
    - `BB` is the build number, starting at `.01`, for subsequent builds in the same quarter.
    - For example, `v2024.01.00` is the initial release of the first quarter of 2024.

    The `latest` version represents the most recent development state. It may include breaking changes and should be treated as a beta release.
    When no version is specified, the API defaults to `v2024.01.00`.
    """


class UpdateSweepConfigRequestTypedDict(TypedDict):
    account_id: str
    sweep_config_id: str
    patch_sweep_config: components_patchsweepconfig.PatchSweepConfigTypedDict


class UpdateSweepConfigRequest(BaseModel):
    account_id: Annotated[
        str,
        pydantic.Field(alias="accountID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    sweep_config_id: Annotated[
        str,
        pydantic.Field(alias="sweepConfigID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    patch_sweep_config: Annotated[
        components_patchsweepconfig.PatchSweepConfig,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdateSweepConfigResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: components_sweepconfig.SweepConfigTypedDict


class UpdateSweepConfigResponse(BaseModel):
    headers: Dict[str, List[str]]

    result: components_sweepconfig.SweepConfig
