# Generated by Django 3.0.8 on 2020-09-01 11:34

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_celery_beat.validators
import django_opstasks.models
import timezone_field.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ClockedSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('clocked_time', models.DateTimeField(help_text='在指定时间运行任务.', verbose_name='Clock Time')),
                ('enabled', models.BooleanField(default=True, editable=False, help_text='设置为False后不进行任务调度.', verbose_name='ENABLED')),
            ],
            options={
                'verbose_name': 'clocked',
                'verbose_name_plural': 'clocked',
                'db_table': 'tasks_clocked_schedule',
                'ordering': ['clocked_time'],
            },
        ),
        migrations.CreateModel(
            name='CrontabSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('minute', models.CharField(default='*', max_length=240, validators=[django_celery_beat.validators.minute_validator], verbose_name='Minutes')),
                ('hour', models.CharField(default='*', max_length=96, validators=[django_celery_beat.validators.hour_validator], verbose_name='Hours')),
                ('day_of_week', models.CharField(default='*', max_length=64, validators=[django_celery_beat.validators.day_of_week_validator], verbose_name='Days Of The Week')),
                ('day_of_month', models.CharField(default='*', max_length=124, validators=[django_celery_beat.validators.day_of_month_validator], verbose_name='Days Of The Month')),
                ('month_of_year', models.CharField(default='*', max_length=64, validators=[django_celery_beat.validators.month_of_year_validator], verbose_name='Months Of The Year')),
                ('timezone', timezone_field.fields.TimeZoneField(default='UTC', verbose_name='Timezone')),
            ],
            options={
                'verbose_name': 'crontab',
                'verbose_name_plural': 'crontabs',
                'db_table': 'tasks_crontab_schedule',
                'ordering': ['month_of_year', 'day_of_month', 'day_of_week', 'hour', 'minute', 'timezone'],
            },
        ),
        migrations.CreateModel(
            name='IntervalSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('every', models.IntegerField(help_text='再次运行任务之前要等待的间隔时间', validators=[django.core.validators.MinValueValidator(1)], verbose_name='间隔时间')),
                ('period', models.CharField(choices=[('days', '天'), ('hours', '小时'), ('minutes', '分钟'), ('seconds', '秒'), ('microseconds', '毫秒')], max_length=24, verbose_name='时间单位')),
            ],
            options={
                'verbose_name': 'interval',
                'verbose_name_plural': 'intervals',
                'db_table': 'tasks_interval_schedule',
                'ordering': ['period', 'every'],
                'unique_together': {('period', 'every')},
            },
        ),
        migrations.CreateModel(
            name='PeriodicTasks',
            fields=[
                ('ident', models.SmallIntegerField(default=1, primary_key=True, serialize=False, unique=True)),
                ('last_update', models.DateTimeField()),
            ],
            options={
                'db_table': 'tasks_periodic_tasks',
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('name', models.CharField(help_text='Name of the task.', max_length=50, primary_key=True, serialize=False, verbose_name='NAME')),
                ('Request', models.CharField(default='celery.worker.request:Request', help_text='Request class used, or the qualified name of one.', max_length=50, null=True, verbose_name='REQUEST')),
                ('Strategy', models.CharField(default='celery.worker.strategy:default', help_text='Execution strategy used, or the qualified name of one.', max_length=50, null=True, verbose_name='STRATEGY')),
                ('abstract', models.BooleanField(default=True, help_text='Deprecated attribute abstract here for compatibility.', null=True, verbose_name='ABSTRACT')),
                ('acks_late', models.BooleanField(default=False, help_text='When enabled messages for this task will be acknowledged after the task has been executed, and not just before (the default behavior).', null=True, verbose_name='ACKS LATE')),
                ('acks_on_failure_or_timeout', models.BooleanField(default=True, help_text='When enabled messages for this task will be acknowledged even if it fails or times out.', null=True, verbose_name='ACKS FAILURE')),
                ('app_main', models.CharField(default='opstasks', help_text='Celery application.', max_length=20, null=True, verbose_name='APP NAME')),
                ('autoregister', models.BooleanField(default=True, help_text='If disabled this task won’t be registered automatically.', null=True, verbose_name='AUTO REGISTER')),
                ('backend_url', models.CharField(default='mysql://user:passwd@localhost/opstasks', help_text='The result store backend class, or the name of the backend class to use.', max_length=100, null=True, verbose_name='BACKEND URL')),
                ('default_retry_delay', models.SmallIntegerField(default=180, help_text='Default time in seconds before a retry of the task should be executed. 3 minutes by default.', null=True, verbose_name='DEFAULT RETRY DELAY')),
                ('ignore_result', models.BooleanField(default=False, help_text='If enabled the worker won’t store task state and return values for this task.', null=True, verbose_name='IGNORE RESULT')),
                ('max_retries', models.SmallIntegerField(default=3, help_text='Maximum number of retries before giving up. If set to None, it will never stop retrying.', null=True, verbose_name='MAX RETRIES')),
                ('priority', models.SmallIntegerField(help_text='The task priority, a number between 0 and 9. .', null=True, verbose_name='PRIORITY')),
                ('rate_limit', models.CharField(help_text='None (no rate limit), "100/s" (hundred tasks a second),"100/m" (hundred tasks a minute), "100/h" (hundred tasks an hour)', max_length=10, null=True, verbose_name='RATE LIMIT')),
                ('reject_on_worker_lost', models.BooleanField(help_text='Even if acks_late is enabled, the worker will acknowledge tasks when the worker process executing them abruptly exits or is signaled (e.g., KILL/INT, etc).\nSetting this to true allows the message to be re-queued instead, so that the task will execute again by the same worker, or another worker.\nWarning: Enabling this can cause message loops; make sure you know what you’re doing.', null=True, verbose_name='REJECT ON LOST')),
                ('resultrepr_maxsize', models.SmallIntegerField(default=1024, help_text='Max length of result representation used in logs and events.', null=True, verbose_name='RESULTREPR MAXSIZE')),
                ('send_events', models.BooleanField(default=False, help_text='If enabled the worker will send monitoring events related to this task\nbut only if the worker is configured to send task related events', null=True, verbose_name='SEND EVENTS')),
                ('serializer', models.CharField(default='json', help_text='The name of a serializer that are registered with kombu.serialization.registry', max_length=10, null=True, verbose_name='SERIALIZER')),
                ('soft_time_limit', models.SmallIntegerField(help_text='Soft time limit. Defaults to the task_soft_time_limit setting.', null=True, verbose_name='SOFT TIME LIMIT')),
                ('store_errors_even_if_ignored', models.BooleanField(default=False, help_text='When enabled errors will be stored even if the task is otherwise configured to ignore results.', null=True, verbose_name='STORE ERRORS')),
                ('throws', models.CharField(default='()', help_text='Tuple of expected exceptions.', max_length=100, null=True, verbose_name='THROWS')),
                ('time_limit', models.SmallIntegerField(help_text='Hard time limit. Defaults to the task_time_limit setting.', null=True, verbose_name='TIME LIMIT')),
                ('track_started', models.BooleanField(default=False, help_text='If enabled the task will report its status as ‘started’ when the task is executed by a worker.', null=True, verbose_name='TRACK STARTED')),
                ('trail', models.BooleanField(default=True, help_text='If enabled the request will keep track of subtasks started by this task, and this information will be sent with the result (result.children).', null=True, verbose_name='TRAIL')),
                ('typing', models.BooleanField(default=True, help_text='Enable argument checking. You can set this to false if you don’t want the signature to be checked when calling the task. Defaults to Celery.strict_typing.', null=True, verbose_name='TYPING')),
                ('description', models.CharField(max_length=255, null=True, verbose_name='DESCRIPTION')),
                ('timestamp', models.DateTimeField(auto_now=True, help_text='Last update time of the task', verbose_name='TIMESTAMP')),
                ('status', models.IntegerField(choices=[(0, 'NORMAL'), (1, 'INVALID')], default=0, verbose_name='STATUS')),
            ],
            options={
                'verbose_name': '任务列表',
                'verbose_name_plural': '任务列表',
                'db_table': 'tasks_task',
            },
        ),
        migrations.CreateModel(
            name='TaskResult',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('task_id', models.CharField(db_index=True, help_text='Celery ID for the Task that was run', max_length=255, unique=True, verbose_name='Task ID')),
                ('task_name', models.CharField(db_index=True, help_text='Name of the Task which was run', max_length=255, null=True, verbose_name='Task Name')),
                ('task_args', models.TextField(help_text='JSON representation of the positional arguments used with the task', null=True, verbose_name='Task Positional Arguments')),
                ('task_kwargs', models.TextField(help_text='JSON representation of the named arguments used with the task', null=True, verbose_name='Task Named Arguments')),
                ('status', models.CharField(choices=[('FAILURE', 'FAILURE'), ('PENDING', 'PENDING'), ('RECEIVED', 'RECEIVED'), ('RETRY', 'RETRY'), ('REVOKED', 'REVOKED'), ('STARTED', 'STARTED'), ('SUCCESS', 'SUCCESS')], db_index=True, default='PENDING', help_text='Current state of the task being run', max_length=50, verbose_name='Task State')),
                ('worker', models.CharField(db_index=True, default=None, help_text='Worker that executes the task', max_length=100, null=True, verbose_name='Worker')),
                ('content_type', models.CharField(help_text='Content type of the result data', max_length=128, verbose_name='Result Content Type')),
                ('content_encoding', models.CharField(help_text='The encoding used to save the task result data', max_length=64, verbose_name='Result Encoding')),
                ('result', models.TextField(default=None, editable=False, help_text='The data returned by the task. Use content_encoding and content_type fields to read.', null=True, verbose_name='Result Data')),
                ('date_created', models.DateTimeField(auto_now_add=True, db_index=True, help_text='Datetime field when the task result was created in UTC', verbose_name='Created DateTime')),
                ('date_done', models.DateTimeField(auto_now=True, db_index=True, help_text='Datetime field when the task was completed in UTC', verbose_name='Completed DateTime')),
                ('traceback', models.TextField(blank=True, help_text='Text of the traceback if the task generated one', null=True, verbose_name='Traceback')),
                ('meta', models.TextField(default=None, editable=False, help_text='JSON meta information about the task, such as information on child tasks', null=True, verbose_name='Task Meta Information')),
            ],
            options={
                'verbose_name': '执行记录',
                'verbose_name_plural': '执行记录',
                'db_table': 'tasks_results',
            },
        ),
        migrations.CreateModel(
            name='SolarSchedule',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('event', models.CharField(choices=[('dawn_astronomical', 'dawn_astronomical'), ('dawn_civil', 'dawn_civil'), ('dawn_nautical', 'dawn_nautical'), ('dusk_astronomical', 'dusk_astronomical'), ('dusk_civil', 'dusk_civil'), ('dusk_nautical', 'dusk_nautical'), ('solar_noon', 'solar_noon'), ('sunrise', 'sunrise'), ('sunset', 'sunset')], help_text='The type of solar event when the job should run', max_length=24, verbose_name='Solar Event')),
                ('latitude', models.DecimalField(decimal_places=6, help_text='Run the task when the event happens at this latitude', max_digits=9, validators=[django.core.validators.MinValueValidator(-90), django.core.validators.MaxValueValidator(90)], verbose_name='纬度')),
                ('longitude', models.DecimalField(decimal_places=6, help_text='Run the task when the event happens at this longitude', max_digits=9, validators=[django.core.validators.MinValueValidator(-180), django.core.validators.MaxValueValidator(180)], verbose_name='经度')),
            ],
            options={
                'verbose_name': 'solar',
                'verbose_name_plural': 'solars',
                'db_table': 'tasks_solar_schedule',
                'ordering': ('event', 'latitude', 'longitude'),
                'unique_together': {('event', 'latitude', 'longitude')},
            },
        ),
        migrations.CreateModel(
            name='PeriodicTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, unique=True, verbose_name='SHORT DESCRIPTION NAME')),
                ('task', models.CharField(max_length=200, verbose_name='TASK')),
                ('args', models.TextField(blank=True, help_text='传递给任务的位置参数, Json格式', validators=[django_opstasks.models.validate_tasks_args], verbose_name='位置参数')),
                ('kwargs', models.TextField(blank=True, help_text='传递给任务的关键字参数, Json格式', validators=[django_opstasks.models.validate_tasks_kwargs], verbose_name='任务参数')),
                ('queue', models.CharField(blank=True, default=None, help_text='选择CELERY_TASK_QUEUES中定义的队列, 留空将使用默认队列.', max_length=200, null=True, verbose_name='队列')),
                ('exchange', models.CharField(blank=True, default=None, help_text='Override Exchange for low-level AMQP routing', max_length=200, null=True, verbose_name='Exchange')),
                ('routing_key', models.CharField(blank=True, default=None, help_text='Override Routing Key for low-level AMQP routing', max_length=200, null=True, verbose_name='Routing Key')),
                ('headers', models.TextField(blank=True, default='{}', help_text='JSON encoded message headers for the AMQP message.', verbose_name='AMQP Message Headers')),
                ('priority', models.PositiveIntegerField(blank=True, default=None, help_text='优先级数字介于0-255之间. 仅支持: RabbitMQ, Redis . 优先级相反, 0最高.', null=True, validators=[django.core.validators.MaxValueValidator(255)], verbose_name='优先级')),
                ('start_time', models.DateTimeField(blank=True, help_text='计划的生效时间', null=True, verbose_name='开始时间')),
                ('expires', models.DateTimeField(blank=True, help_text='超过该时间之后, 本计划将不再启动任务', null=True, verbose_name='过期时间')),
                ('expire_seconds', models.PositiveIntegerField(blank=True, help_text='Timedelta with seconds which the schedule will no longer trigger the task to run', null=True, verbose_name='Expires timedelta with seconds')),
                ('enabled', models.BooleanField(default=True, help_text='取消勾选将关闭计划任务', verbose_name='ENABLED')),
                ('one_off', models.BooleanField(default=False, help_text='勾选后该计划仅执行一次', verbose_name='ONE_OFF')),
                ('last_run_at', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='Last Run Datetime')),
                ('total_run_count', models.PositiveIntegerField(default=0, editable=False, help_text='Running count of how many times the schedule has triggered the task', verbose_name='Total Run Count')),
                ('date_changed', models.DateTimeField(auto_now=True, help_text='Datetime that this PeriodicTask was last modified', verbose_name='Last Modified')),
                ('description', models.TextField(blank=True, default='Detailed description about the details of this Periodic Task', verbose_name='DESCRIPTION')),
                ('clocked', models.ForeignKey(blank=True, help_text='注:仅能设置一种调度方式,请将其余计划留空.', null=True, on_delete=django.db.models.deletion.CASCADE, to='django_opstasks.ClockedSchedule', verbose_name='Clocked计划')),
                ('crontab', models.ForeignKey(blank=True, help_text='注:仅能设置一种调度方式,请将其余计划留空.', null=True, on_delete=django.db.models.deletion.CASCADE, to='django_opstasks.CrontabSchedule', verbose_name='Crontab计划')),
                ('interval', models.ForeignKey(blank=True, help_text='注:仅能设置一种调度方式,请将其余计划留空.', null=True, on_delete=django.db.models.deletion.CASCADE, to='django_opstasks.IntervalSchedule', verbose_name='Interval计划')),
                ('registered_task', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='TASK', to='django_opstasks.Task', verbose_name='已注册任务')),
                ('solar', models.ForeignKey(blank=True, help_text='注:仅能设置一种调度方式,请将其余计划留空.', null=True, on_delete=django.db.models.deletion.CASCADE, to='django_opstasks.SolarSchedule', verbose_name='Solar计划')),
            ],
            options={
                'verbose_name': '定时任务',
                'verbose_name_plural': '定时任务',
                'db_table': 'tasks_periodic_task',
            },
        ),
    ]
