<div align="center">
    <img src="https://raw.githubusercontent.com/fkie-cad/Sandroid_core/refs/heads/main/assets/sandroid_logo.png" alt="Sandroid Logo" width="180"/>
    <p></p><strong>Android Sandbox for Automated Forensic, Malware, and Security Analysis</strong></div></p>
</div>

# Sandroid Framework
![version](https://img.shields.io/badge/version-1.2.4-blue) [![PyPI version](https://badge.fury.io/py/Sandroid.svg)](https://badge.fury.io/py/Sandroid)
[![Ruff](https://github.com/fkie-cad/Sandroid_core/actions/workflows/lint.yml/badge.svg?branch=main)](https://github.com/fkie-cad/Sandroid_core/actions/workflows/lint.yml)
[![Publish status](https://github.com/fkie-cad/Sandroid_core/actions/workflows/publish.yml/badge.svg?branch=main)](https://github.com/fkie-cad/Sandroid_core/actions/workflows/publish.yml)


Sandroid provides a powerful **Android sandbox framework** that enables automated analysis of Android applications.
It combines both **static** and **dynamic** techniques to help security researchers, forensic analysts, and malware analysts better understand how apps behave in a controlled environment.

By using this framework, you can:

- **Extract forensic artifacts** generated by Android apps and identify which app created them.
- **Analyze malware behavior** through automated static and dynamic analysis.
- **Uncover security vulnerabilities** and misconfigurations in Android applications.
- Gain deeper insights into app behavior without manual reverse engineering.

The framework is designed to simplify the process of **forensic investigations**, **mobile threat detection**, and **security testing** by providing a streamlined, automated environment for analysis.
Whether you're investigating malicious apps, assessing security flaws, or collecting digital evidence, this solution helps you quickly identify and understand what happens inside Android applications.


## Quick Start

```bash
# Install from PyPI
pip install sandroid

# Initialize configuration
sandroid-config init

# Run analysis in interactive mode
sandroid
```

See [SETUP.md](SETUP.md) for all installation possibilities.

## Usage
```
usage: sandroid [-h] [-f FILENAME] [-ll LOGLEVEL] [-n NUMBER] [--avoid_strong_noise_filter] [--network] [-d] [--no-processes] [--sockets] [--screenshot INTERVAL] [--trigdroid PACKAGE NAME]
                [--trigdroid_ccf {I,D}] [--hash] [--apk] [--degrade_network] [--whitelist FILE]

Find forensic artefacts for any action on an AVD

options:
  -h, --help            show this help message and exit
  -f FILENAME, --file FILENAME
                        Save output to the specified file, default is sandroid.json
  -ll LOGLEVEL, --loglevel LOGLEVEL
                        Set the log level. The logging file sandroid.log will always contain an expanded DEBUG level log.
  -n NUMBER, --number_of_runs NUMBER
                        Run action n times (Minimum and default is 2)
  --avoid_strong_noise_filter
                        Don't use a "Dry Run". This will catch more noise and disable intra file noise detection.
  --network             Capture traffic and show connections. Connections are not necessarily in chronological order. Each connection will only show up once, even if it was made multiple times. For better
                        results,  it is recommended to use at least -n 3  and to leave the strong noise filter on
  -d, --show_deleted    Perform additional full filesystem checks to reveal deleted files
  --no-processes        Do not monitor active processes during the action
  --sockets             Monitor listening sockets during the action
  --screenshot INTERVAL
                        Take a screenshot each INTERVAL seconds
  --trigdroid PACKAGE NAME
                        Use the TrigDroid(tm) tool to execute malware triggers in package PACKAGE NAME
  --trigdroid_ccf {I,D}
                        Use the TrigDroid(tm) CCF utility to create a Trigdroid config file. I for interactive mode, D to create the default config file
  --hash                Create before/after md5 hashes of all changed and new files and save them to hashes.json
  --apk                 List all APKs from the emulator and their hashes in the output file
  --degrade_network     Lower the emulators network speed and network latency to simulate and 'UMTS/3G' connection. For more fine grained control, use the emulator console
  --whitelist FILE      Entries in the whitelist will be excluded from any outputs. Separate paths by commas, wildcards are supported

```


With its modular architecture, Sandroid integrates multiple companion tools to cover a wide range of analysis capabilities — from cryptographic key extraction to TLS interception and network traffic decryption.

### Related Projects within the Sandroid Sandbox

Sandroid integrates and builds upon several companion projects that extend its capabilities.
These tools are developed under the same sandbox ecosystem and are designed to work together for comprehensive Android analysis:

| Project | Description | Status |
|--------|------------|--------|
| [**TrigDroid**](https://github.com/fkie-cad/Sandroid_TrigDroid) | Dynamic tracing and Frida-based interception for Android apps, enabling enhanced runtime analysis. | ⚠️ *Not fully integrated yet* |
| [**Dexray Insight**](https://github.com/fkie-cad/Sandroid_Dexray-Insight) | A static analysis tool focused on DEX files, helping to uncover cryptographic usage, API patterns, and potential vulnerabilities. | ✅ Integrated |
| [**Dexray Intercept**](https://github.com/fkie-cad/Sandroid_Dexray-Intercept) | Dynamic hooking framework for intercepting sensitive data flows, network traffic, and runtime behaviors in Android apps. | ✅ Integrated |
| [**friTap**](https://github.com/fkie-cad/friTap) | TLS key extraction and decrypted traffic interception for Android, enabling advanced network analysis in sandboxed environments. | ✅ Integrated |


# Ground Truth APK
The framework also includes a custom Android app for testing and calibration.
This app is designed to **create specific forensic artefacts with pinpoint accuracy** at the user's command, while being as minimal as possible to avoid unintended artefacts.
To use it, simply install it on the emulator using Sandroid's built-in APK installer and open the app.

## Supported Artefacts
In the current version, the ground truth app supports nine different artefacts
- Creating a new file
- Adding an entry to a Database
- Deleting an entry from a Database
- Updating an entry in a Database
- Sending a specific number of bytes to a specific URL
- Starting a specific process
- Adding an entry to a XML file
- Deleting an entry from a XML file
- Updating an entry in a XML file
Simply press the corresponding button to generate the Artefact

## Some considerations
- Values added to the XML file and the Database will be the current unix time on the emulator. It can deviate from the actual time but will be automatically be highlighted in the output.
- The first time the application is launched after installation, the XML file and database will be initialised, and Android will create a profile for the application, so **it is recommended that you open the application first, and only then start any analysis.**
- The XML and database files are called `GroundTruth.xml` and `GroundTruth.db` respectively and are stored in the applications directory.

## Documentation

- **[SETUP.md](SETUP.md)** - Complete setup guide for new installation method
- **[CHANGELOG.md](CHANGELOG.md)** - Detailed release notes and version history

## Installation Options

### Option 1: PyPI Installation (Recommended)
```bash
pip install sandroid
sandroid-config init
sandroid --help
sandroid # starting sandroid in interactive mode (default)
```

### Option 2: Legacy Installation (Still Supported)
```bash
git clone <repository>
./install-requirements.sh
./sandroid.legacy
```

## Configuration Management

The modern installation includes a powerful configuration system:

```bash
# Initialize configuration
sandroid-config init

# View configuration
sandroid-config show

# Modify settings
sandroid-config set analysis.monitor_network true
sandroid-config set emulator.device_name "Pixel_8_Pro_API_34"

# Validate configuration
sandroid-config validate
```

Configuration files are automatically discovered in standard locations:
- `~/.config/sandroid/sandroid.yaml` (user config)
- `./sandroid.yaml` (project-specific config)
- Environment variables with `SANDROID_` prefix

Supported formats: YAML, TOML, JSON (YAML preferred)

## Contributing

We welcome contributions to Sandroid! Before contributing:

1. **Review Coding Guidelines**: Please read our comprehensive [CODING_GUIDELINES.md](CODING_GUIDELINES.md) which covers:
   - Python code style standards (PEP 8 compliance)
   - Architecture patterns specific to Sandroid
   - Testing requirements and best practices
   - Security considerations for forensic tools
   - Documentation standards

2. **Development Setup**:
   ```bash
   git clone git@github.com:fkie-cad/Sandroid_core.git
   cd Sandroid_core
   pip install -e .[dev]
   #pytest  # Run tests - right now we don't have any tests
   ```

3. **Submit Changes**: Fork the repository, create a feature branch, ensure tests pass, and submit a pull request.

For detailed contribution instructions, see [docs/development/contributing.rst](docs/development/contributing.rst).


## Contact

Developed and maintained by Fraunhofer FKIE.

For inquiries or collaboration, please contact:
- daniel.baier@fkie.fraunhofer.de.
- jan-niclas.hilgert@fkie.fraunhofer.de
