#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""

   Copyright 2014-2025 OpenDSM contributors

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

"""
import numpy as np
from scipy.interpolate import BSpline

# fmt: off
TCK = (
    np.array(
        [-9.99999800e+01, -9.99999800e+01, -9.99999800e+01, -9.99999800e+01,
         -9.99999800e+01, -9.99999800e+01, -9.91619068e+01, -9.83266402e+01,
         -9.74941846e+01, -9.66645407e+01, -9.58377122e+01, -9.50137126e+01,
         -9.41925408e+01, -9.33741970e+01, -9.25586971e+01, -9.17460351e+01,
         -9.09362253e+01, -9.01292653e+01, -8.93251652e+01, -8.85239253e+01,
         -8.77255539e+01, -8.69300586e+01, -8.61374414e+01, -8.53477099e+01,
         -8.45608629e+01, -8.37769094e+01, -8.29958600e+01, -8.22177146e+01,
         -8.14424793e+01, -8.06701612e+01, -7.99007612e+01, -7.91342906e+01,
         -7.83707533e+01, -7.76101558e+01, -7.68524971e+01, -7.60977931e+01,
         -7.53460405e+01, -7.45972544e+01, -7.38514297e+01, -7.31085828e+01,
         -7.23687129e+01, -7.16318305e+01, -7.08979361e+01, -7.01670372e+01,
         -6.94391472e+01, -6.87142636e+01, -6.79923997e+01, -6.72735535e+01,
         -6.65577345e+01, -6.58449533e+01, -6.51352131e+01, -6.44285222e+01,
         -6.37248873e+01, -6.30243066e+01, -6.23268027e+01, -6.16323670e+01,
         -6.09410147e+01, -6.02527504e+01, -5.95675831e+01, -5.88855131e+01,
         -5.82065575e+01, -5.75307138e+01, -5.68579983e+01, -5.61884124e+01,
         -5.55219639e+01, -5.48586609e+01, -5.41985122e+01, -5.35415210e+01,
         -5.28877003e+01, -5.22370562e+01, -5.15895993e+01, -5.09453269e+01,
         -5.03042593e+01, -4.96663975e+01, -4.90317486e+01, -4.84003254e+01,
         -4.77721368e+01, -4.71471841e+01, -4.65254823e+01, -4.59070388e+01,
         -4.52918565e+01, -4.46799529e+01, -4.40713312e+01, -4.34660006e+01,
         -4.28639755e+01, -4.22652588e+01, -4.16698569e+01, -4.10777887e+01,
         -4.04890524e+01, -3.99036691e+01, -3.93216401e+01, -3.87429783e+01,
         -3.81676957e+01, -3.75957956e+01, -3.70272924e+01, -3.64621965e+01,
         -3.59005176e+01, -3.53422672e+01, -3.47874533e+01, -3.42360858e+01,
         -3.36881813e+01, -3.31437432e+01, -3.26027860e+01, -3.20653230e+01,
         -3.15313647e+01, -3.10009221e+01, -3.04740010e+01, -2.99506229e+01,
         -2.94307969e+01, -2.89145283e+01, -2.84018381e+01, -2.78927378e+01,
         -2.73872312e+01, -2.68853430e+01, -2.63870773e+01, -2.58924510e+01,
         -2.54014782e+01, -2.49141706e+01, -2.44305415e+01, -2.39506055e+01,
         -2.34743794e+01, -2.30018754e+01, -2.25331069e+01, -2.20680896e+01,
         -2.16068408e+01, -2.11493713e+01, -2.06956992e+01, -2.02458406e+01,
         -1.97998137e+01, -1.93576289e+01, -1.89193063e+01, -1.84848656e+01,
         -1.80543172e+01, -1.76276847e+01, -1.72049815e+01, -1.67862257e+01,
         -1.63714383e+01, -1.59606383e+01, -1.55538454e+01, -1.51510716e+01,
         -1.47523449e+01, -1.43576817e+01, -1.39671004e+01, -1.35806287e+01,
         -1.31982778e+01, -1.28200789e+01, -1.24460463e+01, -1.20762057e+01,
         -1.17105795e+01, -1.13491892e+01, -1.09920619e+01, -1.06392173e+01,
         -1.02906780e+01, -9.94647806e+00, -9.60663360e+00, -9.27117058e+00,
         -8.94011550e+00, -8.61349914e+00, -8.29134188e+00, -7.97367254e+00,
         -7.66051449e+00, -7.35189906e+00, -7.04784859e+00, -6.74839097e+00,
         -6.45355449e+00, -6.16336078e+00, -5.87783314e+00, -5.59700021e+00,
         -5.32087490e+00, -5.04948077e+00, -4.78283065e+00, -4.52093336e+00,
         -4.26378900e+00, -4.01139575e+00, -3.76373659e+00, -3.52077339e+00,
         -3.28246606e+00, -3.04874699e+00, -2.81953592e+00, -2.59473887e+00,
         -2.37425513e+00, -2.15802261e+00, -1.94608169e+00, -1.73866290e+00,
         -1.53611957e+00, -1.33898610e+00, -1.14766835e+00, -9.62055927e-01,
         -7.81266320e-01, -6.03322183e-01, -4.25221239e-01, -2.46824794e-01,
         -7.76763660e-02,  7.54617469e-02,  2.17486985e-01,  3.53826824e-01,
          4.89933140e-01,  6.34761751e-01,  7.89741708e-01,  9.38636540e-01,
          1.09388055e+00,  1.23000133e+00,  1.33898962e+00,  1.43317887e+00,
          1.51596478e+00,  1.58762073e+00,  1.65063047e+00,  1.70532890e+00,
          1.75257216e+00,  1.79327671e+00,  1.82855195e+00,  1.85849916e+00,
          1.88400303e+00,  1.90000960e+00,  1.90172739e+00,  1.90440391e+00,
          1.92213219e+00,  1.93770949e+00,  1.95064293e+00,  1.96130851e+00,
          1.97005891e+00,  1.97715673e+00,  1.98278630e+00,  1.98727574e+00,
          1.99079451e+00,  1.99357901e+00,  1.99556189e+00,  1.99694659e+00,
          1.99746232e+00,  1.99773606e+00,  1.99797487e+00,  1.99829915e+00,
          1.99855288e+00,  1.99876116e+00,  1.99892488e+00,  1.99913056e+00,
          1.99922343e+00,  1.99930634e+00,  1.99941449e+00,  1.99949065e+00,
          1.99960643e+00,  1.99966948e+00,  1.99972133e+00,  1.99976616e+00,
          1.99980879e+00,  1.99985830e+00,  1.99990106e+00,  1.99993097e+00,
          1.99995254e+00,  1.99997109e+00,  1.99998582e+00,  2.00000352e+00,
          2.00002031e+00,  2.00003968e+00,  2.00007094e+00,  2.00010168e+00,
          2.00013595e+00,  2.00017135e+00,  2.00020381e+00,  2.00024097e+00,
          2.00028403e+00,  2.00032807e+00,  2.00039608e+00,  2.00045393e+00,
          2.00049877e+00,  2.00054776e+00,  2.00059183e+00,  2.00064085e+00,
          2.00068659e+00,  2.00073395e+00,  2.00079058e+00,  2.00089693e+00,
          2.00099802e+00,  2.00114617e+00,  2.00125120e+00,  2.00134046e+00,
          2.00142858e+00,  2.00150875e+00,  2.00160096e+00,  2.00172427e+00,
          2.00183041e+00,  2.00196187e+00,  2.00223323e+00,  2.00247477e+00,
          2.00278542e+00,  2.00306566e+00,  2.00337256e+00,  2.00371468e+00,
          2.00490935e+00,  2.00708025e+00,  2.00991650e+00,  2.01359578e+00,
          2.01773492e+00,  2.02056213e+00,  2.02730471e+00,  2.03546465e+00,
          2.04531408e+00,  2.05732220e+00,  2.07177821e+00,  2.08892863e+00,
          2.10935079e+00,  2.13331863e+00,  2.16131658e+00,  2.19378209e+00,
          2.23156110e+00,  2.27481045e+00,  2.32452319e+00,  2.38125418e+00,
          2.44570900e+00,  2.51949658e+00,  2.60261083e+00,  2.69662353e+00,
          2.80288640e+00,  2.92225114e+00,  3.05781839e+00,  3.20958028e+00,
          3.38098345e+00,  3.57319716e+00,  3.78871648e+00,  4.02987694e+00,
          4.29691296e+00,  4.59331070e+00,  4.91487791e+00,  5.26115258e+00,
          5.62945458e+00,  6.01729356e+00,  6.42298855e+00,  6.84526884e+00,
          7.28323899e+00,  7.73626562e+00,  8.20386272e+00,  8.68564408e+00,
          9.18127472e+00,  9.69048564e+00,  1.02130375e+01,  1.07487232e+01,
          1.12973390e+01,  1.18587095e+01,  1.24326704e+01,  1.30190710e+01,
          1.36177612e+01,  1.42286006e+01,  1.48514663e+01,  1.54862274e+01,
          1.61327737e+01,  1.67909888e+01,  1.74607586e+01,  1.81419907e+01,
          1.88345746e+01,  1.95384173e+01,  2.02534327e+01,  2.09795231e+01,
          2.17166067e+01,  2.24645942e+01,  2.32234140e+01,  2.39929758e+01,
          2.47732099e+01,  2.55640466e+01,  2.63654087e+01,  2.71772207e+01,
          2.79994267e+01,  2.88319499e+01,  2.96747324e+01,  3.05277064e+01,
          3.13908146e+01,  3.22639955e+01,  3.31471892e+01,  3.40403413e+01,
          3.49433956e+01,  3.58562966e+01,  3.67789887e+01,  3.77114269e+01,
          3.86535543e+01,  3.96053168e+01,  4.05666749e+01,  4.15375779e+01,
          4.25179747e+01,  4.35078202e+01,  4.45070773e+01,  4.55156882e+01,
          4.65336222e+01,  4.75608253e+01,  4.85972646e+01,  4.96428974e+01,
          5.06976770e+01,  5.17615737e+01,  5.28345391e+01,  5.39165383e+01,
          5.50075334e+01,  5.61074933e+01,  5.72163692e+01,  5.83341361e+01,
          5.94607534e+01,  6.05961909e+01,  6.17404082e+01,  6.28933719e+01,
          6.40550589e+01,  6.52254252e+01,  6.64044422e+01,  6.75920782e+01,
          6.87883009e+01,  6.99930845e+01,  7.12063926e+01,  7.24282003e+01,
          7.36584741e+01,  7.48971867e+01,  7.61443064e+01,  7.73998087e+01,
          7.86636653e+01,  7.99358482e+01,  8.12163330e+01,  8.25050862e+01,
          8.38020842e+01,  8.51073021e+01,  8.64207117e+01,  8.77422900e+01,
          8.90720150e+01,  9.04098555e+01,  9.17557859e+01,  9.31097879e+01,
          9.44718340e+01,  9.58419042e+01,  9.72199674e+01,  9.86060051e+01,
          1.00000000e+02,  1.00000000e+02,  1.00000000e+02,  1.00000000e+02,
          1.00000000e+02,  1.00000000e+02]),
    np.array(
        [2.15241886, 2.15239732, 2.15235414, 2.15228893, 2.15220104,
         2.15208949, 2.15197643, 2.15186182, 2.15174563, 2.15162783,
         2.15150839, 2.15138728, 2.15126447, 2.15113993, 2.15101361,
         2.15088549, 2.15075552, 2.15062368, 2.15048993, 2.15035422,
         2.15021653, 2.15007679, 2.14993499, 2.14979107, 2.14964499,
         2.1494967 , 2.14934616, 2.14919332, 2.14903814, 2.14888056,
         2.14872053, 2.148558  , 2.14839292, 2.14822523, 2.14805487,
         2.14788178, 2.14770591, 2.14752719, 2.14734556, 2.14716095,
         2.14697329, 2.14678252, 2.14658857, 2.14639136, 2.14619081,
         2.14598685, 2.14577939, 2.14556836, 2.14535366, 2.14513522,
         2.14491294, 2.14468672, 2.14445648, 2.1442221 , 2.14398349,
         2.14374055, 2.14349316, 2.14324121, 2.14298459, 2.14272317,
         2.14245683, 2.14218544, 2.14190888, 2.14162699, 2.14133965,
         2.14104671, 2.14074801, 2.1404434 , 2.14013271, 2.13981578,
         2.13949244, 2.1391625 , 2.13882579, 2.13848209, 2.13813122,
         2.13777298, 2.13740713, 2.13703346, 2.13665175, 2.13626174,
         2.13586319, 2.13545585, 2.13503943, 2.13461366, 2.13417826,
         2.13373291, 2.13327731, 2.13281113, 2.13233402, 2.13184564,
         2.1313456 , 2.13083354, 2.13030904, 2.12977169, 2.12922105,
         2.12865667, 2.12807807, 2.12748476, 2.12687621, 2.12625189,
         2.12561122, 2.12495362, 2.12427846, 2.1235851 , 2.12287286,
         2.12214101, 2.12138882, 2.1206155 , 2.11982023, 2.11900214,
         2.11816032, 2.11729383, 2.11640166, 2.11548276, 2.11453601,
         2.11356024, 2.11255423, 2.11151667, 2.11044619, 2.10934135,
         2.10820061, 2.10702235, 2.10580488, 2.10454638, 2.10324493,
         2.1018985 , 2.10050495, 2.09906198, 2.09756717, 2.09601793,
         2.09441153, 2.09274504, 2.09101536, 2.08921916, 2.0873529 ,
         2.08541282, 2.08339487, 2.08129473, 2.07910776, 2.07682903,
         2.0744532 , 2.07197458, 2.06938702, 2.06668393, 2.06385821,
         2.06090219, 2.05780762, 2.05456557, 2.05116642, 2.04759972,
         2.04385416, 2.0399175 , 2.03577645, 2.03141654, 2.02682207,
         2.02197592, 2.01685948, 2.0114524 , 2.00573252, 1.99967561,
         1.99325521, 1.98644235, 1.97920538, 1.97150962, 1.96331709,
         1.95458623, 1.94527151, 1.93532302, 1.92468616, 1.91330112,
         1.90110237, 1.88801823, 1.87397035, 1.85887315, 1.84263358,
         1.82515123, 1.80631939, 1.7860286 , 1.76417417, 1.7406663 ,
         1.71544581, 1.6884964 , 1.65984458, 1.62954065, 1.59761539,
         1.56401609, 1.52869221, 1.4920363 , 1.45492882, 1.41830507,
         1.38304801, 1.34971675, 1.31789431, 1.28673462, 1.25630383,
         1.22626369, 1.19731608, 1.17042042, 1.14592617, 1.12356836,
         1.10382229, 1.08627322, 1.0701912 , 1.05533321, 1.04158601,
         1.02879729, 1.01693774, 1.00594766, 0.99614615, 0.98836752,
         0.98257838, 0.97750256, 0.97305027, 0.96868045, 0.96322834,
         0.95670166, 0.95074867, 0.94543953, 0.94074184, 0.93662438,
         0.93304778, 0.929999  , 0.92744291, 0.92543981, 0.92396184,
         0.92296245, 0.92230994, 0.92191552, 0.92158792, 0.92127977,
         0.92097067, 0.92071658, 0.9205028 , 0.92031392, 0.92014471,
         0.91999943, 0.91986096, 0.91972707, 0.91961127, 0.91950272,
         0.91941389, 0.919332  , 0.91925326, 0.91918257, 0.91911623,
         0.91906362, 0.91901607, 0.91898093, 0.91892304, 0.91887442,
         0.91882514, 0.91876538, 0.91870849, 0.91864118, 0.91858104,
         0.91851137, 0.91844507, 0.91836555, 0.9182813 , 0.91819518,
         0.91810947, 0.91802511, 0.91794894, 0.91787628, 0.91780379,
         0.91773116, 0.91763942, 0.91753445, 0.91740104, 0.91725416,
         0.91710059, 0.91695562, 0.91681812, 0.91669648, 0.91657225,
         0.9164454 , 0.91630778, 0.91612458, 0.91590644, 0.91564697,
         0.91535115, 0.91502114, 0.91468199, 0.91413672, 0.91320789,
         0.91180931, 0.90987257, 0.90743783, 0.90494806, 0.90196083,
         0.89848543, 0.89453194, 0.89003571, 0.8847903 , 0.87911514,
         0.87301681, 0.86653323, 0.85972191, 0.85264744, 0.84535685,
         0.83793598, 0.83044481, 0.82295242, 0.81552485, 0.80820985,
         0.80106912, 0.79414917, 0.78748437, 0.78110965, 0.77503897,
         0.76929405, 0.76387843, 0.75880196, 0.75406415, 0.7496679 ,
         0.74561249, 0.74189059, 0.73850467, 0.73544876, 0.73271275,
         0.73027848, 0.7281251 , 0.72622343, 0.7245446 , 0.72306012,
         0.72174368, 0.72057213, 0.71952555, 0.71858701, 0.71774217,
         0.71697891, 0.71628698, 0.71565763, 0.71508345, 0.71455805,
         0.71407596, 0.71363246, 0.71322346, 0.71284538, 0.71249512,
         0.71216995, 0.71186748, 0.71158559, 0.71132242, 0.71107629,
         0.71084574, 0.71062943, 0.71042621, 0.71023499, 0.71005483,
         0.70988487, 0.70972434, 0.70957253, 0.7094288 , 0.70929258,
         0.70916333, 0.70904058, 0.70892389, 0.70881285, 0.70870709,
         0.70860627, 0.70851009, 0.70841826, 0.7083305 , 0.70824658,
         0.70816627, 0.70808935, 0.70801564, 0.70794495, 0.70787712,
         0.70781199, 0.70774941, 0.70768926, 0.70763139, 0.70757569,
         0.70752206, 0.70747039, 0.70742058, 0.70737255, 0.70732619,
         0.70728145, 0.70723823, 0.70719648, 0.70715611, 0.70711708,
         0.70707931, 0.70704276, 0.70700737, 0.70697309, 0.70693987,
         0.70690767, 0.70687645, 0.70684616, 0.70681678, 0.70678825,
         0.70676055, 0.70673364, 0.7067075 , 0.70668209, 0.70665739,
         0.70663337, 0.70661   , 0.70658726, 0.70656513, 0.70654359,
         0.7065226 , 0.70650216, 0.70648225, 0.70646284, 0.70644392,
         0.70642547, 0.70640747, 0.70638992, 0.70637279, 0.70635608,
         0.70633976, 0.70632383, 0.70630827, 0.70629307, 0.70627822,
         0.70626665, 0.70625812, 0.7062525 , 0.70624971, 0.        ,
         0.        , 0.        , 0.        , 0.        , 0.        ]),
 5)
# fmt: on

# approximate partition function for C=1, tau = 10 from r=-100 to 100
# error < 4E-7
ln_Z_fit = BSpline.construct_fast(*TCK)
ln_Z_inf = 2.1653591123321405


def ln_Z(alpha, alpha_min=-100):
    """
    Function to fit a spline onto the data points. Since some points may have higher changes in their local neighborhood,
    we need to fit more points in that region via the spline. The spline is fit on the data points for alpha >= alpha_min.

    Parameters:
    alpha (float): The alpha value for which the spline of Z is to be calculated.
    alpha_min (float, optional): The minimum value of alpha. Defaults to -100.

    Returns:
    float: The spline fit on Z for the given alpha. If alpha is less than or equal to alpha_min,
    the function returns the value at infinity, i.e. 11.2.
    """

    if alpha <= alpha_min:
        return ln_Z_inf

    return ln_Z_fit(alpha)