# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PersistenceProfileCookieArgs', 'PersistenceProfileCookie']

@pulumi.input_type
class PersistenceProfileCookieArgs:
    def __init__(__self__, *,
                 defaults_from: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 always_send: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_encryption_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 hash_length: Optional[pulumi.Input[_builtins.int]] = None,
                 hash_offset: Optional[pulumi.Input[_builtins.int]] = None,
                 httponly: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_services: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_virtuals: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 mirror: Optional[pulumi.Input[_builtins.str]] = None,
                 override_conn_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a PersistenceProfileCookie resource.
        :param pulumi.Input[_builtins.str] defaults_from: Inherit defaults from parent profile
        :param pulumi.Input[_builtins.str] name: Name of the persistence profile
        :param pulumi.Input[_builtins.str] always_send: To enable _ disable always sending cookies
        :param pulumi.Input[_builtins.str] cookie_encryption: To required, preferred, or disabled policy for cookie encryption
        :param pulumi.Input[_builtins.str] cookie_encryption_passphrase: Passphrase for encrypted cookies
        :param pulumi.Input[_builtins.str] cookie_name: Name of the cookie to track persistence
        :param pulumi.Input[_builtins.str] expiration: Expiration TTL for cookie specified in D:H:M:S or in seconds
        :param pulumi.Input[_builtins.int] hash_length: Length of hash to apply to cookie
        :param pulumi.Input[_builtins.int] hash_offset: Number of characters to skip in the cookie for the hash
        :param pulumi.Input[_builtins.str] httponly: To enable _ disable sending only over http
        :param pulumi.Input[_builtins.str] match_across_pools: To enable _ disable match across pools with given persistence record
        :param pulumi.Input[_builtins.str] match_across_services: To enable _ disable match across services with given persistence record
        :param pulumi.Input[_builtins.str] match_across_virtuals: To enable _ disable match across virtual servers with given persistence record
        :param pulumi.Input[_builtins.str] method: Specifies the type of cookie processing that the system uses
        :param pulumi.Input[_builtins.str] mirror: To enable _ disable
        :param pulumi.Input[_builtins.str] override_conn_limit: To enable _ disable that pool member connection limits are overridden for persisted clients. Per-virtual connection limits remain hard limits and are not overridden.
        :param pulumi.Input[_builtins.int] timeout: Timeout for persistence of the session
        """
        pulumi.set(__self__, "defaults_from", defaults_from)
        pulumi.set(__self__, "name", name)
        if always_send is not None:
            pulumi.set(__self__, "always_send", always_send)
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if cookie_encryption is not None:
            pulumi.set(__self__, "cookie_encryption", cookie_encryption)
        if cookie_encryption_passphrase is not None:
            pulumi.set(__self__, "cookie_encryption_passphrase", cookie_encryption_passphrase)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if hash_length is not None:
            pulumi.set(__self__, "hash_length", hash_length)
        if hash_offset is not None:
            pulumi.set(__self__, "hash_offset", hash_offset)
        if httponly is not None:
            pulumi.set(__self__, "httponly", httponly)
        if match_across_pools is not None:
            pulumi.set(__self__, "match_across_pools", match_across_pools)
        if match_across_services is not None:
            pulumi.set(__self__, "match_across_services", match_across_services)
        if match_across_virtuals is not None:
            pulumi.set(__self__, "match_across_virtuals", match_across_virtuals)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if override_conn_limit is not None:
            pulumi.set(__self__, "override_conn_limit", override_conn_limit)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Input[_builtins.str]:
        """
        Inherit defaults from parent profile
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the persistence profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="alwaysSend")
    def always_send(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable always sending cookies
        """
        return pulumi.get(self, "always_send")

    @always_send.setter
    def always_send(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "always_send", value)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "app_service")

    @app_service.setter
    def app_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service", value)

    @_builtins.property
    @pulumi.getter(name="cookieEncryption")
    def cookie_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To required, preferred, or disabled policy for cookie encryption
        """
        return pulumi.get(self, "cookie_encryption")

    @cookie_encryption.setter
    def cookie_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie_encryption", value)

    @_builtins.property
    @pulumi.getter(name="cookieEncryptionPassphrase")
    def cookie_encryption_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Passphrase for encrypted cookies
        """
        return pulumi.get(self, "cookie_encryption_passphrase")

    @cookie_encryption_passphrase.setter
    def cookie_encryption_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie_encryption_passphrase", value)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cookie to track persistence
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie_name", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration TTL for cookie specified in D:H:M:S or in seconds
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter(name="hashLength")
    def hash_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Length of hash to apply to cookie
        """
        return pulumi.get(self, "hash_length")

    @hash_length.setter
    def hash_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hash_length", value)

    @_builtins.property
    @pulumi.getter(name="hashOffset")
    def hash_offset(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of characters to skip in the cookie for the hash
        """
        return pulumi.get(self, "hash_offset")

    @hash_offset.setter
    def hash_offset(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hash_offset", value)

    @_builtins.property
    @pulumi.getter
    def httponly(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable sending only over http
        """
        return pulumi.get(self, "httponly")

    @httponly.setter
    def httponly(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "httponly", value)

    @_builtins.property
    @pulumi.getter(name="matchAcrossPools")
    def match_across_pools(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable match across pools with given persistence record
        """
        return pulumi.get(self, "match_across_pools")

    @match_across_pools.setter
    def match_across_pools(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_across_pools", value)

    @_builtins.property
    @pulumi.getter(name="matchAcrossServices")
    def match_across_services(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable match across services with given persistence record
        """
        return pulumi.get(self, "match_across_services")

    @match_across_services.setter
    def match_across_services(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_across_services", value)

    @_builtins.property
    @pulumi.getter(name="matchAcrossVirtuals")
    def match_across_virtuals(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable match across virtual servers with given persistence record
        """
        return pulumi.get(self, "match_across_virtuals")

    @match_across_virtuals.setter
    def match_across_virtuals(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_across_virtuals", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of cookie processing that the system uses
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mirror", value)

    @_builtins.property
    @pulumi.getter(name="overrideConnLimit")
    def override_conn_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable that pool member connection limits are overridden for persisted clients. Per-virtual connection limits remain hard limits and are not overridden.
        """
        return pulumi.get(self, "override_conn_limit")

    @override_conn_limit.setter
    def override_conn_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "override_conn_limit", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout for persistence of the session
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _PersistenceProfileCookieState:
    def __init__(__self__, *,
                 always_send: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_encryption_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_name: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 hash_length: Optional[pulumi.Input[_builtins.int]] = None,
                 hash_offset: Optional[pulumi.Input[_builtins.int]] = None,
                 httponly: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_services: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_virtuals: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 mirror: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 override_conn_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering PersistenceProfileCookie resources.
        :param pulumi.Input[_builtins.str] always_send: To enable _ disable always sending cookies
        :param pulumi.Input[_builtins.str] cookie_encryption: To required, preferred, or disabled policy for cookie encryption
        :param pulumi.Input[_builtins.str] cookie_encryption_passphrase: Passphrase for encrypted cookies
        :param pulumi.Input[_builtins.str] cookie_name: Name of the cookie to track persistence
        :param pulumi.Input[_builtins.str] defaults_from: Inherit defaults from parent profile
        :param pulumi.Input[_builtins.str] expiration: Expiration TTL for cookie specified in D:H:M:S or in seconds
        :param pulumi.Input[_builtins.int] hash_length: Length of hash to apply to cookie
        :param pulumi.Input[_builtins.int] hash_offset: Number of characters to skip in the cookie for the hash
        :param pulumi.Input[_builtins.str] httponly: To enable _ disable sending only over http
        :param pulumi.Input[_builtins.str] match_across_pools: To enable _ disable match across pools with given persistence record
        :param pulumi.Input[_builtins.str] match_across_services: To enable _ disable match across services with given persistence record
        :param pulumi.Input[_builtins.str] match_across_virtuals: To enable _ disable match across virtual servers with given persistence record
        :param pulumi.Input[_builtins.str] method: Specifies the type of cookie processing that the system uses
        :param pulumi.Input[_builtins.str] mirror: To enable _ disable
        :param pulumi.Input[_builtins.str] name: Name of the persistence profile
        :param pulumi.Input[_builtins.str] override_conn_limit: To enable _ disable that pool member connection limits are overridden for persisted clients. Per-virtual connection limits remain hard limits and are not overridden.
        :param pulumi.Input[_builtins.int] timeout: Timeout for persistence of the session
        """
        if always_send is not None:
            pulumi.set(__self__, "always_send", always_send)
        if app_service is not None:
            pulumi.set(__self__, "app_service", app_service)
        if cookie_encryption is not None:
            pulumi.set(__self__, "cookie_encryption", cookie_encryption)
        if cookie_encryption_passphrase is not None:
            pulumi.set(__self__, "cookie_encryption_passphrase", cookie_encryption_passphrase)
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if defaults_from is not None:
            pulumi.set(__self__, "defaults_from", defaults_from)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if hash_length is not None:
            pulumi.set(__self__, "hash_length", hash_length)
        if hash_offset is not None:
            pulumi.set(__self__, "hash_offset", hash_offset)
        if httponly is not None:
            pulumi.set(__self__, "httponly", httponly)
        if match_across_pools is not None:
            pulumi.set(__self__, "match_across_pools", match_across_pools)
        if match_across_services is not None:
            pulumi.set(__self__, "match_across_services", match_across_services)
        if match_across_virtuals is not None:
            pulumi.set(__self__, "match_across_virtuals", match_across_virtuals)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if override_conn_limit is not None:
            pulumi.set(__self__, "override_conn_limit", override_conn_limit)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter(name="alwaysSend")
    def always_send(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable always sending cookies
        """
        return pulumi.get(self, "always_send")

    @always_send.setter
    def always_send(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "always_send", value)

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "app_service")

    @app_service.setter
    def app_service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service", value)

    @_builtins.property
    @pulumi.getter(name="cookieEncryption")
    def cookie_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To required, preferred, or disabled policy for cookie encryption
        """
        return pulumi.get(self, "cookie_encryption")

    @cookie_encryption.setter
    def cookie_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie_encryption", value)

    @_builtins.property
    @pulumi.getter(name="cookieEncryptionPassphrase")
    def cookie_encryption_passphrase(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Passphrase for encrypted cookies
        """
        return pulumi.get(self, "cookie_encryption_passphrase")

    @cookie_encryption_passphrase.setter
    def cookie_encryption_passphrase(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie_encryption_passphrase", value)

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the cookie to track persistence
        """
        return pulumi.get(self, "cookie_name")

    @cookie_name.setter
    def cookie_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cookie_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Inherit defaults from parent profile
        """
        return pulumi.get(self, "defaults_from")

    @defaults_from.setter
    def defaults_from(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "defaults_from", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration TTL for cookie specified in D:H:M:S or in seconds
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter(name="hashLength")
    def hash_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Length of hash to apply to cookie
        """
        return pulumi.get(self, "hash_length")

    @hash_length.setter
    def hash_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hash_length", value)

    @_builtins.property
    @pulumi.getter(name="hashOffset")
    def hash_offset(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of characters to skip in the cookie for the hash
        """
        return pulumi.get(self, "hash_offset")

    @hash_offset.setter
    def hash_offset(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "hash_offset", value)

    @_builtins.property
    @pulumi.getter
    def httponly(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable sending only over http
        """
        return pulumi.get(self, "httponly")

    @httponly.setter
    def httponly(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "httponly", value)

    @_builtins.property
    @pulumi.getter(name="matchAcrossPools")
    def match_across_pools(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable match across pools with given persistence record
        """
        return pulumi.get(self, "match_across_pools")

    @match_across_pools.setter
    def match_across_pools(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_across_pools", value)

    @_builtins.property
    @pulumi.getter(name="matchAcrossServices")
    def match_across_services(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable match across services with given persistence record
        """
        return pulumi.get(self, "match_across_services")

    @match_across_services.setter
    def match_across_services(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_across_services", value)

    @_builtins.property
    @pulumi.getter(name="matchAcrossVirtuals")
    def match_across_virtuals(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable match across virtual servers with given persistence record
        """
        return pulumi.get(self, "match_across_virtuals")

    @match_across_virtuals.setter
    def match_across_virtuals(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "match_across_virtuals", value)

    @_builtins.property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of cookie processing that the system uses
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "method", value)

    @_builtins.property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mirror", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the persistence profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="overrideConnLimit")
    def override_conn_limit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        To enable _ disable that pool member connection limits are overridden for persisted clients. Per-virtual connection limits remain hard limits and are not overridden.
        """
        return pulumi.get(self, "override_conn_limit")

    @override_conn_limit.setter
    def override_conn_limit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "override_conn_limit", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout for persistence of the session
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.type_token("f5bigip:ltm/persistenceProfileCookie:PersistenceProfileCookie")
class PersistenceProfileCookie(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_send: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_encryption_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_name: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 hash_length: Optional[pulumi.Input[_builtins.int]] = None,
                 hash_offset: Optional[pulumi.Input[_builtins.int]] = None,
                 httponly: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_services: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_virtuals: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 mirror: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 override_conn_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Configures a cookie persistence profile

        ## Example

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test_ppcookie = f5bigip.ltm.PersistenceProfileCookie("test_ppcookie",
            name="/Common/terraform_cookie",
            defaults_from="/Common/cookie",
            match_across_pools="enabled",
            match_across_services="enabled",
            match_across_virtuals="enabled",
            timeout=3600,
            override_conn_limit="enabled",
            always_send="enabled",
            cookie_encryption="required",
            cookie_encryption_passphrase="iam",
            cookie_name="ham",
            expiration="1:0:0",
            hash_length=0)
        ```

        ## Reference

        `name` - (Required) Name of the virtual address

        `defaults_from` - (Required) Parent cookie persistence profile

        `match_across_pools` (Optional) (enabled or disabled) match across pools with given persistence record

        `match_across_services` (Optional) (enabled or disabled) match across services with given persistence record

        `match_across_virtuals` (Optional) (enabled or disabled) match across virtual servers with given persistence record

        `method` (Optional) Specifies the type of cookie processing that the system uses. The default value is insert

        `mirror` (Optional) (enabled or disabled) mirror persistence record

        `timeout` (Optional) (enabled or disabled) Timeout for persistence of the session in seconds

        `override_conn_limit` (Optional) (enabled or disabled) Enable or dissable pool member connection limits are overridden for persisted clients. Per-virtual connection limits remain hard limits and are not overridden.

        `always_send` (Optional) (enabled or disabled) always send cookies

        `cookie_encryption` (Optional) (required, preferred, or disabled) To required, preferred, or disabled policy for cookie encryption

        `cookie_encryption_passphrase` (Optional) (required, preferred, or disabled) Passphrase for encrypted cookies. The field is encrypted on the server and will always return differently then set.
        If this is configured specify `ignore_changes` under the `lifecycle` block to ignore returned encrypted value.

        `cookie_name` (Optional) Name of the cookie to track persistence

        `expiration` (Optional) Expiration TTL for cookie specified in DAY:HOUR:MIN:SECONDS (Examples: 1:0:0:0 one day, 1:0:0 one hour, 30:0 thirty minutes)

        `hash_length` (Optional) (Integer) Length of hash to apply to cookie

        `hash_offset` (Optional) (Integer) Number of characters to skip in the cookie for the hash

        `httponly` (Optional) (enabled or disabled) Sending only over http

        ## Importing

        An cookie persistence profile can be imported into this resource by supplying the Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_persistence_profile_cookie.test_ppcookie "/Common/terraform_cookie"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] always_send: To enable _ disable always sending cookies
        :param pulumi.Input[_builtins.str] cookie_encryption: To required, preferred, or disabled policy for cookie encryption
        :param pulumi.Input[_builtins.str] cookie_encryption_passphrase: Passphrase for encrypted cookies
        :param pulumi.Input[_builtins.str] cookie_name: Name of the cookie to track persistence
        :param pulumi.Input[_builtins.str] defaults_from: Inherit defaults from parent profile
        :param pulumi.Input[_builtins.str] expiration: Expiration TTL for cookie specified in D:H:M:S or in seconds
        :param pulumi.Input[_builtins.int] hash_length: Length of hash to apply to cookie
        :param pulumi.Input[_builtins.int] hash_offset: Number of characters to skip in the cookie for the hash
        :param pulumi.Input[_builtins.str] httponly: To enable _ disable sending only over http
        :param pulumi.Input[_builtins.str] match_across_pools: To enable _ disable match across pools with given persistence record
        :param pulumi.Input[_builtins.str] match_across_services: To enable _ disable match across services with given persistence record
        :param pulumi.Input[_builtins.str] match_across_virtuals: To enable _ disable match across virtual servers with given persistence record
        :param pulumi.Input[_builtins.str] method: Specifies the type of cookie processing that the system uses
        :param pulumi.Input[_builtins.str] mirror: To enable _ disable
        :param pulumi.Input[_builtins.str] name: Name of the persistence profile
        :param pulumi.Input[_builtins.str] override_conn_limit: To enable _ disable that pool member connection limits are overridden for persisted clients. Per-virtual connection limits remain hard limits and are not overridden.
        :param pulumi.Input[_builtins.int] timeout: Timeout for persistence of the session
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PersistenceProfileCookieArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configures a cookie persistence profile

        ## Example

        ```python
        import pulumi
        import pulumi_f5bigip as f5bigip

        test_ppcookie = f5bigip.ltm.PersistenceProfileCookie("test_ppcookie",
            name="/Common/terraform_cookie",
            defaults_from="/Common/cookie",
            match_across_pools="enabled",
            match_across_services="enabled",
            match_across_virtuals="enabled",
            timeout=3600,
            override_conn_limit="enabled",
            always_send="enabled",
            cookie_encryption="required",
            cookie_encryption_passphrase="iam",
            cookie_name="ham",
            expiration="1:0:0",
            hash_length=0)
        ```

        ## Reference

        `name` - (Required) Name of the virtual address

        `defaults_from` - (Required) Parent cookie persistence profile

        `match_across_pools` (Optional) (enabled or disabled) match across pools with given persistence record

        `match_across_services` (Optional) (enabled or disabled) match across services with given persistence record

        `match_across_virtuals` (Optional) (enabled or disabled) match across virtual servers with given persistence record

        `method` (Optional) Specifies the type of cookie processing that the system uses. The default value is insert

        `mirror` (Optional) (enabled or disabled) mirror persistence record

        `timeout` (Optional) (enabled or disabled) Timeout for persistence of the session in seconds

        `override_conn_limit` (Optional) (enabled or disabled) Enable or dissable pool member connection limits are overridden for persisted clients. Per-virtual connection limits remain hard limits and are not overridden.

        `always_send` (Optional) (enabled or disabled) always send cookies

        `cookie_encryption` (Optional) (required, preferred, or disabled) To required, preferred, or disabled policy for cookie encryption

        `cookie_encryption_passphrase` (Optional) (required, preferred, or disabled) Passphrase for encrypted cookies. The field is encrypted on the server and will always return differently then set.
        If this is configured specify `ignore_changes` under the `lifecycle` block to ignore returned encrypted value.

        `cookie_name` (Optional) Name of the cookie to track persistence

        `expiration` (Optional) Expiration TTL for cookie specified in DAY:HOUR:MIN:SECONDS (Examples: 1:0:0:0 one day, 1:0:0 one hour, 30:0 thirty minutes)

        `hash_length` (Optional) (Integer) Length of hash to apply to cookie

        `hash_offset` (Optional) (Integer) Number of characters to skip in the cookie for the hash

        `httponly` (Optional) (enabled or disabled) Sending only over http

        ## Importing

        An cookie persistence profile can be imported into this resource by supplying the Name in `full path` as `id`.
        An example is below:
        ```sh
        $ terraform import bigip_ltm_persistence_profile_cookie.test_ppcookie "/Common/terraform_cookie"
        ```

        :param str resource_name: The name of the resource.
        :param PersistenceProfileCookieArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PersistenceProfileCookieArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 always_send: Optional[pulumi.Input[_builtins.str]] = None,
                 app_service: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_encryption_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
                 cookie_name: Optional[pulumi.Input[_builtins.str]] = None,
                 defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.str]] = None,
                 hash_length: Optional[pulumi.Input[_builtins.int]] = None,
                 hash_offset: Optional[pulumi.Input[_builtins.int]] = None,
                 httponly: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_pools: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_services: Optional[pulumi.Input[_builtins.str]] = None,
                 match_across_virtuals: Optional[pulumi.Input[_builtins.str]] = None,
                 method: Optional[pulumi.Input[_builtins.str]] = None,
                 mirror: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 override_conn_limit: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PersistenceProfileCookieArgs.__new__(PersistenceProfileCookieArgs)

            __props__.__dict__["always_send"] = always_send
            __props__.__dict__["app_service"] = app_service
            __props__.__dict__["cookie_encryption"] = cookie_encryption
            __props__.__dict__["cookie_encryption_passphrase"] = cookie_encryption_passphrase
            __props__.__dict__["cookie_name"] = cookie_name
            if defaults_from is None and not opts.urn:
                raise TypeError("Missing required property 'defaults_from'")
            __props__.__dict__["defaults_from"] = defaults_from
            __props__.__dict__["expiration"] = expiration
            __props__.__dict__["hash_length"] = hash_length
            __props__.__dict__["hash_offset"] = hash_offset
            __props__.__dict__["httponly"] = httponly
            __props__.__dict__["match_across_pools"] = match_across_pools
            __props__.__dict__["match_across_services"] = match_across_services
            __props__.__dict__["match_across_virtuals"] = match_across_virtuals
            __props__.__dict__["method"] = method
            __props__.__dict__["mirror"] = mirror
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["override_conn_limit"] = override_conn_limit
            __props__.__dict__["timeout"] = timeout
        super(PersistenceProfileCookie, __self__).__init__(
            'f5bigip:ltm/persistenceProfileCookie:PersistenceProfileCookie',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            always_send: Optional[pulumi.Input[_builtins.str]] = None,
            app_service: Optional[pulumi.Input[_builtins.str]] = None,
            cookie_encryption: Optional[pulumi.Input[_builtins.str]] = None,
            cookie_encryption_passphrase: Optional[pulumi.Input[_builtins.str]] = None,
            cookie_name: Optional[pulumi.Input[_builtins.str]] = None,
            defaults_from: Optional[pulumi.Input[_builtins.str]] = None,
            expiration: Optional[pulumi.Input[_builtins.str]] = None,
            hash_length: Optional[pulumi.Input[_builtins.int]] = None,
            hash_offset: Optional[pulumi.Input[_builtins.int]] = None,
            httponly: Optional[pulumi.Input[_builtins.str]] = None,
            match_across_pools: Optional[pulumi.Input[_builtins.str]] = None,
            match_across_services: Optional[pulumi.Input[_builtins.str]] = None,
            match_across_virtuals: Optional[pulumi.Input[_builtins.str]] = None,
            method: Optional[pulumi.Input[_builtins.str]] = None,
            mirror: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            override_conn_limit: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None) -> 'PersistenceProfileCookie':
        """
        Get an existing PersistenceProfileCookie resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] always_send: To enable _ disable always sending cookies
        :param pulumi.Input[_builtins.str] cookie_encryption: To required, preferred, or disabled policy for cookie encryption
        :param pulumi.Input[_builtins.str] cookie_encryption_passphrase: Passphrase for encrypted cookies
        :param pulumi.Input[_builtins.str] cookie_name: Name of the cookie to track persistence
        :param pulumi.Input[_builtins.str] defaults_from: Inherit defaults from parent profile
        :param pulumi.Input[_builtins.str] expiration: Expiration TTL for cookie specified in D:H:M:S or in seconds
        :param pulumi.Input[_builtins.int] hash_length: Length of hash to apply to cookie
        :param pulumi.Input[_builtins.int] hash_offset: Number of characters to skip in the cookie for the hash
        :param pulumi.Input[_builtins.str] httponly: To enable _ disable sending only over http
        :param pulumi.Input[_builtins.str] match_across_pools: To enable _ disable match across pools with given persistence record
        :param pulumi.Input[_builtins.str] match_across_services: To enable _ disable match across services with given persistence record
        :param pulumi.Input[_builtins.str] match_across_virtuals: To enable _ disable match across virtual servers with given persistence record
        :param pulumi.Input[_builtins.str] method: Specifies the type of cookie processing that the system uses
        :param pulumi.Input[_builtins.str] mirror: To enable _ disable
        :param pulumi.Input[_builtins.str] name: Name of the persistence profile
        :param pulumi.Input[_builtins.str] override_conn_limit: To enable _ disable that pool member connection limits are overridden for persisted clients. Per-virtual connection limits remain hard limits and are not overridden.
        :param pulumi.Input[_builtins.int] timeout: Timeout for persistence of the session
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PersistenceProfileCookieState.__new__(_PersistenceProfileCookieState)

        __props__.__dict__["always_send"] = always_send
        __props__.__dict__["app_service"] = app_service
        __props__.__dict__["cookie_encryption"] = cookie_encryption
        __props__.__dict__["cookie_encryption_passphrase"] = cookie_encryption_passphrase
        __props__.__dict__["cookie_name"] = cookie_name
        __props__.__dict__["defaults_from"] = defaults_from
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["hash_length"] = hash_length
        __props__.__dict__["hash_offset"] = hash_offset
        __props__.__dict__["httponly"] = httponly
        __props__.__dict__["match_across_pools"] = match_across_pools
        __props__.__dict__["match_across_services"] = match_across_services
        __props__.__dict__["match_across_virtuals"] = match_across_virtuals
        __props__.__dict__["method"] = method
        __props__.__dict__["mirror"] = mirror
        __props__.__dict__["name"] = name
        __props__.__dict__["override_conn_limit"] = override_conn_limit
        __props__.__dict__["timeout"] = timeout
        return PersistenceProfileCookie(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alwaysSend")
    def always_send(self) -> pulumi.Output[_builtins.str]:
        """
        To enable _ disable always sending cookies
        """
        return pulumi.get(self, "always_send")

    @_builtins.property
    @pulumi.getter(name="appService")
    def app_service(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "app_service")

    @_builtins.property
    @pulumi.getter(name="cookieEncryption")
    def cookie_encryption(self) -> pulumi.Output[_builtins.str]:
        """
        To required, preferred, or disabled policy for cookie encryption
        """
        return pulumi.get(self, "cookie_encryption")

    @_builtins.property
    @pulumi.getter(name="cookieEncryptionPassphrase")
    def cookie_encryption_passphrase(self) -> pulumi.Output[_builtins.str]:
        """
        Passphrase for encrypted cookies
        """
        return pulumi.get(self, "cookie_encryption_passphrase")

    @_builtins.property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the cookie to track persistence
        """
        return pulumi.get(self, "cookie_name")

    @_builtins.property
    @pulumi.getter(name="defaultsFrom")
    def defaults_from(self) -> pulumi.Output[_builtins.str]:
        """
        Inherit defaults from parent profile
        """
        return pulumi.get(self, "defaults_from")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[_builtins.str]:
        """
        Expiration TTL for cookie specified in D:H:M:S or in seconds
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter(name="hashLength")
    def hash_length(self) -> pulumi.Output[_builtins.int]:
        """
        Length of hash to apply to cookie
        """
        return pulumi.get(self, "hash_length")

    @_builtins.property
    @pulumi.getter(name="hashOffset")
    def hash_offset(self) -> pulumi.Output[_builtins.int]:
        """
        Number of characters to skip in the cookie for the hash
        """
        return pulumi.get(self, "hash_offset")

    @_builtins.property
    @pulumi.getter
    def httponly(self) -> pulumi.Output[_builtins.str]:
        """
        To enable _ disable sending only over http
        """
        return pulumi.get(self, "httponly")

    @_builtins.property
    @pulumi.getter(name="matchAcrossPools")
    def match_across_pools(self) -> pulumi.Output[_builtins.str]:
        """
        To enable _ disable match across pools with given persistence record
        """
        return pulumi.get(self, "match_across_pools")

    @_builtins.property
    @pulumi.getter(name="matchAcrossServices")
    def match_across_services(self) -> pulumi.Output[_builtins.str]:
        """
        To enable _ disable match across services with given persistence record
        """
        return pulumi.get(self, "match_across_services")

    @_builtins.property
    @pulumi.getter(name="matchAcrossVirtuals")
    def match_across_virtuals(self) -> pulumi.Output[_builtins.str]:
        """
        To enable _ disable match across virtual servers with given persistence record
        """
        return pulumi.get(self, "match_across_virtuals")

    @_builtins.property
    @pulumi.getter
    def method(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the type of cookie processing that the system uses
        """
        return pulumi.get(self, "method")

    @_builtins.property
    @pulumi.getter
    def mirror(self) -> pulumi.Output[_builtins.str]:
        """
        To enable _ disable
        """
        return pulumi.get(self, "mirror")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the persistence profile
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="overrideConnLimit")
    def override_conn_limit(self) -> pulumi.Output[_builtins.str]:
        """
        To enable _ disable that pool member connection limits are overridden for persisted clients. Per-virtual connection limits remain hard limits and are not overridden.
        """
        return pulumi.get(self, "override_conn_limit")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Timeout for persistence of the session
        """
        return pulumi.get(self, "timeout")

