"""
ENCODE_list_files

List ENCODE files with filters (file_format, output_type, assay). Use to programmatically retriev...
"""

from typing import Any, Optional, Callable
from ._shared_client import get_shared_client


def ENCODE_list_files(
    file_type: Optional[str] = None,
    assay_title: Optional[str] = None,
    limit: Optional[int] = 10,
    *,
    stream_callback: Optional[Callable[[str], None]] = None,
    use_cache: bool = False,
    validate: bool = True,
) -> dict[str, Any]:
    """
    List ENCODE files with filters (file_format, output_type, assay). Use to programmatically retriev...

    Parameters
    ----------
    file_type : str
        File type filter (e.g., 'fastq', 'bam', 'bigWig').
    assay_title : str
        Assay filter (e.g., 'ChIP-seq').
    limit : int
        Max number of results (1–100).
    stream_callback : Callable, optional
        Callback for streaming output
    use_cache : bool, default False
        Enable caching
    validate : bool, default True
        Validate parameters

    Returns
    -------
    dict[str, Any]
    """
    # Handle mutable defaults to avoid B006 linting error

    return get_shared_client().run_one_function(
        {
            "name": "ENCODE_list_files",
            "arguments": {
                "file_type": file_type,
                "assay_title": assay_title,
                "limit": limit,
            },
        },
        stream_callback=stream_callback,
        use_cache=use_cache,
        validate=validate,
    )


__all__ = ["ENCODE_list_files"]
