# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.sandbox_options import SandboxOptions
from revengai.models.scrape_third_party_config import ScrapeThirdPartyConfig
from typing import Optional, Set
from typing_extensions import Self

class AnalysisConfig(BaseModel):
    """
    AnalysisConfig
    """ # noqa: E501
    scrape_third_party_config: Optional[ScrapeThirdPartyConfig] = Field(default=None, description="Settings to scrape third party sources")
    generate_cves: Optional[StrictBool] = Field(default=False, description="A configuration option for fetching CVEs data.")
    generate_sbom: Optional[StrictBool] = Field(default=False, description="A configuration option for generating software bill of materials data.")
    generate_capabilities: Optional[StrictBool] = Field(default=False, description="A configuration option for generating capabilities of a binary")
    no_cache: Optional[StrictBool] = Field(default=False, description="When enabled, skips using cached data within the processing.")
    advanced_analysis: Optional[StrictBool] = Field(default=False, description="Enables an advanced security analysis.")
    sandbox_config: Optional[SandboxOptions] = Field(default=None, description="Including a sandbox config enables the dynamic execution sandbox")
    __properties: ClassVar[List[str]] = ["scrape_third_party_config", "generate_cves", "generate_sbom", "generate_capabilities", "no_cache", "advanced_analysis", "sandbox_config"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AnalysisConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of scrape_third_party_config
        if self.scrape_third_party_config:
            _dict['scrape_third_party_config'] = self.scrape_third_party_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sandbox_config
        if self.sandbox_config:
            _dict['sandbox_config'] = self.sandbox_config.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AnalysisConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "scrape_third_party_config": ScrapeThirdPartyConfig.from_dict(obj["scrape_third_party_config"]) if obj.get("scrape_third_party_config") is not None else None,
            "generate_cves": obj.get("generate_cves") if obj.get("generate_cves") is not None else False,
            "generate_sbom": obj.get("generate_sbom") if obj.get("generate_sbom") is not None else False,
            "generate_capabilities": obj.get("generate_capabilities") if obj.get("generate_capabilities") is not None else False,
            "no_cache": obj.get("no_cache") if obj.get("no_cache") is not None else False,
            "advanced_analysis": obj.get("advanced_analysis") if obj.get("advanced_analysis") is not None else False,
            "sandbox_config": SandboxOptions.from_dict(obj["sandbox_config"]) if obj.get("sandbox_config") is not None else None
        })
        return _obj


