# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.file_format import FileFormat
from revengai.models.isa import ISA
from revengai.models.platform import Platform
from typing import Optional, Set
from typing_extensions import Self

class BinaryConfig(BaseModel):
    """
    BinaryConfig
    """ # noqa: E501
    isa: Optional[ISA] = None
    platform: Optional[Platform] = None
    file_format: Optional[FileFormat] = None
    __properties: ClassVar[List[str]] = ["isa", "platform", "file_format"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BinaryConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if isa (nullable) is None
        # and model_fields_set contains the field
        if self.isa is None and "isa" in self.model_fields_set:
            _dict['isa'] = None

        # set to None if platform (nullable) is None
        # and model_fields_set contains the field
        if self.platform is None and "platform" in self.model_fields_set:
            _dict['platform'] = None

        # set to None if file_format (nullable) is None
        # and model_fields_set contains the field
        if self.file_format is None and "file_format" in self.model_fields_set:
            _dict['file_format'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BinaryConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "isa": obj.get("isa"),
            "platform": obj.get("platform"),
            "file_format": obj.get("file_format")
        })
        return _obj


