# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class BinarySearchResult(BaseModel):
    """
    BinarySearchResult
    """ # noqa: E501
    binary_id: StrictInt = Field(description="The binary ID")
    binary_name: StrictStr = Field(description="The name of the binary")
    analysis_id: StrictInt = Field(description="The analysis ID")
    sha_256_hash: StrictStr = Field(description="The SHA-256 hash of the binary")
    tags: Optional[List[StrictStr]]
    created_at: datetime = Field(description="The creation date of the binary")
    model_id: StrictInt = Field(description="The model ID of the binary")
    model_name: StrictStr = Field(description="The name of the model")
    owned_by: StrictStr = Field(description="The owner of the binary")
    __properties: ClassVar[List[str]] = ["binary_id", "binary_name", "analysis_id", "sha_256_hash", "tags", "created_at", "model_id", "model_name", "owned_by"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of BinarySearchResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of BinarySearchResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "binary_id": obj.get("binary_id"),
            "binary_name": obj.get("binary_name"),
            "analysis_id": obj.get("analysis_id"),
            "sha_256_hash": obj.get("sha_256_hash"),
            "tags": obj.get("tags"),
            "created_at": obj.get("created_at"),
            "model_id": obj.get("model_id"),
            "model_name": obj.get("model_name"),
            "owned_by": obj.get("owned_by")
        })
        return _obj


