# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.collection_response_binaries_inner import CollectionResponseBinariesInner
from revengai.models.collection_scope import CollectionScope
from typing import Optional, Set
from typing_extensions import Self

class CollectionResponse(BaseModel):
    """
    CollectionResponse
    """ # noqa: E501
    collection_id: StrictInt = Field(description="Collection ID")
    collection_name: StrictStr = Field(description="Collection name")
    description: StrictStr = Field(description="Collection description")
    model_id: StrictInt = Field(description="Collection model ID")
    user_id: StrictInt = Field(description="Collection user ID")
    team_id: Optional[StrictInt] = None
    collection_scope: CollectionScope = Field(description="Collection public status")
    created_at: datetime = Field(description="Collection creation date")
    updated_at: datetime = Field(description="Collection last update date")
    tags: Optional[List[StrictStr]] = None
    binaries: Optional[List[CollectionResponseBinariesInner]] = None
    __properties: ClassVar[List[str]] = ["collection_id", "collection_name", "description", "model_id", "user_id", "team_id", "collection_scope", "created_at", "updated_at", "tags", "binaries"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CollectionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in binaries (list)
        _items = []
        if self.binaries:
            for _item_binaries in self.binaries:
                if _item_binaries:
                    _items.append(_item_binaries.to_dict())
            _dict['binaries'] = _items
        # set to None if team_id (nullable) is None
        # and model_fields_set contains the field
        if self.team_id is None and "team_id" in self.model_fields_set:
            _dict['team_id'] = None

        # set to None if tags (nullable) is None
        # and model_fields_set contains the field
        if self.tags is None and "tags" in self.model_fields_set:
            _dict['tags'] = None

        # set to None if binaries (nullable) is None
        # and model_fields_set contains the field
        if self.binaries is None and "binaries" in self.model_fields_set:
            _dict['binaries'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CollectionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "collection_id": obj.get("collection_id"),
            "collection_name": obj.get("collection_name"),
            "description": obj.get("description"),
            "model_id": obj.get("model_id"),
            "user_id": obj.get("user_id"),
            "team_id": obj.get("team_id"),
            "collection_scope": obj.get("collection_scope"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "tags": obj.get("tags"),
            "binaries": [CollectionResponseBinariesInner.from_dict(_item) for _item in obj["binaries"]] if obj.get("binaries") is not None else None
        })
        return _obj


