# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class ELFSegment(BaseModel):
    """
    ELFSegment
    """ # noqa: E501
    type: StrictStr
    virtual_address: StrictInt
    virtual_size: StrictInt
    physical_address: StrictInt
    physical_size: StrictInt
    file_offset: StrictInt
    flags: StrictStr
    flags_raw: StrictInt
    alignment: StrictInt
    __properties: ClassVar[List[str]] = ["type", "virtual_address", "virtual_size", "physical_address", "physical_size", "file_offset", "flags", "flags_raw", "alignment"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ELFSegment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ELFSegment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "virtual_address": obj.get("virtual_address"),
            "virtual_size": obj.get("virtual_size"),
            "physical_address": obj.get("physical_address"),
            "physical_size": obj.get("physical_size"),
            "file_offset": obj.get("file_offset"),
            "flags": obj.get("flags"),
            "flags_raw": obj.get("flags_raw"),
            "alignment": obj.get("alignment")
        })
        return _obj


