# coding: utf-8

"""
    RevEng.AI API

    RevEng.AI is Similarity Search Engine for executable binaries

    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from revengai.models.function_block_destination_response import FunctionBlockDestinationResponse
from typing import Optional, Set
from typing_extensions import Self

class FunctionBlockResponse(BaseModel):
    """
    FunctionBlockResponse
    """ # noqa: E501
    asm: List[StrictStr] = Field(description="The ordered assembly strings for this chunk")
    id: StrictInt = Field(description="ID of the block")
    min_addr: StrictInt = Field(description="The minimum vaddr of the block")
    max_addr: StrictInt = Field(description="The maximum vaddr of the block")
    destinations: List[FunctionBlockDestinationResponse] = Field(description="The potential execution flow destinations from this block")
    comment: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["asm", "id", "min_addr", "max_addr", "destinations", "comment"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FunctionBlockResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in destinations (list)
        _items = []
        if self.destinations:
            for _item_destinations in self.destinations:
                if _item_destinations:
                    _items.append(_item_destinations.to_dict())
            _dict['destinations'] = _items
        # set to None if comment (nullable) is None
        # and model_fields_set contains the field
        if self.comment is None and "comment" in self.model_fields_set:
            _dict['comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FunctionBlockResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "asm": obj.get("asm"),
            "id": obj.get("id"),
            "min_addr": obj.get("min_addr"),
            "max_addr": obj.get("max_addr"),
            "destinations": [FunctionBlockDestinationResponse.from_dict(_item) for _item in obj["destinations"]] if obj.get("destinations") is not None else None,
            "comment": obj.get("comment")
        })
        return _obj


