# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate_authority_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_body: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 early_renewal_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input['CertificateOptionsArgs']] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_options: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateValidationOptionArgs']]]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[_builtins.str] domain_name: Fully qualified domain name (FQDN) in the certificate.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               * Creating an Amazon issued certificate
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if certificate_authority_arn is not None:
            pulumi.set(__self__, "certificate_authority_arn", certificate_authority_arn)
        if certificate_body is not None:
            pulumi.set(__self__, "certificate_body", certificate_body)
        if certificate_chain is not None:
            pulumi.set(__self__, "certificate_chain", certificate_chain)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if early_renewal_duration is not None:
            pulumi.set(__self__, "early_renewal_duration", early_renewal_duration)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if validation_method is not None:
            pulumi.set(__self__, "validation_method", validation_method)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "certificate_authority_arn")

    @certificate_authority_arn.setter
    def certificate_authority_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_authority_arn", value)

    @_builtins.property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_body", value)

    @_builtins.property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_chain", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified domain name (FQDN) in the certificate.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="earlyRenewalDuration")
    def early_renewal_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "early_renewal_duration")

    @early_renewal_duration.setter
    def early_renewal_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "early_renewal_duration", value)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['CertificateOptionsArgs']]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['CertificateOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        * Creating an Amazon issued certificate
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "subject_alternative_names")

    @subject_alternative_names.setter
    def subject_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subject_alternative_names", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="validationMethod")
    def validation_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "validation_method")

    @validation_method.setter
    def validation_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_method", value)

    @_builtins.property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateValidationOptionArgs']]]]:
        return pulumi.get(self, "validation_options")

    @validation_options.setter
    def validation_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateValidationOptionArgs']]]]):
        pulumi.set(self, "validation_options", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_authority_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_body: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_validation_options: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateDomainValidationOptionArgs']]]] = None,
                 early_renewal_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 not_after: Optional[pulumi.Input[_builtins.str]] = None,
                 not_before: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input['CertificateOptionsArgs']] = None,
                 pending_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_eligibility: Optional[pulumi.Input[_builtins.str]] = None,
                 renewal_summaries: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateRenewalSummaryArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 validation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_options: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateValidationOptionArgs']]]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the certificate
        :param pulumi.Input[_builtins.str] domain_name: Fully qualified domain name (FQDN) in the certificate.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateDomainValidationOptionArgs']]] domain_validation_options: Set of domain validation objects which can be used to complete certificate validation.
               Can have more than one element, e.g., if SANs are defined.
               Only set if `DNS`-validation was used.
        :param pulumi.Input[_builtins.str] not_after: Expiration date and time of the certificate.
        :param pulumi.Input[_builtins.str] not_before: Start of the validity period of the certificate.
        :param pulumi.Input[_builtins.bool] pending_renewal: `true` if a Private certificate eligible for managed renewal is within the `early_renewal_duration` period.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               * Creating an Amazon issued certificate
        :param pulumi.Input[_builtins.str] renewal_eligibility: Whether the certificate is eligible for managed renewal.
        :param pulumi.Input[Sequence[pulumi.Input['CertificateRenewalSummaryArgs']]] renewal_summaries: Contains information about the status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for the certificate.
        :param pulumi.Input[_builtins.str] status: Status of the certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: Source of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] validation_emails: List of addresses that received a validation email. Only set if `EMAIL` validation was used.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate_authority_arn is not None:
            pulumi.set(__self__, "certificate_authority_arn", certificate_authority_arn)
        if certificate_body is not None:
            pulumi.set(__self__, "certificate_body", certificate_body)
        if certificate_chain is not None:
            pulumi.set(__self__, "certificate_chain", certificate_chain)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_validation_options is not None:
            pulumi.set(__self__, "domain_validation_options", domain_validation_options)
        if early_renewal_duration is not None:
            pulumi.set(__self__, "early_renewal_duration", early_renewal_duration)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if not_after is not None:
            pulumi.set(__self__, "not_after", not_after)
        if not_before is not None:
            pulumi.set(__self__, "not_before", not_before)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if pending_renewal is not None:
            pulumi.set(__self__, "pending_renewal", pending_renewal)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if renewal_eligibility is not None:
            pulumi.set(__self__, "renewal_eligibility", renewal_eligibility)
        if renewal_summaries is not None:
            pulumi.set(__self__, "renewal_summaries", renewal_summaries)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subject_alternative_names is not None:
            pulumi.set(__self__, "subject_alternative_names", subject_alternative_names)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validation_emails is not None:
            pulumi.set(__self__, "validation_emails", validation_emails)
        if validation_method is not None:
            pulumi.set(__self__, "validation_method", validation_method)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the certificate
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "certificate_authority_arn")

    @certificate_authority_arn.setter
    def certificate_authority_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_authority_arn", value)

    @_builtins.property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "certificate_body")

    @certificate_body.setter
    def certificate_body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_body", value)

    @_builtins.property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_chain", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully qualified domain name (FQDN) in the certificate.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="domainValidationOptions")
    def domain_validation_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateDomainValidationOptionArgs']]]]:
        """
        Set of domain validation objects which can be used to complete certificate validation.
        Can have more than one element, e.g., if SANs are defined.
        Only set if `DNS`-validation was used.
        """
        return pulumi.get(self, "domain_validation_options")

    @domain_validation_options.setter
    def domain_validation_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateDomainValidationOptionArgs']]]]):
        pulumi.set(self, "domain_validation_options", value)

    @_builtins.property
    @pulumi.getter(name="earlyRenewalDuration")
    def early_renewal_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "early_renewal_duration")

    @early_renewal_duration.setter
    def early_renewal_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "early_renewal_duration", value)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration date and time of the certificate.
        """
        return pulumi.get(self, "not_after")

    @not_after.setter
    def not_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_after", value)

    @_builtins.property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Start of the validity period of the certificate.
        """
        return pulumi.get(self, "not_before")

    @not_before.setter
    def not_before(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "not_before", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['CertificateOptionsArgs']]:
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['CertificateOptionsArgs']]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="pendingRenewal")
    def pending_renewal(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        `true` if a Private certificate eligible for managed renewal is within the `early_renewal_duration` period.
        """
        return pulumi.get(self, "pending_renewal")

    @pending_renewal.setter
    def pending_renewal(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "pending_renewal", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        * Creating an Amazon issued certificate
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="renewalEligibility")
    def renewal_eligibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the certificate is eligible for managed renewal.
        """
        return pulumi.get(self, "renewal_eligibility")

    @renewal_eligibility.setter
    def renewal_eligibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "renewal_eligibility", value)

    @_builtins.property
    @pulumi.getter(name="renewalSummaries")
    def renewal_summaries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateRenewalSummaryArgs']]]]:
        """
        Contains information about the status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for the certificate.
        """
        return pulumi.get(self, "renewal_summaries")

    @renewal_summaries.setter
    def renewal_summaries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateRenewalSummaryArgs']]]]):
        pulumi.set(self, "renewal_summaries", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the certificate.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "subject_alternative_names")

    @subject_alternative_names.setter
    def subject_alternative_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subject_alternative_names", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source of the certificate.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="validationEmails")
    def validation_emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of addresses that received a validation email. Only set if `EMAIL` validation was used.
        """
        return pulumi.get(self, "validation_emails")

    @validation_emails.setter
    def validation_emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "validation_emails", value)

    @_builtins.property
    @pulumi.getter(name="validationMethod")
    def validation_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "validation_method")

    @validation_method.setter
    def validation_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validation_method", value)

    @_builtins.property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CertificateValidationOptionArgs']]]]:
        return pulumi.get(self, "validation_options")

    @validation_options.setter
    def validation_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CertificateValidationOptionArgs']]]]):
        pulumi.set(self, "validation_options", value)


@pulumi.type_token("aws:acm/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_body: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 early_renewal_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['CertificateOptionsArgs', 'CertificateOptionsArgsDict']]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateValidationOptionArgs', 'CertificateValidationOptionArgsDict']]]]] = None,
                 __props__=None):
        """
        The ACM certificate resource allows requesting and management of certificates
        from the Amazon Certificate Manager.

        ACM certificates can be created in three ways:
        Amazon-issued, where AWS provides the certificate authority and automatically manages renewal;
        imported certificates, issued by another certificate authority;
        and private certificates, issued using an ACM Private Certificate Authority.

        ## Amazon-Issued Certificates

        For Amazon-issued certificates, this resource deals with requesting certificates and managing their attributes and life-cycle.
        This resource does not deal with validation of a certificate but can provide inputs
        for other resources implementing the validation.
        It does not wait for a certificate to be issued.
        Use a `acm.CertificateValidation` resource for this.

        Most commonly, this resource is used together with `route53.Record` and
        `acm.CertificateValidation` to request a DNS validated certificate,
        deploy the required validation records and wait for validation to complete.

        Domain validation through email is also supported but should be avoided as it requires a manual step outside of this provider.

        ## Certificates Imported from Other Certificate Authority

        Imported certificates can be used to make certificates created with an external certificate authority available for AWS services.

        As they are not managed by AWS, imported certificates are not eligible for automatic renewal.
        New certificate materials can be supplied to an existing imported certificate to update it in place.

        ## Private Certificates

        Private certificates are issued by an ACM Private Certificate Authority, which can be created using the resource type `acmpca.CertificateAuthority`.

        Private certificates created using this resource are eligible for managed renewal if they have been exported or associated with another AWS service.
        See [managed renewal documentation](https://docs.aws.amazon.com/acm/latest/userguide/managed-renewal.html) for more information.
        By default, a certificate is valid for 395 days and the managed renewal process will start 60 days before expiration.
        To renew the certificate earlier than 60 days before expiration, configure `early_renewal_duration`.

        ## Example Usage

        ### Custom Domain Validation Options

        ```python
        import pulumi
        import pulumi_aws as aws

        cert = aws.acm.Certificate("cert",
            domain_name="testing.example.com",
            validation_method="EMAIL",
            validation_options=[{
                "domain_name": "testing.example.com",
                "validation_domain": "example.com",
            }])
        ```

        ### Existing Certificate Body Import

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_tls as tls

        example = tls.index.PrivateKey("example", algorithm=RSA)
        example_self_signed_cert = tls.index.SelfSignedCert("example",
            key_algorithm=RSA,
            private_key_pem=example.private_key_pem,
            subject=[{
                commonName: example.com,
                organization: ACME Examples, Inc,
            }],
            validity_period_hours=12,
            allowed_uses=[
                key_encipherment,
                digital_signature,
                server_auth,
            ])
        cert = aws.acm.Certificate("cert",
            private_key=example["privateKeyPem"],
            certificate_body=example_self_signed_cert["certPem"])
        ```

        ### Referencing domain_validation_options With for_each Based Resources

        See the `acm.CertificateValidation` resource for a full example of performing DNS validation.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate({dvo.domain_name: {
            name: dvo.resource_record_name,
            record: dvo.resource_record_value,
            type: dvo.resource_record_type,
        } for dvo in example_aws_acm_certificate.domain_validation_options})]:
            example.append(aws.route53.Record(f"example-{range['key']}",
                allow_overwrite=True,
                name=range["value"]["name"],
                records=[range["value"]["record"]],
                ttl=60,
                type=aws.route53.RecordType(range["value"]["type"]),
                zone_id=example_aws_route53_zone["zoneId"]))
        ```

        ## Import

        Using `pulumi import`, import certificates using their ARN. For example:

        ```sh
        $ pulumi import aws:acm/certificate:Certificate cert arn:aws:acm:eu-central-1:123456789012:certificate/7e7a28d2-163f-4b8f-b9cd-822f96c08d6a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_name: Fully qualified domain name (FQDN) in the certificate.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               * Creating an Amazon issued certificate
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CertificateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ACM certificate resource allows requesting and management of certificates
        from the Amazon Certificate Manager.

        ACM certificates can be created in three ways:
        Amazon-issued, where AWS provides the certificate authority and automatically manages renewal;
        imported certificates, issued by another certificate authority;
        and private certificates, issued using an ACM Private Certificate Authority.

        ## Amazon-Issued Certificates

        For Amazon-issued certificates, this resource deals with requesting certificates and managing their attributes and life-cycle.
        This resource does not deal with validation of a certificate but can provide inputs
        for other resources implementing the validation.
        It does not wait for a certificate to be issued.
        Use a `acm.CertificateValidation` resource for this.

        Most commonly, this resource is used together with `route53.Record` and
        `acm.CertificateValidation` to request a DNS validated certificate,
        deploy the required validation records and wait for validation to complete.

        Domain validation through email is also supported but should be avoided as it requires a manual step outside of this provider.

        ## Certificates Imported from Other Certificate Authority

        Imported certificates can be used to make certificates created with an external certificate authority available for AWS services.

        As they are not managed by AWS, imported certificates are not eligible for automatic renewal.
        New certificate materials can be supplied to an existing imported certificate to update it in place.

        ## Private Certificates

        Private certificates are issued by an ACM Private Certificate Authority, which can be created using the resource type `acmpca.CertificateAuthority`.

        Private certificates created using this resource are eligible for managed renewal if they have been exported or associated with another AWS service.
        See [managed renewal documentation](https://docs.aws.amazon.com/acm/latest/userguide/managed-renewal.html) for more information.
        By default, a certificate is valid for 395 days and the managed renewal process will start 60 days before expiration.
        To renew the certificate earlier than 60 days before expiration, configure `early_renewal_duration`.

        ## Example Usage

        ### Custom Domain Validation Options

        ```python
        import pulumi
        import pulumi_aws as aws

        cert = aws.acm.Certificate("cert",
            domain_name="testing.example.com",
            validation_method="EMAIL",
            validation_options=[{
                "domain_name": "testing.example.com",
                "validation_domain": "example.com",
            }])
        ```

        ### Existing Certificate Body Import

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_tls as tls

        example = tls.index.PrivateKey("example", algorithm=RSA)
        example_self_signed_cert = tls.index.SelfSignedCert("example",
            key_algorithm=RSA,
            private_key_pem=example.private_key_pem,
            subject=[{
                commonName: example.com,
                organization: ACME Examples, Inc,
            }],
            validity_period_hours=12,
            allowed_uses=[
                key_encipherment,
                digital_signature,
                server_auth,
            ])
        cert = aws.acm.Certificate("cert",
            private_key=example["privateKeyPem"],
            certificate_body=example_self_signed_cert["certPem"])
        ```

        ### Referencing domain_validation_options With for_each Based Resources

        See the `acm.CertificateValidation` resource for a full example of performing DNS validation.

        ```python
        import pulumi
        import pulumi_aws as aws

        example = []
        for range in [{"key": k, "value": v} for [k, v] in enumerate({dvo.domain_name: {
            name: dvo.resource_record_name,
            record: dvo.resource_record_value,
            type: dvo.resource_record_type,
        } for dvo in example_aws_acm_certificate.domain_validation_options})]:
            example.append(aws.route53.Record(f"example-{range['key']}",
                allow_overwrite=True,
                name=range["value"]["name"],
                records=[range["value"]["record"]],
                ttl=60,
                type=aws.route53.RecordType(range["value"]["type"]),
                zone_id=example_aws_route53_zone["zoneId"]))
        ```

        ## Import

        Using `pulumi import`, import certificates using their ARN. For example:

        ```sh
        $ pulumi import aws:acm/certificate:Certificate cert arn:aws:acm:eu-central-1:123456789012:certificate/7e7a28d2-163f-4b8f-b9cd-822f96c08d6a
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_authority_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_body: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 early_renewal_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 options: Optional[pulumi.Input[Union['CertificateOptionsArgs', 'CertificateOptionsArgsDict']]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validation_method: Optional[pulumi.Input[_builtins.str]] = None,
                 validation_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateValidationOptionArgs', 'CertificateValidationOptionArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["certificate_authority_arn"] = certificate_authority_arn
            __props__.__dict__["certificate_body"] = certificate_body
            __props__.__dict__["certificate_chain"] = certificate_chain
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["early_renewal_duration"] = early_renewal_duration
            __props__.__dict__["key_algorithm"] = key_algorithm
            __props__.__dict__["options"] = options
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["region"] = region
            __props__.__dict__["subject_alternative_names"] = subject_alternative_names
            __props__.__dict__["tags"] = tags
            __props__.__dict__["validation_method"] = validation_method
            __props__.__dict__["validation_options"] = validation_options
            __props__.__dict__["arn"] = None
            __props__.__dict__["domain_validation_options"] = None
            __props__.__dict__["not_after"] = None
            __props__.__dict__["not_before"] = None
            __props__.__dict__["pending_renewal"] = None
            __props__.__dict__["renewal_eligibility"] = None
            __props__.__dict__["renewal_summaries"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["validation_emails"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'aws:acm/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_authority_arn: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_body: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_chain: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain_validation_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateDomainValidationOptionArgs', 'CertificateDomainValidationOptionArgsDict']]]]] = None,
            early_renewal_duration: Optional[pulumi.Input[_builtins.str]] = None,
            key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            not_after: Optional[pulumi.Input[_builtins.str]] = None,
            not_before: Optional[pulumi.Input[_builtins.str]] = None,
            options: Optional[pulumi.Input[Union['CertificateOptionsArgs', 'CertificateOptionsArgsDict']]] = None,
            pending_renewal: Optional[pulumi.Input[_builtins.bool]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_eligibility: Optional[pulumi.Input[_builtins.str]] = None,
            renewal_summaries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateRenewalSummaryArgs', 'CertificateRenewalSummaryArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subject_alternative_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            validation_emails: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            validation_method: Optional[pulumi.Input[_builtins.str]] = None,
            validation_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CertificateValidationOptionArgs', 'CertificateValidationOptionArgsDict']]]]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the certificate
        :param pulumi.Input[_builtins.str] domain_name: Fully qualified domain name (FQDN) in the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateDomainValidationOptionArgs', 'CertificateDomainValidationOptionArgsDict']]]] domain_validation_options: Set of domain validation objects which can be used to complete certificate validation.
               Can have more than one element, e.g., if SANs are defined.
               Only set if `DNS`-validation was used.
        :param pulumi.Input[_builtins.str] not_after: Expiration date and time of the certificate.
        :param pulumi.Input[_builtins.str] not_before: Start of the validity period of the certificate.
        :param pulumi.Input[_builtins.bool] pending_renewal: `true` if a Private certificate eligible for managed renewal is within the `early_renewal_duration` period.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
               * Creating an Amazon issued certificate
        :param pulumi.Input[_builtins.str] renewal_eligibility: Whether the certificate is eligible for managed renewal.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CertificateRenewalSummaryArgs', 'CertificateRenewalSummaryArgsDict']]]] renewal_summaries: Contains information about the status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for the certificate.
        :param pulumi.Input[_builtins.str] status: Status of the certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: Source of the certificate.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] validation_emails: List of addresses that received a validation email. Only set if `EMAIL` validation was used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate_authority_arn"] = certificate_authority_arn
        __props__.__dict__["certificate_body"] = certificate_body
        __props__.__dict__["certificate_chain"] = certificate_chain
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["domain_validation_options"] = domain_validation_options
        __props__.__dict__["early_renewal_duration"] = early_renewal_duration
        __props__.__dict__["key_algorithm"] = key_algorithm
        __props__.__dict__["not_after"] = not_after
        __props__.__dict__["not_before"] = not_before
        __props__.__dict__["options"] = options
        __props__.__dict__["pending_renewal"] = pending_renewal
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["region"] = region
        __props__.__dict__["renewal_eligibility"] = renewal_eligibility
        __props__.__dict__["renewal_summaries"] = renewal_summaries
        __props__.__dict__["status"] = status
        __props__.__dict__["subject_alternative_names"] = subject_alternative_names
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        __props__.__dict__["validation_emails"] = validation_emails
        __props__.__dict__["validation_method"] = validation_method
        __props__.__dict__["validation_options"] = validation_options
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the certificate
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "certificate_authority_arn")

    @_builtins.property
    @pulumi.getter(name="certificateBody")
    def certificate_body(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "certificate_body")

    @_builtins.property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "certificate_chain")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Fully qualified domain name (FQDN) in the certificate.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainValidationOptions")
    def domain_validation_options(self) -> pulumi.Output[Sequence['outputs.CertificateDomainValidationOption']]:
        """
        Set of domain validation objects which can be used to complete certificate validation.
        Can have more than one element, e.g., if SANs are defined.
        Only set if `DNS`-validation was used.
        """
        return pulumi.get(self, "domain_validation_options")

    @_builtins.property
    @pulumi.getter(name="earlyRenewalDuration")
    def early_renewal_duration(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "early_renewal_duration")

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "key_algorithm")

    @_builtins.property
    @pulumi.getter(name="notAfter")
    def not_after(self) -> pulumi.Output[_builtins.str]:
        """
        Expiration date and time of the certificate.
        """
        return pulumi.get(self, "not_after")

    @_builtins.property
    @pulumi.getter(name="notBefore")
    def not_before(self) -> pulumi.Output[_builtins.str]:
        """
        Start of the validity period of the certificate.
        """
        return pulumi.get(self, "not_before")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output['outputs.CertificateOptions']:
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="pendingRenewal")
    def pending_renewal(self) -> pulumi.Output[_builtins.bool]:
        """
        `true` if a Private certificate eligible for managed renewal is within the `early_renewal_duration` period.
        """
        return pulumi.get(self, "pending_renewal")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        * Creating an Amazon issued certificate
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="renewalEligibility")
    def renewal_eligibility(self) -> pulumi.Output[_builtins.str]:
        """
        Whether the certificate is eligible for managed renewal.
        """
        return pulumi.get(self, "renewal_eligibility")

    @_builtins.property
    @pulumi.getter(name="renewalSummaries")
    def renewal_summaries(self) -> pulumi.Output[Sequence['outputs.CertificateRenewalSummary']]:
        """
        Contains information about the status of ACM's [managed renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html) for the certificate.
        """
        return pulumi.get(self, "renewal_summaries")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the certificate.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subjectAlternativeNames")
    def subject_alternative_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "subject_alternative_names")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Source of the certificate.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="validationEmails")
    def validation_emails(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of addresses that received a validation email. Only set if `EMAIL` validation was used.
        """
        return pulumi.get(self, "validation_emails")

    @_builtins.property
    @pulumi.getter(name="validationMethod")
    def validation_method(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "validation_method")

    @_builtins.property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> pulumi.Output[Optional[Sequence['outputs.CertificateValidationOption']]]:
        return pulumi.get(self, "validation_options")

