# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate_authority_arn: pulumi.Input[_builtins.str],
                 certificate_signing_request: pulumi.Input[_builtins.str],
                 signing_algorithm: pulumi.Input[_builtins.str],
                 validity: pulumi.Input['CertificateValidityArgs'],
                 api_passthrough: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 template_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[_builtins.str] certificate_authority_arn: ARN of the certificate authority.
        :param pulumi.Input[_builtins.str] certificate_signing_request: Certificate Signing Request in PEM format.
        :param pulumi.Input[_builtins.str] signing_algorithm: Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
        :param pulumi.Input['CertificateValidityArgs'] validity: Configures end of the validity period for the certificate. See validity block below.
        :param pulumi.Input[_builtins.str] api_passthrough: Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] template_arn: Template to use when issuing a certificate.
               See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
        """
        pulumi.set(__self__, "certificate_authority_arn", certificate_authority_arn)
        pulumi.set(__self__, "certificate_signing_request", certificate_signing_request)
        pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        pulumi.set(__self__, "validity", validity)
        if api_passthrough is not None:
            pulumi.set(__self__, "api_passthrough", api_passthrough)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if template_arn is not None:
            pulumi.set(__self__, "template_arn", template_arn)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> pulumi.Input[_builtins.str]:
        """
        ARN of the certificate authority.
        """
        return pulumi.get(self, "certificate_authority_arn")

    @certificate_authority_arn.setter
    def certificate_authority_arn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_authority_arn", value)

    @_builtins.property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> pulumi.Input[_builtins.str]:
        """
        Certificate Signing Request in PEM format.
        """
        return pulumi.get(self, "certificate_signing_request")

    @certificate_signing_request.setter
    def certificate_signing_request(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_signing_request", value)

    @_builtins.property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Input[_builtins.str]:
        """
        Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "signing_algorithm", value)

    @_builtins.property
    @pulumi.getter
    def validity(self) -> pulumi.Input['CertificateValidityArgs']:
        """
        Configures end of the validity period for the certificate. See validity block below.
        """
        return pulumi.get(self, "validity")

    @validity.setter
    def validity(self, value: pulumi.Input['CertificateValidityArgs']):
        pulumi.set(self, "validity", value)

    @_builtins.property
    @pulumi.getter(name="apiPassthrough")
    def api_passthrough(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
        """
        return pulumi.get(self, "api_passthrough")

    @api_passthrough.setter
    def api_passthrough(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_passthrough", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="templateArn")
    def template_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template to use when issuing a certificate.
        See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
        """
        return pulumi.get(self, "template_arn")

    @template_arn.setter
    def template_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_arn", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 api_passthrough: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_authority_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_chain: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_signing_request: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 template_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 validity: Optional[pulumi.Input['CertificateValidityArgs']] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[_builtins.str] api_passthrough: Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
        :param pulumi.Input[_builtins.str] arn: ARN of the certificate.
        :param pulumi.Input[_builtins.str] certificate: PEM-encoded certificate value.
        :param pulumi.Input[_builtins.str] certificate_authority_arn: ARN of the certificate authority.
        :param pulumi.Input[_builtins.str] certificate_chain: PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA.
        :param pulumi.Input[_builtins.str] certificate_signing_request: Certificate Signing Request in PEM format.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] signing_algorithm: Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
        :param pulumi.Input[_builtins.str] template_arn: Template to use when issuing a certificate.
               See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
        :param pulumi.Input['CertificateValidityArgs'] validity: Configures end of the validity period for the certificate. See validity block below.
        """
        if api_passthrough is not None:
            pulumi.set(__self__, "api_passthrough", api_passthrough)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_authority_arn is not None:
            pulumi.set(__self__, "certificate_authority_arn", certificate_authority_arn)
        if certificate_chain is not None:
            pulumi.set(__self__, "certificate_chain", certificate_chain)
        if certificate_signing_request is not None:
            pulumi.set(__self__, "certificate_signing_request", certificate_signing_request)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if signing_algorithm is not None:
            pulumi.set(__self__, "signing_algorithm", signing_algorithm)
        if template_arn is not None:
            pulumi.set(__self__, "template_arn", template_arn)
        if validity is not None:
            pulumi.set(__self__, "validity", validity)

    @_builtins.property
    @pulumi.getter(name="apiPassthrough")
    def api_passthrough(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
        """
        return pulumi.get(self, "api_passthrough")

    @api_passthrough.setter
    def api_passthrough(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_passthrough", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the certificate.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM-encoded certificate value.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the certificate authority.
        """
        return pulumi.get(self, "certificate_authority_arn")

    @certificate_authority_arn.setter
    def certificate_authority_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_authority_arn", value)

    @_builtins.property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA.
        """
        return pulumi.get(self, "certificate_chain")

    @certificate_chain.setter
    def certificate_chain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_chain", value)

    @_builtins.property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Certificate Signing Request in PEM format.
        """
        return pulumi.get(self, "certificate_signing_request")

    @certificate_signing_request.setter
    def certificate_signing_request(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_signing_request", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signing_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="templateArn")
    def template_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Template to use when issuing a certificate.
        See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
        """
        return pulumi.get(self, "template_arn")

    @template_arn.setter
    def template_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_arn", value)

    @_builtins.property
    @pulumi.getter
    def validity(self) -> Optional[pulumi.Input['CertificateValidityArgs']]:
        """
        Configures end of the validity period for the certificate. See validity block below.
        """
        return pulumi.get(self, "validity")

    @validity.setter
    def validity(self, value: Optional[pulumi.Input['CertificateValidityArgs']]):
        pulumi.set(self, "validity", value)


@pulumi.type_token("aws:acmpca/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_passthrough: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_authority_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_signing_request: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 template_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 validity: Optional[pulumi.Input[Union['CertificateValidityArgs', 'CertificateValidityArgsDict']]] = None,
                 __props__=None):
        """
        Provides a resource to issue a certificate using AWS Certificate Manager Private Certificate Authority (ACM PCA).

        Certificates created using `acmpca.Certificate` are not eligible for automatic renewal,
        and must be replaced instead.
        To issue a renewable certificate using an ACM PCA, create a `acm.Certificate`
        with the parameter `certificate_authority_arn`.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_tls as tls

        example_certificate_authority = aws.acmpca.CertificateAuthority("example",
            certificate_authority_configuration={
                "key_algorithm": "RSA_4096",
                "signing_algorithm": "SHA512WITHRSA",
                "subject": {
                    "common_name": "example.com",
                },
            },
            permanent_deletion_time_in_days=7)
        key = tls.index.PrivateKey("key", algorithm=RSA)
        csr = tls.index.CertRequest("csr",
            private_key_pem=key.private_key_pem,
            subject=[{
                commonName: example,
            }])
        example = aws.acmpca.Certificate("example",
            certificate_authority_arn=example_certificate_authority.arn,
            certificate_signing_request=csr["certRequestPem"],
            signing_algorithm="SHA256WITHRSA",
            validity={
                "type": "YEARS",
                "value": "1",
            })
        ```

        ## Import

        Using `pulumi import`, import ACM PCA Certificates using their ARN. For example:

        ```sh
        $ pulumi import aws:acmpca/certificate:Certificate cert arn:aws:acm-pca:eu-west-1:675225743824:certificate-authority/08319ede-83g9-1400-8f21-c7d12b2b6edb/certificate/a4e9c2aa4bcfab625g1b9136464cd3a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_passthrough: Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
        :param pulumi.Input[_builtins.str] certificate_authority_arn: ARN of the certificate authority.
        :param pulumi.Input[_builtins.str] certificate_signing_request: Certificate Signing Request in PEM format.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] signing_algorithm: Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
        :param pulumi.Input[_builtins.str] template_arn: Template to use when issuing a certificate.
               See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
        :param pulumi.Input[Union['CertificateValidityArgs', 'CertificateValidityArgsDict']] validity: Configures end of the validity period for the certificate. See validity block below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to issue a certificate using AWS Certificate Manager Private Certificate Authority (ACM PCA).

        Certificates created using `acmpca.Certificate` are not eligible for automatic renewal,
        and must be replaced instead.
        To issue a renewable certificate using an ACM PCA, create a `acm.Certificate`
        with the parameter `certificate_authority_arn`.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_tls as tls

        example_certificate_authority = aws.acmpca.CertificateAuthority("example",
            certificate_authority_configuration={
                "key_algorithm": "RSA_4096",
                "signing_algorithm": "SHA512WITHRSA",
                "subject": {
                    "common_name": "example.com",
                },
            },
            permanent_deletion_time_in_days=7)
        key = tls.index.PrivateKey("key", algorithm=RSA)
        csr = tls.index.CertRequest("csr",
            private_key_pem=key.private_key_pem,
            subject=[{
                commonName: example,
            }])
        example = aws.acmpca.Certificate("example",
            certificate_authority_arn=example_certificate_authority.arn,
            certificate_signing_request=csr["certRequestPem"],
            signing_algorithm="SHA256WITHRSA",
            validity={
                "type": "YEARS",
                "value": "1",
            })
        ```

        ## Import

        Using `pulumi import`, import ACM PCA Certificates using their ARN. For example:

        ```sh
        $ pulumi import aws:acmpca/certificate:Certificate cert arn:aws:acm-pca:eu-west-1:675225743824:certificate-authority/08319ede-83g9-1400-8f21-c7d12b2b6edb/certificate/a4e9c2aa4bcfab625g1b9136464cd3a
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_passthrough: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_authority_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_signing_request: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 signing_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 template_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 validity: Optional[pulumi.Input[Union['CertificateValidityArgs', 'CertificateValidityArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["api_passthrough"] = api_passthrough
            if certificate_authority_arn is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_authority_arn'")
            __props__.__dict__["certificate_authority_arn"] = certificate_authority_arn
            if certificate_signing_request is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_signing_request'")
            __props__.__dict__["certificate_signing_request"] = certificate_signing_request
            __props__.__dict__["region"] = region
            if signing_algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'signing_algorithm'")
            __props__.__dict__["signing_algorithm"] = signing_algorithm
            __props__.__dict__["template_arn"] = template_arn
            if validity is None and not opts.urn:
                raise TypeError("Missing required property 'validity'")
            __props__.__dict__["validity"] = validity
            __props__.__dict__["arn"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["certificate_chain"] = None
        super(Certificate, __self__).__init__(
            'aws:acmpca/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_passthrough: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_authority_arn: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_chain: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_signing_request: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            signing_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            template_arn: Optional[pulumi.Input[_builtins.str]] = None,
            validity: Optional[pulumi.Input[Union['CertificateValidityArgs', 'CertificateValidityArgsDict']]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_passthrough: Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
        :param pulumi.Input[_builtins.str] arn: ARN of the certificate.
        :param pulumi.Input[_builtins.str] certificate: PEM-encoded certificate value.
        :param pulumi.Input[_builtins.str] certificate_authority_arn: ARN of the certificate authority.
        :param pulumi.Input[_builtins.str] certificate_chain: PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA.
        :param pulumi.Input[_builtins.str] certificate_signing_request: Certificate Signing Request in PEM format.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] signing_algorithm: Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
        :param pulumi.Input[_builtins.str] template_arn: Template to use when issuing a certificate.
               See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
        :param pulumi.Input[Union['CertificateValidityArgs', 'CertificateValidityArgsDict']] validity: Configures end of the validity period for the certificate. See validity block below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["api_passthrough"] = api_passthrough
        __props__.__dict__["arn"] = arn
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificate_authority_arn"] = certificate_authority_arn
        __props__.__dict__["certificate_chain"] = certificate_chain
        __props__.__dict__["certificate_signing_request"] = certificate_signing_request
        __props__.__dict__["region"] = region
        __props__.__dict__["signing_algorithm"] = signing_algorithm
        __props__.__dict__["template_arn"] = template_arn
        __props__.__dict__["validity"] = validity
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiPassthrough")
    def api_passthrough(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies X.509 certificate information to be included in the issued certificate. To use with API Passthrough templates
        """
        return pulumi.get(self, "api_passthrough")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the certificate.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        PEM-encoded certificate value.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the certificate authority.
        """
        return pulumi.get(self, "certificate_authority_arn")

    @_builtins.property
    @pulumi.getter(name="certificateChain")
    def certificate_chain(self) -> pulumi.Output[_builtins.str]:
        """
        PEM-encoded certificate chain that includes any intermediate certificates and chains up to root CA.
        """
        return pulumi.get(self, "certificate_chain")

    @_builtins.property
    @pulumi.getter(name="certificateSigningRequest")
    def certificate_signing_request(self) -> pulumi.Output[_builtins.str]:
        """
        Certificate Signing Request in PEM format.
        """
        return pulumi.get(self, "certificate_signing_request")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        Algorithm to use to sign certificate requests. Valid values: `SHA256WITHRSA`, `SHA256WITHECDSA`, `SHA384WITHRSA`, `SHA384WITHECDSA`, `SHA512WITHRSA`, `SHA512WITHECDSA`.
        """
        return pulumi.get(self, "signing_algorithm")

    @_builtins.property
    @pulumi.getter(name="templateArn")
    def template_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Template to use when issuing a certificate.
        See [ACM PCA Documentation](https://docs.aws.amazon.com/privateca/latest/userguide/UsingTemplates.html) for more information.
        """
        return pulumi.get(self, "template_arn")

    @_builtins.property
    @pulumi.getter
    def validity(self) -> pulumi.Output['outputs.CertificateValidity']:
        """
        Configures end of the validity period for the certificate. See validity block below.
        """
        return pulumi.get(self, "validity")

