# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'QueryLoggingConfigurationDestination',
    'QueryLoggingConfigurationDestinationCloudwatchLogs',
    'QueryLoggingConfigurationDestinationFilters',
    'QueryLoggingConfigurationTimeouts',
    'ScraperDestination',
    'ScraperDestinationAmp',
    'ScraperRoleConfiguration',
    'ScraperSource',
    'ScraperSourceEks',
    'ScraperTimeouts',
    'WorkspaceConfigurationLimitsPerLabelSet',
    'WorkspaceConfigurationLimitsPerLabelSetLimits',
    'WorkspaceConfigurationTimeouts',
    'WorkspaceLoggingConfiguration',
]

@pulumi.output_type
class QueryLoggingConfigurationDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogs":
            suggest = "cloudwatch_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryLoggingConfigurationDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryLoggingConfigurationDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryLoggingConfigurationDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs: Optional['outputs.QueryLoggingConfigurationDestinationCloudwatchLogs'] = None,
                 filters: Optional['outputs.QueryLoggingConfigurationDestinationFilters'] = None):
        """
        :param 'QueryLoggingConfigurationDestinationCloudwatchLogsArgs' cloudwatch_logs: Configuration block for CloudWatch Logs destination. See `cloudwatch_logs`.
        :param 'QueryLoggingConfigurationDestinationFiltersArgs' filters: A list of filter configurations that specify which logs should be sent to the destination. See `filters`.
        """
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional['outputs.QueryLoggingConfigurationDestinationCloudwatchLogs']:
        """
        Configuration block for CloudWatch Logs destination. See `cloudwatch_logs`.
        """
        return pulumi.get(self, "cloudwatch_logs")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional['outputs.QueryLoggingConfigurationDestinationFilters']:
        """
        A list of filter configurations that specify which logs should be sent to the destination. See `filters`.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class QueryLoggingConfigurationDestinationCloudwatchLogs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupArn":
            suggest = "log_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryLoggingConfigurationDestinationCloudwatchLogs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryLoggingConfigurationDestinationCloudwatchLogs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryLoggingConfigurationDestinationCloudwatchLogs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_arn: _builtins.str):
        """
        :param _builtins.str log_group_arn: The ARN of the CloudWatch log group to which query logs will be sent.
        """
        pulumi.set(__self__, "log_group_arn", log_group_arn)

    @_builtins.property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> _builtins.str:
        """
        The ARN of the CloudWatch log group to which query logs will be sent.
        """
        return pulumi.get(self, "log_group_arn")


@pulumi.output_type
class QueryLoggingConfigurationDestinationFilters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "qspThreshold":
            suggest = "qsp_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in QueryLoggingConfigurationDestinationFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        QueryLoggingConfigurationDestinationFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        QueryLoggingConfigurationDestinationFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 qsp_threshold: _builtins.int):
        """
        :param _builtins.int qsp_threshold: The Query Samples Processed (QSP) threshold above which queries will be logged. Queries processing more samples than this threshold will be captured in logs.
        """
        pulumi.set(__self__, "qsp_threshold", qsp_threshold)

    @_builtins.property
    @pulumi.getter(name="qspThreshold")
    def qsp_threshold(self) -> _builtins.int:
        """
        The Query Samples Processed (QSP) threshold above which queries will be logged. Queries processing more samples than this threshold will be captured in logs.
        """
        return pulumi.get(self, "qsp_threshold")


@pulumi.output_type
class QueryLoggingConfigurationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class ScraperDestination(dict):
    def __init__(__self__, *,
                 amp: Optional['outputs.ScraperDestinationAmp'] = None):
        """
        :param 'ScraperDestinationAmpArgs' amp: Configuration block for an Amazon Managed Prometheus workspace destination. See `amp`.
        """
        if amp is not None:
            pulumi.set(__self__, "amp", amp)

    @_builtins.property
    @pulumi.getter
    def amp(self) -> Optional['outputs.ScraperDestinationAmp']:
        """
        Configuration block for an Amazon Managed Prometheus workspace destination. See `amp`.
        """
        return pulumi.get(self, "amp")


@pulumi.output_type
class ScraperDestinationAmp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workspaceArn":
            suggest = "workspace_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScraperDestinationAmp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScraperDestinationAmp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScraperDestinationAmp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workspace_arn: _builtins.str):
        """
        :param _builtins.str workspace_arn: The Amazon Resource Name (ARN) of the prometheus workspace.
        """
        pulumi.set(__self__, "workspace_arn", workspace_arn)

    @_builtins.property
    @pulumi.getter(name="workspaceArn")
    def workspace_arn(self) -> _builtins.str:
        """
        The Amazon Resource Name (ARN) of the prometheus workspace.
        """
        return pulumi.get(self, "workspace_arn")


@pulumi.output_type
class ScraperRoleConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRoleArn":
            suggest = "source_role_arn"
        elif key == "targetRoleArn":
            suggest = "target_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScraperRoleConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScraperRoleConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScraperRoleConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_role_arn: Optional[_builtins.str] = None,
                 target_role_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str source_role_arn: The Amazon Resource Name (ARN) of the source role configuration. Must be an IAM role ARN.
        :param _builtins.str target_role_arn: The Amazon Resource Name (ARN) of the target role configuration. Must be an IAM role ARN.
        """
        if source_role_arn is not None:
            pulumi.set(__self__, "source_role_arn", source_role_arn)
        if target_role_arn is not None:
            pulumi.set(__self__, "target_role_arn", target_role_arn)

    @_builtins.property
    @pulumi.getter(name="sourceRoleArn")
    def source_role_arn(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the source role configuration. Must be an IAM role ARN.
        """
        return pulumi.get(self, "source_role_arn")

    @_builtins.property
    @pulumi.getter(name="targetRoleArn")
    def target_role_arn(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the target role configuration. Must be an IAM role ARN.
        """
        return pulumi.get(self, "target_role_arn")


@pulumi.output_type
class ScraperSource(dict):
    def __init__(__self__, *,
                 eks: Optional['outputs.ScraperSourceEks'] = None):
        """
        :param 'ScraperSourceEksArgs' eks: Configuration block for an EKS cluster source. See `eks`.
        """
        if eks is not None:
            pulumi.set(__self__, "eks", eks)

    @_builtins.property
    @pulumi.getter
    def eks(self) -> Optional['outputs.ScraperSourceEks']:
        """
        Configuration block for an EKS cluster source. See `eks`.
        """
        return pulumi.get(self, "eks")


@pulumi.output_type
class ScraperSourceEks(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterArn":
            suggest = "cluster_arn"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScraperSourceEks. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScraperSourceEks.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScraperSourceEks.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_arn: _builtins.str,
                 subnet_ids: Sequence[_builtins.str],
                 security_group_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] subnet_ids: List of subnet IDs. Must be in at least two different availability zones.
        :param Sequence[_builtins.str] security_group_ids: List of the security group IDs for the Amazon EKS cluster VPC configuration.
        """
        pulumi.set(__self__, "cluster_arn", cluster_arn)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @_builtins.property
    @pulumi.getter(name="clusterArn")
    def cluster_arn(self) -> _builtins.str:
        return pulumi.get(self, "cluster_arn")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[_builtins.str]:
        """
        List of subnet IDs. Must be in at least two different availability zones.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of the security group IDs for the Amazon EKS cluster VPC configuration.
        """
        return pulumi.get(self, "security_group_ids")


@pulumi.output_type
class ScraperTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class WorkspaceConfigurationLimitsPerLabelSet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelSet":
            suggest = "label_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceConfigurationLimitsPerLabelSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceConfigurationLimitsPerLabelSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceConfigurationLimitsPerLabelSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_set: Mapping[str, _builtins.str],
                 limits: Optional['outputs.WorkspaceConfigurationLimitsPerLabelSetLimits'] = None):
        """
        :param Mapping[str, _builtins.str] label_set: Map of label key-value pairs that identify the metrics to which the limits apply. An empty map represents the default bucket for metrics that don't match any other label set.
        :param 'WorkspaceConfigurationLimitsPerLabelSetLimitsArgs' limits: Configuration block for the limits to apply to the specified label set. Detailed below.
        """
        pulumi.set(__self__, "label_set", label_set)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @_builtins.property
    @pulumi.getter(name="labelSet")
    def label_set(self) -> Mapping[str, _builtins.str]:
        """
        Map of label key-value pairs that identify the metrics to which the limits apply. An empty map represents the default bucket for metrics that don't match any other label set.
        """
        return pulumi.get(self, "label_set")

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional['outputs.WorkspaceConfigurationLimitsPerLabelSetLimits']:
        """
        Configuration block for the limits to apply to the specified label set. Detailed below.
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class WorkspaceConfigurationLimitsPerLabelSetLimits(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSeries":
            suggest = "max_series"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceConfigurationLimitsPerLabelSetLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceConfigurationLimitsPerLabelSetLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceConfigurationLimitsPerLabelSetLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_series: _builtins.int):
        """
        :param _builtins.int max_series: Maximum number of active time series that can be ingested for metrics matching the label set.
        """
        pulumi.set(__self__, "max_series", max_series)

    @_builtins.property
    @pulumi.getter(name="maxSeries")
    def max_series(self) -> _builtins.int:
        """
        Maximum number of active time series that can be ingested for metrics matching the label set.
        """
        return pulumi.get(self, "max_series")


@pulumi.output_type
class WorkspaceConfigurationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class WorkspaceLoggingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupArn":
            suggest = "log_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceLoggingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceLoggingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceLoggingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_arn: _builtins.str):
        """
        :param _builtins.str log_group_arn: The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist.
        """
        pulumi.set(__self__, "log_group_arn", log_group_arn)

    @_builtins.property
    @pulumi.getter(name="logGroupArn")
    def log_group_arn(self) -> _builtins.str:
        """
        The ARN of the CloudWatch log group to which the vended log data will be published. This log group must exist.
        """
        return pulumi.get(self, "log_group_arn")


