# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAuthorizersResult',
    'AwaitableGetAuthorizersResult',
    'get_authorizers',
    'get_authorizers_output',
]

@pulumi.output_type
class GetAuthorizersResult:
    """
    A collection of values returned by getAuthorizers.
    """
    def __init__(__self__, id=None, ids=None, region=None, rest_api_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rest_api_id and not isinstance(rest_api_id, str):
            raise TypeError("Expected argument 'rest_api_id' to be a str")
        pulumi.set(__self__, "rest_api_id", rest_api_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        List of Authorizer identifiers.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="restApiId")
    def rest_api_id(self) -> _builtins.str:
        return pulumi.get(self, "rest_api_id")


class AwaitableGetAuthorizersResult(GetAuthorizersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthorizersResult(
            id=self.id,
            ids=self.ids,
            region=self.region,
            rest_api_id=self.rest_api_id)


def get_authorizers(region: Optional[_builtins.str] = None,
                    rest_api_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthorizersResult:
    """
    Provides details about multiple API Gateway Authorizers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_authorizers(rest_api_id=example_aws_api_gateway_rest_api["id"])
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str rest_api_id: ID of the associated REST API.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['restApiId'] = rest_api_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:apigateway/getAuthorizers:getAuthorizers', __args__, opts=opts, typ=GetAuthorizersResult).value

    return AwaitableGetAuthorizersResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        region=pulumi.get(__ret__, 'region'),
        rest_api_id=pulumi.get(__ret__, 'rest_api_id'))
def get_authorizers_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           rest_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAuthorizersResult]:
    """
    Provides details about multiple API Gateway Authorizers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.apigateway.get_authorizers(rest_api_id=example_aws_api_gateway_rest_api["id"])
    ```


    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str rest_api_id: ID of the associated REST API.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['restApiId'] = rest_api_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:apigateway/getAuthorizers:getAuthorizers', __args__, opts=opts, typ=GetAuthorizersResult)
    return __ret__.apply(lambda __response__: GetAuthorizersResult(
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        region=pulumi.get(__response__, 'region'),
        rest_api_id=pulumi.get(__response__, 'rest_api_id')))
