# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 http_method: pulumi.Input[_builtins.str],
                 resource_id: pulumi.Input[_builtins.str],
                 rest_api: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 cache_key_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 content_handling: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 passthrough_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeout_milliseconds: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_config: Optional[pulumi.Input['IntegrationTlsConfigArgs']] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input[_builtins.str] http_method: HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
               when calling the associated resource.
        :param pulumi.Input[_builtins.str] resource_id: API resource ID.
        :param pulumi.Input[_builtins.str] rest_api: ID of the associated REST API.
        :param pulumi.Input[_builtins.str] type: Integration input's [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_key_parameters: List of cache key parameters for the integration.
        :param pulumi.Input[_builtins.str] cache_namespace: Integration's cache namespace.
        :param pulumi.Input[_builtins.str] connection_id: ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
        :param pulumi.Input[_builtins.str] connection_type: Integration input's [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
        :param pulumi.Input[_builtins.str] content_handling: How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        :param pulumi.Input[_builtins.str] credentials: Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role's ARN. To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*`.
        :param pulumi.Input[_builtins.str] integration_http_method: Integration HTTP method
               (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
               **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
               Not all methods are compatible with all `AWS` integrations.
               e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
        :param pulumi.Input[_builtins.str] passthrough_behavior: Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_parameters: Map of request query string parameters and headers that should be passed to the backend responder.
               For example: `request_parameters = { "integration.request.header.X-Some-Other-Header" = "method.request.header.X-Some-Header" }`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_templates: Map of the integration's request templates.
        :param pulumi.Input[_builtins.int] timeout_milliseconds: Custom timeout between 50 and 300,000 milliseconds. The default value is 29,000 milliseconds. You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase time beyond 29,000 milliseconds.
        :param pulumi.Input['IntegrationTlsConfigArgs'] tls_config: TLS configuration. See below.
        :param pulumi.Input[_builtins.str] uri: Input's URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
               For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
               e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:123456789012:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
        """
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "rest_api", rest_api)
        pulumi.set(__self__, "type", type)
        if cache_key_parameters is not None:
            pulumi.set(__self__, "cache_key_parameters", cache_key_parameters)
        if cache_namespace is not None:
            pulumi.set(__self__, "cache_namespace", cache_namespace)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if content_handling is not None:
            pulumi.set(__self__, "content_handling", content_handling)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if integration_http_method is not None:
            pulumi.set(__self__, "integration_http_method", integration_http_method)
        if passthrough_behavior is not None:
            pulumi.set(__self__, "passthrough_behavior", passthrough_behavior)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if request_templates is not None:
            pulumi.set(__self__, "request_templates", request_templates)
        if timeout_milliseconds is not None:
            pulumi.set(__self__, "timeout_milliseconds", timeout_milliseconds)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> pulumi.Input[_builtins.str]:
        """
        HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
        when calling the associated resource.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "http_method", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        API resource ID.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="restApi")
    def rest_api(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the associated REST API.
        """
        return pulumi.get(self, "rest_api")

    @rest_api.setter
    def rest_api(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rest_api", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Integration input's [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="cacheKeyParameters")
    def cache_key_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of cache key parameters for the integration.
        """
        return pulumi.get(self, "cache_key_parameters")

    @cache_key_parameters.setter
    def cache_key_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_key_parameters", value)

    @_builtins.property
    @pulumi.getter(name="cacheNamespace")
    def cache_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration's cache namespace.
        """
        return pulumi.get(self, "cache_namespace")

    @cache_namespace.setter
    def cache_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_namespace", value)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration input's [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_type", value)

    @_builtins.property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        """
        return pulumi.get(self, "content_handling")

    @content_handling.setter
    def content_handling(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_handling", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role's ARN. To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*`.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="integrationHttpMethod")
    def integration_http_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration HTTP method
        (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
        **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
        Not all methods are compatible with all `AWS` integrations.
        e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
        """
        return pulumi.get(self, "integration_http_method")

    @integration_http_method.setter
    def integration_http_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_http_method", value)

    @_builtins.property
    @pulumi.getter(name="passthroughBehavior")
    def passthrough_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
        """
        return pulumi.get(self, "passthrough_behavior")

    @passthrough_behavior.setter
    def passthrough_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passthrough_behavior", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of request query string parameters and headers that should be passed to the backend responder.
        For example: `request_parameters = { "integration.request.header.X-Some-Other-Header" = "method.request.header.X-Some-Header" }`
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_parameters", value)

    @_builtins.property
    @pulumi.getter(name="requestTemplates")
    def request_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of the integration's request templates.
        """
        return pulumi.get(self, "request_templates")

    @request_templates.setter
    def request_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_templates", value)

    @_builtins.property
    @pulumi.getter(name="timeoutMilliseconds")
    def timeout_milliseconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Custom timeout between 50 and 300,000 milliseconds. The default value is 29,000 milliseconds. You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase time beyond 29,000 milliseconds.
        """
        return pulumi.get(self, "timeout_milliseconds")

    @timeout_milliseconds.setter
    def timeout_milliseconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_milliseconds", value)

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['IntegrationTlsConfigArgs']]:
        """
        TLS configuration. See below.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['IntegrationTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Input's URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
        For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
        e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:123456789012:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 cache_key_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 content_handling: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 passthrough_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_api: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_milliseconds: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_config: Optional[pulumi.Input['IntegrationTlsConfigArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_key_parameters: List of cache key parameters for the integration.
        :param pulumi.Input[_builtins.str] cache_namespace: Integration's cache namespace.
        :param pulumi.Input[_builtins.str] connection_id: ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
        :param pulumi.Input[_builtins.str] connection_type: Integration input's [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
        :param pulumi.Input[_builtins.str] content_handling: How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        :param pulumi.Input[_builtins.str] credentials: Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role's ARN. To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*`.
        :param pulumi.Input[_builtins.str] http_method: HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
               when calling the associated resource.
        :param pulumi.Input[_builtins.str] integration_http_method: Integration HTTP method
               (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
               **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
               Not all methods are compatible with all `AWS` integrations.
               e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
        :param pulumi.Input[_builtins.str] passthrough_behavior: Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_parameters: Map of request query string parameters and headers that should be passed to the backend responder.
               For example: `request_parameters = { "integration.request.header.X-Some-Other-Header" = "method.request.header.X-Some-Header" }`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_templates: Map of the integration's request templates.
        :param pulumi.Input[_builtins.str] resource_id: API resource ID.
        :param pulumi.Input[_builtins.str] rest_api: ID of the associated REST API.
        :param pulumi.Input[_builtins.int] timeout_milliseconds: Custom timeout between 50 and 300,000 milliseconds. The default value is 29,000 milliseconds. You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase time beyond 29,000 milliseconds.
        :param pulumi.Input['IntegrationTlsConfigArgs'] tls_config: TLS configuration. See below.
        :param pulumi.Input[_builtins.str] type: Integration input's [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        :param pulumi.Input[_builtins.str] uri: Input's URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
               For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
               e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:123456789012:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
        """
        if cache_key_parameters is not None:
            pulumi.set(__self__, "cache_key_parameters", cache_key_parameters)
        if cache_namespace is not None:
            pulumi.set(__self__, "cache_namespace", cache_namespace)
        if connection_id is not None:
            pulumi.set(__self__, "connection_id", connection_id)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if content_handling is not None:
            pulumi.set(__self__, "content_handling", content_handling)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if integration_http_method is not None:
            pulumi.set(__self__, "integration_http_method", integration_http_method)
        if passthrough_behavior is not None:
            pulumi.set(__self__, "passthrough_behavior", passthrough_behavior)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_parameters is not None:
            pulumi.set(__self__, "request_parameters", request_parameters)
        if request_templates is not None:
            pulumi.set(__self__, "request_templates", request_templates)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if rest_api is not None:
            pulumi.set(__self__, "rest_api", rest_api)
        if timeout_milliseconds is not None:
            pulumi.set(__self__, "timeout_milliseconds", timeout_milliseconds)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter(name="cacheKeyParameters")
    def cache_key_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of cache key parameters for the integration.
        """
        return pulumi.get(self, "cache_key_parameters")

    @cache_key_parameters.setter
    def cache_key_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "cache_key_parameters", value)

    @_builtins.property
    @pulumi.getter(name="cacheNamespace")
    def cache_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration's cache namespace.
        """
        return pulumi.get(self, "cache_namespace")

    @cache_namespace.setter
    def cache_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_namespace", value)

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
        """
        return pulumi.get(self, "connection_id")

    @connection_id.setter
    def connection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_id", value)

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration input's [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_type", value)

    @_builtins.property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        """
        return pulumi.get(self, "content_handling")

    @content_handling.setter
    def content_handling(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_handling", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role's ARN. To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*`.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
        when calling the associated resource.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_method", value)

    @_builtins.property
    @pulumi.getter(name="integrationHttpMethod")
    def integration_http_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration HTTP method
        (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
        **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
        Not all methods are compatible with all `AWS` integrations.
        e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
        """
        return pulumi.get(self, "integration_http_method")

    @integration_http_method.setter
    def integration_http_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_http_method", value)

    @_builtins.property
    @pulumi.getter(name="passthroughBehavior")
    def passthrough_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
        """
        return pulumi.get(self, "passthrough_behavior")

    @passthrough_behavior.setter
    def passthrough_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "passthrough_behavior", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of request query string parameters and headers that should be passed to the backend responder.
        For example: `request_parameters = { "integration.request.header.X-Some-Other-Header" = "method.request.header.X-Some-Header" }`
        """
        return pulumi.get(self, "request_parameters")

    @request_parameters.setter
    def request_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_parameters", value)

    @_builtins.property
    @pulumi.getter(name="requestTemplates")
    def request_templates(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of the integration's request templates.
        """
        return pulumi.get(self, "request_templates")

    @request_templates.setter
    def request_templates(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "request_templates", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API resource ID.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="restApi")
    def rest_api(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the associated REST API.
        """
        return pulumi.get(self, "rest_api")

    @rest_api.setter
    def rest_api(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_api", value)

    @_builtins.property
    @pulumi.getter(name="timeoutMilliseconds")
    def timeout_milliseconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Custom timeout between 50 and 300,000 milliseconds. The default value is 29,000 milliseconds. You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase time beyond 29,000 milliseconds.
        """
        return pulumi.get(self, "timeout_milliseconds")

    @timeout_milliseconds.setter
    def timeout_milliseconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout_milliseconds", value)

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['IntegrationTlsConfigArgs']]:
        """
        TLS configuration. See below.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['IntegrationTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration input's [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Input's URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
        For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
        e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:123456789012:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.type_token("aws:apigateway/integration:Integration")
class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_key_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 content_handling: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 passthrough_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_api: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_milliseconds: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_config: Optional[pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an HTTP Method Integration for an API Gateway Integration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
            name="MyDemoAPI",
            description="This is my API for demonstration purposes")
        my_demo_resource = aws.apigateway.Resource("MyDemoResource",
            rest_api=my_demo_api.id,
            parent_id=my_demo_api.root_resource_id,
            path_part="mydemoresource")
        my_demo_method = aws.apigateway.Method("MyDemoMethod",
            rest_api=my_demo_api.id,
            resource_id=my_demo_resource.id,
            http_method="GET",
            authorization="NONE")
        my_demo_integration = aws.apigateway.Integration("MyDemoIntegration",
            rest_api=my_demo_api.id,
            resource_id=my_demo_resource.id,
            http_method=my_demo_method.http_method,
            type="MOCK",
            cache_key_parameters=["method.request.path.param"],
            cache_namespace="foobar",
            timeout_milliseconds=29000,
            request_parameters={
                "integration.request.header.X-Authorization": "'static'",
            },
            request_templates={
                "application/xml": \"\"\"{
           "body" : $input.json('$')
        }
        \"\"\",
            })
        ```

        ## Lambda integration

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        config = pulumi.Config()
        myregion = config.require_object("myregion")
        account_id = config.require_object("accountId")
        # API Gateway
        api = aws.apigateway.RestApi("api", name="myapi")
        resource = aws.apigateway.Resource("resource",
            path_part="resource",
            parent_id=api.root_resource_id,
            rest_api=api.id)
        method = aws.apigateway.Method("method",
            rest_api=api.id,
            resource_id=resource.id,
            http_method="GET",
            authorization="NONE")
        # IAM
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["lambda.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        role = aws.iam.Role("role",
            name="myrole",
            assume_role_policy=assume_role.json)
        lambda_ = aws.lambda_.Function("lambda",
            code=pulumi.FileArchive("lambda.zip"),
            name="mylambda",
            role=role.arn,
            handler="lambda.lambda_handler",
            runtime=aws.lambda_.Runtime.PYTHON3D12,
            source_code_hash=std.filebase64sha256(input="lambda.zip").result)
        integration = aws.apigateway.Integration("integration",
            rest_api=api.id,
            resource_id=resource.id,
            http_method=method.http_method,
            integration_http_method="POST",
            type="AWS_PROXY",
            uri=lambda_.invoke_arn)
        # Lambda
        apigw_lambda = aws.lambda_.Permission("apigw_lambda",
            statement_id="AllowExecutionFromAPIGateway",
            action="lambda:InvokeFunction",
            function=lambda_.name,
            principal="apigateway.amazonaws.com",
            source_arn=pulumi.Output.all(
                id=api.id,
                http_method=method.http_method,
                path=resource.path
        ).apply(lambda resolved_outputs: f"arn:aws:execute-api:{myregion}:{account_id}:{resolved_outputs['id']}/*/{resolved_outputs['http_method']}{resolved_outputs['path']}")
        )
        ```

        ## VPC Link

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        name = config.require_object("name")
        subnet_id = config.require_object("subnetId")
        test = aws.lb.LoadBalancer("test",
            name=name,
            internal=True,
            load_balancer_type="network",
            subnets=[subnet_id])
        test_vpc_link = aws.apigateway.VpcLink("test",
            name=name,
            target_arn=test.arn)
        test_rest_api = aws.apigateway.RestApi("test", name=name)
        test_resource = aws.apigateway.Resource("test",
            rest_api=test_rest_api.id,
            parent_id=test_rest_api.root_resource_id,
            path_part="test")
        test_method = aws.apigateway.Method("test",
            rest_api=test_rest_api.id,
            resource_id=test_resource.id,
            http_method="GET",
            authorization="NONE",
            request_models={
                "application/json": "Error",
            })
        test_integration = aws.apigateway.Integration("test",
            rest_api=test_rest_api.id,
            resource_id=test_resource.id,
            http_method=test_method.http_method,
            request_templates={
                "application/json": "",
                "application/xml": \"\"\"#set($inputRoot = $input.path('$'))
        { }\"\"\",
            },
            request_parameters={
                "integration.request.header.X-Authorization": "'static'",
                "integration.request.header.X-Foo": "'Bar'",
            },
            type="HTTP",
            uri="https://www.google.de",
            integration_http_method="GET",
            passthrough_behavior="WHEN_NO_MATCH",
            content_handling="CONVERT_TO_TEXT",
            connection_type="VPC_LINK",
            connection_id=test_vpc_link.id)
        ```

        ## Import

        Using `pulumi import`, import `aws_api_gateway_integration` using `REST-API-ID/RESOURCE-ID/HTTP-METHOD`. For example:

        ```sh
        $ pulumi import aws:apigateway/integration:Integration example 12345abcde/67890fghij/GET
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_key_parameters: List of cache key parameters for the integration.
        :param pulumi.Input[_builtins.str] cache_namespace: Integration's cache namespace.
        :param pulumi.Input[_builtins.str] connection_id: ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
        :param pulumi.Input[_builtins.str] connection_type: Integration input's [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
        :param pulumi.Input[_builtins.str] content_handling: How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        :param pulumi.Input[_builtins.str] credentials: Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role's ARN. To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*`.
        :param pulumi.Input[_builtins.str] http_method: HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
               when calling the associated resource.
        :param pulumi.Input[_builtins.str] integration_http_method: Integration HTTP method
               (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
               **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
               Not all methods are compatible with all `AWS` integrations.
               e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
        :param pulumi.Input[_builtins.str] passthrough_behavior: Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_parameters: Map of request query string parameters and headers that should be passed to the backend responder.
               For example: `request_parameters = { "integration.request.header.X-Some-Other-Header" = "method.request.header.X-Some-Header" }`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_templates: Map of the integration's request templates.
        :param pulumi.Input[_builtins.str] resource_id: API resource ID.
        :param pulumi.Input[_builtins.str] rest_api: ID of the associated REST API.
        :param pulumi.Input[_builtins.int] timeout_milliseconds: Custom timeout between 50 and 300,000 milliseconds. The default value is 29,000 milliseconds. You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase time beyond 29,000 milliseconds.
        :param pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']] tls_config: TLS configuration. See below.
        :param pulumi.Input[_builtins.str] type: Integration input's [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        :param pulumi.Input[_builtins.str] uri: Input's URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
               For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
               e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:123456789012:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an HTTP Method Integration for an API Gateway Integration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        my_demo_api = aws.apigateway.RestApi("MyDemoAPI",
            name="MyDemoAPI",
            description="This is my API for demonstration purposes")
        my_demo_resource = aws.apigateway.Resource("MyDemoResource",
            rest_api=my_demo_api.id,
            parent_id=my_demo_api.root_resource_id,
            path_part="mydemoresource")
        my_demo_method = aws.apigateway.Method("MyDemoMethod",
            rest_api=my_demo_api.id,
            resource_id=my_demo_resource.id,
            http_method="GET",
            authorization="NONE")
        my_demo_integration = aws.apigateway.Integration("MyDemoIntegration",
            rest_api=my_demo_api.id,
            resource_id=my_demo_resource.id,
            http_method=my_demo_method.http_method,
            type="MOCK",
            cache_key_parameters=["method.request.path.param"],
            cache_namespace="foobar",
            timeout_milliseconds=29000,
            request_parameters={
                "integration.request.header.X-Authorization": "'static'",
            },
            request_templates={
                "application/xml": \"\"\"{
           "body" : $input.json('$')
        }
        \"\"\",
            })
        ```

        ## Lambda integration

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_std as std

        config = pulumi.Config()
        myregion = config.require_object("myregion")
        account_id = config.require_object("accountId")
        # API Gateway
        api = aws.apigateway.RestApi("api", name="myapi")
        resource = aws.apigateway.Resource("resource",
            path_part="resource",
            parent_id=api.root_resource_id,
            rest_api=api.id)
        method = aws.apigateway.Method("method",
            rest_api=api.id,
            resource_id=resource.id,
            http_method="GET",
            authorization="NONE")
        # IAM
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["lambda.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        role = aws.iam.Role("role",
            name="myrole",
            assume_role_policy=assume_role.json)
        lambda_ = aws.lambda_.Function("lambda",
            code=pulumi.FileArchive("lambda.zip"),
            name="mylambda",
            role=role.arn,
            handler="lambda.lambda_handler",
            runtime=aws.lambda_.Runtime.PYTHON3D12,
            source_code_hash=std.filebase64sha256(input="lambda.zip").result)
        integration = aws.apigateway.Integration("integration",
            rest_api=api.id,
            resource_id=resource.id,
            http_method=method.http_method,
            integration_http_method="POST",
            type="AWS_PROXY",
            uri=lambda_.invoke_arn)
        # Lambda
        apigw_lambda = aws.lambda_.Permission("apigw_lambda",
            statement_id="AllowExecutionFromAPIGateway",
            action="lambda:InvokeFunction",
            function=lambda_.name,
            principal="apigateway.amazonaws.com",
            source_arn=pulumi.Output.all(
                id=api.id,
                http_method=method.http_method,
                path=resource.path
        ).apply(lambda resolved_outputs: f"arn:aws:execute-api:{myregion}:{account_id}:{resolved_outputs['id']}/*/{resolved_outputs['http_method']}{resolved_outputs['path']}")
        )
        ```

        ## VPC Link

        ```python
        import pulumi
        import pulumi_aws as aws

        config = pulumi.Config()
        name = config.require_object("name")
        subnet_id = config.require_object("subnetId")
        test = aws.lb.LoadBalancer("test",
            name=name,
            internal=True,
            load_balancer_type="network",
            subnets=[subnet_id])
        test_vpc_link = aws.apigateway.VpcLink("test",
            name=name,
            target_arn=test.arn)
        test_rest_api = aws.apigateway.RestApi("test", name=name)
        test_resource = aws.apigateway.Resource("test",
            rest_api=test_rest_api.id,
            parent_id=test_rest_api.root_resource_id,
            path_part="test")
        test_method = aws.apigateway.Method("test",
            rest_api=test_rest_api.id,
            resource_id=test_resource.id,
            http_method="GET",
            authorization="NONE",
            request_models={
                "application/json": "Error",
            })
        test_integration = aws.apigateway.Integration("test",
            rest_api=test_rest_api.id,
            resource_id=test_resource.id,
            http_method=test_method.http_method,
            request_templates={
                "application/json": "",
                "application/xml": \"\"\"#set($inputRoot = $input.path('$'))
        { }\"\"\",
            },
            request_parameters={
                "integration.request.header.X-Authorization": "'static'",
                "integration.request.header.X-Foo": "'Bar'",
            },
            type="HTTP",
            uri="https://www.google.de",
            integration_http_method="GET",
            passthrough_behavior="WHEN_NO_MATCH",
            content_handling="CONVERT_TO_TEXT",
            connection_type="VPC_LINK",
            connection_id=test_vpc_link.id)
        ```

        ## Import

        Using `pulumi import`, import `aws_api_gateway_integration` using `REST-API-ID/RESOURCE-ID/HTTP-METHOD`. For example:

        ```sh
        $ pulumi import aws:apigateway/integration:Integration example 12345abcde/67890fghij/GET
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_key_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cache_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[_builtins.str]] = None,
                 content_handling: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[_builtins.str]] = None,
                 http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 passthrough_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_api: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout_milliseconds: Optional[pulumi.Input[_builtins.int]] = None,
                 tls_config: Optional[pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            __props__.__dict__["cache_key_parameters"] = cache_key_parameters
            __props__.__dict__["cache_namespace"] = cache_namespace
            __props__.__dict__["connection_id"] = connection_id
            __props__.__dict__["connection_type"] = connection_type
            __props__.__dict__["content_handling"] = content_handling
            __props__.__dict__["credentials"] = credentials
            if http_method is None and not opts.urn:
                raise TypeError("Missing required property 'http_method'")
            __props__.__dict__["http_method"] = http_method
            __props__.__dict__["integration_http_method"] = integration_http_method
            __props__.__dict__["passthrough_behavior"] = passthrough_behavior
            __props__.__dict__["region"] = region
            __props__.__dict__["request_parameters"] = request_parameters
            __props__.__dict__["request_templates"] = request_templates
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if rest_api is None and not opts.urn:
                raise TypeError("Missing required property 'rest_api'")
            __props__.__dict__["rest_api"] = rest_api
            __props__.__dict__["timeout_milliseconds"] = timeout_milliseconds
            __props__.__dict__["tls_config"] = tls_config
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["uri"] = uri
        super(Integration, __self__).__init__(
            'aws:apigateway/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_key_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cache_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            connection_id: Optional[pulumi.Input[_builtins.str]] = None,
            connection_type: Optional[pulumi.Input[_builtins.str]] = None,
            content_handling: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[_builtins.str]] = None,
            http_method: Optional[pulumi.Input[_builtins.str]] = None,
            integration_http_method: Optional[pulumi.Input[_builtins.str]] = None,
            passthrough_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            request_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            request_templates: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            rest_api: Optional[pulumi.Input[_builtins.str]] = None,
            timeout_milliseconds: Optional[pulumi.Input[_builtins.int]] = None,
            tls_config: Optional[pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] cache_key_parameters: List of cache key parameters for the integration.
        :param pulumi.Input[_builtins.str] cache_namespace: Integration's cache namespace.
        :param pulumi.Input[_builtins.str] connection_id: ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
        :param pulumi.Input[_builtins.str] connection_type: Integration input's [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
        :param pulumi.Input[_builtins.str] content_handling: How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        :param pulumi.Input[_builtins.str] credentials: Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role's ARN. To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*`.
        :param pulumi.Input[_builtins.str] http_method: HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
               when calling the associated resource.
        :param pulumi.Input[_builtins.str] integration_http_method: Integration HTTP method
               (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
               **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
               Not all methods are compatible with all `AWS` integrations.
               e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
        :param pulumi.Input[_builtins.str] passthrough_behavior: Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_parameters: Map of request query string parameters and headers that should be passed to the backend responder.
               For example: `request_parameters = { "integration.request.header.X-Some-Other-Header" = "method.request.header.X-Some-Header" }`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] request_templates: Map of the integration's request templates.
        :param pulumi.Input[_builtins.str] resource_id: API resource ID.
        :param pulumi.Input[_builtins.str] rest_api: ID of the associated REST API.
        :param pulumi.Input[_builtins.int] timeout_milliseconds: Custom timeout between 50 and 300,000 milliseconds. The default value is 29,000 milliseconds. You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase time beyond 29,000 milliseconds.
        :param pulumi.Input[Union['IntegrationTlsConfigArgs', 'IntegrationTlsConfigArgsDict']] tls_config: TLS configuration. See below.
        :param pulumi.Input[_builtins.str] type: Integration input's [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        :param pulumi.Input[_builtins.str] uri: Input's URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
               For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
               e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:123456789012:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["cache_key_parameters"] = cache_key_parameters
        __props__.__dict__["cache_namespace"] = cache_namespace
        __props__.__dict__["connection_id"] = connection_id
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["content_handling"] = content_handling
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["http_method"] = http_method
        __props__.__dict__["integration_http_method"] = integration_http_method
        __props__.__dict__["passthrough_behavior"] = passthrough_behavior
        __props__.__dict__["region"] = region
        __props__.__dict__["request_parameters"] = request_parameters
        __props__.__dict__["request_templates"] = request_templates
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["rest_api"] = rest_api
        __props__.__dict__["timeout_milliseconds"] = timeout_milliseconds
        __props__.__dict__["tls_config"] = tls_config
        __props__.__dict__["type"] = type
        __props__.__dict__["uri"] = uri
        return Integration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cacheKeyParameters")
    def cache_key_parameters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of cache key parameters for the integration.
        """
        return pulumi.get(self, "cache_key_parameters")

    @_builtins.property
    @pulumi.getter(name="cacheNamespace")
    def cache_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        Integration's cache namespace.
        """
        return pulumi.get(self, "cache_namespace")

    @_builtins.property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the VpcLink used for the integration. **Required** if `connection_type` is `VPC_LINK`
        """
        return pulumi.get(self, "connection_id")

    @_builtins.property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Integration input's [connectionType](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#connectionType). Valid values are `INTERNET` (default for connections through the public routable internet), and `VPC_LINK` (for private connections between API Gateway and a network load balancer in a VPC).
        """
        return pulumi.get(self, "connection_type")

    @_builtins.property
    @pulumi.getter(name="contentHandling")
    def content_handling(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`. If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehaviors is configured to support payload pass-through.
        """
        return pulumi.get(self, "content_handling")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Credentials required for the integration. For `AWS` integrations, 2 options are available. To specify an IAM Role for Amazon API Gateway to assume, use the role's ARN. To require that the caller's identity be passed through from the request, specify the string `arn:aws:iam::\\*:user/\\*`.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> pulumi.Output[_builtins.str]:
        """
        HTTP method (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTION`, `ANY`)
        when calling the associated resource.
        """
        return pulumi.get(self, "http_method")

    @_builtins.property
    @pulumi.getter(name="integrationHttpMethod")
    def integration_http_method(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Integration HTTP method
        (`GET`, `POST`, `PUT`, `DELETE`, `HEAD`, `OPTIONs`, `ANY`, `PATCH`) specifying how API Gateway will interact with the back end.
        **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
        Not all methods are compatible with all `AWS` integrations.
        e.g., Lambda function [can only be invoked](https://github.com/awslabs/aws-apigateway-importer/issues/9#issuecomment-129651005) via `POST`.
        """
        return pulumi.get(self, "integration_http_method")

    @_builtins.property
    @pulumi.getter(name="passthroughBehavior")
    def passthrough_behavior(self) -> pulumi.Output[_builtins.str]:
        """
        Integration passthrough behavior (`WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, `NEVER`).  **Required** if `request_templates` is used.
        """
        return pulumi.get(self, "passthrough_behavior")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="requestParameters")
    def request_parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of request query string parameters and headers that should be passed to the backend responder.
        For example: `request_parameters = { "integration.request.header.X-Some-Other-Header" = "method.request.header.X-Some-Header" }`
        """
        return pulumi.get(self, "request_parameters")

    @_builtins.property
    @pulumi.getter(name="requestTemplates")
    def request_templates(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of the integration's request templates.
        """
        return pulumi.get(self, "request_templates")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        API resource ID.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="restApi")
    def rest_api(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the associated REST API.
        """
        return pulumi.get(self, "rest_api")

    @_builtins.property
    @pulumi.getter(name="timeoutMilliseconds")
    def timeout_milliseconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Custom timeout between 50 and 300,000 milliseconds. The default value is 29,000 milliseconds. You need to raise a [Service Quota Ticket](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html) to increase time beyond 29,000 milliseconds.
        """
        return pulumi.get(self, "timeout_milliseconds")

    @_builtins.property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> pulumi.Output[Optional['outputs.IntegrationTlsConfig']]:
        """
        TLS configuration. See below.
        """
        return pulumi.get(self, "tls_config")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Integration input's [type](https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/). Valid values are `HTTP` (for HTTP backends), `MOCK` (not calling any real backend), `AWS` (for AWS services), `AWS_PROXY` (for Lambda proxy integration) and `HTTP_PROXY` (for HTTP proxy integration). An `HTTP` or `HTTP_PROXY` integration with a `connection_type` of `VPC_LINK` is referred to as a private integration and uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Input's URI. **Required** if `type` is `AWS`, `AWS_PROXY`, `HTTP` or `HTTP_PROXY`.
        For HTTP integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification . For AWS integrations, the URI should be of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:{path|action}/{service_api}`. `region`, `subdomain` and `service` are used to determine the right endpoint.
        e.g., `arn:aws:apigateway:eu-west-1:lambda:path/2015-03-31/functions/arn:aws:lambda:eu-west-1:123456789012:function:my-func/invocations`. For private integrations, the URI parameter is not used for routing requests to your endpoint, but is used for setting the Host header and for certificate validation.
        """
        return pulumi.get(self, "uri")

