# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[_builtins.str],
                 scalable_dimension: pulumi.Input[_builtins.str],
                 service_namespace: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 step_scaling_policy_configuration: Optional[pulumi.Input['PolicyStepScalingPolicyConfigurationArgs']] = None,
                 target_tracking_scaling_policy_configuration: Optional[pulumi.Input['PolicyTargetTrackingScalingPolicyConfigurationArgs']] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[_builtins.str] resource_id: Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[_builtins.str] scalable_dimension: Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[_builtins.str] service_namespace: AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[_builtins.str] name: Name of the policy. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] policy_type: Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['PolicyStepScalingPolicyConfigurationArgs'] step_scaling_policy_configuration: Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
        :param pulumi.Input['PolicyTargetTrackingScalingPolicyConfigurationArgs'] target_tracking_scaling_policy_configuration: Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "scalable_dimension", scalable_dimension)
        pulumi.set(__self__, "service_namespace", service_namespace)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if step_scaling_policy_configuration is not None:
            pulumi.set(__self__, "step_scaling_policy_configuration", step_scaling_policy_configuration)
        if target_tracking_scaling_policy_configuration is not None:
            pulumi.set(__self__, "target_tracking_scaling_policy_configuration", target_tracking_scaling_policy_configuration)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> pulumi.Input[_builtins.str]:
        """
        Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        """
        return pulumi.get(self, "scalable_dimension")

    @scalable_dimension.setter
    def scalable_dimension(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scalable_dimension", value)

    @_builtins.property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> pulumi.Input[_builtins.str]:
        """
        AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        """
        return pulumi.get(self, "service_namespace")

    @service_namespace.setter
    def service_namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_namespace", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the policy. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="stepScalingPolicyConfiguration")
    def step_scaling_policy_configuration(self) -> Optional[pulumi.Input['PolicyStepScalingPolicyConfigurationArgs']]:
        """
        Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
        """
        return pulumi.get(self, "step_scaling_policy_configuration")

    @step_scaling_policy_configuration.setter
    def step_scaling_policy_configuration(self, value: Optional[pulumi.Input['PolicyStepScalingPolicyConfigurationArgs']]):
        pulumi.set(self, "step_scaling_policy_configuration", value)

    @_builtins.property
    @pulumi.getter(name="targetTrackingScalingPolicyConfiguration")
    def target_tracking_scaling_policy_configuration(self) -> Optional[pulumi.Input['PolicyTargetTrackingScalingPolicyConfigurationArgs']]:
        """
        Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
        """
        return pulumi.get(self, "target_tracking_scaling_policy_configuration")

    @target_tracking_scaling_policy_configuration.setter
    def target_tracking_scaling_policy_configuration(self, value: Optional[pulumi.Input['PolicyTargetTrackingScalingPolicyConfigurationArgs']]):
        pulumi.set(self, "target_tracking_scaling_policy_configuration", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 alarm_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scalable_dimension: Optional[pulumi.Input[_builtins.str]] = None,
                 service_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 step_scaling_policy_configuration: Optional[pulumi.Input['PolicyStepScalingPolicyConfigurationArgs']] = None,
                 target_tracking_scaling_policy_configuration: Optional[pulumi.Input['PolicyTargetTrackingScalingPolicyConfigurationArgs']] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alarm_arns: List of CloudWatch alarm ARNs associated with the scaling policy.
        :param pulumi.Input[_builtins.str] arn: ARN assigned by AWS to the scaling policy.
        :param pulumi.Input[_builtins.str] name: Name of the policy. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] policy_type: Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_id: Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[_builtins.str] scalable_dimension: Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[_builtins.str] service_namespace: AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input['PolicyStepScalingPolicyConfigurationArgs'] step_scaling_policy_configuration: Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
        :param pulumi.Input['PolicyTargetTrackingScalingPolicyConfigurationArgs'] target_tracking_scaling_policy_configuration: Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
        """
        if alarm_arns is not None:
            pulumi.set(__self__, "alarm_arns", alarm_arns)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_type is not None:
            pulumi.set(__self__, "policy_type", policy_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if scalable_dimension is not None:
            pulumi.set(__self__, "scalable_dimension", scalable_dimension)
        if service_namespace is not None:
            pulumi.set(__self__, "service_namespace", service_namespace)
        if step_scaling_policy_configuration is not None:
            pulumi.set(__self__, "step_scaling_policy_configuration", step_scaling_policy_configuration)
        if target_tracking_scaling_policy_configuration is not None:
            pulumi.set(__self__, "target_tracking_scaling_policy_configuration", target_tracking_scaling_policy_configuration)

    @_builtins.property
    @pulumi.getter(name="alarmArns")
    def alarm_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of CloudWatch alarm ARNs associated with the scaling policy.
        """
        return pulumi.get(self, "alarm_arns")

    @alarm_arns.setter
    def alarm_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alarm_arns", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN assigned by AWS to the scaling policy.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the policy. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
        """
        return pulumi.get(self, "policy_type")

    @policy_type.setter
    def policy_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_id", value)

    @_builtins.property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        """
        return pulumi.get(self, "scalable_dimension")

    @scalable_dimension.setter
    def scalable_dimension(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scalable_dimension", value)

    @_builtins.property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        """
        return pulumi.get(self, "service_namespace")

    @service_namespace.setter
    def service_namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_namespace", value)

    @_builtins.property
    @pulumi.getter(name="stepScalingPolicyConfiguration")
    def step_scaling_policy_configuration(self) -> Optional[pulumi.Input['PolicyStepScalingPolicyConfigurationArgs']]:
        """
        Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
        """
        return pulumi.get(self, "step_scaling_policy_configuration")

    @step_scaling_policy_configuration.setter
    def step_scaling_policy_configuration(self, value: Optional[pulumi.Input['PolicyStepScalingPolicyConfigurationArgs']]):
        pulumi.set(self, "step_scaling_policy_configuration", value)

    @_builtins.property
    @pulumi.getter(name="targetTrackingScalingPolicyConfiguration")
    def target_tracking_scaling_policy_configuration(self) -> Optional[pulumi.Input['PolicyTargetTrackingScalingPolicyConfigurationArgs']]:
        """
        Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
        """
        return pulumi.get(self, "target_tracking_scaling_policy_configuration")

    @target_tracking_scaling_policy_configuration.setter
    def target_tracking_scaling_policy_configuration(self, value: Optional[pulumi.Input['PolicyTargetTrackingScalingPolicyConfigurationArgs']]):
        pulumi.set(self, "target_tracking_scaling_policy_configuration", value)


@pulumi.type_token("aws:appautoscaling/policy:Policy")
class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scalable_dimension: Optional[pulumi.Input[_builtins.str]] = None,
                 service_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 step_scaling_policy_configuration: Optional[pulumi.Input[Union['PolicyStepScalingPolicyConfigurationArgs', 'PolicyStepScalingPolicyConfigurationArgsDict']]] = None,
                 target_tracking_scaling_policy_configuration: Optional[pulumi.Input[Union['PolicyTargetTrackingScalingPolicyConfigurationArgs', 'PolicyTargetTrackingScalingPolicyConfigurationArgsDict']]] = None,
                 __props__=None):
        """
        Provides an Application AutoScaling Policy resource.

        ## Example Usage

        ### DynamoDB Table Autoscaling

        ```python
        import pulumi
        import pulumi_aws as aws

        dynamodb_table_read_target = aws.appautoscaling.Target("dynamodb_table_read_target",
            max_capacity=100,
            min_capacity=5,
            resource_id="table/tableName",
            scalable_dimension="dynamodb:table:ReadCapacityUnits",
            service_namespace="dynamodb")
        dynamodb_table_read_policy = aws.appautoscaling.Policy("dynamodb_table_read_policy",
            name=dynamodb_table_read_target.resource_id.apply(lambda resource_id: f"DynamoDBReadCapacityUtilization:{resource_id}"),
            policy_type="TargetTrackingScaling",
            resource_id=dynamodb_table_read_target.resource_id,
            scalable_dimension=dynamodb_table_read_target.scalable_dimension,
            service_namespace=dynamodb_table_read_target.service_namespace,
            target_tracking_scaling_policy_configuration={
                "predefined_metric_specification": {
                    "predefined_metric_type": "DynamoDBReadCapacityUtilization",
                },
                "target_value": 70,
            })
        ```

        ### ECS Service Autoscaling

        ```python
        import pulumi
        import pulumi_aws as aws

        ecs_target = aws.appautoscaling.Target("ecs_target",
            max_capacity=4,
            min_capacity=1,
            resource_id="service/clusterName/serviceName",
            scalable_dimension="ecs:service:DesiredCount",
            service_namespace="ecs")
        ecs_policy = aws.appautoscaling.Policy("ecs_policy",
            name="scale-down",
            policy_type="StepScaling",
            resource_id=ecs_target.resource_id,
            scalable_dimension=ecs_target.scalable_dimension,
            service_namespace=ecs_target.service_namespace,
            step_scaling_policy_configuration={
                "adjustment_type": "ChangeInCapacity",
                "cooldown": 60,
                "metric_aggregation_type": "Maximum",
                "step_adjustments": [{
                    "metric_interval_upper_bound": "0",
                    "scaling_adjustment": -1,
                }],
            })
        ```

        ### Preserve desired count when updating an autoscaled ECS Service

        ```python
        import pulumi
        import pulumi_aws as aws

        ecs_service = aws.ecs.Service("ecs_service",
            name="serviceName",
            cluster="clusterName",
            task_definition="taskDefinitionFamily:1",
            desired_count=2)
        ```

        ### Aurora Read Replica Autoscaling

        ```python
        import pulumi
        import pulumi_aws as aws

        replicas = aws.appautoscaling.Target("replicas",
            service_namespace="rds",
            scalable_dimension="rds:cluster:ReadReplicaCount",
            resource_id=f"cluster:{example['id']}",
            min_capacity=1,
            max_capacity=15)
        replicas_policy = aws.appautoscaling.Policy("replicas",
            name="cpu-auto-scaling",
            service_namespace=replicas.service_namespace,
            scalable_dimension=replicas.scalable_dimension,
            resource_id=replicas.resource_id,
            policy_type="TargetTrackingScaling",
            target_tracking_scaling_policy_configuration={
                "predefined_metric_specification": {
                    "predefined_metric_type": "RDSReaderAverageCPUUtilization",
                },
                "target_value": 75,
                "scale_in_cooldown": 300,
                "scale_out_cooldown": 300,
            })
        ```

        ### Create target tracking scaling policy using metric math

        ```python
        import pulumi
        import pulumi_aws as aws

        ecs_target = aws.appautoscaling.Target("ecs_target",
            max_capacity=4,
            min_capacity=1,
            resource_id="service/clusterName/serviceName",
            scalable_dimension="ecs:service:DesiredCount",
            service_namespace="ecs")
        example = aws.appautoscaling.Policy("example",
            name="foo",
            policy_type="TargetTrackingScaling",
            resource_id=ecs_target.resource_id,
            scalable_dimension=ecs_target.scalable_dimension,
            service_namespace=ecs_target.service_namespace,
            target_tracking_scaling_policy_configuration={
                "target_value": 100,
                "customized_metric_specification": {
                    "metrics": [
                        {
                            "label": "Get the queue size (the number of messages waiting to be processed)",
                            "id": "m1",
                            "metric_stat": {
                                "metric": {
                                    "metric_name": "ApproximateNumberOfMessagesVisible",
                                    "namespace": "AWS/SQS",
                                    "dimensions": [{
                                        "name": "QueueName",
                                        "value": "my-queue",
                                    }],
                                },
                                "stat": "Sum",
                            },
                            "return_data": False,
                        },
                        {
                            "label": "Get the ECS running task count (the number of currently running tasks)",
                            "id": "m2",
                            "metric_stat": {
                                "metric": {
                                    "metric_name": "RunningTaskCount",
                                    "namespace": "ECS/ContainerInsights",
                                    "dimensions": [
                                        {
                                            "name": "ClusterName",
                                            "value": "default",
                                        },
                                        {
                                            "name": "ServiceName",
                                            "value": "web-app",
                                        },
                                    ],
                                },
                                "stat": "Average",
                            },
                            "return_data": False,
                        },
                        {
                            "label": "Calculate the backlog per instance",
                            "id": "e1",
                            "expression": "m1 / m2",
                            "return_data": True,
                        },
                    ],
                },
            })
        ```

        ### MSK / Kafka Autoscaling

        ```python
        import pulumi
        import pulumi_aws as aws

        msk_target = aws.appautoscaling.Target("msk_target",
            service_namespace="kafka",
            scalable_dimension="kafka:broker-storage:VolumeSize",
            resource_id=example["arn"],
            min_capacity=1,
            max_capacity=8)
        targets = aws.appautoscaling.Policy("targets",
            name="storage-size-auto-scaling",
            service_namespace=msk_target.service_namespace,
            scalable_dimension=msk_target.scalable_dimension,
            resource_id=msk_target.resource_id,
            policy_type="TargetTrackingScaling",
            target_tracking_scaling_policy_configuration={
                "predefined_metric_specification": {
                    "predefined_metric_type": "KafkaBrokerStorageUtilization",
                },
                "target_value": 55,
            })
        ```

        ## Import

        Using `pulumi import`, import Application AutoScaling Policy using the `service-namespace` , `resource-id`, `scalable-dimension` and `policy-name` separated by `/`. For example:

        ```sh
        $ pulumi import aws:appautoscaling/policy:Policy test-policy service-namespace/resource-id/scalable-dimension/policy-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Name of the policy. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] policy_type: Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_id: Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[_builtins.str] scalable_dimension: Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[_builtins.str] service_namespace: AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[Union['PolicyStepScalingPolicyConfigurationArgs', 'PolicyStepScalingPolicyConfigurationArgsDict']] step_scaling_policy_configuration: Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
        :param pulumi.Input[Union['PolicyTargetTrackingScalingPolicyConfigurationArgs', 'PolicyTargetTrackingScalingPolicyConfigurationArgsDict']] target_tracking_scaling_policy_configuration: Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Application AutoScaling Policy resource.

        ## Example Usage

        ### DynamoDB Table Autoscaling

        ```python
        import pulumi
        import pulumi_aws as aws

        dynamodb_table_read_target = aws.appautoscaling.Target("dynamodb_table_read_target",
            max_capacity=100,
            min_capacity=5,
            resource_id="table/tableName",
            scalable_dimension="dynamodb:table:ReadCapacityUnits",
            service_namespace="dynamodb")
        dynamodb_table_read_policy = aws.appautoscaling.Policy("dynamodb_table_read_policy",
            name=dynamodb_table_read_target.resource_id.apply(lambda resource_id: f"DynamoDBReadCapacityUtilization:{resource_id}"),
            policy_type="TargetTrackingScaling",
            resource_id=dynamodb_table_read_target.resource_id,
            scalable_dimension=dynamodb_table_read_target.scalable_dimension,
            service_namespace=dynamodb_table_read_target.service_namespace,
            target_tracking_scaling_policy_configuration={
                "predefined_metric_specification": {
                    "predefined_metric_type": "DynamoDBReadCapacityUtilization",
                },
                "target_value": 70,
            })
        ```

        ### ECS Service Autoscaling

        ```python
        import pulumi
        import pulumi_aws as aws

        ecs_target = aws.appautoscaling.Target("ecs_target",
            max_capacity=4,
            min_capacity=1,
            resource_id="service/clusterName/serviceName",
            scalable_dimension="ecs:service:DesiredCount",
            service_namespace="ecs")
        ecs_policy = aws.appautoscaling.Policy("ecs_policy",
            name="scale-down",
            policy_type="StepScaling",
            resource_id=ecs_target.resource_id,
            scalable_dimension=ecs_target.scalable_dimension,
            service_namespace=ecs_target.service_namespace,
            step_scaling_policy_configuration={
                "adjustment_type": "ChangeInCapacity",
                "cooldown": 60,
                "metric_aggregation_type": "Maximum",
                "step_adjustments": [{
                    "metric_interval_upper_bound": "0",
                    "scaling_adjustment": -1,
                }],
            })
        ```

        ### Preserve desired count when updating an autoscaled ECS Service

        ```python
        import pulumi
        import pulumi_aws as aws

        ecs_service = aws.ecs.Service("ecs_service",
            name="serviceName",
            cluster="clusterName",
            task_definition="taskDefinitionFamily:1",
            desired_count=2)
        ```

        ### Aurora Read Replica Autoscaling

        ```python
        import pulumi
        import pulumi_aws as aws

        replicas = aws.appautoscaling.Target("replicas",
            service_namespace="rds",
            scalable_dimension="rds:cluster:ReadReplicaCount",
            resource_id=f"cluster:{example['id']}",
            min_capacity=1,
            max_capacity=15)
        replicas_policy = aws.appautoscaling.Policy("replicas",
            name="cpu-auto-scaling",
            service_namespace=replicas.service_namespace,
            scalable_dimension=replicas.scalable_dimension,
            resource_id=replicas.resource_id,
            policy_type="TargetTrackingScaling",
            target_tracking_scaling_policy_configuration={
                "predefined_metric_specification": {
                    "predefined_metric_type": "RDSReaderAverageCPUUtilization",
                },
                "target_value": 75,
                "scale_in_cooldown": 300,
                "scale_out_cooldown": 300,
            })
        ```

        ### Create target tracking scaling policy using metric math

        ```python
        import pulumi
        import pulumi_aws as aws

        ecs_target = aws.appautoscaling.Target("ecs_target",
            max_capacity=4,
            min_capacity=1,
            resource_id="service/clusterName/serviceName",
            scalable_dimension="ecs:service:DesiredCount",
            service_namespace="ecs")
        example = aws.appautoscaling.Policy("example",
            name="foo",
            policy_type="TargetTrackingScaling",
            resource_id=ecs_target.resource_id,
            scalable_dimension=ecs_target.scalable_dimension,
            service_namespace=ecs_target.service_namespace,
            target_tracking_scaling_policy_configuration={
                "target_value": 100,
                "customized_metric_specification": {
                    "metrics": [
                        {
                            "label": "Get the queue size (the number of messages waiting to be processed)",
                            "id": "m1",
                            "metric_stat": {
                                "metric": {
                                    "metric_name": "ApproximateNumberOfMessagesVisible",
                                    "namespace": "AWS/SQS",
                                    "dimensions": [{
                                        "name": "QueueName",
                                        "value": "my-queue",
                                    }],
                                },
                                "stat": "Sum",
                            },
                            "return_data": False,
                        },
                        {
                            "label": "Get the ECS running task count (the number of currently running tasks)",
                            "id": "m2",
                            "metric_stat": {
                                "metric": {
                                    "metric_name": "RunningTaskCount",
                                    "namespace": "ECS/ContainerInsights",
                                    "dimensions": [
                                        {
                                            "name": "ClusterName",
                                            "value": "default",
                                        },
                                        {
                                            "name": "ServiceName",
                                            "value": "web-app",
                                        },
                                    ],
                                },
                                "stat": "Average",
                            },
                            "return_data": False,
                        },
                        {
                            "label": "Calculate the backlog per instance",
                            "id": "e1",
                            "expression": "m1 / m2",
                            "return_data": True,
                        },
                    ],
                },
            })
        ```

        ### MSK / Kafka Autoscaling

        ```python
        import pulumi
        import pulumi_aws as aws

        msk_target = aws.appautoscaling.Target("msk_target",
            service_namespace="kafka",
            scalable_dimension="kafka:broker-storage:VolumeSize",
            resource_id=example["arn"],
            min_capacity=1,
            max_capacity=8)
        targets = aws.appautoscaling.Policy("targets",
            name="storage-size-auto-scaling",
            service_namespace=msk_target.service_namespace,
            scalable_dimension=msk_target.scalable_dimension,
            resource_id=msk_target.resource_id,
            policy_type="TargetTrackingScaling",
            target_tracking_scaling_policy_configuration={
                "predefined_metric_specification": {
                    "predefined_metric_type": "KafkaBrokerStorageUtilization",
                },
                "target_value": 55,
            })
        ```

        ## Import

        Using `pulumi import`, import Application AutoScaling Policy using the `service-namespace` , `resource-id`, `scalable-dimension` and `policy-name` separated by `/`. For example:

        ```sh
        $ pulumi import aws:appautoscaling/policy:Policy test-policy service-namespace/resource-id/scalable-dimension/policy-name
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 scalable_dimension: Optional[pulumi.Input[_builtins.str]] = None,
                 service_namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 step_scaling_policy_configuration: Optional[pulumi.Input[Union['PolicyStepScalingPolicyConfigurationArgs', 'PolicyStepScalingPolicyConfigurationArgsDict']]] = None,
                 target_tracking_scaling_policy_configuration: Optional[pulumi.Input[Union['PolicyTargetTrackingScalingPolicyConfigurationArgs', 'PolicyTargetTrackingScalingPolicyConfigurationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["policy_type"] = policy_type
            __props__.__dict__["region"] = region
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if scalable_dimension is None and not opts.urn:
                raise TypeError("Missing required property 'scalable_dimension'")
            __props__.__dict__["scalable_dimension"] = scalable_dimension
            if service_namespace is None and not opts.urn:
                raise TypeError("Missing required property 'service_namespace'")
            __props__.__dict__["service_namespace"] = service_namespace
            __props__.__dict__["step_scaling_policy_configuration"] = step_scaling_policy_configuration
            __props__.__dict__["target_tracking_scaling_policy_configuration"] = target_tracking_scaling_policy_configuration
            __props__.__dict__["alarm_arns"] = None
            __props__.__dict__["arn"] = None
        super(Policy, __self__).__init__(
            'aws:appautoscaling/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_arns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            scalable_dimension: Optional[pulumi.Input[_builtins.str]] = None,
            service_namespace: Optional[pulumi.Input[_builtins.str]] = None,
            step_scaling_policy_configuration: Optional[pulumi.Input[Union['PolicyStepScalingPolicyConfigurationArgs', 'PolicyStepScalingPolicyConfigurationArgsDict']]] = None,
            target_tracking_scaling_policy_configuration: Optional[pulumi.Input[Union['PolicyTargetTrackingScalingPolicyConfigurationArgs', 'PolicyTargetTrackingScalingPolicyConfigurationArgsDict']]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alarm_arns: List of CloudWatch alarm ARNs associated with the scaling policy.
        :param pulumi.Input[_builtins.str] arn: ARN assigned by AWS to the scaling policy.
        :param pulumi.Input[_builtins.str] name: Name of the policy. Must be between 1 and 255 characters in length.
        :param pulumi.Input[_builtins.str] policy_type: Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_id: Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[_builtins.str] scalable_dimension: Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[_builtins.str] service_namespace: AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        :param pulumi.Input[Union['PolicyStepScalingPolicyConfigurationArgs', 'PolicyStepScalingPolicyConfigurationArgsDict']] step_scaling_policy_configuration: Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
        :param pulumi.Input[Union['PolicyTargetTrackingScalingPolicyConfigurationArgs', 'PolicyTargetTrackingScalingPolicyConfigurationArgsDict']] target_tracking_scaling_policy_configuration: Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["alarm_arns"] = alarm_arns
        __props__.__dict__["arn"] = arn
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_type"] = policy_type
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["scalable_dimension"] = scalable_dimension
        __props__.__dict__["service_namespace"] = service_namespace
        __props__.__dict__["step_scaling_policy_configuration"] = step_scaling_policy_configuration
        __props__.__dict__["target_tracking_scaling_policy_configuration"] = target_tracking_scaling_policy_configuration
        return Policy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alarmArns")
    def alarm_arns(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of CloudWatch alarm ARNs associated with the scaling policy.
        """
        return pulumi.get(self, "alarm_arns")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN assigned by AWS to the scaling policy.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the policy. Must be between 1 and 255 characters in length.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyType")
    def policy_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Policy type. Valid values are `StepScaling` and `TargetTrackingScaling`. Defaults to `StepScaling`. Certain services only support only one policy type. For more information see the [Target Tracking Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html) and [Step Scaling Policies](https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html) documentation.
        """
        return pulumi.get(self, "policy_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource type and unique identifier string for the resource associated with the scaling policy. Documentation can be found in the `ResourceId` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="scalableDimension")
    def scalable_dimension(self) -> pulumi.Output[_builtins.str]:
        """
        Scalable dimension of the scalable target. Documentation can be found in the `ScalableDimension` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        """
        return pulumi.get(self, "scalable_dimension")

    @_builtins.property
    @pulumi.getter(name="serviceNamespace")
    def service_namespace(self) -> pulumi.Output[_builtins.str]:
        """
        AWS service namespace of the scalable target. Documentation can be found in the `ServiceNamespace` parameter at: [AWS Application Auto Scaling API Reference](https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html)
        """
        return pulumi.get(self, "service_namespace")

    @_builtins.property
    @pulumi.getter(name="stepScalingPolicyConfiguration")
    def step_scaling_policy_configuration(self) -> pulumi.Output[Optional['outputs.PolicyStepScalingPolicyConfiguration']]:
        """
        Step scaling policy configuration, requires `policy_type = "StepScaling"` (default). See supported fields below.
        """
        return pulumi.get(self, "step_scaling_policy_configuration")

    @_builtins.property
    @pulumi.getter(name="targetTrackingScalingPolicyConfiguration")
    def target_tracking_scaling_policy_configuration(self) -> pulumi.Output[Optional['outputs.PolicyTargetTrackingScalingPolicyConfiguration']]:
        """
        Target tracking policy, requires `policy_type = "TargetTrackingScaling"`. See supported fields below.
        """
        return pulumi.get(self, "target_tracking_scaling_policy_configuration")

