# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlowArgs', 'Flow']

@pulumi.input_type
class FlowArgs:
    def __init__(__self__, *,
                 destination_flow_configs: pulumi.Input[Sequence[pulumi.Input['FlowDestinationFlowConfigArgs']]],
                 source_flow_config: pulumi.Input['FlowSourceFlowConfigArgs'],
                 tasks: pulumi.Input[Sequence[pulumi.Input['FlowTaskArgs']]],
                 trigger_config: pulumi.Input['FlowTriggerConfigArgs'],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_catalog_config: Optional[pulumi.Input['FlowMetadataCatalogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Flow resource.
        :param pulumi.Input[Sequence[pulumi.Input['FlowDestinationFlowConfigArgs']]] destination_flow_configs: A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
        :param pulumi.Input['FlowSourceFlowConfigArgs'] source_flow_config: The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
        :param pulumi.Input[Sequence[pulumi.Input['FlowTaskArgs']]] tasks: A Task that Amazon AppFlow performs while transferring the data in the flow run.
        :param pulumi.Input['FlowTriggerConfigArgs'] trigger_config: A Trigger that determine how and when the flow runs.
        :param pulumi.Input[_builtins.str] description: Description of the flow you want to create.
        :param pulumi.Input[_builtins.str] kms_arn: ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        :param pulumi.Input['FlowMetadataCatalogConfigArgs'] metadata_catalog_config: A Catalog that determines the configuration that Amazon AppFlow uses when it catalogs the data that’s transferred by the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
        :param pulumi.Input[_builtins.str] name: Name of the flow.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "destination_flow_configs", destination_flow_configs)
        pulumi.set(__self__, "source_flow_config", source_flow_config)
        pulumi.set(__self__, "tasks", tasks)
        pulumi.set(__self__, "trigger_config", trigger_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kms_arn is not None:
            pulumi.set(__self__, "kms_arn", kms_arn)
        if metadata_catalog_config is not None:
            pulumi.set(__self__, "metadata_catalog_config", metadata_catalog_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="destinationFlowConfigs")
    def destination_flow_configs(self) -> pulumi.Input[Sequence[pulumi.Input['FlowDestinationFlowConfigArgs']]]:
        """
        A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
        """
        return pulumi.get(self, "destination_flow_configs")

    @destination_flow_configs.setter
    def destination_flow_configs(self, value: pulumi.Input[Sequence[pulumi.Input['FlowDestinationFlowConfigArgs']]]):
        pulumi.set(self, "destination_flow_configs", value)

    @_builtins.property
    @pulumi.getter(name="sourceFlowConfig")
    def source_flow_config(self) -> pulumi.Input['FlowSourceFlowConfigArgs']:
        """
        The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
        """
        return pulumi.get(self, "source_flow_config")

    @source_flow_config.setter
    def source_flow_config(self, value: pulumi.Input['FlowSourceFlowConfigArgs']):
        pulumi.set(self, "source_flow_config", value)

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> pulumi.Input[Sequence[pulumi.Input['FlowTaskArgs']]]:
        """
        A Task that Amazon AppFlow performs while transferring the data in the flow run.
        """
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: pulumi.Input[Sequence[pulumi.Input['FlowTaskArgs']]]):
        pulumi.set(self, "tasks", value)

    @_builtins.property
    @pulumi.getter(name="triggerConfig")
    def trigger_config(self) -> pulumi.Input['FlowTriggerConfigArgs']:
        """
        A Trigger that determine how and when the flow runs.
        """
        return pulumi.get(self, "trigger_config")

    @trigger_config.setter
    def trigger_config(self, value: pulumi.Input['FlowTriggerConfigArgs']):
        pulumi.set(self, "trigger_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the flow you want to create.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        """
        return pulumi.get(self, "kms_arn")

    @kms_arn.setter
    def kms_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_arn", value)

    @_builtins.property
    @pulumi.getter(name="metadataCatalogConfig")
    def metadata_catalog_config(self) -> Optional[pulumi.Input['FlowMetadataCatalogConfigArgs']]:
        """
        A Catalog that determines the configuration that Amazon AppFlow uses when it catalogs the data that’s transferred by the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
        """
        return pulumi.get(self, "metadata_catalog_config")

    @metadata_catalog_config.setter
    def metadata_catalog_config(self, value: Optional[pulumi.Input['FlowMetadataCatalogConfigArgs']]):
        pulumi.set(self, "metadata_catalog_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FlowState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_flow_configs: Optional[pulumi.Input[Sequence[pulumi.Input['FlowDestinationFlowConfigArgs']]]] = None,
                 flow_status: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_catalog_config: Optional[pulumi.Input['FlowMetadataCatalogConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_flow_config: Optional[pulumi.Input['FlowSourceFlowConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input['FlowTaskArgs']]]] = None,
                 trigger_config: Optional[pulumi.Input['FlowTriggerConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Flow resources.
        :param pulumi.Input[_builtins.str] arn: Flow's ARN.
        :param pulumi.Input[_builtins.str] description: Description of the flow you want to create.
        :param pulumi.Input[Sequence[pulumi.Input['FlowDestinationFlowConfigArgs']]] destination_flow_configs: A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
        :param pulumi.Input[_builtins.str] flow_status: The current status of the flow.
        :param pulumi.Input[_builtins.str] kms_arn: ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        :param pulumi.Input['FlowMetadataCatalogConfigArgs'] metadata_catalog_config: A Catalog that determines the configuration that Amazon AppFlow uses when it catalogs the data that’s transferred by the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
        :param pulumi.Input[_builtins.str] name: Name of the flow.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input['FlowSourceFlowConfigArgs'] source_flow_config: The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['FlowTaskArgs']]] tasks: A Task that Amazon AppFlow performs while transferring the data in the flow run.
        :param pulumi.Input['FlowTriggerConfigArgs'] trigger_config: A Trigger that determine how and when the flow runs.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_flow_configs is not None:
            pulumi.set(__self__, "destination_flow_configs", destination_flow_configs)
        if flow_status is not None:
            pulumi.set(__self__, "flow_status", flow_status)
        if kms_arn is not None:
            pulumi.set(__self__, "kms_arn", kms_arn)
        if metadata_catalog_config is not None:
            pulumi.set(__self__, "metadata_catalog_config", metadata_catalog_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_flow_config is not None:
            pulumi.set(__self__, "source_flow_config", source_flow_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if tasks is not None:
            pulumi.set(__self__, "tasks", tasks)
        if trigger_config is not None:
            pulumi.set(__self__, "trigger_config", trigger_config)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Flow's ARN.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the flow you want to create.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationFlowConfigs")
    def destination_flow_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlowDestinationFlowConfigArgs']]]]:
        """
        A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
        """
        return pulumi.get(self, "destination_flow_configs")

    @destination_flow_configs.setter
    def destination_flow_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlowDestinationFlowConfigArgs']]]]):
        pulumi.set(self, "destination_flow_configs", value)

    @_builtins.property
    @pulumi.getter(name="flowStatus")
    def flow_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the flow.
        """
        return pulumi.get(self, "flow_status")

    @flow_status.setter
    def flow_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flow_status", value)

    @_builtins.property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        """
        return pulumi.get(self, "kms_arn")

    @kms_arn.setter
    def kms_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_arn", value)

    @_builtins.property
    @pulumi.getter(name="metadataCatalogConfig")
    def metadata_catalog_config(self) -> Optional[pulumi.Input['FlowMetadataCatalogConfigArgs']]:
        """
        A Catalog that determines the configuration that Amazon AppFlow uses when it catalogs the data that’s transferred by the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
        """
        return pulumi.get(self, "metadata_catalog_config")

    @metadata_catalog_config.setter
    def metadata_catalog_config(self, value: Optional[pulumi.Input['FlowMetadataCatalogConfigArgs']]):
        pulumi.set(self, "metadata_catalog_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the flow.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceFlowConfig")
    def source_flow_config(self) -> Optional[pulumi.Input['FlowSourceFlowConfigArgs']]:
        """
        The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
        """
        return pulumi.get(self, "source_flow_config")

    @source_flow_config.setter
    def source_flow_config(self, value: Optional[pulumi.Input['FlowSourceFlowConfigArgs']]):
        pulumi.set(self, "source_flow_config", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FlowTaskArgs']]]]:
        """
        A Task that Amazon AppFlow performs while transferring the data in the flow run.
        """
        return pulumi.get(self, "tasks")

    @tasks.setter
    def tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FlowTaskArgs']]]]):
        pulumi.set(self, "tasks", value)

    @_builtins.property
    @pulumi.getter(name="triggerConfig")
    def trigger_config(self) -> Optional[pulumi.Input['FlowTriggerConfigArgs']]:
        """
        A Trigger that determine how and when the flow runs.
        """
        return pulumi.get(self, "trigger_config")

    @trigger_config.setter
    def trigger_config(self, value: Optional[pulumi.Input['FlowTriggerConfigArgs']]):
        pulumi.set(self, "trigger_config", value)


@pulumi.type_token("aws:appflow/flow:Flow")
class Flow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_flow_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowDestinationFlowConfigArgs', 'FlowDestinationFlowConfigArgsDict']]]]] = None,
                 kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_catalog_config: Optional[pulumi.Input[Union['FlowMetadataCatalogConfigArgs', 'FlowMetadataCatalogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_flow_config: Optional[pulumi.Input[Union['FlowSourceFlowConfigArgs', 'FlowSourceFlowConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowTaskArgs', 'FlowTaskArgsDict']]]]] = None,
                 trigger_config: Optional[pulumi.Input[Union['FlowTriggerConfigArgs', 'FlowTriggerConfigArgsDict']]] = None,
                 __props__=None):
        """
        Provides an AppFlow flow resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_source_bucket = aws.s3.Bucket("example_source", bucket="example-source")
        example_source = aws.iam.get_policy_document(statements=[{
            "sid": "AllowAppFlowSourceActions",
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["appflow.amazonaws.com"],
            }],
            "actions": [
                "s3:ListBucket",
                "s3:GetObject",
            ],
            "resources": [
                "arn:aws:s3:::example-source",
                "arn:aws:s3:::example-source/*",
            ],
        }])
        example_source_bucket_policy = aws.s3.BucketPolicy("example_source",
            bucket=example_source_bucket.id,
            policy=example_source.json)
        example = aws.s3.BucketObjectv2("example",
            bucket=example_source_bucket.id,
            key="example_source.csv",
            source=pulumi.FileAsset("example_source.csv"))
        example_destination_bucket = aws.s3.Bucket("example_destination", bucket="example-destination")
        example_destination = aws.iam.get_policy_document(statements=[{
            "sid": "AllowAppFlowDestinationActions",
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["appflow.amazonaws.com"],
            }],
            "actions": [
                "s3:PutObject",
                "s3:AbortMultipartUpload",
                "s3:ListMultipartUploadParts",
                "s3:ListBucketMultipartUploads",
                "s3:GetBucketAcl",
                "s3:PutObjectAcl",
            ],
            "resources": [
                "arn:aws:s3:::example-destination",
                "arn:aws:s3:::example-destination/*",
            ],
        }])
        example_destination_bucket_policy = aws.s3.BucketPolicy("example_destination",
            bucket=example_destination_bucket.id,
            policy=example_destination.json)
        example_flow = aws.appflow.Flow("example",
            name="example",
            source_flow_config={
                "connector_type": "S3",
                "source_connector_properties": {
                    "s3": {
                        "bucket_name": example_source_bucket_policy.bucket,
                        "bucket_prefix": "example",
                    },
                },
            },
            destination_flow_configs=[{
                "connector_type": "S3",
                "destination_connector_properties": {
                    "s3": {
                        "bucket_name": example_destination_bucket_policy.bucket,
                        "s3_output_format_config": {
                            "prefix_config": {
                                "prefix_type": "PATH",
                            },
                        },
                    },
                },
            }],
            tasks=[{
                "source_fields": ["exampleField"],
                "destination_field": "exampleField",
                "task_type": "Map",
                "connector_operators": [{
                    "s3": "NO_OP",
                }],
            }],
            trigger_config={
                "trigger_type": "OnDemand",
            })
        ```

        ## Import

        Using `pulumi import`, import AppFlow flows using the `name`. For example:

        ```sh
        $ pulumi import aws:appflow/flow:Flow example example-flow
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the flow you want to create.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlowDestinationFlowConfigArgs', 'FlowDestinationFlowConfigArgsDict']]]] destination_flow_configs: A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
        :param pulumi.Input[_builtins.str] kms_arn: ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        :param pulumi.Input[Union['FlowMetadataCatalogConfigArgs', 'FlowMetadataCatalogConfigArgsDict']] metadata_catalog_config: A Catalog that determines the configuration that Amazon AppFlow uses when it catalogs the data that’s transferred by the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
        :param pulumi.Input[_builtins.str] name: Name of the flow.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['FlowSourceFlowConfigArgs', 'FlowSourceFlowConfigArgsDict']] source_flow_config: The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlowTaskArgs', 'FlowTaskArgsDict']]]] tasks: A Task that Amazon AppFlow performs while transferring the data in the flow run.
        :param pulumi.Input[Union['FlowTriggerConfigArgs', 'FlowTriggerConfigArgsDict']] trigger_config: A Trigger that determine how and when the flow runs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppFlow flow resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_source_bucket = aws.s3.Bucket("example_source", bucket="example-source")
        example_source = aws.iam.get_policy_document(statements=[{
            "sid": "AllowAppFlowSourceActions",
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["appflow.amazonaws.com"],
            }],
            "actions": [
                "s3:ListBucket",
                "s3:GetObject",
            ],
            "resources": [
                "arn:aws:s3:::example-source",
                "arn:aws:s3:::example-source/*",
            ],
        }])
        example_source_bucket_policy = aws.s3.BucketPolicy("example_source",
            bucket=example_source_bucket.id,
            policy=example_source.json)
        example = aws.s3.BucketObjectv2("example",
            bucket=example_source_bucket.id,
            key="example_source.csv",
            source=pulumi.FileAsset("example_source.csv"))
        example_destination_bucket = aws.s3.Bucket("example_destination", bucket="example-destination")
        example_destination = aws.iam.get_policy_document(statements=[{
            "sid": "AllowAppFlowDestinationActions",
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["appflow.amazonaws.com"],
            }],
            "actions": [
                "s3:PutObject",
                "s3:AbortMultipartUpload",
                "s3:ListMultipartUploadParts",
                "s3:ListBucketMultipartUploads",
                "s3:GetBucketAcl",
                "s3:PutObjectAcl",
            ],
            "resources": [
                "arn:aws:s3:::example-destination",
                "arn:aws:s3:::example-destination/*",
            ],
        }])
        example_destination_bucket_policy = aws.s3.BucketPolicy("example_destination",
            bucket=example_destination_bucket.id,
            policy=example_destination.json)
        example_flow = aws.appflow.Flow("example",
            name="example",
            source_flow_config={
                "connector_type": "S3",
                "source_connector_properties": {
                    "s3": {
                        "bucket_name": example_source_bucket_policy.bucket,
                        "bucket_prefix": "example",
                    },
                },
            },
            destination_flow_configs=[{
                "connector_type": "S3",
                "destination_connector_properties": {
                    "s3": {
                        "bucket_name": example_destination_bucket_policy.bucket,
                        "s3_output_format_config": {
                            "prefix_config": {
                                "prefix_type": "PATH",
                            },
                        },
                    },
                },
            }],
            tasks=[{
                "source_fields": ["exampleField"],
                "destination_field": "exampleField",
                "task_type": "Map",
                "connector_operators": [{
                    "s3": "NO_OP",
                }],
            }],
            trigger_config={
                "trigger_type": "OnDemand",
            })
        ```

        ## Import

        Using `pulumi import`, import AppFlow flows using the `name`. For example:

        ```sh
        $ pulumi import aws:appflow/flow:Flow example example-flow
        ```

        :param str resource_name: The name of the resource.
        :param FlowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_flow_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowDestinationFlowConfigArgs', 'FlowDestinationFlowConfigArgsDict']]]]] = None,
                 kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata_catalog_config: Optional[pulumi.Input[Union['FlowMetadataCatalogConfigArgs', 'FlowMetadataCatalogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_flow_config: Optional[pulumi.Input[Union['FlowSourceFlowConfigArgs', 'FlowSourceFlowConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowTaskArgs', 'FlowTaskArgsDict']]]]] = None,
                 trigger_config: Optional[pulumi.Input[Union['FlowTriggerConfigArgs', 'FlowTriggerConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlowArgs.__new__(FlowArgs)

            __props__.__dict__["description"] = description
            if destination_flow_configs is None and not opts.urn:
                raise TypeError("Missing required property 'destination_flow_configs'")
            __props__.__dict__["destination_flow_configs"] = destination_flow_configs
            __props__.__dict__["kms_arn"] = kms_arn
            __props__.__dict__["metadata_catalog_config"] = metadata_catalog_config
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if source_flow_config is None and not opts.urn:
                raise TypeError("Missing required property 'source_flow_config'")
            __props__.__dict__["source_flow_config"] = source_flow_config
            __props__.__dict__["tags"] = tags
            if tasks is None and not opts.urn:
                raise TypeError("Missing required property 'tasks'")
            __props__.__dict__["tasks"] = tasks
            if trigger_config is None and not opts.urn:
                raise TypeError("Missing required property 'trigger_config'")
            __props__.__dict__["trigger_config"] = trigger_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["flow_status"] = None
            __props__.__dict__["tags_all"] = None
        super(Flow, __self__).__init__(
            'aws:appflow/flow:Flow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_flow_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowDestinationFlowConfigArgs', 'FlowDestinationFlowConfigArgsDict']]]]] = None,
            flow_status: Optional[pulumi.Input[_builtins.str]] = None,
            kms_arn: Optional[pulumi.Input[_builtins.str]] = None,
            metadata_catalog_config: Optional[pulumi.Input[Union['FlowMetadataCatalogConfigArgs', 'FlowMetadataCatalogConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            source_flow_config: Optional[pulumi.Input[Union['FlowSourceFlowConfigArgs', 'FlowSourceFlowConfigArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FlowTaskArgs', 'FlowTaskArgsDict']]]]] = None,
            trigger_config: Optional[pulumi.Input[Union['FlowTriggerConfigArgs', 'FlowTriggerConfigArgsDict']]] = None) -> 'Flow':
        """
        Get an existing Flow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Flow's ARN.
        :param pulumi.Input[_builtins.str] description: Description of the flow you want to create.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlowDestinationFlowConfigArgs', 'FlowDestinationFlowConfigArgsDict']]]] destination_flow_configs: A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
        :param pulumi.Input[_builtins.str] flow_status: The current status of the flow.
        :param pulumi.Input[_builtins.str] kms_arn: ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        :param pulumi.Input[Union['FlowMetadataCatalogConfigArgs', 'FlowMetadataCatalogConfigArgsDict']] metadata_catalog_config: A Catalog that determines the configuration that Amazon AppFlow uses when it catalogs the data that’s transferred by the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
        :param pulumi.Input[_builtins.str] name: Name of the flow.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Union['FlowSourceFlowConfigArgs', 'FlowSourceFlowConfigArgsDict']] source_flow_config: The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FlowTaskArgs', 'FlowTaskArgsDict']]]] tasks: A Task that Amazon AppFlow performs while transferring the data in the flow run.
        :param pulumi.Input[Union['FlowTriggerConfigArgs', 'FlowTriggerConfigArgsDict']] trigger_config: A Trigger that determine how and when the flow runs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlowState.__new__(_FlowState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_flow_configs"] = destination_flow_configs
        __props__.__dict__["flow_status"] = flow_status
        __props__.__dict__["kms_arn"] = kms_arn
        __props__.__dict__["metadata_catalog_config"] = metadata_catalog_config
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["source_flow_config"] = source_flow_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["tasks"] = tasks
        __props__.__dict__["trigger_config"] = trigger_config
        return Flow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Flow's ARN.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the flow you want to create.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationFlowConfigs")
    def destination_flow_configs(self) -> pulumi.Output[Sequence['outputs.FlowDestinationFlowConfig']]:
        """
        A Destination Flow Config that controls how Amazon AppFlow places data in the destination connector.
        """
        return pulumi.get(self, "destination_flow_configs")

    @_builtins.property
    @pulumi.getter(name="flowStatus")
    def flow_status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the flow.
        """
        return pulumi.get(self, "flow_status")

    @_builtins.property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
        """
        return pulumi.get(self, "kms_arn")

    @_builtins.property
    @pulumi.getter(name="metadataCatalogConfig")
    def metadata_catalog_config(self) -> pulumi.Output['outputs.FlowMetadataCatalogConfig']:
        """
        A Catalog that determines the configuration that Amazon AppFlow uses when it catalogs the data that’s transferred by the associated flow. When Amazon AppFlow catalogs the data from a flow, it stores metadata in a data catalog.
        """
        return pulumi.get(self, "metadata_catalog_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the flow.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourceFlowConfig")
    def source_flow_config(self) -> pulumi.Output['outputs.FlowSourceFlowConfig']:
        """
        The Source Flow Config that controls how Amazon AppFlow retrieves data from the source connector.
        """
        return pulumi.get(self, "source_flow_config")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def tasks(self) -> pulumi.Output[Sequence['outputs.FlowTask']]:
        """
        A Task that Amazon AppFlow performs while transferring the data in the flow run.
        """
        return pulumi.get(self, "tasks")

    @_builtins.property
    @pulumi.getter(name="triggerConfig")
    def trigger_config(self) -> pulumi.Output['outputs.FlowTriggerConfig']:
        """
        A Trigger that determine how and when the flow runs.
        """
        return pulumi.get(self, "trigger_config")

