# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiArgs', 'Api']

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 event_config: Optional[pulumi.Input['ApiEventConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Api resource.
        :param pulumi.Input['ApiEventConfigArgs'] event_config: Configuration for the Event API. See Event Config below.
        :param pulumi.Input[_builtins.str] name: Name of the Event API.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] owner_contact: Contact information for the owner of the Event API.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        if event_config is not None:
            pulumi.set(__self__, "event_config", event_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_contact is not None:
            pulumi.set(__self__, "owner_contact", owner_contact)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="eventConfig")
    def event_config(self) -> Optional[pulumi.Input['ApiEventConfigArgs']]:
        """
        Configuration for the Event API. See Event Config below.
        """
        return pulumi.get(self, "event_config")

    @event_config.setter
    def event_config(self, value: Optional[pulumi.Input['ApiEventConfigArgs']]):
        pulumi.set(self, "event_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Event API.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerContact")
    def owner_contact(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contact information for the owner of the Event API.
        """
        return pulumi.get(self, "owner_contact")

    @owner_contact.setter
    def owner_contact(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_contact", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ApiState:
    def __init__(__self__, *,
                 api_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dns: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 event_config: Optional[pulumi.Input['ApiEventConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 waf_web_acl_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 xray_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Api resources.
        :param pulumi.Input[_builtins.str] api_arn: ARN of the Event API.
        :param pulumi.Input[_builtins.str] api_id: ID of the Event API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dns: DNS configuration for the Event API.
        :param pulumi.Input['ApiEventConfigArgs'] event_config: Configuration for the Event API. See Event Config below.
        :param pulumi.Input[_builtins.str] name: Name of the Event API.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] owner_contact: Contact information for the owner of the Event API.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] waf_web_acl_arn: ARN of the associated WAF web ACL.
        """
        if api_arn is not None:
            pulumi.set(__self__, "api_arn", api_arn)
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if event_config is not None:
            pulumi.set(__self__, "event_config", event_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner_contact is not None:
            pulumi.set(__self__, "owner_contact", owner_contact)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if waf_web_acl_arn is not None:
            pulumi.set(__self__, "waf_web_acl_arn", waf_web_acl_arn)
        if xray_enabled is not None:
            pulumi.set(__self__, "xray_enabled", xray_enabled)

    @_builtins.property
    @pulumi.getter(name="apiArn")
    def api_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the Event API.
        """
        return pulumi.get(self, "api_arn")

    @api_arn.setter
    def api_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_arn", value)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Event API.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_id", value)

    @_builtins.property
    @pulumi.getter
    def dns(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        DNS configuration for the Event API.
        """
        return pulumi.get(self, "dns")

    @dns.setter
    def dns(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns", value)

    @_builtins.property
    @pulumi.getter(name="eventConfig")
    def event_config(self) -> Optional[pulumi.Input['ApiEventConfigArgs']]:
        """
        Configuration for the Event API. See Event Config below.
        """
        return pulumi.get(self, "event_config")

    @event_config.setter
    def event_config(self, value: Optional[pulumi.Input['ApiEventConfigArgs']]):
        pulumi.set(self, "event_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Event API.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ownerContact")
    def owner_contact(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Contact information for the owner of the Event API.
        """
        return pulumi.get(self, "owner_contact")

    @owner_contact.setter
    def owner_contact(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner_contact", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="wafWebAclArn")
    def waf_web_acl_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the associated WAF web ACL.
        """
        return pulumi.get(self, "waf_web_acl_arn")

    @waf_web_acl_arn.setter
    def waf_web_acl_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "waf_web_acl_arn", value)

    @_builtins.property
    @pulumi.getter(name="xrayEnabled")
    def xray_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "xray_enabled")

    @xray_enabled.setter
    def xray_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "xray_enabled", value)


@pulumi.type_token("aws:appsync/api:Api")
class Api(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_config: Optional[pulumi.Input[Union['ApiEventConfigArgs', 'ApiEventConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an [AWS AppSync Event API](https://docs.aws.amazon.com/appsync/latest/eventapi/event-api-concepts.html#API). Event APIs enable real-time subscriptions and event-driven communication in AppSync applications.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.Api("example",
            name="example-event-api",
            event_config={
                "auth_providers": [{
                    "auth_type": "API_KEY",
                }],
                "connection_auth_modes": [{
                    "auth_type": "API_KEY",
                }],
                "default_publish_auth_modes": [{
                    "auth_type": "API_KEY",
                }],
                "default_subscribe_auth_modes": [{
                    "auth_type": "API_KEY",
                }],
            })
        ```

        ### With Cognito Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="example-user-pool")
        current = aws.get_region()
        example_api = aws.appsync.Api("example",
            name="example-event-api",
            event_config={
                "auth_providers": [{
                    "auth_type": "AMAZON_COGNITO_USER_POOLS",
                    "cognito_config": {
                        "user_pool_id": example.id,
                        "aws_region": current.name,
                    },
                }],
                "connection_auth_modes": [{
                    "auth_type": "AMAZON_COGNITO_USER_POOLS",
                }],
                "default_publish_auth_modes": [{
                    "auth_type": "AMAZON_COGNITO_USER_POOLS",
                }],
                "default_subscribe_auth_modes": [{
                    "auth_type": "AMAZON_COGNITO_USER_POOLS",
                }],
            })
        ```

        ### With Lambda Authorizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.Api("example",
            name="example-event-api",
            event_config={
                "auth_providers": [{
                    "auth_type": "AWS_LAMBDA",
                    "lambda_authorizer_config": {
                        "authorizer_uri": example_aws_lambda_function["invokeArn"],
                        "authorizer_result_ttl_in_seconds": 300,
                    },
                }],
                "connection_auth_modes": [{
                    "auth_type": "AWS_LAMBDA",
                }],
                "default_publish_auth_modes": [{
                    "auth_type": "AWS_LAMBDA",
                }],
                "default_subscribe_auth_modes": [{
                    "auth_type": "AWS_LAMBDA",
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import AppSync Event API using the `api_id`. For example:

        ```sh
        $ pulumi import aws:appsync/api:Api example example-api-id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ApiEventConfigArgs', 'ApiEventConfigArgsDict']] event_config: Configuration for the Event API. See Event Config below.
        :param pulumi.Input[_builtins.str] name: Name of the Event API.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] owner_contact: Contact information for the owner of the Event API.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApiArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an [AWS AppSync Event API](https://docs.aws.amazon.com/appsync/latest/eventapi/event-api-concepts.html#API). Event APIs enable real-time subscriptions and event-driven communication in AppSync applications.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.Api("example",
            name="example-event-api",
            event_config={
                "auth_providers": [{
                    "auth_type": "API_KEY",
                }],
                "connection_auth_modes": [{
                    "auth_type": "API_KEY",
                }],
                "default_publish_auth_modes": [{
                    "auth_type": "API_KEY",
                }],
                "default_subscribe_auth_modes": [{
                    "auth_type": "API_KEY",
                }],
            })
        ```

        ### With Cognito Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="example-user-pool")
        current = aws.get_region()
        example_api = aws.appsync.Api("example",
            name="example-event-api",
            event_config={
                "auth_providers": [{
                    "auth_type": "AMAZON_COGNITO_USER_POOLS",
                    "cognito_config": {
                        "user_pool_id": example.id,
                        "aws_region": current.name,
                    },
                }],
                "connection_auth_modes": [{
                    "auth_type": "AMAZON_COGNITO_USER_POOLS",
                }],
                "default_publish_auth_modes": [{
                    "auth_type": "AMAZON_COGNITO_USER_POOLS",
                }],
                "default_subscribe_auth_modes": [{
                    "auth_type": "AMAZON_COGNITO_USER_POOLS",
                }],
            })
        ```

        ### With Lambda Authorizer

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.Api("example",
            name="example-event-api",
            event_config={
                "auth_providers": [{
                    "auth_type": "AWS_LAMBDA",
                    "lambda_authorizer_config": {
                        "authorizer_uri": example_aws_lambda_function["invokeArn"],
                        "authorizer_result_ttl_in_seconds": 300,
                    },
                }],
                "connection_auth_modes": [{
                    "auth_type": "AWS_LAMBDA",
                }],
                "default_publish_auth_modes": [{
                    "auth_type": "AWS_LAMBDA",
                }],
                "default_subscribe_auth_modes": [{
                    "auth_type": "AWS_LAMBDA",
                }],
            })
        ```

        ## Import

        Using `pulumi import`, import AppSync Event API using the `api_id`. For example:

        ```sh
        $ pulumi import aws:appsync/api:Api example example-api-id
        ```

        :param str resource_name: The name of the resource.
        :param ApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 event_config: Optional[pulumi.Input[Union['ApiEventConfigArgs', 'ApiEventConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner_contact: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiArgs.__new__(ApiArgs)

            __props__.__dict__["event_config"] = event_config
            __props__.__dict__["name"] = name
            __props__.__dict__["owner_contact"] = owner_contact
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["api_arn"] = None
            __props__.__dict__["api_id"] = None
            __props__.__dict__["dns"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["waf_web_acl_arn"] = None
            __props__.__dict__["xray_enabled"] = None
        super(Api, __self__).__init__(
            'aws:appsync/api:Api',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_arn: Optional[pulumi.Input[_builtins.str]] = None,
            api_id: Optional[pulumi.Input[_builtins.str]] = None,
            dns: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            event_config: Optional[pulumi.Input[Union['ApiEventConfigArgs', 'ApiEventConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner_contact: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            waf_web_acl_arn: Optional[pulumi.Input[_builtins.str]] = None,
            xray_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Api':
        """
        Get an existing Api resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_arn: ARN of the Event API.
        :param pulumi.Input[_builtins.str] api_id: ID of the Event API.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] dns: DNS configuration for the Event API.
        :param pulumi.Input[Union['ApiEventConfigArgs', 'ApiEventConfigArgsDict']] event_config: Configuration for the Event API. See Event Config below.
        :param pulumi.Input[_builtins.str] name: Name of the Event API.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] owner_contact: Contact information for the owner of the Event API.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] waf_web_acl_arn: ARN of the associated WAF web ACL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiState.__new__(_ApiState)

        __props__.__dict__["api_arn"] = api_arn
        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["dns"] = dns
        __props__.__dict__["event_config"] = event_config
        __props__.__dict__["name"] = name
        __props__.__dict__["owner_contact"] = owner_contact
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["waf_web_acl_arn"] = waf_web_acl_arn
        __props__.__dict__["xray_enabled"] = xray_enabled
        return Api(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiArn")
    def api_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the Event API.
        """
        return pulumi.get(self, "api_arn")

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Event API.
        """
        return pulumi.get(self, "api_id")

    @_builtins.property
    @pulumi.getter
    def dns(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        DNS configuration for the Event API.
        """
        return pulumi.get(self, "dns")

    @_builtins.property
    @pulumi.getter(name="eventConfig")
    def event_config(self) -> pulumi.Output[Optional['outputs.ApiEventConfig']]:
        """
        Configuration for the Event API. See Event Config below.
        """
        return pulumi.get(self, "event_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the Event API.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerContact")
    def owner_contact(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Contact information for the owner of the Event API.
        """
        return pulumi.get(self, "owner_contact")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="wafWebAclArn")
    def waf_web_acl_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the associated WAF web ACL.
        """
        return pulumi.get(self, "waf_web_acl_arn")

    @_builtins.property
    @pulumi.getter(name="xrayEnabled")
    def xray_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "xray_enabled")

