# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApiCacheArgs', 'ApiCache']

@pulumi.input_type
class ApiCacheArgs:
    def __init__(__self__, *,
                 api_caching_behavior: pulumi.Input[_builtins.str],
                 api_id: pulumi.Input[_builtins.str],
                 ttl: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ApiCache resource.
        :param pulumi.Input[_builtins.str] api_caching_behavior: Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
        :param pulumi.Input[_builtins.str] api_id: GraphQL API ID.
        :param pulumi.Input[_builtins.int] ttl: TTL in seconds for cache entries.
        :param pulumi.Input[_builtins.str] type: Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
        :param pulumi.Input[_builtins.bool] at_rest_encryption_enabled: At-rest encryption flag for cache. You cannot update this setting after creation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Transit encryption flag when connecting to cache. You cannot update this setting after creation.
        """
        pulumi.set(__self__, "api_caching_behavior", api_caching_behavior)
        pulumi.set(__self__, "api_id", api_id)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        if at_rest_encryption_enabled is not None:
            pulumi.set(__self__, "at_rest_encryption_enabled", at_rest_encryption_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if transit_encryption_enabled is not None:
            pulumi.set(__self__, "transit_encryption_enabled", transit_encryption_enabled)

    @_builtins.property
    @pulumi.getter(name="apiCachingBehavior")
    def api_caching_behavior(self) -> pulumi.Input[_builtins.str]:
        """
        Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
        """
        return pulumi.get(self, "api_caching_behavior")

    @api_caching_behavior.setter
    def api_caching_behavior(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_caching_behavior", value)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Input[_builtins.str]:
        """
        GraphQL API ID.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_id", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Input[_builtins.int]:
        """
        TTL in seconds for cache entries.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="atRestEncryptionEnabled")
    def at_rest_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        At-rest encryption flag for cache. You cannot update this setting after creation.
        """
        return pulumi.get(self, "at_rest_encryption_enabled")

    @at_rest_encryption_enabled.setter
    def at_rest_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "at_rest_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Transit encryption flag when connecting to cache. You cannot update this setting after creation.
        """
        return pulumi.get(self, "transit_encryption_enabled")

    @transit_encryption_enabled.setter
    def transit_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transit_encryption_enabled", value)


@pulumi.input_type
class _ApiCacheState:
    def __init__(__self__, *,
                 api_caching_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiCache resources.
        :param pulumi.Input[_builtins.str] api_caching_behavior: Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
        :param pulumi.Input[_builtins.str] api_id: GraphQL API ID.
        :param pulumi.Input[_builtins.bool] at_rest_encryption_enabled: At-rest encryption flag for cache. You cannot update this setting after creation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Transit encryption flag when connecting to cache. You cannot update this setting after creation.
        :param pulumi.Input[_builtins.int] ttl: TTL in seconds for cache entries.
        :param pulumi.Input[_builtins.str] type: Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
        """
        if api_caching_behavior is not None:
            pulumi.set(__self__, "api_caching_behavior", api_caching_behavior)
        if api_id is not None:
            pulumi.set(__self__, "api_id", api_id)
        if at_rest_encryption_enabled is not None:
            pulumi.set(__self__, "at_rest_encryption_enabled", at_rest_encryption_enabled)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if transit_encryption_enabled is not None:
            pulumi.set(__self__, "transit_encryption_enabled", transit_encryption_enabled)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="apiCachingBehavior")
    def api_caching_behavior(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
        """
        return pulumi.get(self, "api_caching_behavior")

    @api_caching_behavior.setter
    def api_caching_behavior(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_caching_behavior", value)

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        GraphQL API ID.
        """
        return pulumi.get(self, "api_id")

    @api_id.setter
    def api_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_id", value)

    @_builtins.property
    @pulumi.getter(name="atRestEncryptionEnabled")
    def at_rest_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        At-rest encryption flag for cache. You cannot update this setting after creation.
        """
        return pulumi.get(self, "at_rest_encryption_enabled")

    @at_rest_encryption_enabled.setter
    def at_rest_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "at_rest_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Transit encryption flag when connecting to cache. You cannot update this setting after creation.
        """
        return pulumi.get(self, "transit_encryption_enabled")

    @transit_encryption_enabled.setter
    def transit_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "transit_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TTL in seconds for cache entries.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:appsync/apiCache:ApiCache")
class ApiCache(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_caching_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an AppSync API Cache.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="API_KEY",
            name="example")
        example_api_cache = aws.appsync.ApiCache("example",
            api_id=example.id,
            api_caching_behavior="FULL_REQUEST_CACHING",
            type="LARGE",
            ttl=900)
        ```

        ## Import

        Using `pulumi import`, import `aws_appsync_api_cache` using the AppSync API ID. For example:

        ```sh
        $ pulumi import aws:appsync/apiCache:ApiCache example xxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_caching_behavior: Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
        :param pulumi.Input[_builtins.str] api_id: GraphQL API ID.
        :param pulumi.Input[_builtins.bool] at_rest_encryption_enabled: At-rest encryption flag for cache. You cannot update this setting after creation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Transit encryption flag when connecting to cache. You cannot update this setting after creation.
        :param pulumi.Input[_builtins.int] ttl: TTL in seconds for cache entries.
        :param pulumi.Input[_builtins.str] type: Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiCacheArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppSync API Cache.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="API_KEY",
            name="example")
        example_api_cache = aws.appsync.ApiCache("example",
            api_id=example.id,
            api_caching_behavior="FULL_REQUEST_CACHING",
            type="LARGE",
            ttl=900)
        ```

        ## Import

        Using `pulumi import`, import `aws_appsync_api_cache` using the AppSync API ID. For example:

        ```sh
        $ pulumi import aws:appsync/apiCache:ApiCache example xxxxx
        ```

        :param str resource_name: The name of the resource.
        :param ApiCacheArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiCacheArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_caching_behavior: Optional[pulumi.Input[_builtins.str]] = None,
                 api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiCacheArgs.__new__(ApiCacheArgs)

            if api_caching_behavior is None and not opts.urn:
                raise TypeError("Missing required property 'api_caching_behavior'")
            __props__.__dict__["api_caching_behavior"] = api_caching_behavior
            if api_id is None and not opts.urn:
                raise TypeError("Missing required property 'api_id'")
            __props__.__dict__["api_id"] = api_id
            __props__.__dict__["at_rest_encryption_enabled"] = at_rest_encryption_enabled
            __props__.__dict__["region"] = region
            __props__.__dict__["transit_encryption_enabled"] = transit_encryption_enabled
            if ttl is None and not opts.urn:
                raise TypeError("Missing required property 'ttl'")
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(ApiCache, __self__).__init__(
            'aws:appsync/apiCache:ApiCache',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_caching_behavior: Optional[pulumi.Input[_builtins.str]] = None,
            api_id: Optional[pulumi.Input[_builtins.str]] = None,
            at_rest_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            transit_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApiCache':
        """
        Get an existing ApiCache resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_caching_behavior: Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
        :param pulumi.Input[_builtins.str] api_id: GraphQL API ID.
        :param pulumi.Input[_builtins.bool] at_rest_encryption_enabled: At-rest encryption flag for cache. You cannot update this setting after creation.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.bool] transit_encryption_enabled: Transit encryption flag when connecting to cache. You cannot update this setting after creation.
        :param pulumi.Input[_builtins.int] ttl: TTL in seconds for cache entries.
        :param pulumi.Input[_builtins.str] type: Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiCacheState.__new__(_ApiCacheState)

        __props__.__dict__["api_caching_behavior"] = api_caching_behavior
        __props__.__dict__["api_id"] = api_id
        __props__.__dict__["at_rest_encryption_enabled"] = at_rest_encryption_enabled
        __props__.__dict__["region"] = region
        __props__.__dict__["transit_encryption_enabled"] = transit_encryption_enabled
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        return ApiCache(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiCachingBehavior")
    def api_caching_behavior(self) -> pulumi.Output[_builtins.str]:
        """
        Caching behavior. Valid values are `FULL_REQUEST_CACHING` and `PER_RESOLVER_CACHING`.
        """
        return pulumi.get(self, "api_caching_behavior")

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> pulumi.Output[_builtins.str]:
        """
        GraphQL API ID.
        """
        return pulumi.get(self, "api_id")

    @_builtins.property
    @pulumi.getter(name="atRestEncryptionEnabled")
    def at_rest_encryption_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        At-rest encryption flag for cache. You cannot update this setting after creation.
        """
        return pulumi.get(self, "at_rest_encryption_enabled")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Transit encryption flag when connecting to cache. You cannot update this setting after creation.
        """
        return pulumi.get(self, "transit_encryption_enabled")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[_builtins.int]:
        """
        TTL in seconds for cache entries.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Cache instance type. Valid values are `SMALL`, `MEDIUM`, `LARGE`, `XLARGE`, `LARGE_2X`, `LARGE_4X`, `LARGE_8X`, `LARGE_12X`, `T2_SMALL`, `T2_MEDIUM`, `R4_LARGE`, `R4_XLARGE`, `R4_2XLARGE`, `R4_4XLARGE`, `R4_8XLARGE`.
        """
        return pulumi.get(self, "type")

