# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GraphQLApiArgs', 'GraphQLApi']

@pulumi.input_type
class GraphQLApiArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[_builtins.str],
                 additional_authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderArgs']]]] = None,
                 api_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enhanced_metrics_config: Optional[pulumi.Input['GraphQLApiEnhancedMetricsConfigArgs']] = None,
                 introspection_config: Optional[pulumi.Input[_builtins.str]] = None,
                 lambda_authorizer_config: Optional[pulumi.Input['GraphQLApiLambdaAuthorizerConfigArgs']] = None,
                 log_config: Optional[pulumi.Input['GraphQLApiLogConfigArgs']] = None,
                 merged_api_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openid_connect_config: Optional[pulumi.Input['GraphQLApiOpenidConnectConfigArgs']] = None,
                 query_depth_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resolver_count_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_pool_config: Optional[pulumi.Input['GraphQLApiUserPoolConfigArgs']] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 xray_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a GraphQLApi resource.
        :param pulumi.Input[_builtins.str] authentication_type: Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        :param pulumi.Input[Sequence[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderArgs']]] additional_authentication_providers: One or more additional authentication providers for the GraphQL API. See `additional_authentication_provider` Block for details.
        :param pulumi.Input[_builtins.str] api_type: API type. Valid values are `GRAPHQL` or `MERGED`. A `MERGED` type requires `merged_api_execution_role_arn` to be set.
        :param pulumi.Input['GraphQLApiEnhancedMetricsConfigArgs'] enhanced_metrics_config: Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
        :param pulumi.Input[_builtins.str] introspection_config: Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
        :param pulumi.Input['GraphQLApiLambdaAuthorizerConfigArgs'] lambda_authorizer_config: Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        :param pulumi.Input['GraphQLApiLogConfigArgs'] log_config: Nested argument containing logging configuration. See `log_config` Block for details.
        :param pulumi.Input[_builtins.str] merged_api_execution_role_arn: ARN of the execution role when `api_type` is set to `MERGED`.
        :param pulumi.Input[_builtins.str] name: User-supplied name for the GraphQL API.
               
               The following arguments are optional:
        :param pulumi.Input['GraphQLApiOpenidConnectConfigArgs'] openid_connect_config: Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        :param pulumi.Input[_builtins.int] query_depth_limit: The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
               
               Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] resolver_count_limit: The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
        :param pulumi.Input[_builtins.str] schema: Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['GraphQLApiUserPoolConfigArgs'] user_pool_config: Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        :param pulumi.Input[_builtins.str] visibility: Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
        :param pulumi.Input[_builtins.bool] xray_enabled: Whether tracing with X-ray is enabled. Defaults to false.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if additional_authentication_providers is not None:
            pulumi.set(__self__, "additional_authentication_providers", additional_authentication_providers)
        if api_type is not None:
            pulumi.set(__self__, "api_type", api_type)
        if enhanced_metrics_config is not None:
            pulumi.set(__self__, "enhanced_metrics_config", enhanced_metrics_config)
        if introspection_config is not None:
            pulumi.set(__self__, "introspection_config", introspection_config)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if merged_api_execution_role_arn is not None:
            pulumi.set(__self__, "merged_api_execution_role_arn", merged_api_execution_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openid_connect_config is not None:
            pulumi.set(__self__, "openid_connect_config", openid_connect_config)
        if query_depth_limit is not None:
            pulumi.set(__self__, "query_depth_limit", query_depth_limit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resolver_count_limit is not None:
            pulumi.set(__self__, "resolver_count_limit", resolver_count_limit)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if xray_enabled is not None:
            pulumi.set(__self__, "xray_enabled", xray_enabled)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[_builtins.str]:
        """
        Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="additionalAuthenticationProviders")
    def additional_authentication_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderArgs']]]]:
        """
        One or more additional authentication providers for the GraphQL API. See `additional_authentication_provider` Block for details.
        """
        return pulumi.get(self, "additional_authentication_providers")

    @additional_authentication_providers.setter
    def additional_authentication_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderArgs']]]]):
        pulumi.set(self, "additional_authentication_providers", value)

    @_builtins.property
    @pulumi.getter(name="apiType")
    def api_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API type. Valid values are `GRAPHQL` or `MERGED`. A `MERGED` type requires `merged_api_execution_role_arn` to be set.
        """
        return pulumi.get(self, "api_type")

    @api_type.setter
    def api_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_type", value)

    @_builtins.property
    @pulumi.getter(name="enhancedMetricsConfig")
    def enhanced_metrics_config(self) -> Optional[pulumi.Input['GraphQLApiEnhancedMetricsConfigArgs']]:
        """
        Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
        """
        return pulumi.get(self, "enhanced_metrics_config")

    @enhanced_metrics_config.setter
    def enhanced_metrics_config(self, value: Optional[pulumi.Input['GraphQLApiEnhancedMetricsConfigArgs']]):
        pulumi.set(self, "enhanced_metrics_config", value)

    @_builtins.property
    @pulumi.getter(name="introspectionConfig")
    def introspection_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
        """
        return pulumi.get(self, "introspection_config")

    @introspection_config.setter
    def introspection_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "introspection_config", value)

    @_builtins.property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional[pulumi.Input['GraphQLApiLambdaAuthorizerConfigArgs']]:
        """
        Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @lambda_authorizer_config.setter
    def lambda_authorizer_config(self, value: Optional[pulumi.Input['GraphQLApiLambdaAuthorizerConfigArgs']]):
        pulumi.set(self, "lambda_authorizer_config", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['GraphQLApiLogConfigArgs']]:
        """
        Nested argument containing logging configuration. See `log_config` Block for details.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['GraphQLApiLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="mergedApiExecutionRoleArn")
    def merged_api_execution_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the execution role when `api_type` is set to `MERGED`.
        """
        return pulumi.get(self, "merged_api_execution_role_arn")

    @merged_api_execution_role_arn.setter
    def merged_api_execution_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "merged_api_execution_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied name for the GraphQL API.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> Optional[pulumi.Input['GraphQLApiOpenidConnectConfigArgs']]:
        """
        Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        """
        return pulumi.get(self, "openid_connect_config")

    @openid_connect_config.setter
    def openid_connect_config(self, value: Optional[pulumi.Input['GraphQLApiOpenidConnectConfigArgs']]):
        pulumi.set(self, "openid_connect_config", value)

    @_builtins.property
    @pulumi.getter(name="queryDepthLimit")
    def query_depth_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.

        Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
        """
        return pulumi.get(self, "query_depth_limit")

    @query_depth_limit.setter
    def query_depth_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "query_depth_limit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resolverCountLimit")
    def resolver_count_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
        """
        return pulumi.get(self, "resolver_count_limit")

    @resolver_count_limit.setter
    def resolver_count_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resolver_count_limit", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional[pulumi.Input['GraphQLApiUserPoolConfigArgs']]:
        """
        Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
        return pulumi.get(self, "user_pool_config")

    @user_pool_config.setter
    def user_pool_config(self, value: Optional[pulumi.Input['GraphQLApiUserPoolConfigArgs']]):
        pulumi.set(self, "user_pool_config", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)

    @_builtins.property
    @pulumi.getter(name="xrayEnabled")
    def xray_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether tracing with X-ray is enabled. Defaults to false.
        """
        return pulumi.get(self, "xray_enabled")

    @xray_enabled.setter
    def xray_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "xray_enabled", value)


@pulumi.input_type
class _GraphQLApiState:
    def __init__(__self__, *,
                 additional_authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderArgs']]]] = None,
                 api_type: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enhanced_metrics_config: Optional[pulumi.Input['GraphQLApiEnhancedMetricsConfigArgs']] = None,
                 introspection_config: Optional[pulumi.Input[_builtins.str]] = None,
                 lambda_authorizer_config: Optional[pulumi.Input['GraphQLApiLambdaAuthorizerConfigArgs']] = None,
                 log_config: Optional[pulumi.Input['GraphQLApiLogConfigArgs']] = None,
                 merged_api_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openid_connect_config: Optional[pulumi.Input['GraphQLApiOpenidConnectConfigArgs']] = None,
                 query_depth_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resolver_count_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uris: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_pool_config: Optional[pulumi.Input['GraphQLApiUserPoolConfigArgs']] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 xray_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering GraphQLApi resources.
        :param pulumi.Input[Sequence[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderArgs']]] additional_authentication_providers: One or more additional authentication providers for the GraphQL API. See `additional_authentication_provider` Block for details.
        :param pulumi.Input[_builtins.str] api_type: API type. Valid values are `GRAPHQL` or `MERGED`. A `MERGED` type requires `merged_api_execution_role_arn` to be set.
        :param pulumi.Input[_builtins.str] arn: ARN
        :param pulumi.Input[_builtins.str] authentication_type: Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        :param pulumi.Input['GraphQLApiEnhancedMetricsConfigArgs'] enhanced_metrics_config: Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
        :param pulumi.Input[_builtins.str] introspection_config: Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
        :param pulumi.Input['GraphQLApiLambdaAuthorizerConfigArgs'] lambda_authorizer_config: Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        :param pulumi.Input['GraphQLApiLogConfigArgs'] log_config: Nested argument containing logging configuration. See `log_config` Block for details.
        :param pulumi.Input[_builtins.str] merged_api_execution_role_arn: ARN of the execution role when `api_type` is set to `MERGED`.
        :param pulumi.Input[_builtins.str] name: User-supplied name for the GraphQL API.
               
               The following arguments are optional:
        :param pulumi.Input['GraphQLApiOpenidConnectConfigArgs'] openid_connect_config: Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        :param pulumi.Input[_builtins.int] query_depth_limit: The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
               
               Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] resolver_count_limit: The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
        :param pulumi.Input[_builtins.str] schema: Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] uris: Map of URIs associated with the API E.g., `uris["GRAPHQL"] = https://ID.appsync-api.REGION.amazonaws.com/graphql`
        :param pulumi.Input['GraphQLApiUserPoolConfigArgs'] user_pool_config: Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        :param pulumi.Input[_builtins.str] visibility: Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
        :param pulumi.Input[_builtins.bool] xray_enabled: Whether tracing with X-ray is enabled. Defaults to false.
        """
        if additional_authentication_providers is not None:
            pulumi.set(__self__, "additional_authentication_providers", additional_authentication_providers)
        if api_type is not None:
            pulumi.set(__self__, "api_type", api_type)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if enhanced_metrics_config is not None:
            pulumi.set(__self__, "enhanced_metrics_config", enhanced_metrics_config)
        if introspection_config is not None:
            pulumi.set(__self__, "introspection_config", introspection_config)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if merged_api_execution_role_arn is not None:
            pulumi.set(__self__, "merged_api_execution_role_arn", merged_api_execution_role_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if openid_connect_config is not None:
            pulumi.set(__self__, "openid_connect_config", openid_connect_config)
        if query_depth_limit is not None:
            pulumi.set(__self__, "query_depth_limit", query_depth_limit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resolver_count_limit is not None:
            pulumi.set(__self__, "resolver_count_limit", resolver_count_limit)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if uris is not None:
            pulumi.set(__self__, "uris", uris)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if xray_enabled is not None:
            pulumi.set(__self__, "xray_enabled", xray_enabled)

    @_builtins.property
    @pulumi.getter(name="additionalAuthenticationProviders")
    def additional_authentication_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderArgs']]]]:
        """
        One or more additional authentication providers for the GraphQL API. See `additional_authentication_provider` Block for details.
        """
        return pulumi.get(self, "additional_authentication_providers")

    @additional_authentication_providers.setter
    def additional_authentication_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GraphQLApiAdditionalAuthenticationProviderArgs']]]]):
        pulumi.set(self, "additional_authentication_providers", value)

    @_builtins.property
    @pulumi.getter(name="apiType")
    def api_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        API type. Valid values are `GRAPHQL` or `MERGED`. A `MERGED` type requires `merged_api_execution_role_arn` to be set.
        """
        return pulumi.get(self, "api_type")

    @api_type.setter
    def api_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_type", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="enhancedMetricsConfig")
    def enhanced_metrics_config(self) -> Optional[pulumi.Input['GraphQLApiEnhancedMetricsConfigArgs']]:
        """
        Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
        """
        return pulumi.get(self, "enhanced_metrics_config")

    @enhanced_metrics_config.setter
    def enhanced_metrics_config(self, value: Optional[pulumi.Input['GraphQLApiEnhancedMetricsConfigArgs']]):
        pulumi.set(self, "enhanced_metrics_config", value)

    @_builtins.property
    @pulumi.getter(name="introspectionConfig")
    def introspection_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
        """
        return pulumi.get(self, "introspection_config")

    @introspection_config.setter
    def introspection_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "introspection_config", value)

    @_builtins.property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional[pulumi.Input['GraphQLApiLambdaAuthorizerConfigArgs']]:
        """
        Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @lambda_authorizer_config.setter
    def lambda_authorizer_config(self, value: Optional[pulumi.Input['GraphQLApiLambdaAuthorizerConfigArgs']]):
        pulumi.set(self, "lambda_authorizer_config", value)

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['GraphQLApiLogConfigArgs']]:
        """
        Nested argument containing logging configuration. See `log_config` Block for details.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['GraphQLApiLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @_builtins.property
    @pulumi.getter(name="mergedApiExecutionRoleArn")
    def merged_api_execution_role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the execution role when `api_type` is set to `MERGED`.
        """
        return pulumi.get(self, "merged_api_execution_role_arn")

    @merged_api_execution_role_arn.setter
    def merged_api_execution_role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "merged_api_execution_role_arn", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-supplied name for the GraphQL API.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> Optional[pulumi.Input['GraphQLApiOpenidConnectConfigArgs']]:
        """
        Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        """
        return pulumi.get(self, "openid_connect_config")

    @openid_connect_config.setter
    def openid_connect_config(self, value: Optional[pulumi.Input['GraphQLApiOpenidConnectConfigArgs']]):
        pulumi.set(self, "openid_connect_config", value)

    @_builtins.property
    @pulumi.getter(name="queryDepthLimit")
    def query_depth_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.

        Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
        """
        return pulumi.get(self, "query_depth_limit")

    @query_depth_limit.setter
    def query_depth_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "query_depth_limit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resolverCountLimit")
    def resolver_count_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
        """
        return pulumi.get(self, "resolver_count_limit")

    @resolver_count_limit.setter
    def resolver_count_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resolver_count_limit", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of URIs associated with the API E.g., `uris["GRAPHQL"] = https://ID.appsync-api.REGION.amazonaws.com/graphql`
        """
        return pulumi.get(self, "uris")

    @uris.setter
    def uris(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "uris", value)

    @_builtins.property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional[pulumi.Input['GraphQLApiUserPoolConfigArgs']]:
        """
        Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
        return pulumi.get(self, "user_pool_config")

    @user_pool_config.setter
    def user_pool_config(self, value: Optional[pulumi.Input['GraphQLApiUserPoolConfigArgs']]):
        pulumi.set(self, "user_pool_config", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)

    @_builtins.property
    @pulumi.getter(name="xrayEnabled")
    def xray_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether tracing with X-ray is enabled. Defaults to false.
        """
        return pulumi.get(self, "xray_enabled")

    @xray_enabled.setter
    def xray_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "xray_enabled", value)


@pulumi.type_token("aws:appsync/graphQLApi:GraphQLApi")
class GraphQLApi(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GraphQLApiAdditionalAuthenticationProviderArgs', 'GraphQLApiAdditionalAuthenticationProviderArgsDict']]]]] = None,
                 api_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enhanced_metrics_config: Optional[pulumi.Input[Union['GraphQLApiEnhancedMetricsConfigArgs', 'GraphQLApiEnhancedMetricsConfigArgsDict']]] = None,
                 introspection_config: Optional[pulumi.Input[_builtins.str]] = None,
                 lambda_authorizer_config: Optional[pulumi.Input[Union['GraphQLApiLambdaAuthorizerConfigArgs', 'GraphQLApiLambdaAuthorizerConfigArgsDict']]] = None,
                 log_config: Optional[pulumi.Input[Union['GraphQLApiLogConfigArgs', 'GraphQLApiLogConfigArgsDict']]] = None,
                 merged_api_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openid_connect_config: Optional[pulumi.Input[Union['GraphQLApiOpenidConnectConfigArgs', 'GraphQLApiOpenidConnectConfigArgsDict']]] = None,
                 query_depth_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resolver_count_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_pool_config: Optional[pulumi.Input[Union['GraphQLApiUserPoolConfigArgs', 'GraphQLApiUserPoolConfigArgsDict']]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 xray_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Provides an AppSync GraphQL API.

        ## Example Usage

        ### API Key Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="API_KEY",
            name="example")
        ```

        ### AWS IAM Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AWS_IAM",
            name="example")
        ```

        ### AWS Cognito User Pool Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AMAZON_COGNITO_USER_POOLS",
            name="example",
            user_pool_config={
                "aws_region": current["region"],
                "default_action": "DENY",
                "user_pool_id": example_aws_cognito_user_pool["id"],
            })
        ```

        ### OpenID Connect Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="OPENID_CONNECT",
            name="example",
            openid_connect_config={
                "issuer": "https://example.com",
            })
        ```

        ### AWS Lambda Authorizer Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AWS_LAMBDA",
            name="example",
            lambda_authorizer_config={
                "authorizer_uri": "arn:aws:lambda:us-east-1:123456789012:function:custom_lambda_authorizer",
            })
        appsync_lambda_authorizer = aws.lambda_.Permission("appsync_lambda_authorizer",
            statement_id="appsync_lambda_authorizer",
            action="lambda:InvokeFunction",
            function="custom_lambda_authorizer",
            principal="appsync.amazonaws.com",
            source_arn=example.arn)
        ```

        ### With Multiple Authentication Providers

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="API_KEY",
            name="example",
            additional_authentication_providers=[{
                "authentication_type": "AWS_IAM",
            }])
        ```

        ### With Schema

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AWS_IAM",
            name="example",
            schema=\"\"\"schema {
        \\x09query: Query
        }
        type Query {
          test: Int
        }
        \"\"\")
        ```

        ### Enabling Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["appsync.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role.json)
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            policy_arn="arn:aws:iam::aws:policy/service-role/AWSAppSyncPushToCloudWatchLogs",
            role=example.name)
        example_graph_ql_api = aws.appsync.GraphQLApi("example", log_config={
            "cloudwatch_logs_role_arn": example.arn,
            "field_log_level": "ERROR",
        })
        ```

        ### GraphQL run complexity, query depth, and introspection

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AWS_IAM",
            name="example",
            introspection_config="ENABLED",
            query_depth_limit=2,
            resolver_count_limit=2)
        ```

        ## Import

        Using `pulumi import`, import AppSync GraphQL API using the GraphQL API ID. For example:

        ```sh
        $ pulumi import aws:appsync/graphQLApi:GraphQLApi example 0123456789
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GraphQLApiAdditionalAuthenticationProviderArgs', 'GraphQLApiAdditionalAuthenticationProviderArgsDict']]]] additional_authentication_providers: One or more additional authentication providers for the GraphQL API. See `additional_authentication_provider` Block for details.
        :param pulumi.Input[_builtins.str] api_type: API type. Valid values are `GRAPHQL` or `MERGED`. A `MERGED` type requires `merged_api_execution_role_arn` to be set.
        :param pulumi.Input[_builtins.str] authentication_type: Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        :param pulumi.Input[Union['GraphQLApiEnhancedMetricsConfigArgs', 'GraphQLApiEnhancedMetricsConfigArgsDict']] enhanced_metrics_config: Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
        :param pulumi.Input[_builtins.str] introspection_config: Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
        :param pulumi.Input[Union['GraphQLApiLambdaAuthorizerConfigArgs', 'GraphQLApiLambdaAuthorizerConfigArgsDict']] lambda_authorizer_config: Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        :param pulumi.Input[Union['GraphQLApiLogConfigArgs', 'GraphQLApiLogConfigArgsDict']] log_config: Nested argument containing logging configuration. See `log_config` Block for details.
        :param pulumi.Input[_builtins.str] merged_api_execution_role_arn: ARN of the execution role when `api_type` is set to `MERGED`.
        :param pulumi.Input[_builtins.str] name: User-supplied name for the GraphQL API.
               
               The following arguments are optional:
        :param pulumi.Input[Union['GraphQLApiOpenidConnectConfigArgs', 'GraphQLApiOpenidConnectConfigArgsDict']] openid_connect_config: Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        :param pulumi.Input[_builtins.int] query_depth_limit: The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
               
               Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] resolver_count_limit: The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
        :param pulumi.Input[_builtins.str] schema: Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['GraphQLApiUserPoolConfigArgs', 'GraphQLApiUserPoolConfigArgsDict']] user_pool_config: Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        :param pulumi.Input[_builtins.str] visibility: Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
        :param pulumi.Input[_builtins.bool] xray_enabled: Whether tracing with X-ray is enabled. Defaults to false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GraphQLApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AppSync GraphQL API.

        ## Example Usage

        ### API Key Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="API_KEY",
            name="example")
        ```

        ### AWS IAM Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AWS_IAM",
            name="example")
        ```

        ### AWS Cognito User Pool Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AMAZON_COGNITO_USER_POOLS",
            name="example",
            user_pool_config={
                "aws_region": current["region"],
                "default_action": "DENY",
                "user_pool_id": example_aws_cognito_user_pool["id"],
            })
        ```

        ### OpenID Connect Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="OPENID_CONNECT",
            name="example",
            openid_connect_config={
                "issuer": "https://example.com",
            })
        ```

        ### AWS Lambda Authorizer Authentication

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AWS_LAMBDA",
            name="example",
            lambda_authorizer_config={
                "authorizer_uri": "arn:aws:lambda:us-east-1:123456789012:function:custom_lambda_authorizer",
            })
        appsync_lambda_authorizer = aws.lambda_.Permission("appsync_lambda_authorizer",
            statement_id="appsync_lambda_authorizer",
            action="lambda:InvokeFunction",
            function="custom_lambda_authorizer",
            principal="appsync.amazonaws.com",
            source_arn=example.arn)
        ```

        ### With Multiple Authentication Providers

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="API_KEY",
            name="example",
            additional_authentication_providers=[{
                "authentication_type": "AWS_IAM",
            }])
        ```

        ### With Schema

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AWS_IAM",
            name="example",
            schema=\"\"\"schema {
        \\x09query: Query
        }
        type Query {
          test: Int
        }
        \"\"\")
        ```

        ### Enabling Logging

        ```python
        import pulumi
        import pulumi_aws as aws

        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["appsync.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role.json)
        example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
            policy_arn="arn:aws:iam::aws:policy/service-role/AWSAppSyncPushToCloudWatchLogs",
            role=example.name)
        example_graph_ql_api = aws.appsync.GraphQLApi("example", log_config={
            "cloudwatch_logs_role_arn": example.arn,
            "field_log_level": "ERROR",
        })
        ```

        ### GraphQL run complexity, query depth, and introspection

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.appsync.GraphQLApi("example",
            authentication_type="AWS_IAM",
            name="example",
            introspection_config="ENABLED",
            query_depth_limit=2,
            resolver_count_limit=2)
        ```

        ## Import

        Using `pulumi import`, import AppSync GraphQL API using the GraphQL API ID. For example:

        ```sh
        $ pulumi import aws:appsync/graphQLApi:GraphQLApi example 0123456789
        ```

        :param str resource_name: The name of the resource.
        :param GraphQLApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GraphQLApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GraphQLApiAdditionalAuthenticationProviderArgs', 'GraphQLApiAdditionalAuthenticationProviderArgsDict']]]]] = None,
                 api_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enhanced_metrics_config: Optional[pulumi.Input[Union['GraphQLApiEnhancedMetricsConfigArgs', 'GraphQLApiEnhancedMetricsConfigArgsDict']]] = None,
                 introspection_config: Optional[pulumi.Input[_builtins.str]] = None,
                 lambda_authorizer_config: Optional[pulumi.Input[Union['GraphQLApiLambdaAuthorizerConfigArgs', 'GraphQLApiLambdaAuthorizerConfigArgsDict']]] = None,
                 log_config: Optional[pulumi.Input[Union['GraphQLApiLogConfigArgs', 'GraphQLApiLogConfigArgsDict']]] = None,
                 merged_api_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 openid_connect_config: Optional[pulumi.Input[Union['GraphQLApiOpenidConnectConfigArgs', 'GraphQLApiOpenidConnectConfigArgsDict']]] = None,
                 query_depth_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resolver_count_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_pool_config: Optional[pulumi.Input[Union['GraphQLApiUserPoolConfigArgs', 'GraphQLApiUserPoolConfigArgsDict']]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 xray_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GraphQLApiArgs.__new__(GraphQLApiArgs)

            __props__.__dict__["additional_authentication_providers"] = additional_authentication_providers
            __props__.__dict__["api_type"] = api_type
            if authentication_type is None and not opts.urn:
                raise TypeError("Missing required property 'authentication_type'")
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["enhanced_metrics_config"] = enhanced_metrics_config
            __props__.__dict__["introspection_config"] = introspection_config
            __props__.__dict__["lambda_authorizer_config"] = lambda_authorizer_config
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["merged_api_execution_role_arn"] = merged_api_execution_role_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["openid_connect_config"] = openid_connect_config
            __props__.__dict__["query_depth_limit"] = query_depth_limit
            __props__.__dict__["region"] = region
            __props__.__dict__["resolver_count_limit"] = resolver_count_limit
            __props__.__dict__["schema"] = schema
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_pool_config"] = user_pool_config
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["xray_enabled"] = xray_enabled
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["uris"] = None
        super(GraphQLApi, __self__).__init__(
            'aws:appsync/graphQLApi:GraphQLApi',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_authentication_providers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GraphQLApiAdditionalAuthenticationProviderArgs', 'GraphQLApiAdditionalAuthenticationProviderArgsDict']]]]] = None,
            api_type: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
            enhanced_metrics_config: Optional[pulumi.Input[Union['GraphQLApiEnhancedMetricsConfigArgs', 'GraphQLApiEnhancedMetricsConfigArgsDict']]] = None,
            introspection_config: Optional[pulumi.Input[_builtins.str]] = None,
            lambda_authorizer_config: Optional[pulumi.Input[Union['GraphQLApiLambdaAuthorizerConfigArgs', 'GraphQLApiLambdaAuthorizerConfigArgsDict']]] = None,
            log_config: Optional[pulumi.Input[Union['GraphQLApiLogConfigArgs', 'GraphQLApiLogConfigArgsDict']]] = None,
            merged_api_execution_role_arn: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            openid_connect_config: Optional[pulumi.Input[Union['GraphQLApiOpenidConnectConfigArgs', 'GraphQLApiOpenidConnectConfigArgsDict']]] = None,
            query_depth_limit: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resolver_count_limit: Optional[pulumi.Input[_builtins.int]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            uris: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_pool_config: Optional[pulumi.Input[Union['GraphQLApiUserPoolConfigArgs', 'GraphQLApiUserPoolConfigArgsDict']]] = None,
            visibility: Optional[pulumi.Input[_builtins.str]] = None,
            xray_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'GraphQLApi':
        """
        Get an existing GraphQLApi resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GraphQLApiAdditionalAuthenticationProviderArgs', 'GraphQLApiAdditionalAuthenticationProviderArgsDict']]]] additional_authentication_providers: One or more additional authentication providers for the GraphQL API. See `additional_authentication_provider` Block for details.
        :param pulumi.Input[_builtins.str] api_type: API type. Valid values are `GRAPHQL` or `MERGED`. A `MERGED` type requires `merged_api_execution_role_arn` to be set.
        :param pulumi.Input[_builtins.str] arn: ARN
        :param pulumi.Input[_builtins.str] authentication_type: Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        :param pulumi.Input[Union['GraphQLApiEnhancedMetricsConfigArgs', 'GraphQLApiEnhancedMetricsConfigArgsDict']] enhanced_metrics_config: Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
        :param pulumi.Input[_builtins.str] introspection_config: Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
        :param pulumi.Input[Union['GraphQLApiLambdaAuthorizerConfigArgs', 'GraphQLApiLambdaAuthorizerConfigArgsDict']] lambda_authorizer_config: Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        :param pulumi.Input[Union['GraphQLApiLogConfigArgs', 'GraphQLApiLogConfigArgsDict']] log_config: Nested argument containing logging configuration. See `log_config` Block for details.
        :param pulumi.Input[_builtins.str] merged_api_execution_role_arn: ARN of the execution role when `api_type` is set to `MERGED`.
        :param pulumi.Input[_builtins.str] name: User-supplied name for the GraphQL API.
               
               The following arguments are optional:
        :param pulumi.Input[Union['GraphQLApiOpenidConnectConfigArgs', 'GraphQLApiOpenidConnectConfigArgsDict']] openid_connect_config: Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        :param pulumi.Input[_builtins.int] query_depth_limit: The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.
               
               Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.int] resolver_count_limit: The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
        :param pulumi.Input[_builtins.str] schema: Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] uris: Map of URIs associated with the API E.g., `uris["GRAPHQL"] = https://ID.appsync-api.REGION.amazonaws.com/graphql`
        :param pulumi.Input[Union['GraphQLApiUserPoolConfigArgs', 'GraphQLApiUserPoolConfigArgsDict']] user_pool_config: Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        :param pulumi.Input[_builtins.str] visibility: Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
        :param pulumi.Input[_builtins.bool] xray_enabled: Whether tracing with X-ray is enabled. Defaults to false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GraphQLApiState.__new__(_GraphQLApiState)

        __props__.__dict__["additional_authentication_providers"] = additional_authentication_providers
        __props__.__dict__["api_type"] = api_type
        __props__.__dict__["arn"] = arn
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["enhanced_metrics_config"] = enhanced_metrics_config
        __props__.__dict__["introspection_config"] = introspection_config
        __props__.__dict__["lambda_authorizer_config"] = lambda_authorizer_config
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["merged_api_execution_role_arn"] = merged_api_execution_role_arn
        __props__.__dict__["name"] = name
        __props__.__dict__["openid_connect_config"] = openid_connect_config
        __props__.__dict__["query_depth_limit"] = query_depth_limit
        __props__.__dict__["region"] = region
        __props__.__dict__["resolver_count_limit"] = resolver_count_limit
        __props__.__dict__["schema"] = schema
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["uris"] = uris
        __props__.__dict__["user_pool_config"] = user_pool_config
        __props__.__dict__["visibility"] = visibility
        __props__.__dict__["xray_enabled"] = xray_enabled
        return GraphQLApi(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalAuthenticationProviders")
    def additional_authentication_providers(self) -> pulumi.Output[Optional[Sequence['outputs.GraphQLApiAdditionalAuthenticationProvider']]]:
        """
        One or more additional authentication providers for the GraphQL API. See `additional_authentication_provider` Block for details.
        """
        return pulumi.get(self, "additional_authentication_providers")

    @_builtins.property
    @pulumi.getter(name="apiType")
    def api_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        API type. Valid values are `GRAPHQL` or `MERGED`. A `MERGED` type requires `merged_api_execution_role_arn` to be set.
        """
        return pulumi.get(self, "api_type")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[_builtins.str]:
        """
        Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="enhancedMetricsConfig")
    def enhanced_metrics_config(self) -> pulumi.Output[Optional['outputs.GraphQLApiEnhancedMetricsConfig']]:
        """
        Enables and controls the enhanced metrics feature. See `enhanced_metrics_config` Block for details.
        """
        return pulumi.get(self, "enhanced_metrics_config")

    @_builtins.property
    @pulumi.getter(name="introspectionConfig")
    def introspection_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sets the value of the GraphQL API to enable (`ENABLED`) or disable (`DISABLED`) introspection. If no value is provided, the introspection configuration will be set to ENABLED by default. This field will produce an error if the operation attempts to use the introspection feature while this field is disabled. For more information about introspection, see [GraphQL introspection](https://graphql.org/learn/introspection/).
        """
        return pulumi.get(self, "introspection_config")

    @_builtins.property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> pulumi.Output[Optional['outputs.GraphQLApiLambdaAuthorizerConfig']]:
        """
        Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.GraphQLApiLogConfig']]:
        """
        Nested argument containing logging configuration. See `log_config` Block for details.
        """
        return pulumi.get(self, "log_config")

    @_builtins.property
    @pulumi.getter(name="mergedApiExecutionRoleArn")
    def merged_api_execution_role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ARN of the execution role when `api_type` is set to `MERGED`.
        """
        return pulumi.get(self, "merged_api_execution_role_arn")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        User-supplied name for the GraphQL API.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> pulumi.Output[Optional['outputs.GraphQLApiOpenidConnectConfig']]:
        """
        Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        """
        return pulumi.get(self, "openid_connect_config")

    @_builtins.property
    @pulumi.getter(name="queryDepthLimit")
    def query_depth_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum depth a query can have in a single request. Depth refers to the amount of nested levels allowed in the body of query. The default value is `0` (or unspecified), which indicates there's no depth limit. If you set a limit, it can be between `1` and `75` nested levels. This field will produce a limit error if the operation falls out of bounds.

        Note that fields can still be set to nullable or non-nullable. If a non-nullable field produces an error, the error will be thrown upwards to the first nullable field available.
        """
        return pulumi.get(self, "query_depth_limit")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resolverCountLimit")
    def resolver_count_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of resolvers that can be invoked in a single request. The default value is `0` (or unspecified), which will set the limit to `10000`. When specified, the limit value can be between `1` and `10000`. This field will produce a limit error if the operation falls out of bounds.
        """
        return pulumi.get(self, "resolver_count_limit")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Schema definition, in GraphQL schema language format. This provider cannot perform drift detection of this configuration.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def uris(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of URIs associated with the API E.g., `uris["GRAPHQL"] = https://ID.appsync-api.REGION.amazonaws.com/graphql`
        """
        return pulumi.get(self, "uris")

    @_builtins.property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> pulumi.Output[Optional['outputs.GraphQLApiUserPoolConfig']]:
        """
        Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
        return pulumi.get(self, "user_pool_config")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Sets the value of the GraphQL API to public (`GLOBAL`) or private (`PRIVATE`). If no value is provided, the visibility will be set to `GLOBAL` by default. This value cannot be changed once the API has been created.
        """
        return pulumi.get(self, "visibility")

    @_builtins.property
    @pulumi.getter(name="xrayEnabled")
    def xray_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether tracing with X-ray is enabled. Defaults to false.
        """
        return pulumi.get(self, "xray_enabled")

