# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApiEventConfig',
    'ApiEventConfigAuthProvider',
    'ApiEventConfigAuthProviderCognitoConfig',
    'ApiEventConfigAuthProviderLambdaAuthorizerConfig',
    'ApiEventConfigAuthProviderOpenidConnectConfig',
    'ApiEventConfigConnectionAuthMode',
    'ApiEventConfigDefaultPublishAuthMode',
    'ApiEventConfigDefaultSubscribeAuthMode',
    'ApiEventConfigLogConfig',
    'ChannelNamespaceHandlerConfigs',
    'ChannelNamespaceHandlerConfigsOnPublish',
    'ChannelNamespaceHandlerConfigsOnPublishIntegration',
    'ChannelNamespaceHandlerConfigsOnPublishIntegrationLambdaConfig',
    'ChannelNamespaceHandlerConfigsOnSubscribe',
    'ChannelNamespaceHandlerConfigsOnSubscribeIntegration',
    'ChannelNamespaceHandlerConfigsOnSubscribeIntegrationLambdaConfig',
    'ChannelNamespacePublishAuthMode',
    'ChannelNamespaceSubscribeAuthMode',
    'DataSourceDynamodbConfig',
    'DataSourceDynamodbConfigDeltaSyncConfig',
    'DataSourceElasticsearchConfig',
    'DataSourceEventBridgeConfig',
    'DataSourceHttpConfig',
    'DataSourceHttpConfigAuthorizationConfig',
    'DataSourceHttpConfigAuthorizationConfigAwsIamConfig',
    'DataSourceLambdaConfig',
    'DataSourceOpensearchserviceConfig',
    'DataSourceRelationalDatabaseConfig',
    'DataSourceRelationalDatabaseConfigHttpEndpointConfig',
    'FunctionRuntime',
    'FunctionSyncConfig',
    'FunctionSyncConfigLambdaConflictHandlerConfig',
    'GraphQLApiAdditionalAuthenticationProvider',
    'GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig',
    'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig',
    'GraphQLApiAdditionalAuthenticationProviderUserPoolConfig',
    'GraphQLApiEnhancedMetricsConfig',
    'GraphQLApiLambdaAuthorizerConfig',
    'GraphQLApiLogConfig',
    'GraphQLApiOpenidConnectConfig',
    'GraphQLApiUserPoolConfig',
    'ResolverCachingConfig',
    'ResolverPipelineConfig',
    'ResolverRuntime',
    'ResolverSyncConfig',
    'ResolverSyncConfigLambdaConflictHandlerConfig',
    'SourceApiAssociationSourceApiAssociationConfig',
    'SourceApiAssociationTimeouts',
]

@pulumi.output_type
class ApiEventConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authProviders":
            suggest = "auth_providers"
        elif key == "connectionAuthModes":
            suggest = "connection_auth_modes"
        elif key == "defaultPublishAuthModes":
            suggest = "default_publish_auth_modes"
        elif key == "defaultSubscribeAuthModes":
            suggest = "default_subscribe_auth_modes"
        elif key == "logConfig":
            suggest = "log_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_providers: Optional[Sequence['outputs.ApiEventConfigAuthProvider']] = None,
                 connection_auth_modes: Optional[Sequence['outputs.ApiEventConfigConnectionAuthMode']] = None,
                 default_publish_auth_modes: Optional[Sequence['outputs.ApiEventConfigDefaultPublishAuthMode']] = None,
                 default_subscribe_auth_modes: Optional[Sequence['outputs.ApiEventConfigDefaultSubscribeAuthMode']] = None,
                 log_config: Optional['outputs.ApiEventConfigLogConfig'] = None):
        """
        :param Sequence['ApiEventConfigAuthProviderArgs'] auth_providers: List of authentication providers. See Auth Providers below.
        :param Sequence['ApiEventConfigConnectionAuthModeArgs'] connection_auth_modes: List of authentication modes for connections. See Auth Modes below.
        :param Sequence['ApiEventConfigDefaultPublishAuthModeArgs'] default_publish_auth_modes: List of default authentication modes for publishing. See Auth Modes below.
        :param Sequence['ApiEventConfigDefaultSubscribeAuthModeArgs'] default_subscribe_auth_modes: List of default authentication modes for subscribing. See Auth Modes below.
        :param 'ApiEventConfigLogConfigArgs' log_config: Logging configuration. See Log Config below.
        """
        if auth_providers is not None:
            pulumi.set(__self__, "auth_providers", auth_providers)
        if connection_auth_modes is not None:
            pulumi.set(__self__, "connection_auth_modes", connection_auth_modes)
        if default_publish_auth_modes is not None:
            pulumi.set(__self__, "default_publish_auth_modes", default_publish_auth_modes)
        if default_subscribe_auth_modes is not None:
            pulumi.set(__self__, "default_subscribe_auth_modes", default_subscribe_auth_modes)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)

    @_builtins.property
    @pulumi.getter(name="authProviders")
    def auth_providers(self) -> Optional[Sequence['outputs.ApiEventConfigAuthProvider']]:
        """
        List of authentication providers. See Auth Providers below.
        """
        return pulumi.get(self, "auth_providers")

    @_builtins.property
    @pulumi.getter(name="connectionAuthModes")
    def connection_auth_modes(self) -> Optional[Sequence['outputs.ApiEventConfigConnectionAuthMode']]:
        """
        List of authentication modes for connections. See Auth Modes below.
        """
        return pulumi.get(self, "connection_auth_modes")

    @_builtins.property
    @pulumi.getter(name="defaultPublishAuthModes")
    def default_publish_auth_modes(self) -> Optional[Sequence['outputs.ApiEventConfigDefaultPublishAuthMode']]:
        """
        List of default authentication modes for publishing. See Auth Modes below.
        """
        return pulumi.get(self, "default_publish_auth_modes")

    @_builtins.property
    @pulumi.getter(name="defaultSubscribeAuthModes")
    def default_subscribe_auth_modes(self) -> Optional[Sequence['outputs.ApiEventConfigDefaultSubscribeAuthMode']]:
        """
        List of default authentication modes for subscribing. See Auth Modes below.
        """
        return pulumi.get(self, "default_subscribe_auth_modes")

    @_builtins.property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional['outputs.ApiEventConfigLogConfig']:
        """
        Logging configuration. See Log Config below.
        """
        return pulumi.get(self, "log_config")


@pulumi.output_type
class ApiEventConfigAuthProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "cognitoConfig":
            suggest = "cognito_config"
        elif key == "lambdaAuthorizerConfig":
            suggest = "lambda_authorizer_config"
        elif key == "openidConnectConfig":
            suggest = "openid_connect_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfigAuthProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfigAuthProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfigAuthProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str,
                 cognito_config: Optional['outputs.ApiEventConfigAuthProviderCognitoConfig'] = None,
                 lambda_authorizer_config: Optional['outputs.ApiEventConfigAuthProviderLambdaAuthorizerConfig'] = None,
                 openid_connect_config: Optional['outputs.ApiEventConfigAuthProviderOpenidConnectConfig'] = None):
        """
        :param _builtins.str auth_type: Type of authentication provider. Valid values: `AMAZON_COGNITO_USER_POOLS`, `AWS_LAMBDA`, `OPENID_CONNECT`, `API_KEY`.
        :param 'ApiEventConfigAuthProviderCognitoConfigArgs' cognito_config: Configuration for Cognito user pool authentication. Required when `auth_type` is `AMAZON_COGNITO_USER_POOLS`. See Cognito Config below.
        :param 'ApiEventConfigAuthProviderLambdaAuthorizerConfigArgs' lambda_authorizer_config: Configuration for Lambda authorization. Required when `auth_type` is `AWS_LAMBDA`. See Lambda Authorizer Config below.
        :param 'ApiEventConfigAuthProviderOpenidConnectConfigArgs' openid_connect_config: Configuration for OpenID Connect. Required when `auth_type` is `OPENID_CONNECT`. See OpenID Connect Config below.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        if cognito_config is not None:
            pulumi.set(__self__, "cognito_config", cognito_config)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if openid_connect_config is not None:
            pulumi.set(__self__, "openid_connect_config", openid_connect_config)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        Type of authentication provider. Valid values: `AMAZON_COGNITO_USER_POOLS`, `AWS_LAMBDA`, `OPENID_CONNECT`, `API_KEY`.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="cognitoConfig")
    def cognito_config(self) -> Optional['outputs.ApiEventConfigAuthProviderCognitoConfig']:
        """
        Configuration for Cognito user pool authentication. Required when `auth_type` is `AMAZON_COGNITO_USER_POOLS`. See Cognito Config below.
        """
        return pulumi.get(self, "cognito_config")

    @_builtins.property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional['outputs.ApiEventConfigAuthProviderLambdaAuthorizerConfig']:
        """
        Configuration for Lambda authorization. Required when `auth_type` is `AWS_LAMBDA`. See Lambda Authorizer Config below.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @_builtins.property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> Optional['outputs.ApiEventConfigAuthProviderOpenidConnectConfig']:
        """
        Configuration for OpenID Connect. Required when `auth_type` is `OPENID_CONNECT`. See OpenID Connect Config below.
        """
        return pulumi.get(self, "openid_connect_config")


@pulumi.output_type
class ApiEventConfigAuthProviderCognitoConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsRegion":
            suggest = "aws_region"
        elif key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfigAuthProviderCognitoConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfigAuthProviderCognitoConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfigAuthProviderCognitoConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_region: _builtins.str,
                 user_pool_id: _builtins.str,
                 app_id_client_regex: Optional[_builtins.str] = None):
        """
        :param _builtins.str aws_region: AWS region where the user pool is located.
        :param _builtins.str user_pool_id: ID of the Cognito user pool.
        :param _builtins.str app_id_client_regex: Regular expression for matching the client ID.
        """
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> _builtins.str:
        """
        AWS region where the user pool is located.
        """
        return pulumi.get(self, "aws_region")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> _builtins.str:
        """
        ID of the Cognito user pool.
        """
        return pulumi.get(self, "user_pool_id")

    @_builtins.property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[_builtins.str]:
        """
        Regular expression for matching the client ID.
        """
        return pulumi.get(self, "app_id_client_regex")


@pulumi.output_type
class ApiEventConfigAuthProviderLambdaAuthorizerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerUri":
            suggest = "authorizer_uri"
        elif key == "authorizerResultTtlInSeconds":
            suggest = "authorizer_result_ttl_in_seconds"
        elif key == "identityValidationExpression":
            suggest = "identity_validation_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfigAuthProviderLambdaAuthorizerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfigAuthProviderLambdaAuthorizerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfigAuthProviderLambdaAuthorizerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_uri: _builtins.str,
                 authorizer_result_ttl_in_seconds: Optional[_builtins.int] = None,
                 identity_validation_expression: Optional[_builtins.str] = None):
        """
        :param _builtins.str authorizer_uri: URI of the Lambda function for authorization.
        :param _builtins.int authorizer_result_ttl_in_seconds: TTL in seconds for the authorization result cache.
        :param _builtins.str identity_validation_expression: Regular expression for identity validation.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @_builtins.property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> _builtins.str:
        """
        URI of the Lambda function for authorization.
        """
        return pulumi.get(self, "authorizer_uri")

    @_builtins.property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[_builtins.int]:
        """
        TTL in seconds for the authorization result cache.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @_builtins.property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[_builtins.str]:
        """
        Regular expression for identity validation.
        """
        return pulumi.get(self, "identity_validation_expression")


@pulumi.output_type
class ApiEventConfigAuthProviderOpenidConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfigAuthProviderOpenidConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfigAuthProviderOpenidConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfigAuthProviderOpenidConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: _builtins.str,
                 auth_ttl: Optional[_builtins.int] = None,
                 client_id: Optional[_builtins.str] = None,
                 iat_ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.str issuer: Issuer URL for the OpenID Connect provider.
        :param _builtins.int auth_ttl: TTL in seconds for the authentication token.
        :param _builtins.str client_id: Client ID for the OpenID Connect provider.
        :param _builtins.int iat_ttl: TTL in seconds for the issued at time.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        Issuer URL for the OpenID Connect provider.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[_builtins.int]:
        """
        TTL in seconds for the authentication token.
        """
        return pulumi.get(self, "auth_ttl")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        Client ID for the OpenID Connect provider.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[_builtins.int]:
        """
        TTL in seconds for the issued at time.
        """
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class ApiEventConfigConnectionAuthMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfigConnectionAuthMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfigConnectionAuthMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfigConnectionAuthMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str):
        """
        :param _builtins.str auth_type: Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        pulumi.set(__self__, "auth_type", auth_type)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        return pulumi.get(self, "auth_type")


@pulumi.output_type
class ApiEventConfigDefaultPublishAuthMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfigDefaultPublishAuthMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfigDefaultPublishAuthMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfigDefaultPublishAuthMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str):
        """
        :param _builtins.str auth_type: Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        pulumi.set(__self__, "auth_type", auth_type)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        return pulumi.get(self, "auth_type")


@pulumi.output_type
class ApiEventConfigDefaultSubscribeAuthMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfigDefaultSubscribeAuthMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfigDefaultSubscribeAuthMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfigDefaultSubscribeAuthMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str):
        """
        :param _builtins.str auth_type: Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        pulumi.set(__self__, "auth_type", auth_type)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        return pulumi.get(self, "auth_type")


@pulumi.output_type
class ApiEventConfigLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogsRoleArn":
            suggest = "cloudwatch_logs_role_arn"
        elif key == "logLevel":
            suggest = "log_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiEventConfigLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiEventConfigLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiEventConfigLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs_role_arn: _builtins.str,
                 log_level: _builtins.str):
        """
        :param _builtins.str cloudwatch_logs_role_arn: ARN of the IAM role for CloudWatch logs.
        :param _builtins.str log_level: Log level. Valid values: `NONE`, `ERROR`, `ALL`, `INFO`, `DEBUG`.
        """
        pulumi.set(__self__, "cloudwatch_logs_role_arn", cloudwatch_logs_role_arn)
        pulumi.set(__self__, "log_level", log_level)

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogsRoleArn")
    def cloudwatch_logs_role_arn(self) -> _builtins.str:
        """
        ARN of the IAM role for CloudWatch logs.
        """
        return pulumi.get(self, "cloudwatch_logs_role_arn")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> _builtins.str:
        """
        Log level. Valid values: `NONE`, `ERROR`, `ALL`, `INFO`, `DEBUG`.
        """
        return pulumi.get(self, "log_level")


@pulumi.output_type
class ChannelNamespaceHandlerConfigs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onPublish":
            suggest = "on_publish"
        elif key == "onSubscribe":
            suggest = "on_subscribe"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceHandlerConfigs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceHandlerConfigs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceHandlerConfigs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_publish: Optional['outputs.ChannelNamespaceHandlerConfigsOnPublish'] = None,
                 on_subscribe: Optional['outputs.ChannelNamespaceHandlerConfigsOnSubscribe'] = None):
        """
        :param 'ChannelNamespaceHandlerConfigsOnPublishArgs' on_publish: Handler configuration. See Handler Config below.
        :param 'ChannelNamespaceHandlerConfigsOnSubscribeArgs' on_subscribe: Handler configuration. See Handler Config below.
        """
        if on_publish is not None:
            pulumi.set(__self__, "on_publish", on_publish)
        if on_subscribe is not None:
            pulumi.set(__self__, "on_subscribe", on_subscribe)

    @_builtins.property
    @pulumi.getter(name="onPublish")
    def on_publish(self) -> Optional['outputs.ChannelNamespaceHandlerConfigsOnPublish']:
        """
        Handler configuration. See Handler Config below.
        """
        return pulumi.get(self, "on_publish")

    @_builtins.property
    @pulumi.getter(name="onSubscribe")
    def on_subscribe(self) -> Optional['outputs.ChannelNamespaceHandlerConfigsOnSubscribe']:
        """
        Handler configuration. See Handler Config below.
        """
        return pulumi.get(self, "on_subscribe")


@pulumi.output_type
class ChannelNamespaceHandlerConfigsOnPublish(dict):
    def __init__(__self__, *,
                 behavior: _builtins.str,
                 integration: Optional['outputs.ChannelNamespaceHandlerConfigsOnPublishIntegration'] = None):
        """
        :param _builtins.str behavior: Behavior for the handler. Valid values: `CODE`, `DIRECT`.
        :param 'ChannelNamespaceHandlerConfigsOnPublishIntegrationArgs' integration: Integration data source configuration for the handler. See Integration below.
        """
        pulumi.set(__self__, "behavior", behavior)
        if integration is not None:
            pulumi.set(__self__, "integration", integration)

    @_builtins.property
    @pulumi.getter
    def behavior(self) -> _builtins.str:
        """
        Behavior for the handler. Valid values: `CODE`, `DIRECT`.
        """
        return pulumi.get(self, "behavior")

    @_builtins.property
    @pulumi.getter
    def integration(self) -> Optional['outputs.ChannelNamespaceHandlerConfigsOnPublishIntegration']:
        """
        Integration data source configuration for the handler. See Integration below.
        """
        return pulumi.get(self, "integration")


@pulumi.output_type
class ChannelNamespaceHandlerConfigsOnPublishIntegration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceName":
            suggest = "data_source_name"
        elif key == "lambdaConfig":
            suggest = "lambda_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceHandlerConfigsOnPublishIntegration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceHandlerConfigsOnPublishIntegration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceHandlerConfigsOnPublishIntegration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_name: _builtins.str,
                 lambda_config: Optional['outputs.ChannelNamespaceHandlerConfigsOnPublishIntegrationLambdaConfig'] = None):
        """
        :param _builtins.str data_source_name: Unique name of the data source that has been configured on the API.
        :param 'ChannelNamespaceHandlerConfigsOnPublishIntegrationLambdaConfigArgs' lambda_config: Configuration for a Lambda data source. See Lambda Config below.
        """
        pulumi.set(__self__, "data_source_name", data_source_name)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> _builtins.str:
        """
        Unique name of the data source that has been configured on the API.
        """
        return pulumi.get(self, "data_source_name")

    @_builtins.property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional['outputs.ChannelNamespaceHandlerConfigsOnPublishIntegrationLambdaConfig']:
        """
        Configuration for a Lambda data source. See Lambda Config below.
        """
        return pulumi.get(self, "lambda_config")


@pulumi.output_type
class ChannelNamespaceHandlerConfigsOnPublishIntegrationLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invokeType":
            suggest = "invoke_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceHandlerConfigsOnPublishIntegrationLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceHandlerConfigsOnPublishIntegrationLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceHandlerConfigsOnPublishIntegrationLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invoke_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str invoke_type: Invocation type for a Lambda data source. Valid values: `REQUEST_RESPONSE`, `EVENT`.
        """
        if invoke_type is not None:
            pulumi.set(__self__, "invoke_type", invoke_type)

    @_builtins.property
    @pulumi.getter(name="invokeType")
    def invoke_type(self) -> Optional[_builtins.str]:
        """
        Invocation type for a Lambda data source. Valid values: `REQUEST_RESPONSE`, `EVENT`.
        """
        return pulumi.get(self, "invoke_type")


@pulumi.output_type
class ChannelNamespaceHandlerConfigsOnSubscribe(dict):
    def __init__(__self__, *,
                 behavior: _builtins.str,
                 integration: Optional['outputs.ChannelNamespaceHandlerConfigsOnSubscribeIntegration'] = None):
        """
        :param _builtins.str behavior: Behavior for the handler. Valid values: `CODE`, `DIRECT`.
        :param 'ChannelNamespaceHandlerConfigsOnSubscribeIntegrationArgs' integration: Integration data source configuration for the handler. See Integration below.
        """
        pulumi.set(__self__, "behavior", behavior)
        if integration is not None:
            pulumi.set(__self__, "integration", integration)

    @_builtins.property
    @pulumi.getter
    def behavior(self) -> _builtins.str:
        """
        Behavior for the handler. Valid values: `CODE`, `DIRECT`.
        """
        return pulumi.get(self, "behavior")

    @_builtins.property
    @pulumi.getter
    def integration(self) -> Optional['outputs.ChannelNamespaceHandlerConfigsOnSubscribeIntegration']:
        """
        Integration data source configuration for the handler. See Integration below.
        """
        return pulumi.get(self, "integration")


@pulumi.output_type
class ChannelNamespaceHandlerConfigsOnSubscribeIntegration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceName":
            suggest = "data_source_name"
        elif key == "lambdaConfig":
            suggest = "lambda_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceHandlerConfigsOnSubscribeIntegration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceHandlerConfigsOnSubscribeIntegration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceHandlerConfigsOnSubscribeIntegration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_name: _builtins.str,
                 lambda_config: Optional['outputs.ChannelNamespaceHandlerConfigsOnSubscribeIntegrationLambdaConfig'] = None):
        """
        :param _builtins.str data_source_name: Unique name of the data source that has been configured on the API.
        :param 'ChannelNamespaceHandlerConfigsOnSubscribeIntegrationLambdaConfigArgs' lambda_config: Configuration for a Lambda data source. See Lambda Config below.
        """
        pulumi.set(__self__, "data_source_name", data_source_name)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)

    @_builtins.property
    @pulumi.getter(name="dataSourceName")
    def data_source_name(self) -> _builtins.str:
        """
        Unique name of the data source that has been configured on the API.
        """
        return pulumi.get(self, "data_source_name")

    @_builtins.property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional['outputs.ChannelNamespaceHandlerConfigsOnSubscribeIntegrationLambdaConfig']:
        """
        Configuration for a Lambda data source. See Lambda Config below.
        """
        return pulumi.get(self, "lambda_config")


@pulumi.output_type
class ChannelNamespaceHandlerConfigsOnSubscribeIntegrationLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invokeType":
            suggest = "invoke_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceHandlerConfigsOnSubscribeIntegrationLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceHandlerConfigsOnSubscribeIntegrationLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceHandlerConfigsOnSubscribeIntegrationLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 invoke_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str invoke_type: Invocation type for a Lambda data source. Valid values: `REQUEST_RESPONSE`, `EVENT`.
        """
        if invoke_type is not None:
            pulumi.set(__self__, "invoke_type", invoke_type)

    @_builtins.property
    @pulumi.getter(name="invokeType")
    def invoke_type(self) -> Optional[_builtins.str]:
        """
        Invocation type for a Lambda data source. Valid values: `REQUEST_RESPONSE`, `EVENT`.
        """
        return pulumi.get(self, "invoke_type")


@pulumi.output_type
class ChannelNamespacePublishAuthMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespacePublishAuthMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespacePublishAuthMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespacePublishAuthMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str):
        """
        :param _builtins.str auth_type: Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        pulumi.set(__self__, "auth_type", auth_type)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        return pulumi.get(self, "auth_type")


@pulumi.output_type
class ChannelNamespaceSubscribeAuthMode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelNamespaceSubscribeAuthMode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelNamespaceSubscribeAuthMode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelNamespaceSubscribeAuthMode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str):
        """
        :param _builtins.str auth_type: Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        pulumi.set(__self__, "auth_type", auth_type)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        Type of authentication. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`.
        """
        return pulumi.get(self, "auth_type")


@pulumi.output_type
class DataSourceDynamodbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableName":
            suggest = "table_name"
        elif key == "deltaSyncConfig":
            suggest = "delta_sync_config"
        elif key == "useCallerCredentials":
            suggest = "use_caller_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDynamodbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDynamodbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDynamodbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 table_name: _builtins.str,
                 delta_sync_config: Optional['outputs.DataSourceDynamodbConfigDeltaSyncConfig'] = None,
                 region: Optional[_builtins.str] = None,
                 use_caller_credentials: Optional[_builtins.bool] = None,
                 versioned: Optional[_builtins.bool] = None):
        """
        :param _builtins.str table_name: Name of the DynamoDB table.
        :param 'DataSourceDynamodbConfigDeltaSyncConfigArgs' delta_sync_config: The DeltaSyncConfig for a versioned data source. See `delta_sync_config` Block for details.
        :param _builtins.str region: AWS region of the DynamoDB table. Defaults to current region.
        :param _builtins.bool use_caller_credentials: Set to `true` to use Amazon Cognito credentials with this data source.
        :param _builtins.bool versioned: Detects Conflict Detection and Resolution with this data source.
        """
        pulumi.set(__self__, "table_name", table_name)
        if delta_sync_config is not None:
            pulumi.set(__self__, "delta_sync_config", delta_sync_config)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if use_caller_credentials is not None:
            pulumi.set(__self__, "use_caller_credentials", use_caller_credentials)
        if versioned is not None:
            pulumi.set(__self__, "versioned", versioned)

    @_builtins.property
    @pulumi.getter(name="tableName")
    def table_name(self) -> _builtins.str:
        """
        Name of the DynamoDB table.
        """
        return pulumi.get(self, "table_name")

    @_builtins.property
    @pulumi.getter(name="deltaSyncConfig")
    def delta_sync_config(self) -> Optional['outputs.DataSourceDynamodbConfigDeltaSyncConfig']:
        """
        The DeltaSyncConfig for a versioned data source. See `delta_sync_config` Block for details.
        """
        return pulumi.get(self, "delta_sync_config")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        AWS region of the DynamoDB table. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="useCallerCredentials")
    def use_caller_credentials(self) -> Optional[_builtins.bool]:
        """
        Set to `true` to use Amazon Cognito credentials with this data source.
        """
        return pulumi.get(self, "use_caller_credentials")

    @_builtins.property
    @pulumi.getter
    def versioned(self) -> Optional[_builtins.bool]:
        """
        Detects Conflict Detection and Resolution with this data source.
        """
        return pulumi.get(self, "versioned")


@pulumi.output_type
class DataSourceDynamodbConfigDeltaSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deltaSyncTableName":
            suggest = "delta_sync_table_name"
        elif key == "baseTableTtl":
            suggest = "base_table_ttl"
        elif key == "deltaSyncTableTtl":
            suggest = "delta_sync_table_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceDynamodbConfigDeltaSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceDynamodbConfigDeltaSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceDynamodbConfigDeltaSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delta_sync_table_name: _builtins.str,
                 base_table_ttl: Optional[_builtins.int] = None,
                 delta_sync_table_ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.str delta_sync_table_name: The table name.
        :param _builtins.int base_table_ttl: The number of minutes that an Item is stored in the data source.
        :param _builtins.int delta_sync_table_ttl: The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        pulumi.set(__self__, "delta_sync_table_name", delta_sync_table_name)
        if base_table_ttl is not None:
            pulumi.set(__self__, "base_table_ttl", base_table_ttl)
        if delta_sync_table_ttl is not None:
            pulumi.set(__self__, "delta_sync_table_ttl", delta_sync_table_ttl)

    @_builtins.property
    @pulumi.getter(name="deltaSyncTableName")
    def delta_sync_table_name(self) -> _builtins.str:
        """
        The table name.
        """
        return pulumi.get(self, "delta_sync_table_name")

    @_builtins.property
    @pulumi.getter(name="baseTableTtl")
    def base_table_ttl(self) -> Optional[_builtins.int]:
        """
        The number of minutes that an Item is stored in the data source.
        """
        return pulumi.get(self, "base_table_ttl")

    @_builtins.property
    @pulumi.getter(name="deltaSyncTableTtl")
    def delta_sync_table_ttl(self) -> Optional[_builtins.int]:
        """
        The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
        """
        return pulumi.get(self, "delta_sync_table_ttl")


@pulumi.output_type
class DataSourceElasticsearchConfig(dict):
    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint: HTTP endpoint of the Elasticsearch domain.
        :param _builtins.str region: AWS region of Elasticsearch domain. Defaults to current region.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        HTTP endpoint of the Elasticsearch domain.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        AWS region of Elasticsearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class DataSourceEventBridgeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBusArn":
            suggest = "event_bus_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceEventBridgeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceEventBridgeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceEventBridgeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bus_arn: _builtins.str):
        """
        :param _builtins.str event_bus_arn: ARN for the EventBridge bus.
        """
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @_builtins.property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> _builtins.str:
        """
        ARN for the EventBridge bus.
        """
        return pulumi.get(self, "event_bus_arn")


@pulumi.output_type
class DataSourceHttpConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationConfig":
            suggest = "authorization_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 authorization_config: Optional['outputs.DataSourceHttpConfigAuthorizationConfig'] = None):
        """
        :param _builtins.str endpoint: HTTP URL.
        :param 'DataSourceHttpConfigAuthorizationConfigArgs' authorization_config: Authorization configuration in case the HTTP endpoint requires authorization. See `authorization_config` Block for details.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if authorization_config is not None:
            pulumi.set(__self__, "authorization_config", authorization_config)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        HTTP URL.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="authorizationConfig")
    def authorization_config(self) -> Optional['outputs.DataSourceHttpConfigAuthorizationConfig']:
        """
        Authorization configuration in case the HTTP endpoint requires authorization. See `authorization_config` Block for details.
        """
        return pulumi.get(self, "authorization_config")


@pulumi.output_type
class DataSourceHttpConfigAuthorizationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationType":
            suggest = "authorization_type"
        elif key == "awsIamConfig":
            suggest = "aws_iam_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfigAuthorizationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfigAuthorizationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfigAuthorizationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_type: Optional[_builtins.str] = None,
                 aws_iam_config: Optional['outputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfig'] = None):
        """
        :param _builtins.str authorization_type: Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
        :param 'DataSourceHttpConfigAuthorizationConfigAwsIamConfigArgs' aws_iam_config: Identity and Access Management (IAM) settings. See `aws_iam_config` Block for details.
        """
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if aws_iam_config is not None:
            pulumi.set(__self__, "aws_iam_config", aws_iam_config)

    @_builtins.property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[_builtins.str]:
        """
        Authorization type that the HTTP endpoint requires. Default values is `AWS_IAM`.
        """
        return pulumi.get(self, "authorization_type")

    @_builtins.property
    @pulumi.getter(name="awsIamConfig")
    def aws_iam_config(self) -> Optional['outputs.DataSourceHttpConfigAuthorizationConfigAwsIamConfig']:
        """
        Identity and Access Management (IAM) settings. See `aws_iam_config` Block for details.
        """
        return pulumi.get(self, "aws_iam_config")


@pulumi.output_type
class DataSourceHttpConfigAuthorizationConfigAwsIamConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signingRegion":
            suggest = "signing_region"
        elif key == "signingServiceName":
            suggest = "signing_service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceHttpConfigAuthorizationConfigAwsIamConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceHttpConfigAuthorizationConfigAwsIamConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceHttpConfigAuthorizationConfigAwsIamConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signing_region: Optional[_builtins.str] = None,
                 signing_service_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str signing_region: Signing Amazon Web Services Region for IAM authorization.
        :param _builtins.str signing_service_name: Signing service name for IAM authorization.
        """
        if signing_region is not None:
            pulumi.set(__self__, "signing_region", signing_region)
        if signing_service_name is not None:
            pulumi.set(__self__, "signing_service_name", signing_service_name)

    @_builtins.property
    @pulumi.getter(name="signingRegion")
    def signing_region(self) -> Optional[_builtins.str]:
        """
        Signing Amazon Web Services Region for IAM authorization.
        """
        return pulumi.get(self, "signing_region")

    @_builtins.property
    @pulumi.getter(name="signingServiceName")
    def signing_service_name(self) -> Optional[_builtins.str]:
        """
        Signing service name for IAM authorization.
        """
        return pulumi.get(self, "signing_service_name")


@pulumi.output_type
class DataSourceLambdaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionArn":
            suggest = "function_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceLambdaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceLambdaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_arn: _builtins.str):
        """
        :param _builtins.str function_arn: ARN for the Lambda function.
        """
        pulumi.set(__self__, "function_arn", function_arn)

    @_builtins.property
    @pulumi.getter(name="functionArn")
    def function_arn(self) -> _builtins.str:
        """
        ARN for the Lambda function.
        """
        return pulumi.get(self, "function_arn")


@pulumi.output_type
class DataSourceOpensearchserviceConfig(dict):
    def __init__(__self__, *,
                 endpoint: _builtins.str,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint: HTTP endpoint of the OpenSearch domain.
        :param _builtins.str region: AWS region of the OpenSearch domain. Defaults to current region.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> _builtins.str:
        """
        HTTP endpoint of the OpenSearch domain.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        AWS region of the OpenSearch domain. Defaults to current region.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class DataSourceRelationalDatabaseConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpEndpointConfig":
            suggest = "http_endpoint_config"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRelationalDatabaseConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRelationalDatabaseConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRelationalDatabaseConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_endpoint_config: Optional['outputs.DataSourceRelationalDatabaseConfigHttpEndpointConfig'] = None,
                 source_type: Optional[_builtins.str] = None):
        """
        :param 'DataSourceRelationalDatabaseConfigHttpEndpointConfigArgs' http_endpoint_config: Amazon RDS HTTP endpoint configuration. See `http_endpoint_config` Block for details.
        :param _builtins.str source_type: Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
        """
        if http_endpoint_config is not None:
            pulumi.set(__self__, "http_endpoint_config", http_endpoint_config)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)

    @_builtins.property
    @pulumi.getter(name="httpEndpointConfig")
    def http_endpoint_config(self) -> Optional['outputs.DataSourceRelationalDatabaseConfigHttpEndpointConfig']:
        """
        Amazon RDS HTTP endpoint configuration. See `http_endpoint_config` Block for details.
        """
        return pulumi.get(self, "http_endpoint_config")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[_builtins.str]:
        """
        Source type for the relational database. Valid values: `RDS_HTTP_ENDPOINT`.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class DataSourceRelationalDatabaseConfigHttpEndpointConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsSecretStoreArn":
            suggest = "aws_secret_store_arn"
        elif key == "dbClusterIdentifier":
            suggest = "db_cluster_identifier"
        elif key == "databaseName":
            suggest = "database_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataSourceRelationalDatabaseConfigHttpEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataSourceRelationalDatabaseConfigHttpEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataSourceRelationalDatabaseConfigHttpEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_secret_store_arn: _builtins.str,
                 db_cluster_identifier: _builtins.str,
                 database_name: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 schema: Optional[_builtins.str] = None):
        """
        :param _builtins.str aws_secret_store_arn: AWS secret store ARN for database credentials.
        :param _builtins.str db_cluster_identifier: Amazon RDS cluster identifier.
        :param _builtins.str database_name: Logical database name.
        :param _builtins.str region: AWS Region for RDS HTTP endpoint. Defaults to current region.
        :param _builtins.str schema: Logical schema name.
        """
        pulumi.set(__self__, "aws_secret_store_arn", aws_secret_store_arn)
        pulumi.set(__self__, "db_cluster_identifier", db_cluster_identifier)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter(name="awsSecretStoreArn")
    def aws_secret_store_arn(self) -> _builtins.str:
        """
        AWS secret store ARN for database credentials.
        """
        return pulumi.get(self, "aws_secret_store_arn")

    @_builtins.property
    @pulumi.getter(name="dbClusterIdentifier")
    def db_cluster_identifier(self) -> _builtins.str:
        """
        Amazon RDS cluster identifier.
        """
        return pulumi.get(self, "db_cluster_identifier")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[_builtins.str]:
        """
        Logical database name.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        AWS Region for RDS HTTP endpoint. Defaults to current region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[_builtins.str]:
        """
        Logical schema name.
        """
        return pulumi.get(self, "schema")


@pulumi.output_type
class FunctionRuntime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionRuntime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionRuntime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionRuntime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 runtime_version: _builtins.str):
        """
        :param _builtins.str name: The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        :param _builtins.str runtime_version: The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> _builtins.str:
        """
        The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class FunctionSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: Optional[_builtins.str] = None,
                 conflict_handler: Optional[_builtins.str] = None,
                 lambda_conflict_handler_config: Optional['outputs.FunctionSyncConfigLambdaConflictHandlerConfig'] = None):
        """
        :param _builtins.str conflict_detection: Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        :param _builtins.str conflict_handler: Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        :param 'FunctionSyncConfigLambdaConflictHandlerConfigArgs' lambda_conflict_handler_config: Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See `lambda_conflict_handler_config` Block for details.
        """
        if conflict_detection is not None:
            pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @_builtins.property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> Optional[_builtins.str]:
        """
        Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        return pulumi.get(self, "conflict_detection")

    @_builtins.property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[_builtins.str]:
        """
        Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        return pulumi.get(self, "conflict_handler")

    @_builtins.property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.FunctionSyncConfigLambdaConflictHandlerConfig']:
        """
        Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See `lambda_conflict_handler_config` Block for details.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class FunctionSyncConfigLambdaConflictHandlerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionSyncConfigLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str lambda_conflict_handler_arn: ARN for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @_builtins.property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[_builtins.str]:
        """
        ARN for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProvider(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationType":
            suggest = "authentication_type"
        elif key == "lambdaAuthorizerConfig":
            suggest = "lambda_authorizer_config"
        elif key == "openidConnectConfig":
            suggest = "openid_connect_config"
        elif key == "userPoolConfig":
            suggest = "user_pool_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_type: _builtins.str,
                 lambda_authorizer_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig'] = None,
                 openid_connect_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig'] = None,
                 user_pool_config: Optional['outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig'] = None):
        """
        :param _builtins.str authentication_type: Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        :param 'GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfigArgs' lambda_authorizer_config: Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        :param 'GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfigArgs' openid_connect_config: Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        :param 'GraphQLApiAdditionalAuthenticationProviderUserPoolConfigArgs' user_pool_config: Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if lambda_authorizer_config is not None:
            pulumi.set(__self__, "lambda_authorizer_config", lambda_authorizer_config)
        if openid_connect_config is not None:
            pulumi.set(__self__, "openid_connect_config", openid_connect_config)
        if user_pool_config is not None:
            pulumi.set(__self__, "user_pool_config", user_pool_config)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> _builtins.str:
        """
        Authentication type. Valid values: `API_KEY`, `AWS_IAM`, `AMAZON_COGNITO_USER_POOLS`, `OPENID_CONNECT`, `AWS_LAMBDA`
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="lambdaAuthorizerConfig")
    def lambda_authorizer_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig']:
        """
        Nested argument containing Lambda authorizer configuration. See `lambda_authorizer_config` Block for details.
        """
        return pulumi.get(self, "lambda_authorizer_config")

    @_builtins.property
    @pulumi.getter(name="openidConnectConfig")
    def openid_connect_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig']:
        """
        Nested argument containing OpenID Connect configuration. See `openid_connect_config` Block for details.
        """
        return pulumi.get(self, "openid_connect_config")

    @_builtins.property
    @pulumi.getter(name="userPoolConfig")
    def user_pool_config(self) -> Optional['outputs.GraphQLApiAdditionalAuthenticationProviderUserPoolConfig']:
        """
        Amazon Cognito User Pool configuration. See `user_pool_config` Block for details.
        """
        return pulumi.get(self, "user_pool_config")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerUri":
            suggest = "authorizer_uri"
        elif key == "authorizerResultTtlInSeconds":
            suggest = "authorizer_result_ttl_in_seconds"
        elif key == "identityValidationExpression":
            suggest = "identity_validation_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderLambdaAuthorizerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_uri: _builtins.str,
                 authorizer_result_ttl_in_seconds: Optional[_builtins.int] = None,
                 identity_validation_expression: Optional[_builtins.str] = None):
        """
        :param _builtins.str authorizer_uri: ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        :param _builtins.int authorizer_result_ttl_in_seconds: Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        :param _builtins.str identity_validation_expression: Regular expression for validation of tokens before the Lambda function is called.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @_builtins.property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> _builtins.str:
        """
        ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        return pulumi.get(self, "authorizer_uri")

    @_builtins.property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @_builtins.property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[_builtins.str]:
        """
        Regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderOpenidConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: _builtins.str,
                 auth_ttl: Optional[_builtins.int] = None,
                 client_id: Optional[_builtins.str] = None,
                 iat_ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.str issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param _builtins.int auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param _builtins.str client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param _builtins.int iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[_builtins.int]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[_builtins.int]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class GraphQLApiAdditionalAuthenticationProviderUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiAdditionalAuthenticationProviderUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiAdditionalAuthenticationProviderUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiAdditionalAuthenticationProviderUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_pool_id: _builtins.str,
                 app_id_client_regex: Optional[_builtins.str] = None,
                 aws_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str user_pool_id: User pool ID.
        :param _builtins.str app_id_client_regex: Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param _builtins.str aws_region: AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> _builtins.str:
        """
        User pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @_builtins.property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[_builtins.str]:
        """
        Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[_builtins.str]:
        """
        AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")


@pulumi.output_type
class GraphQLApiEnhancedMetricsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataSourceLevelMetricsBehavior":
            suggest = "data_source_level_metrics_behavior"
        elif key == "operationLevelMetricsConfig":
            suggest = "operation_level_metrics_config"
        elif key == "resolverLevelMetricsBehavior":
            suggest = "resolver_level_metrics_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiEnhancedMetricsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiEnhancedMetricsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiEnhancedMetricsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_source_level_metrics_behavior: _builtins.str,
                 operation_level_metrics_config: _builtins.str,
                 resolver_level_metrics_behavior: _builtins.str):
        """
        :param _builtins.str data_source_level_metrics_behavior: How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
        :param _builtins.str operation_level_metrics_config: How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
        :param _builtins.str resolver_level_metrics_behavior: How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
        """
        pulumi.set(__self__, "data_source_level_metrics_behavior", data_source_level_metrics_behavior)
        pulumi.set(__self__, "operation_level_metrics_config", operation_level_metrics_config)
        pulumi.set(__self__, "resolver_level_metrics_behavior", resolver_level_metrics_behavior)

    @_builtins.property
    @pulumi.getter(name="dataSourceLevelMetricsBehavior")
    def data_source_level_metrics_behavior(self) -> _builtins.str:
        """
        How data source metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_DATA_SOURCE_METRICS`, `PER_DATA_SOURCE_METRICS`
        """
        return pulumi.get(self, "data_source_level_metrics_behavior")

    @_builtins.property
    @pulumi.getter(name="operationLevelMetricsConfig")
    def operation_level_metrics_config(self) -> _builtins.str:
        """
        How operation metrics will be emitted to CloudWatch. Valid values: `ENABLED`, `DISABLED`
        """
        return pulumi.get(self, "operation_level_metrics_config")

    @_builtins.property
    @pulumi.getter(name="resolverLevelMetricsBehavior")
    def resolver_level_metrics_behavior(self) -> _builtins.str:
        """
        How resolver metrics will be emitted to CloudWatch. Valid values: `FULL_REQUEST_RESOLVER_METRICS`, `PER_RESOLVER_METRICS`
        """
        return pulumi.get(self, "resolver_level_metrics_behavior")


@pulumi.output_type
class GraphQLApiLambdaAuthorizerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizerUri":
            suggest = "authorizer_uri"
        elif key == "authorizerResultTtlInSeconds":
            suggest = "authorizer_result_ttl_in_seconds"
        elif key == "identityValidationExpression":
            suggest = "identity_validation_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiLambdaAuthorizerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiLambdaAuthorizerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiLambdaAuthorizerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorizer_uri: _builtins.str,
                 authorizer_result_ttl_in_seconds: Optional[_builtins.int] = None,
                 identity_validation_expression: Optional[_builtins.str] = None):
        """
        :param _builtins.str authorizer_uri: ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        :param _builtins.int authorizer_result_ttl_in_seconds: Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        :param _builtins.str identity_validation_expression: Regular expression for validation of tokens before the Lambda function is called.
        """
        pulumi.set(__self__, "authorizer_uri", authorizer_uri)
        if authorizer_result_ttl_in_seconds is not None:
            pulumi.set(__self__, "authorizer_result_ttl_in_seconds", authorizer_result_ttl_in_seconds)
        if identity_validation_expression is not None:
            pulumi.set(__self__, "identity_validation_expression", identity_validation_expression)

    @_builtins.property
    @pulumi.getter(name="authorizerUri")
    def authorizer_uri(self) -> _builtins.str:
        """
        ARN of the Lambda function to be called for authorization. Note: This Lambda function must have a resource-based policy assigned to it, to allow `lambda:InvokeFunction` from service principal `appsync.amazonaws.com`.
        """
        return pulumi.get(self, "authorizer_uri")

    @_builtins.property
    @pulumi.getter(name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds a response should be cached for. The default is 5 minutes (300 seconds). The Lambda function can override this by returning a `ttlOverride` key in its response. A value of 0 disables caching of responses. Minimum value of 0. Maximum value of 3600.
        """
        return pulumi.get(self, "authorizer_result_ttl_in_seconds")

    @_builtins.property
    @pulumi.getter(name="identityValidationExpression")
    def identity_validation_expression(self) -> Optional[_builtins.str]:
        """
        Regular expression for validation of tokens before the Lambda function is called.
        """
        return pulumi.get(self, "identity_validation_expression")


@pulumi.output_type
class GraphQLApiLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudwatchLogsRoleArn":
            suggest = "cloudwatch_logs_role_arn"
        elif key == "fieldLogLevel":
            suggest = "field_log_level"
        elif key == "excludeVerboseContent":
            suggest = "exclude_verbose_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloudwatch_logs_role_arn: _builtins.str,
                 field_log_level: _builtins.str,
                 exclude_verbose_content: Optional[_builtins.bool] = None):
        """
        :param _builtins.str cloudwatch_logs_role_arn: Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        :param _builtins.str field_log_level: Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        :param _builtins.bool exclude_verbose_content: Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        pulumi.set(__self__, "cloudwatch_logs_role_arn", cloudwatch_logs_role_arn)
        pulumi.set(__self__, "field_log_level", field_log_level)
        if exclude_verbose_content is not None:
            pulumi.set(__self__, "exclude_verbose_content", exclude_verbose_content)

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogsRoleArn")
    def cloudwatch_logs_role_arn(self) -> _builtins.str:
        """
        Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
        """
        return pulumi.get(self, "cloudwatch_logs_role_arn")

    @_builtins.property
    @pulumi.getter(name="fieldLogLevel")
    def field_log_level(self) -> _builtins.str:
        """
        Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
        """
        return pulumi.get(self, "field_log_level")

    @_builtins.property
    @pulumi.getter(name="excludeVerboseContent")
    def exclude_verbose_content(self) -> Optional[_builtins.bool]:
        """
        Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
        """
        return pulumi.get(self, "exclude_verbose_content")


@pulumi.output_type
class GraphQLApiOpenidConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authTtl":
            suggest = "auth_ttl"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "iatTtl":
            suggest = "iat_ttl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiOpenidConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiOpenidConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiOpenidConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issuer: _builtins.str,
                 auth_ttl: Optional[_builtins.int] = None,
                 client_id: Optional[_builtins.str] = None,
                 iat_ttl: Optional[_builtins.int] = None):
        """
        :param _builtins.str issuer: Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        :param _builtins.int auth_ttl: Number of milliseconds a token is valid after being authenticated.
        :param _builtins.str client_id: Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        :param _builtins.int iat_ttl: Number of milliseconds a token is valid after being issued to a user.
        """
        pulumi.set(__self__, "issuer", issuer)
        if auth_ttl is not None:
            pulumi.set(__self__, "auth_ttl", auth_ttl)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if iat_ttl is not None:
            pulumi.set(__self__, "iat_ttl", iat_ttl)

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        Issuer for the OpenID Connect configuration. The issuer returned by discovery MUST exactly match the value of iss in the ID Token.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter(name="authTtl")
    def auth_ttl(self) -> Optional[_builtins.int]:
        """
        Number of milliseconds a token is valid after being authenticated.
        """
        return pulumi.get(self, "auth_ttl")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        Client identifier of the Relying party at the OpenID identity provider. This identifier is typically obtained when the Relying party is registered with the OpenID identity provider. You can specify a regular expression so the AWS AppSync can validate against multiple client identifiers at a time.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="iatTtl")
    def iat_ttl(self) -> Optional[_builtins.int]:
        """
        Number of milliseconds a token is valid after being issued to a user.
        """
        return pulumi.get(self, "iat_ttl")


@pulumi.output_type
class GraphQLApiUserPoolConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "userPoolId":
            suggest = "user_pool_id"
        elif key == "appIdClientRegex":
            suggest = "app_id_client_regex"
        elif key == "awsRegion":
            suggest = "aws_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GraphQLApiUserPoolConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GraphQLApiUserPoolConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GraphQLApiUserPoolConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: _builtins.str,
                 user_pool_id: _builtins.str,
                 app_id_client_regex: Optional[_builtins.str] = None,
                 aws_region: Optional[_builtins.str] = None):
        """
        :param _builtins.str default_action: Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        :param _builtins.str user_pool_id: User pool ID.
        :param _builtins.str app_id_client_regex: Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        :param _builtins.str aws_region: AWS region in which the user pool was created.
        """
        pulumi.set(__self__, "default_action", default_action)
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if app_id_client_regex is not None:
            pulumi.set(__self__, "app_id_client_regex", app_id_client_regex)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> _builtins.str:
        """
        Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> _builtins.str:
        """
        User pool ID.
        """
        return pulumi.get(self, "user_pool_id")

    @_builtins.property
    @pulumi.getter(name="appIdClientRegex")
    def app_id_client_regex(self) -> Optional[_builtins.str]:
        """
        Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
        """
        return pulumi.get(self, "app_id_client_regex")

    @_builtins.property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[_builtins.str]:
        """
        AWS region in which the user pool was created.
        """
        return pulumi.get(self, "aws_region")


@pulumi.output_type
class ResolverCachingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cachingKeys":
            suggest = "caching_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverCachingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverCachingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching_keys: Optional[Sequence[_builtins.str]] = None,
                 ttl: Optional[_builtins.int] = None):
        """
        :param Sequence[_builtins.str] caching_keys: The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
        :param _builtins.int ttl: The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
        """
        if caching_keys is not None:
            pulumi.set(__self__, "caching_keys", caching_keys)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @_builtins.property
    @pulumi.getter(name="cachingKeys")
    def caching_keys(self) -> Optional[Sequence[_builtins.str]]:
        """
        The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
        """
        return pulumi.get(self, "caching_keys")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[_builtins.int]:
        """
        The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class ResolverPipelineConfig(dict):
    def __init__(__self__, *,
                 functions: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] functions: A list of Function objects.
        """
        if functions is not None:
            pulumi.set(__self__, "functions", functions)

    @_builtins.property
    @pulumi.getter
    def functions(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Function objects.
        """
        return pulumi.get(self, "functions")


@pulumi.output_type
class ResolverRuntime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverRuntime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverRuntime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverRuntime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 runtime_version: _builtins.str):
        """
        :param _builtins.str name: The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        :param _builtins.str runtime_version: The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime_version", runtime_version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the runtime to use. Currently, the only allowed value is `APPSYNC_JS`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> _builtins.str:
        """
        The version of the runtime to use. Currently, the only allowed version is `1.0.0`.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class ResolverSyncConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "conflictDetection":
            suggest = "conflict_detection"
        elif key == "conflictHandler":
            suggest = "conflict_handler"
        elif key == "lambdaConflictHandlerConfig":
            suggest = "lambda_conflict_handler_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverSyncConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverSyncConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 conflict_detection: Optional[_builtins.str] = None,
                 conflict_handler: Optional[_builtins.str] = None,
                 lambda_conflict_handler_config: Optional['outputs.ResolverSyncConfigLambdaConflictHandlerConfig'] = None):
        """
        :param _builtins.str conflict_detection: Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        :param _builtins.str conflict_handler: Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        :param 'ResolverSyncConfigLambdaConflictHandlerConfigArgs' lambda_conflict_handler_config: Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        if conflict_detection is not None:
            pulumi.set(__self__, "conflict_detection", conflict_detection)
        if conflict_handler is not None:
            pulumi.set(__self__, "conflict_handler", conflict_handler)
        if lambda_conflict_handler_config is not None:
            pulumi.set(__self__, "lambda_conflict_handler_config", lambda_conflict_handler_config)

    @_builtins.property
    @pulumi.getter(name="conflictDetection")
    def conflict_detection(self) -> Optional[_builtins.str]:
        """
        Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
        """
        return pulumi.get(self, "conflict_detection")

    @_builtins.property
    @pulumi.getter(name="conflictHandler")
    def conflict_handler(self) -> Optional[_builtins.str]:
        """
        Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
        """
        return pulumi.get(self, "conflict_handler")

    @_builtins.property
    @pulumi.getter(name="lambdaConflictHandlerConfig")
    def lambda_conflict_handler_config(self) -> Optional['outputs.ResolverSyncConfigLambdaConflictHandlerConfig']:
        """
        Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
        """
        return pulumi.get(self, "lambda_conflict_handler_config")


@pulumi.output_type
class ResolverSyncConfigLambdaConflictHandlerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lambdaConflictHandlerArn":
            suggest = "lambda_conflict_handler_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResolverSyncConfigLambdaConflictHandlerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResolverSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResolverSyncConfigLambdaConflictHandlerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lambda_conflict_handler_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str lambda_conflict_handler_arn: ARN for the Lambda function to use as the Conflict Handler.
        """
        if lambda_conflict_handler_arn is not None:
            pulumi.set(__self__, "lambda_conflict_handler_arn", lambda_conflict_handler_arn)

    @_builtins.property
    @pulumi.getter(name="lambdaConflictHandlerArn")
    def lambda_conflict_handler_arn(self) -> Optional[_builtins.str]:
        """
        ARN for the Lambda function to use as the Conflict Handler.
        """
        return pulumi.get(self, "lambda_conflict_handler_arn")


@pulumi.output_type
class SourceApiAssociationSourceApiAssociationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mergeType":
            suggest = "merge_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceApiAssociationSourceApiAssociationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceApiAssociationSourceApiAssociationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceApiAssociationSourceApiAssociationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 merge_type: _builtins.str):
        """
        :param _builtins.str merge_type: Merge type. Valid values: `MANUAL_MERGE`, `AUTO_MERGE`
        """
        pulumi.set(__self__, "merge_type", merge_type)

    @_builtins.property
    @pulumi.getter(name="mergeType")
    def merge_type(self) -> _builtins.str:
        """
        Merge type. Valid values: `MANUAL_MERGE`, `AUTO_MERGE`
        """
        return pulumi.get(self, "merge_type")


@pulumi.output_type
class SourceApiAssociationTimeouts(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.str] = None,
                 delete: Optional[_builtins.str] = None,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str create: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        :param _builtins.str delete: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        :param _builtins.str update: A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours). Setting a timeout for a Delete operation is only applicable if changes are saved into state before the destroy operation occurs.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
        """
        return pulumi.get(self, "update")


