# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAmiIdsResult',
    'AwaitableGetAmiIdsResult',
    'get_ami_ids',
    'get_ami_ids_output',
]

@pulumi.output_type
class GetAmiIdsResult:
    """
    A collection of values returned by getAmiIds.
    """
    def __init__(__self__, arns=None, filters=None, id=None, names=None, region=None):
        if arns and not isinstance(arns, list):
            raise TypeError("Expected argument 'arns' to be a list")
        pulumi.set(__self__, "arns", arns)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arns(self) -> Sequence[_builtins.str]:
        """
        List of the Autoscaling Groups Arns in the current region.
        """
        return pulumi.get(self, "arns")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAmiIdsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def names(self) -> Sequence[_builtins.str]:
        """
        List of the Autoscaling Groups in the current region.
        """
        return pulumi.get(self, "names")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetAmiIdsResult(GetAmiIdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAmiIdsResult(
            arns=self.arns,
            filters=self.filters,
            id=self.id,
            names=self.names,
            region=self.region)


def get_ami_ids(filters: Optional[Sequence[Union['GetAmiIdsFilterArgs', 'GetAmiIdsFilterArgsDict']]] = None,
                names: Optional[Sequence[_builtins.str]] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAmiIdsResult:
    """
    The Autoscaling Groups data source allows access to the list of AWS
    ASGs within a specific region. This will allow you to pass a list of AutoScaling Groups to other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    groups = aws.autoscaling.get_ami_ids(filters=[
        {
            "name": "tag:Team",
            "values": ["Pets"],
        },
        {
            "name": "tag-key",
            "values": ["Environment"],
        },
    ])
    slack_notifications = aws.autoscaling.Notification("slack_notifications",
        group_names=groups.names,
        notifications=[
            aws.autoscaling.NotificationType.INSTANCE_LAUNCH,
            aws.autoscaling.NotificationType.INSTANCE_TERMINATE,
            aws.autoscaling.NotificationType.INSTANCE_LAUNCH_ERROR,
            aws.autoscaling.NotificationType.INSTANCE_TERMINATE_ERROR,
        ],
        topic_arn="TOPIC ARN")
    ```


    :param Sequence[Union['GetAmiIdsFilterArgs', 'GetAmiIdsFilterArgsDict']] filters: Filter used to scope the list e.g., by tags. See [related docs](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_Filter.html).
    :param Sequence[_builtins.str] names: List of autoscaling group names
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['names'] = names
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:autoscaling/getAmiIds:getAmiIds', __args__, opts=opts, typ=GetAmiIdsResult).value

    return AwaitableGetAmiIdsResult(
        arns=pulumi.get(__ret__, 'arns'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'),
        region=pulumi.get(__ret__, 'region'))
def get_ami_ids_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAmiIdsFilterArgs', 'GetAmiIdsFilterArgsDict']]]]] = None,
                       names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAmiIdsResult]:
    """
    The Autoscaling Groups data source allows access to the list of AWS
    ASGs within a specific region. This will allow you to pass a list of AutoScaling Groups to other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    groups = aws.autoscaling.get_ami_ids(filters=[
        {
            "name": "tag:Team",
            "values": ["Pets"],
        },
        {
            "name": "tag-key",
            "values": ["Environment"],
        },
    ])
    slack_notifications = aws.autoscaling.Notification("slack_notifications",
        group_names=groups.names,
        notifications=[
            aws.autoscaling.NotificationType.INSTANCE_LAUNCH,
            aws.autoscaling.NotificationType.INSTANCE_TERMINATE,
            aws.autoscaling.NotificationType.INSTANCE_LAUNCH_ERROR,
            aws.autoscaling.NotificationType.INSTANCE_TERMINATE_ERROR,
        ],
        topic_arn="TOPIC ARN")
    ```


    :param Sequence[Union['GetAmiIdsFilterArgs', 'GetAmiIdsFilterArgsDict']] filters: Filter used to scope the list e.g., by tags. See [related docs](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_Filter.html).
    :param Sequence[_builtins.str] names: List of autoscaling group names
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['names'] = names
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:autoscaling/getAmiIds:getAmiIds', __args__, opts=opts, typ=GetAmiIdsResult)
    return __ret__.apply(lambda __response__: GetAmiIdsResult(
        arns=pulumi.get(__response__, 'arns'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        names=pulumi.get(__response__, 'names'),
        region=pulumi.get(__response__, 'region')))
