# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['VaultLockConfigurationArgs', 'VaultLockConfiguration']

@pulumi.input_type
class VaultLockConfigurationArgs:
    def __init__(__self__, *,
                 backup_vault_name: pulumi.Input[_builtins.str],
                 changeable_for_days: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 min_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VaultLockConfiguration resource.
        :param pulumi.Input[_builtins.str] backup_vault_name: Name of the backup vault to add a lock configuration for.
        :param pulumi.Input[_builtins.int] changeable_for_days: The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
        :param pulumi.Input[_builtins.int] max_retention_days: The maximum retention period that the vault retains its recovery points.
        :param pulumi.Input[_builtins.int] min_retention_days: The minimum retention period that the vault retains its recovery points.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        pulumi.set(__self__, "backup_vault_name", backup_vault_name)
        if changeable_for_days is not None:
            pulumi.set(__self__, "changeable_for_days", changeable_for_days)
        if max_retention_days is not None:
            pulumi.set(__self__, "max_retention_days", max_retention_days)
        if min_retention_days is not None:
            pulumi.set(__self__, "min_retention_days", min_retention_days)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="backupVaultName")
    def backup_vault_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the backup vault to add a lock configuration for.
        """
        return pulumi.get(self, "backup_vault_name")

    @backup_vault_name.setter
    def backup_vault_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_vault_name", value)

    @_builtins.property
    @pulumi.getter(name="changeableForDays")
    def changeable_for_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
        """
        return pulumi.get(self, "changeable_for_days")

    @changeable_for_days.setter
    def changeable_for_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "changeable_for_days", value)

    @_builtins.property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum retention period that the vault retains its recovery points.
        """
        return pulumi.get(self, "max_retention_days")

    @max_retention_days.setter
    def max_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="minRetentionDays")
    def min_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum retention period that the vault retains its recovery points.
        """
        return pulumi.get(self, "min_retention_days")

    @min_retention_days.setter
    def min_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _VaultLockConfigurationState:
    def __init__(__self__, *,
                 backup_vault_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 changeable_for_days: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 min_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VaultLockConfiguration resources.
        :param pulumi.Input[_builtins.str] backup_vault_arn: The ARN of the vault.
        :param pulumi.Input[_builtins.str] backup_vault_name: Name of the backup vault to add a lock configuration for.
        :param pulumi.Input[_builtins.int] changeable_for_days: The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
        :param pulumi.Input[_builtins.int] max_retention_days: The maximum retention period that the vault retains its recovery points.
        :param pulumi.Input[_builtins.int] min_retention_days: The minimum retention period that the vault retains its recovery points.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        if backup_vault_arn is not None:
            pulumi.set(__self__, "backup_vault_arn", backup_vault_arn)
        if backup_vault_name is not None:
            pulumi.set(__self__, "backup_vault_name", backup_vault_name)
        if changeable_for_days is not None:
            pulumi.set(__self__, "changeable_for_days", changeable_for_days)
        if max_retention_days is not None:
            pulumi.set(__self__, "max_retention_days", max_retention_days)
        if min_retention_days is not None:
            pulumi.set(__self__, "min_retention_days", min_retention_days)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="backupVaultArn")
    def backup_vault_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the vault.
        """
        return pulumi.get(self, "backup_vault_arn")

    @backup_vault_arn.setter
    def backup_vault_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_vault_arn", value)

    @_builtins.property
    @pulumi.getter(name="backupVaultName")
    def backup_vault_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the backup vault to add a lock configuration for.
        """
        return pulumi.get(self, "backup_vault_name")

    @backup_vault_name.setter
    def backup_vault_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_vault_name", value)

    @_builtins.property
    @pulumi.getter(name="changeableForDays")
    def changeable_for_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
        """
        return pulumi.get(self, "changeable_for_days")

    @changeable_for_days.setter
    def changeable_for_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "changeable_for_days", value)

    @_builtins.property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum retention period that the vault retains its recovery points.
        """
        return pulumi.get(self, "max_retention_days")

    @max_retention_days.setter
    def max_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="minRetentionDays")
    def min_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The minimum retention period that the vault retains its recovery points.
        """
        return pulumi.get(self, "min_retention_days")

    @min_retention_days.setter
    def min_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("aws:backup/vaultLockConfiguration:VaultLockConfiguration")
class VaultLockConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 changeable_for_days: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 min_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides an AWS Backup vault lock configuration resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.backup.VaultLockConfiguration("test",
            backup_vault_name="example_backup_vault",
            changeable_for_days=3,
            max_retention_days=1200,
            min_retention_days=7)
        ```

        ## Import

        Using `pulumi import`, import Backup vault lock configuration using the `name`. For example:

        ```sh
        $ pulumi import aws:backup/vaultLockConfiguration:VaultLockConfiguration test TestVault
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_vault_name: Name of the backup vault to add a lock configuration for.
        :param pulumi.Input[_builtins.int] changeable_for_days: The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
        :param pulumi.Input[_builtins.int] max_retention_days: The maximum retention period that the vault retains its recovery points.
        :param pulumi.Input[_builtins.int] min_retention_days: The minimum retention period that the vault retains its recovery points.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultLockConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an AWS Backup vault lock configuration resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.backup.VaultLockConfiguration("test",
            backup_vault_name="example_backup_vault",
            changeable_for_days=3,
            max_retention_days=1200,
            min_retention_days=7)
        ```

        ## Import

        Using `pulumi import`, import Backup vault lock configuration using the `name`. For example:

        ```sh
        $ pulumi import aws:backup/vaultLockConfiguration:VaultLockConfiguration test TestVault
        ```

        :param str resource_name: The name of the resource.
        :param VaultLockConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultLockConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 changeable_for_days: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 min_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultLockConfigurationArgs.__new__(VaultLockConfigurationArgs)

            if backup_vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'backup_vault_name'")
            __props__.__dict__["backup_vault_name"] = backup_vault_name
            __props__.__dict__["changeable_for_days"] = changeable_for_days
            __props__.__dict__["max_retention_days"] = max_retention_days
            __props__.__dict__["min_retention_days"] = min_retention_days
            __props__.__dict__["region"] = region
            __props__.__dict__["backup_vault_arn"] = None
        super(VaultLockConfiguration, __self__).__init__(
            'aws:backup/vaultLockConfiguration:VaultLockConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_vault_arn: Optional[pulumi.Input[_builtins.str]] = None,
            backup_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
            changeable_for_days: Optional[pulumi.Input[_builtins.int]] = None,
            max_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            min_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'VaultLockConfiguration':
        """
        Get an existing VaultLockConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backup_vault_arn: The ARN of the vault.
        :param pulumi.Input[_builtins.str] backup_vault_name: Name of the backup vault to add a lock configuration for.
        :param pulumi.Input[_builtins.int] changeable_for_days: The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
        :param pulumi.Input[_builtins.int] max_retention_days: The maximum retention period that the vault retains its recovery points.
        :param pulumi.Input[_builtins.int] min_retention_days: The minimum retention period that the vault retains its recovery points.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultLockConfigurationState.__new__(_VaultLockConfigurationState)

        __props__.__dict__["backup_vault_arn"] = backup_vault_arn
        __props__.__dict__["backup_vault_name"] = backup_vault_name
        __props__.__dict__["changeable_for_days"] = changeable_for_days
        __props__.__dict__["max_retention_days"] = max_retention_days
        __props__.__dict__["min_retention_days"] = min_retention_days
        __props__.__dict__["region"] = region
        return VaultLockConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupVaultArn")
    def backup_vault_arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the vault.
        """
        return pulumi.get(self, "backup_vault_arn")

    @_builtins.property
    @pulumi.getter(name="backupVaultName")
    def backup_vault_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the backup vault to add a lock configuration for.
        """
        return pulumi.get(self, "backup_vault_name")

    @_builtins.property
    @pulumi.getter(name="changeableForDays")
    def changeable_for_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of days before the lock date. If omitted creates a vault lock in `governance` mode, otherwise it will create a vault lock in `compliance` mode.
        """
        return pulumi.get(self, "changeable_for_days")

    @_builtins.property
    @pulumi.getter(name="maxRetentionDays")
    def max_retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum retention period that the vault retains its recovery points.
        """
        return pulumi.get(self, "max_retention_days")

    @_builtins.property
    @pulumi.getter(name="minRetentionDays")
    def min_retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The minimum retention period that the vault retains its recovery points.
        """
        return pulumi.get(self, "min_retention_days")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

