# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentAgentAliasArgs', 'AgentAgentAlias']

@pulumi.input_type
class AgentAgentAliasArgs:
    def __init__(__self__, *,
                 agent_alias_name: pulumi.Input[_builtins.str],
                 agent_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentAliasRoutingConfigurationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentAgentAliasTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a AgentAgentAlias resource.
        :param pulumi.Input[_builtins.str] agent_alias_name: Name of the alias.
        :param pulumi.Input[_builtins.str] agent_id: Identifier of the agent to create an alias for.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: Description of the alias.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AgentAgentAliasRoutingConfigurationArgs']]] routing_configurations: Details about the routing configuration of the alias. See `routing_configuration` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "agent_alias_name", agent_alias_name)
        pulumi.set(__self__, "agent_id", agent_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routing_configurations is not None:
            pulumi.set(__self__, "routing_configurations", routing_configurations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="agentAliasName")
    def agent_alias_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the alias.
        """
        return pulumi.get(self, "agent_alias_name")

    @agent_alias_name.setter
    def agent_alias_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_alias_name", value)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the agent to create an alias for.

        The following arguments are optional:
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the alias.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routingConfigurations")
    def routing_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentAliasRoutingConfigurationArgs']]]]:
        """
        Details about the routing configuration of the alias. See `routing_configuration` Block for details.
        """
        return pulumi.get(self, "routing_configurations")

    @routing_configurations.setter
    def routing_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentAliasRoutingConfigurationArgs']]]]):
        pulumi.set(self, "routing_configurations", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentAgentAliasTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentAgentAliasTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _AgentAgentAliasState:
    def __init__(__self__, *,
                 agent_alias_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_alias_id: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentAliasRoutingConfigurationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input['AgentAgentAliasTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering AgentAgentAlias resources.
        :param pulumi.Input[_builtins.str] agent_alias_arn: ARN of the alias.
        :param pulumi.Input[_builtins.str] agent_alias_id: Unique identifier of the alias.
        :param pulumi.Input[_builtins.str] agent_alias_name: Name of the alias.
        :param pulumi.Input[_builtins.str] agent_id: Identifier of the agent to create an alias for.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: Description of the alias.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AgentAgentAliasRoutingConfigurationArgs']]] routing_configurations: Details about the routing configuration of the alias. See `routing_configuration` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if agent_alias_arn is not None:
            pulumi.set(__self__, "agent_alias_arn", agent_alias_arn)
        if agent_alias_id is not None:
            pulumi.set(__self__, "agent_alias_id", agent_alias_id)
        if agent_alias_name is not None:
            pulumi.set(__self__, "agent_alias_name", agent_alias_name)
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routing_configurations is not None:
            pulumi.set(__self__, "routing_configurations", routing_configurations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @_builtins.property
    @pulumi.getter(name="agentAliasArn")
    def agent_alias_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the alias.
        """
        return pulumi.get(self, "agent_alias_arn")

    @agent_alias_arn.setter
    def agent_alias_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_alias_arn", value)

    @_builtins.property
    @pulumi.getter(name="agentAliasId")
    def agent_alias_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier of the alias.
        """
        return pulumi.get(self, "agent_alias_id")

    @agent_alias_id.setter
    def agent_alias_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_alias_id", value)

    @_builtins.property
    @pulumi.getter(name="agentAliasName")
    def agent_alias_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the alias.
        """
        return pulumi.get(self, "agent_alias_name")

    @agent_alias_name.setter
    def agent_alias_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_alias_name", value)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the agent to create an alias for.

        The following arguments are optional:
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the alias.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routingConfigurations")
    def routing_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentAliasRoutingConfigurationArgs']]]]:
        """
        Details about the routing configuration of the alias. See `routing_configuration` Block for details.
        """
        return pulumi.get(self, "routing_configurations")

    @routing_configurations.setter
    def routing_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentAgentAliasRoutingConfigurationArgs']]]]):
        pulumi.set(self, "routing_configurations", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['AgentAgentAliasTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['AgentAgentAliasTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.type_token("aws:bedrock/agentAgentAlias:AgentAgentAlias")
class AgentAgentAlias(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentAliasRoutingConfigurationArgs', 'AgentAgentAliasRoutingConfigurationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentAgentAliasTimeoutsArgs', 'AgentAgentAliasTimeoutsArgsDict']]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Agents for Amazon Bedrock Agent Alias.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Agents for Amazon Bedrock Agent Alias using the alias ID and the agent ID separated by `,`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentAgentAlias:AgentAgentAlias example 66IVY0GUTF,GGRRAED6JP
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_alias_name: Name of the alias.
        :param pulumi.Input[_builtins.str] agent_id: Identifier of the agent to create an alias for.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: Description of the alias.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentAliasRoutingConfigurationArgs', 'AgentAgentAliasRoutingConfigurationArgsDict']]]] routing_configurations: Details about the routing configuration of the alias. See `routing_configuration` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentAgentAliasArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Agents for Amazon Bedrock Agent Alias.

        ## Example Usage

        ## Import

        Using `pulumi import`, import Agents for Amazon Bedrock Agent Alias using the alias ID and the agent ID separated by `,`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentAgentAlias:AgentAgentAlias example 66IVY0GUTF,GGRRAED6JP
        ```

        :param str resource_name: The name of the resource.
        :param AgentAgentAliasArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentAgentAliasArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_alias_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentAliasRoutingConfigurationArgs', 'AgentAgentAliasRoutingConfigurationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 timeouts: Optional[pulumi.Input[Union['AgentAgentAliasTimeoutsArgs', 'AgentAgentAliasTimeoutsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentAgentAliasArgs.__new__(AgentAgentAliasArgs)

            if agent_alias_name is None and not opts.urn:
                raise TypeError("Missing required property 'agent_alias_name'")
            __props__.__dict__["agent_alias_name"] = agent_alias_name
            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            __props__.__dict__["description"] = description
            __props__.__dict__["region"] = region
            __props__.__dict__["routing_configurations"] = routing_configurations
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["agent_alias_arn"] = None
            __props__.__dict__["agent_alias_id"] = None
            __props__.__dict__["tags_all"] = None
        super(AgentAgentAlias, __self__).__init__(
            'aws:bedrock/agentAgentAlias:AgentAgentAlias',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_alias_arn: Optional[pulumi.Input[_builtins.str]] = None,
            agent_alias_id: Optional[pulumi.Input[_builtins.str]] = None,
            agent_alias_name: Optional[pulumi.Input[_builtins.str]] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            routing_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentAliasRoutingConfigurationArgs', 'AgentAgentAliasRoutingConfigurationArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            timeouts: Optional[pulumi.Input[Union['AgentAgentAliasTimeoutsArgs', 'AgentAgentAliasTimeoutsArgsDict']]] = None) -> 'AgentAgentAlias':
        """
        Get an existing AgentAgentAlias resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_alias_arn: ARN of the alias.
        :param pulumi.Input[_builtins.str] agent_alias_id: Unique identifier of the alias.
        :param pulumi.Input[_builtins.str] agent_alias_name: Name of the alias.
        :param pulumi.Input[_builtins.str] agent_id: Identifier of the agent to create an alias for.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] description: Description of the alias.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentAgentAliasRoutingConfigurationArgs', 'AgentAgentAliasRoutingConfigurationArgsDict']]]] routing_configurations: Details about the routing configuration of the alias. See `routing_configuration` Block for details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentAgentAliasState.__new__(_AgentAgentAliasState)

        __props__.__dict__["agent_alias_arn"] = agent_alias_arn
        __props__.__dict__["agent_alias_id"] = agent_alias_id
        __props__.__dict__["agent_alias_name"] = agent_alias_name
        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["description"] = description
        __props__.__dict__["region"] = region
        __props__.__dict__["routing_configurations"] = routing_configurations
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["timeouts"] = timeouts
        return AgentAgentAlias(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentAliasArn")
    def agent_alias_arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the alias.
        """
        return pulumi.get(self, "agent_alias_arn")

    @_builtins.property
    @pulumi.getter(name="agentAliasId")
    def agent_alias_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier of the alias.
        """
        return pulumi.get(self, "agent_alias_id")

    @_builtins.property
    @pulumi.getter(name="agentAliasName")
    def agent_alias_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the alias.
        """
        return pulumi.get(self, "agent_alias_name")

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the agent to create an alias for.

        The following arguments are optional:
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the alias.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routingConfigurations")
    def routing_configurations(self) -> pulumi.Output[Sequence['outputs.AgentAgentAliasRoutingConfiguration']]:
        """
        Details about the routing configuration of the alias. See `routing_configuration` Block for details.
        """
        return pulumi.get(self, "routing_configurations")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags assigned to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.AgentAgentAliasTimeouts']]:
        return pulumi.get(self, "timeouts")

