# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentPromptArgs', 'AgentPrompt']

@pulumi.input_type
class AgentPromptArgs:
    def __init__(__self__, *,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 default_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 variants: Optional[pulumi.Input[Sequence[pulumi.Input['AgentPromptVariantArgs']]]] = None):
        """
        The set of arguments for constructing a AgentPrompt resource.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: Amazon Resource Name (ARN) of the KMS key that you encrypted the prompt with.
        :param pulumi.Input[_builtins.str] default_variant: Name of the default variant for your prompt.
        :param pulumi.Input[_builtins.str] description: Description of the prompt.
        :param pulumi.Input[_builtins.str] name: Name of the prompt.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input['AgentPromptVariantArgs']]] variants: A list of objects, each containing details about a variant of the prompt. See Variant for more information.
        """
        if customer_encryption_key_arn is not None:
            pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if default_variant is not None:
            pulumi.set(__self__, "default_variant", default_variant)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if variants is not None:
            pulumi.set(__self__, "variants", variants)

    @_builtins.property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the KMS key that you encrypted the prompt with.
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @customer_encryption_key_arn.setter
    def customer_encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="defaultVariant")
    def default_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the default variant for your prompt.
        """
        return pulumi.get(self, "default_variant")

    @default_variant.setter
    def default_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_variant", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the prompt.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the prompt.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def variants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentPromptVariantArgs']]]]:
        """
        A list of objects, each containing details about a variant of the prompt. See Variant for more information.
        """
        return pulumi.get(self, "variants")

    @variants.setter
    def variants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentPromptVariantArgs']]]]):
        pulumi.set(self, "variants", value)


@pulumi.input_type
class _AgentPromptState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 default_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 variants: Optional[pulumi.Input[Sequence[pulumi.Input['AgentPromptVariantArgs']]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentPrompt resources.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the prompt.
        :param pulumi.Input[_builtins.str] created_at: Time at which the prompt was created.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: Amazon Resource Name (ARN) of the KMS key that you encrypted the prompt with.
        :param pulumi.Input[_builtins.str] default_variant: Name of the default variant for your prompt.
        :param pulumi.Input[_builtins.str] description: Description of the prompt.
        :param pulumi.Input[_builtins.str] name: Name of the prompt.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] updated_at: Time at which the prompt was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['AgentPromptVariantArgs']]] variants: A list of objects, each containing details about a variant of the prompt. See Variant for more information.
        :param pulumi.Input[_builtins.str] version: Version of the prompt. When you create a prompt, the version created is the `DRAFT` version.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if customer_encryption_key_arn is not None:
            pulumi.set(__self__, "customer_encryption_key_arn", customer_encryption_key_arn)
        if default_variant is not None:
            pulumi.set(__self__, "default_variant", default_variant)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if variants is not None:
            pulumi.set(__self__, "variants", variants)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the prompt.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the prompt was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the KMS key that you encrypted the prompt with.
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @customer_encryption_key_arn.setter
    def customer_encryption_key_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_encryption_key_arn", value)

    @_builtins.property
    @pulumi.getter(name="defaultVariant")
    def default_variant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the default variant for your prompt.
        """
        return pulumi.get(self, "default_variant")

    @default_variant.setter
    def default_variant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_variant", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the prompt.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the prompt.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the prompt was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def variants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AgentPromptVariantArgs']]]]:
        """
        A list of objects, each containing details about a variant of the prompt. See Variant for more information.
        """
        return pulumi.get(self, "variants")

    @variants.setter
    def variants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AgentPromptVariantArgs']]]]):
        pulumi.set(self, "variants", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the prompt. When you create a prompt, the version created is the `DRAFT` version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("aws:bedrock/agentPrompt:AgentPrompt")
class AgentPrompt(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 default_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentPromptVariantArgs', 'AgentPromptVariantArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource for managing an AWS Bedrock Agents Prompt.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentPrompt("example",
            name="MyPrompt",
            description="My prompt description.")
        ```

        ### With Variants

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentPrompt("example",
            name="MakePlaylist",
            description="My first prompt.",
            default_variant="Variant1",
            variants=[{
                "name": "Variant1",
                "model_id": "amazon.titan-text-express-v1",
                "inference_configuration": {
                    "text": {
                        "temperature": 0.8,
                    },
                },
                "template_type": "TEXT",
                "template_configuration": {
                    "text": {
                        "text": "Make me a {{genre}} playlist consisting of the following number of songs: {{number}}.",
                        "input_variables": [
                            {
                                "name": "genre",
                            },
                            {
                                "name": "number",
                            },
                        ],
                    },
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import Bedrock Agents Prompt using the `id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentPrompt:AgentPrompt example 1A2BC3DEFG
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: Amazon Resource Name (ARN) of the KMS key that you encrypted the prompt with.
        :param pulumi.Input[_builtins.str] default_variant: Name of the default variant for your prompt.
        :param pulumi.Input[_builtins.str] description: Description of the prompt.
        :param pulumi.Input[_builtins.str] name: Name of the prompt.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentPromptVariantArgs', 'AgentPromptVariantArgsDict']]]] variants: A list of objects, each containing details about a variant of the prompt. See Variant for more information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AgentPromptArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS Bedrock Agents Prompt.

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentPrompt("example",
            name="MyPrompt",
            description="My prompt description.")
        ```

        ### With Variants

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.bedrock.AgentPrompt("example",
            name="MakePlaylist",
            description="My first prompt.",
            default_variant="Variant1",
            variants=[{
                "name": "Variant1",
                "model_id": "amazon.titan-text-express-v1",
                "inference_configuration": {
                    "text": {
                        "temperature": 0.8,
                    },
                },
                "template_type": "TEXT",
                "template_configuration": {
                    "text": {
                        "text": "Make me a {{genre}} playlist consisting of the following number of songs: {{number}}.",
                        "input_variables": [
                            {
                                "name": "genre",
                            },
                            {
                                "name": "number",
                            },
                        ],
                    },
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import Bedrock Agents Prompt using the `id`. For example:

        ```sh
        $ pulumi import aws:bedrock/agentPrompt:AgentPrompt example 1A2BC3DEFG
        ```

        :param str resource_name: The name of the resource.
        :param AgentPromptArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentPromptArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 default_variant: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentPromptVariantArgs', 'AgentPromptVariantArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentPromptArgs.__new__(AgentPromptArgs)

            __props__.__dict__["customer_encryption_key_arn"] = customer_encryption_key_arn
            __props__.__dict__["default_variant"] = default_variant
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["variants"] = variants
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["version"] = None
        super(AgentPrompt, __self__).__init__(
            'aws:bedrock/agentPrompt:AgentPrompt',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            customer_encryption_key_arn: Optional[pulumi.Input[_builtins.str]] = None,
            default_variant: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AgentPromptVariantArgs', 'AgentPromptVariantArgsDict']]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'AgentPrompt':
        """
        Get an existing AgentPrompt resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: Amazon Resource Name (ARN) of the prompt.
        :param pulumi.Input[_builtins.str] created_at: Time at which the prompt was created.
        :param pulumi.Input[_builtins.str] customer_encryption_key_arn: Amazon Resource Name (ARN) of the KMS key that you encrypted the prompt with.
        :param pulumi.Input[_builtins.str] default_variant: Name of the default variant for your prompt.
        :param pulumi.Input[_builtins.str] description: Description of the prompt.
        :param pulumi.Input[_builtins.str] name: Name of the prompt.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] updated_at: Time at which the prompt was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AgentPromptVariantArgs', 'AgentPromptVariantArgsDict']]]] variants: A list of objects, each containing details about a variant of the prompt. See Variant for more information.
        :param pulumi.Input[_builtins.str] version: Version of the prompt. When you create a prompt, the version created is the `DRAFT` version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentPromptState.__new__(_AgentPromptState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["customer_encryption_key_arn"] = customer_encryption_key_arn
        __props__.__dict__["default_variant"] = default_variant
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["variants"] = variants
        __props__.__dict__["version"] = version
        return AgentPrompt(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the prompt.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the prompt was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customerEncryptionKeyArn")
    def customer_encryption_key_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the KMS key that you encrypted the prompt with.
        """
        return pulumi.get(self, "customer_encryption_key_arn")

    @_builtins.property
    @pulumi.getter(name="defaultVariant")
    def default_variant(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Name of the default variant for your prompt.
        """
        return pulumi.get(self, "default_variant")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the prompt.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the prompt.

        The following arguments are optional:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the prompt was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def variants(self) -> pulumi.Output[Optional[Sequence['outputs.AgentPromptVariant']]]:
        """
        A list of objects, each containing details about a variant of the prompt. See Variant for more information.
        """
        return pulumi.get(self, "variants")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Version of the prompt. When you create a prompt, the version created is the `DRAFT` version.
        """
        return pulumi.get(self, "version")

