# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AggregateAuthorizationArgs', 'AggregateAuthorization']

@pulumi.input_type
class AggregateAuthorizationArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 authorized_aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AggregateAuthorization resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] authorized_aws_region: The region authorized to collect aggregated data.
        :param pulumi.Input[_builtins.str] region: The region authorized to collect aggregated data. Use `authorized_aws_region` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "account_id", account_id)
        if authorized_aws_region is not None:
            pulumi.set(__self__, "authorized_aws_region", authorized_aws_region)
        if region is not None:
            warnings.warn("""region is deprecated. Use authorized_aws_region instead.""", DeprecationWarning)
            pulumi.log.warn("""region is deprecated: region is deprecated. Use authorized_aws_region instead.""")
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter(name="authorizedAwsRegion")
    def authorized_aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region authorized to collect aggregated data.
        """
        return pulumi.get(self, "authorized_aws_region")

    @authorized_aws_region.setter
    def authorized_aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorized_aws_region", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use authorized_aws_region instead.""")
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region authorized to collect aggregated data. Use `authorized_aws_region` instead.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AggregateAuthorizationState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AggregateAuthorization resources.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] arn: The ARN of the authorization
        :param pulumi.Input[_builtins.str] authorized_aws_region: The region authorized to collect aggregated data.
        :param pulumi.Input[_builtins.str] region: The region authorized to collect aggregated data. Use `authorized_aws_region` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if authorized_aws_region is not None:
            pulumi.set(__self__, "authorized_aws_region", authorized_aws_region)
        if region is not None:
            warnings.warn("""region is deprecated. Use authorized_aws_region instead.""", DeprecationWarning)
            pulumi.log.warn("""region is deprecated: region is deprecated. Use authorized_aws_region instead.""")
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the authorization
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="authorizedAwsRegion")
    def authorized_aws_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region authorized to collect aggregated data.
        """
        return pulumi.get(self, "authorized_aws_region")

    @authorized_aws_region.setter
    def authorized_aws_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorized_aws_region", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use authorized_aws_region instead.""")
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region authorized to collect aggregated data. Use `authorized_aws_region` instead.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:cfg/aggregateAuthorization:AggregateAuthorization")
class AggregateAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an AWS Config Aggregate Authorization

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cfg.AggregateAuthorization("example",
            account_id="123456789012",
            authorized_aws_region="eu-west-2")
        ```

        ## Import

        Using `pulumi import`, import Config aggregate authorizations using `account_id:authorized_aws_region`. For example:

        ```sh
        $ pulumi import aws:cfg/aggregateAuthorization:AggregateAuthorization example 123456789012:us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] authorized_aws_region: The region authorized to collect aggregated data.
        :param pulumi.Input[_builtins.str] region: The region authorized to collect aggregated data. Use `authorized_aws_region` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AggregateAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Config Aggregate Authorization

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cfg.AggregateAuthorization("example",
            account_id="123456789012",
            authorized_aws_region="eu-west-2")
        ```

        ## Import

        Using `pulumi import`, import Config aggregate authorizations using `account_id:authorized_aws_region`. For example:

        ```sh
        $ pulumi import aws:cfg/aggregateAuthorization:AggregateAuthorization example 123456789012:us-east-1
        ```

        :param str resource_name: The name of the resource.
        :param AggregateAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AggregateAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_aws_region: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AggregateAuthorizationArgs.__new__(AggregateAuthorizationArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["authorized_aws_region"] = authorized_aws_region
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(AggregateAuthorization, __self__).__init__(
            'aws:cfg/aggregateAuthorization:AggregateAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            authorized_aws_region: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'AggregateAuthorization':
        """
        Get an existing AggregateAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account ID.
        :param pulumi.Input[_builtins.str] arn: The ARN of the authorization
        :param pulumi.Input[_builtins.str] authorized_aws_region: The region authorized to collect aggregated data.
        :param pulumi.Input[_builtins.str] region: The region authorized to collect aggregated data. Use `authorized_aws_region` instead.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AggregateAuthorizationState.__new__(_AggregateAuthorizationState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["authorized_aws_region"] = authorized_aws_region
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return AggregateAuthorization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account ID.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the authorization
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="authorizedAwsRegion")
    def authorized_aws_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region authorized to collect aggregated data.
        """
        return pulumi.get(self, "authorized_aws_region")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""region is deprecated. Use authorized_aws_region instead.""")
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region authorized to collect aggregated data. Use `authorized_aws_region` instead.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

