# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CloudFormationTypeLoggingConfig',
    'StackInstancesDeploymentTargets',
    'StackInstancesOperationPreferences',
    'StackInstancesStackInstanceSummary',
    'StackSetAutoDeployment',
    'StackSetInstanceDeploymentTargets',
    'StackSetInstanceOperationPreferences',
    'StackSetInstanceStackInstanceSummary',
    'StackSetManagedExecution',
    'StackSetOperationPreferences',
    'GetCloudFormationTypeLoggingConfigResult',
]

@pulumi.output_type
class CloudFormationTypeLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"
        elif key == "logRoleArn":
            suggest = "log_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudFormationTypeLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudFormationTypeLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudFormationTypeLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_name: _builtins.str,
                 log_role_arn: _builtins.str):
        """
        :param _builtins.str log_group_name: Name of the CloudWatch Log Group where CloudFormation sends error logging information when invoking the type's handlers.
        :param _builtins.str log_role_arn: Amazon Resource Name (ARN) of the IAM Role CloudFormation assumes when sending error logging information to CloudWatch Logs.
        """
        pulumi.set(__self__, "log_group_name", log_group_name)
        pulumi.set(__self__, "log_role_arn", log_role_arn)

    @_builtins.property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> _builtins.str:
        """
        Name of the CloudWatch Log Group where CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @_builtins.property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> _builtins.str:
        """
        Amazon Resource Name (ARN) of the IAM Role CloudFormation assumes when sending error logging information to CloudWatch Logs.
        """
        return pulumi.get(self, "log_role_arn")


@pulumi.output_type
class StackInstancesDeploymentTargets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountFilterType":
            suggest = "account_filter_type"
        elif key == "accountsUrl":
            suggest = "accounts_url"
        elif key == "organizationalUnitIds":
            suggest = "organizational_unit_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackInstancesDeploymentTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackInstancesDeploymentTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackInstancesDeploymentTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_filter_type: Optional[_builtins.str] = None,
                 accounts: Optional[Sequence[_builtins.str]] = None,
                 accounts_url: Optional[_builtins.str] = None,
                 organizational_unit_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str account_filter_type: Limit deployment targets to individual accounts or include additional accounts with provided OUs. Valid values: `INTERSECTION`, `DIFFERENCE`, `UNION`, `NONE`.
        :param Sequence[_builtins.str] accounts: List of accounts to deploy stack set updates.
        :param _builtins.str accounts_url: S3 URL of the file containing the list of accounts.
        :param Sequence[_builtins.str] organizational_unit_ids: Organization root ID or organizational unit (OU) IDs to which stack sets deploy.
        """
        if account_filter_type is not None:
            pulumi.set(__self__, "account_filter_type", account_filter_type)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if accounts_url is not None:
            pulumi.set(__self__, "accounts_url", accounts_url)
        if organizational_unit_ids is not None:
            pulumi.set(__self__, "organizational_unit_ids", organizational_unit_ids)

    @_builtins.property
    @pulumi.getter(name="accountFilterType")
    def account_filter_type(self) -> Optional[_builtins.str]:
        """
        Limit deployment targets to individual accounts or include additional accounts with provided OUs. Valid values: `INTERSECTION`, `DIFFERENCE`, `UNION`, `NONE`.
        """
        return pulumi.get(self, "account_filter_type")

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of accounts to deploy stack set updates.
        """
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter(name="accountsUrl")
    def accounts_url(self) -> Optional[_builtins.str]:
        """
        S3 URL of the file containing the list of accounts.
        """
        return pulumi.get(self, "accounts_url")

    @_builtins.property
    @pulumi.getter(name="organizationalUnitIds")
    def organizational_unit_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Organization root ID or organizational unit (OU) IDs to which stack sets deploy.
        """
        return pulumi.get(self, "organizational_unit_ids")


@pulumi.output_type
class StackInstancesOperationPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrencyMode":
            suggest = "concurrency_mode"
        elif key == "failureToleranceCount":
            suggest = "failure_tolerance_count"
        elif key == "failureTolerancePercentage":
            suggest = "failure_tolerance_percentage"
        elif key == "maxConcurrentCount":
            suggest = "max_concurrent_count"
        elif key == "maxConcurrentPercentage":
            suggest = "max_concurrent_percentage"
        elif key == "regionConcurrencyType":
            suggest = "region_concurrency_type"
        elif key == "regionOrders":
            suggest = "region_orders"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackInstancesOperationPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackInstancesOperationPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackInstancesOperationPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrency_mode: Optional[_builtins.str] = None,
                 failure_tolerance_count: Optional[_builtins.int] = None,
                 failure_tolerance_percentage: Optional[_builtins.int] = None,
                 max_concurrent_count: Optional[_builtins.int] = None,
                 max_concurrent_percentage: Optional[_builtins.int] = None,
                 region_concurrency_type: Optional[_builtins.str] = None,
                 region_orders: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str concurrency_mode: How the concurrency level behaves during the operation execution. Valid values are `STRICT_FAILURE_TOLERANCE` and `SOFT_FAILURE_TOLERANCE`.
        :param _builtins.int failure_tolerance_count: Number of accounts, per region, for which this operation can fail before CloudFormation stops the operation in that region.
        :param _builtins.int failure_tolerance_percentage: Percentage of accounts, per region, for which this stack operation can fail before CloudFormation stops the operation in that region.
        :param _builtins.int max_concurrent_count: Maximum number of accounts in which to perform this operation at one time.
        :param _builtins.int max_concurrent_percentage: Maximum percentage of accounts in which to perform this operation at one time.
        :param _builtins.str region_concurrency_type: Concurrency type of deploying stack sets operations in regions, could be in parallel or one region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
        :param Sequence[_builtins.str] region_orders: Order of the regions where you want to perform the stack operation.
        """
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if failure_tolerance_count is not None:
            pulumi.set(__self__, "failure_tolerance_count", failure_tolerance_count)
        if failure_tolerance_percentage is not None:
            pulumi.set(__self__, "failure_tolerance_percentage", failure_tolerance_percentage)
        if max_concurrent_count is not None:
            pulumi.set(__self__, "max_concurrent_count", max_concurrent_count)
        if max_concurrent_percentage is not None:
            pulumi.set(__self__, "max_concurrent_percentage", max_concurrent_percentage)
        if region_concurrency_type is not None:
            pulumi.set(__self__, "region_concurrency_type", region_concurrency_type)
        if region_orders is not None:
            pulumi.set(__self__, "region_orders", region_orders)

    @_builtins.property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional[_builtins.str]:
        """
        How the concurrency level behaves during the operation execution. Valid values are `STRICT_FAILURE_TOLERANCE` and `SOFT_FAILURE_TOLERANCE`.
        """
        return pulumi.get(self, "concurrency_mode")

    @_builtins.property
    @pulumi.getter(name="failureToleranceCount")
    def failure_tolerance_count(self) -> Optional[_builtins.int]:
        """
        Number of accounts, per region, for which this operation can fail before CloudFormation stops the operation in that region.
        """
        return pulumi.get(self, "failure_tolerance_count")

    @_builtins.property
    @pulumi.getter(name="failureTolerancePercentage")
    def failure_tolerance_percentage(self) -> Optional[_builtins.int]:
        """
        Percentage of accounts, per region, for which this stack operation can fail before CloudFormation stops the operation in that region.
        """
        return pulumi.get(self, "failure_tolerance_percentage")

    @_builtins.property
    @pulumi.getter(name="maxConcurrentCount")
    def max_concurrent_count(self) -> Optional[_builtins.int]:
        """
        Maximum number of accounts in which to perform this operation at one time.
        """
        return pulumi.get(self, "max_concurrent_count")

    @_builtins.property
    @pulumi.getter(name="maxConcurrentPercentage")
    def max_concurrent_percentage(self) -> Optional[_builtins.int]:
        """
        Maximum percentage of accounts in which to perform this operation at one time.
        """
        return pulumi.get(self, "max_concurrent_percentage")

    @_builtins.property
    @pulumi.getter(name="regionConcurrencyType")
    def region_concurrency_type(self) -> Optional[_builtins.str]:
        """
        Concurrency type of deploying stack sets operations in regions, could be in parallel or one region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
        """
        return pulumi.get(self, "region_concurrency_type")

    @_builtins.property
    @pulumi.getter(name="regionOrders")
    def region_orders(self) -> Optional[Sequence[_builtins.str]]:
        """
        Order of the regions where you want to perform the stack operation.
        """
        return pulumi.get(self, "region_orders")


@pulumi.output_type
class StackInstancesStackInstanceSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "detailedStatus":
            suggest = "detailed_status"
        elif key == "driftStatus":
            suggest = "drift_status"
        elif key == "organizationalUnitId":
            suggest = "organizational_unit_id"
        elif key == "stackId":
            suggest = "stack_id"
        elif key == "stackSetId":
            suggest = "stack_set_id"
        elif key == "statusReason":
            suggest = "status_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackInstancesStackInstanceSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackInstancesStackInstanceSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackInstancesStackInstanceSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[_builtins.str] = None,
                 detailed_status: Optional[_builtins.str] = None,
                 drift_status: Optional[_builtins.str] = None,
                 organizational_unit_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 stack_id: Optional[_builtins.str] = None,
                 stack_set_id: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 status_reason: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_id: Account ID in which the instance is deployed.
        :param _builtins.str detailed_status: Detailed status of the stack instance. Values include `PENDING`, `RUNNING`, `SUCCEEDED`, `FAILED`, `CANCELLED`, `INOPERABLE`, `SKIPPED_SUSPENDED_ACCOUNT`, `FAILED_IMPORT`.
        :param _builtins.str drift_status: Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. Values include `DRIFTED`, `IN_SYNC`, `UNKNOWN`, `NOT_CHECKED`.
        :param _builtins.str organizational_unit_id: Organization root ID or organizational unit (OU) IDs that you specified for `deployment_targets`.
        :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param _builtins.str stack_id: ID of the stack instance.
        :param _builtins.str stack_set_id: Name or unique ID of the stack set that the stack instance is associated with.
        :param _builtins.str status: Status of the stack instance, in terms of its synchronization with its associated stack set. Values include `CURRENT`, `OUTDATED`, `INOPERABLE`.
        :param _builtins.str status_reason: Explanation for the specific status code assigned to this stack instance.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if detailed_status is not None:
            pulumi.set(__self__, "detailed_status", detailed_status)
        if drift_status is not None:
            pulumi.set(__self__, "drift_status", drift_status)
        if organizational_unit_id is not None:
            pulumi.set(__self__, "organizational_unit_id", organizational_unit_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)
        if stack_set_id is not None:
            pulumi.set(__self__, "stack_set_id", stack_set_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        Account ID in which the instance is deployed.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="detailedStatus")
    def detailed_status(self) -> Optional[_builtins.str]:
        """
        Detailed status of the stack instance. Values include `PENDING`, `RUNNING`, `SUCCEEDED`, `FAILED`, `CANCELLED`, `INOPERABLE`, `SKIPPED_SUSPENDED_ACCOUNT`, `FAILED_IMPORT`.
        """
        return pulumi.get(self, "detailed_status")

    @_builtins.property
    @pulumi.getter(name="driftStatus")
    def drift_status(self) -> Optional[_builtins.str]:
        """
        Status of the stack instance's actual configuration compared to the expected template and parameter configuration of the stack set to which it belongs. Values include `DRIFTED`, `IN_SYNC`, `UNKNOWN`, `NOT_CHECKED`.
        """
        return pulumi.get(self, "drift_status")

    @_builtins.property
    @pulumi.getter(name="organizationalUnitId")
    def organizational_unit_id(self) -> Optional[_builtins.str]:
        """
        Organization root ID or organizational unit (OU) IDs that you specified for `deployment_targets`.
        """
        return pulumi.get(self, "organizational_unit_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[_builtins.str]:
        """
        ID of the stack instance.
        """
        return pulumi.get(self, "stack_id")

    @_builtins.property
    @pulumi.getter(name="stackSetId")
    def stack_set_id(self) -> Optional[_builtins.str]:
        """
        Name or unique ID of the stack set that the stack instance is associated with.
        """
        return pulumi.get(self, "stack_set_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        Status of the stack instance, in terms of its synchronization with its associated stack set. Values include `CURRENT`, `OUTDATED`, `INOPERABLE`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[_builtins.str]:
        """
        Explanation for the specific status code assigned to this stack instance.
        """
        return pulumi.get(self, "status_reason")


@pulumi.output_type
class StackSetAutoDeployment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainStacksOnAccountRemoval":
            suggest = "retain_stacks_on_account_removal"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetAutoDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetAutoDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetAutoDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 retain_stacks_on_account_removal: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enabled: Whether or not auto-deployment is enabled.
        :param _builtins.bool retain_stacks_on_account_removal: Whether or not to retain stacks when the account is removed.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if retain_stacks_on_account_removal is not None:
            pulumi.set(__self__, "retain_stacks_on_account_removal", retain_stacks_on_account_removal)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether or not auto-deployment is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="retainStacksOnAccountRemoval")
    def retain_stacks_on_account_removal(self) -> Optional[_builtins.bool]:
        """
        Whether or not to retain stacks when the account is removed.
        """
        return pulumi.get(self, "retain_stacks_on_account_removal")


@pulumi.output_type
class StackSetInstanceDeploymentTargets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountFilterType":
            suggest = "account_filter_type"
        elif key == "accountsUrl":
            suggest = "accounts_url"
        elif key == "organizationalUnitIds":
            suggest = "organizational_unit_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetInstanceDeploymentTargets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetInstanceDeploymentTargets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetInstanceDeploymentTargets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_filter_type: Optional[_builtins.str] = None,
                 accounts: Optional[Sequence[_builtins.str]] = None,
                 accounts_url: Optional[_builtins.str] = None,
                 organizational_unit_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str account_filter_type: Limit deployment targets to individual accounts or include additional accounts with provided OUs. Valid values: `INTERSECTION`, `DIFFERENCE`, `UNION`, `NONE`.
        :param Sequence[_builtins.str] accounts: List of accounts to deploy stack set updates.
        :param _builtins.str accounts_url: S3 URL of the file containing the list of accounts.
        :param Sequence[_builtins.str] organizational_unit_ids: Organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
        if account_filter_type is not None:
            pulumi.set(__self__, "account_filter_type", account_filter_type)
        if accounts is not None:
            pulumi.set(__self__, "accounts", accounts)
        if accounts_url is not None:
            pulumi.set(__self__, "accounts_url", accounts_url)
        if organizational_unit_ids is not None:
            pulumi.set(__self__, "organizational_unit_ids", organizational_unit_ids)

    @_builtins.property
    @pulumi.getter(name="accountFilterType")
    def account_filter_type(self) -> Optional[_builtins.str]:
        """
        Limit deployment targets to individual accounts or include additional accounts with provided OUs. Valid values: `INTERSECTION`, `DIFFERENCE`, `UNION`, `NONE`.
        """
        return pulumi.get(self, "account_filter_type")

    @_builtins.property
    @pulumi.getter
    def accounts(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of accounts to deploy stack set updates.
        """
        return pulumi.get(self, "accounts")

    @_builtins.property
    @pulumi.getter(name="accountsUrl")
    def accounts_url(self) -> Optional[_builtins.str]:
        """
        S3 URL of the file containing the list of accounts.
        """
        return pulumi.get(self, "accounts_url")

    @_builtins.property
    @pulumi.getter(name="organizationalUnitIds")
    def organizational_unit_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Organization root ID or organizational unit (OU) IDs to which StackSets deploys.
        """
        return pulumi.get(self, "organizational_unit_ids")


@pulumi.output_type
class StackSetInstanceOperationPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrencyMode":
            suggest = "concurrency_mode"
        elif key == "failureToleranceCount":
            suggest = "failure_tolerance_count"
        elif key == "failureTolerancePercentage":
            suggest = "failure_tolerance_percentage"
        elif key == "maxConcurrentCount":
            suggest = "max_concurrent_count"
        elif key == "maxConcurrentPercentage":
            suggest = "max_concurrent_percentage"
        elif key == "regionConcurrencyType":
            suggest = "region_concurrency_type"
        elif key == "regionOrders":
            suggest = "region_orders"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetInstanceOperationPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetInstanceOperationPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetInstanceOperationPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrency_mode: Optional[_builtins.str] = None,
                 failure_tolerance_count: Optional[_builtins.int] = None,
                 failure_tolerance_percentage: Optional[_builtins.int] = None,
                 max_concurrent_count: Optional[_builtins.int] = None,
                 max_concurrent_percentage: Optional[_builtins.int] = None,
                 region_concurrency_type: Optional[_builtins.str] = None,
                 region_orders: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str concurrency_mode: Specifies how the concurrency level behaves during the operation execution. Valid values are `STRICT_FAILURE_TOLERANCE` and `SOFT_FAILURE_TOLERANCE`.
        :param _builtins.int failure_tolerance_count: Number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
        :param _builtins.int failure_tolerance_percentage: Percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
        :param _builtins.int max_concurrent_count: Maximum number of accounts in which to perform this operation at one time.
        :param _builtins.int max_concurrent_percentage: Maximum percentage of accounts in which to perform this operation at one time.
        :param _builtins.str region_concurrency_type: Concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
        :param Sequence[_builtins.str] region_orders: Order of the Regions in where you want to perform the stack operation.
        """
        if concurrency_mode is not None:
            pulumi.set(__self__, "concurrency_mode", concurrency_mode)
        if failure_tolerance_count is not None:
            pulumi.set(__self__, "failure_tolerance_count", failure_tolerance_count)
        if failure_tolerance_percentage is not None:
            pulumi.set(__self__, "failure_tolerance_percentage", failure_tolerance_percentage)
        if max_concurrent_count is not None:
            pulumi.set(__self__, "max_concurrent_count", max_concurrent_count)
        if max_concurrent_percentage is not None:
            pulumi.set(__self__, "max_concurrent_percentage", max_concurrent_percentage)
        if region_concurrency_type is not None:
            pulumi.set(__self__, "region_concurrency_type", region_concurrency_type)
        if region_orders is not None:
            pulumi.set(__self__, "region_orders", region_orders)

    @_builtins.property
    @pulumi.getter(name="concurrencyMode")
    def concurrency_mode(self) -> Optional[_builtins.str]:
        """
        Specifies how the concurrency level behaves during the operation execution. Valid values are `STRICT_FAILURE_TOLERANCE` and `SOFT_FAILURE_TOLERANCE`.
        """
        return pulumi.get(self, "concurrency_mode")

    @_builtins.property
    @pulumi.getter(name="failureToleranceCount")
    def failure_tolerance_count(self) -> Optional[_builtins.int]:
        """
        Number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
        """
        return pulumi.get(self, "failure_tolerance_count")

    @_builtins.property
    @pulumi.getter(name="failureTolerancePercentage")
    def failure_tolerance_percentage(self) -> Optional[_builtins.int]:
        """
        Percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
        """
        return pulumi.get(self, "failure_tolerance_percentage")

    @_builtins.property
    @pulumi.getter(name="maxConcurrentCount")
    def max_concurrent_count(self) -> Optional[_builtins.int]:
        """
        Maximum number of accounts in which to perform this operation at one time.
        """
        return pulumi.get(self, "max_concurrent_count")

    @_builtins.property
    @pulumi.getter(name="maxConcurrentPercentage")
    def max_concurrent_percentage(self) -> Optional[_builtins.int]:
        """
        Maximum percentage of accounts in which to perform this operation at one time.
        """
        return pulumi.get(self, "max_concurrent_percentage")

    @_builtins.property
    @pulumi.getter(name="regionConcurrencyType")
    def region_concurrency_type(self) -> Optional[_builtins.str]:
        """
        Concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time. Valid values are `SEQUENTIAL` and `PARALLEL`.
        """
        return pulumi.get(self, "region_concurrency_type")

    @_builtins.property
    @pulumi.getter(name="regionOrders")
    def region_orders(self) -> Optional[Sequence[_builtins.str]]:
        """
        Order of the Regions in where you want to perform the stack operation.
        """
        return pulumi.get(self, "region_orders")


@pulumi.output_type
class StackSetInstanceStackInstanceSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "organizationalUnitId":
            suggest = "organizational_unit_id"
        elif key == "stackId":
            suggest = "stack_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetInstanceStackInstanceSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetInstanceStackInstanceSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetInstanceStackInstanceSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: Optional[_builtins.str] = None,
                 organizational_unit_id: Optional[_builtins.str] = None,
                 stack_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str account_id: Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
        :param _builtins.str organizational_unit_id: Organizational unit ID in which the stack is deployed.
        :param _builtins.str stack_id: Stack identifier.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if organizational_unit_id is not None:
            pulumi.set(__self__, "organizational_unit_id", organizational_unit_id)
        if stack_id is not None:
            pulumi.set(__self__, "stack_id", stack_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        Target AWS Account ID to create a Stack based on the StackSet. Defaults to current account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="organizationalUnitId")
    def organizational_unit_id(self) -> Optional[_builtins.str]:
        """
        Organizational unit ID in which the stack is deployed.
        """
        return pulumi.get(self, "organizational_unit_id")

    @_builtins.property
    @pulumi.getter(name="stackId")
    def stack_id(self) -> Optional[_builtins.str]:
        """
        Stack identifier.
        """
        return pulumi.get(self, "stack_id")


@pulumi.output_type
class StackSetManagedExecution(dict):
    def __init__(__self__, *,
                 active: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool active: When set to true, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order. Default is false.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[_builtins.bool]:
        """
        When set to true, StackSets performs non-conflicting operations concurrently and queues conflicting operations. After conflicting operations finish, StackSets starts queued operations in request order. Default is false.
        """
        return pulumi.get(self, "active")


@pulumi.output_type
class StackSetOperationPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureToleranceCount":
            suggest = "failure_tolerance_count"
        elif key == "failureTolerancePercentage":
            suggest = "failure_tolerance_percentage"
        elif key == "maxConcurrentCount":
            suggest = "max_concurrent_count"
        elif key == "maxConcurrentPercentage":
            suggest = "max_concurrent_percentage"
        elif key == "regionConcurrencyType":
            suggest = "region_concurrency_type"
        elif key == "regionOrders":
            suggest = "region_orders"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StackSetOperationPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StackSetOperationPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StackSetOperationPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_tolerance_count: Optional[_builtins.int] = None,
                 failure_tolerance_percentage: Optional[_builtins.int] = None,
                 max_concurrent_count: Optional[_builtins.int] = None,
                 max_concurrent_percentage: Optional[_builtins.int] = None,
                 region_concurrency_type: Optional[_builtins.str] = None,
                 region_orders: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int failure_tolerance_count: The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
        :param _builtins.int failure_tolerance_percentage: The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
        :param _builtins.int max_concurrent_count: The maximum number of accounts in which to perform this operation at one time.
        :param _builtins.int max_concurrent_percentage: The maximum percentage of accounts in which to perform this operation at one time.
        :param _builtins.str region_concurrency_type: The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        :param Sequence[_builtins.str] region_orders: The order of the Regions in where you want to perform the stack operation.
        """
        if failure_tolerance_count is not None:
            pulumi.set(__self__, "failure_tolerance_count", failure_tolerance_count)
        if failure_tolerance_percentage is not None:
            pulumi.set(__self__, "failure_tolerance_percentage", failure_tolerance_percentage)
        if max_concurrent_count is not None:
            pulumi.set(__self__, "max_concurrent_count", max_concurrent_count)
        if max_concurrent_percentage is not None:
            pulumi.set(__self__, "max_concurrent_percentage", max_concurrent_percentage)
        if region_concurrency_type is not None:
            pulumi.set(__self__, "region_concurrency_type", region_concurrency_type)
        if region_orders is not None:
            pulumi.set(__self__, "region_orders", region_orders)

    @_builtins.property
    @pulumi.getter(name="failureToleranceCount")
    def failure_tolerance_count(self) -> Optional[_builtins.int]:
        """
        The number of accounts, per Region, for which this operation can fail before AWS CloudFormation stops the operation in that Region.
        """
        return pulumi.get(self, "failure_tolerance_count")

    @_builtins.property
    @pulumi.getter(name="failureTolerancePercentage")
    def failure_tolerance_percentage(self) -> Optional[_builtins.int]:
        """
        The percentage of accounts, per Region, for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
        """
        return pulumi.get(self, "failure_tolerance_percentage")

    @_builtins.property
    @pulumi.getter(name="maxConcurrentCount")
    def max_concurrent_count(self) -> Optional[_builtins.int]:
        """
        The maximum number of accounts in which to perform this operation at one time.
        """
        return pulumi.get(self, "max_concurrent_count")

    @_builtins.property
    @pulumi.getter(name="maxConcurrentPercentage")
    def max_concurrent_percentage(self) -> Optional[_builtins.int]:
        """
        The maximum percentage of accounts in which to perform this operation at one time.
        """
        return pulumi.get(self, "max_concurrent_percentage")

    @_builtins.property
    @pulumi.getter(name="regionConcurrencyType")
    def region_concurrency_type(self) -> Optional[_builtins.str]:
        """
        The concurrency type of deploying StackSets operations in Regions, could be in parallel or one Region at a time.
        """
        return pulumi.get(self, "region_concurrency_type")

    @_builtins.property
    @pulumi.getter(name="regionOrders")
    def region_orders(self) -> Optional[Sequence[_builtins.str]]:
        """
        The order of the Regions in where you want to perform the stack operation.
        """
        return pulumi.get(self, "region_orders")


@pulumi.output_type
class GetCloudFormationTypeLoggingConfigResult(dict):
    def __init__(__self__, *,
                 log_group_name: _builtins.str,
                 log_role_arn: _builtins.str):
        """
        :param _builtins.str log_group_name: Name of the CloudWatch Log Group where CloudFormation sends error logging information when invoking the type's handlers.
        :param _builtins.str log_role_arn: ARN of the IAM Role CloudFormation assumes when sending error logging information to CloudWatch Logs.
        """
        pulumi.set(__self__, "log_group_name", log_group_name)
        pulumi.set(__self__, "log_role_arn", log_role_arn)

    @_builtins.property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> _builtins.str:
        """
        Name of the CloudWatch Log Group where CloudFormation sends error logging information when invoking the type's handlers.
        """
        return pulumi.get(self, "log_group_name")

    @_builtins.property
    @pulumi.getter(name="logRoleArn")
    def log_role_arn(self) -> _builtins.str:
        """
        ARN of the IAM Role CloudFormation assumes when sending error logging information to CloudWatch Logs.
        """
        return pulumi.get(self, "log_role_arn")


