# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DistributionArgs', 'Distribution']

@pulumi.input_type
class DistributionArgs:
    def __init__(__self__, *,
                 default_cache_behavior: pulumi.Input['DistributionDefaultCacheBehaviorArgs'],
                 enabled: pulumi.Input[_builtins.bool],
                 origins: pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]],
                 restrictions: pulumi.Input['DistributionRestrictionsArgs'],
                 viewer_certificate: pulumi.Input['DistributionViewerCertificateArgs'],
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 anycast_ip_list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 continuous_deployment_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]]] = None,
                 default_root_object: Optional[pulumi.Input[_builtins.str]] = None,
                 http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_config: Optional[pulumi.Input['DistributionLoggingConfigArgs']] = None,
                 ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorArgs']]]] = None,
                 origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]]] = None,
                 price_class: Optional[pulumi.Input[_builtins.str]] = None,
                 retain_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 staging: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 web_acl_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Distribution resource.
        :param pulumi.Input['DistributionDefaultCacheBehaviorArgs'] default_cache_behavior: Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
        :param pulumi.Input[_builtins.bool] enabled: Whether the distribution is enabled to accept end user requests for content.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]] origins: One or more origins for this distribution (multiples allowed).
        :param pulumi.Input['DistributionRestrictionsArgs'] restrictions: The restriction configuration for this distribution (maximum one).
        :param pulumi.Input['DistributionViewerCertificateArgs'] viewer_certificate: The SSL configuration for this distribution (maximum one).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: Extra CNAMEs (alternate domain names), if any, for this distribution.
        :param pulumi.Input[_builtins.str] anycast_ip_list_id: ID of the Anycast static IP list that is associated with the distribution.
        :param pulumi.Input[_builtins.str] comment: Any comments you want to include about the distribution.
        :param pulumi.Input[_builtins.str] continuous_deployment_policy_id: Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `cloudfront.ContinuousDeploymentPolicy` resource for additional details.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]] custom_error_responses: One or more custom error response elements (multiples allowed).
        :param pulumi.Input[_builtins.str] default_root_object: Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        :param pulumi.Input[_builtins.str] http_version: Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
        :param pulumi.Input[_builtins.bool] is_ipv6_enabled: Whether the IPv6 is enabled for the distribution.
        :param pulumi.Input['DistributionLoggingConfigArgs'] logging_config: The logging configuration that controls how logs are written to your distribution (maximum one). AWS provides two versions of access logs for CloudFront: Legacy and v2. This argument configures legacy version standard logs.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorArgs']]] ordered_cache_behaviors: Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]] origin_groups: One or more origin_group for this distribution (multiples allowed).
        :param pulumi.Input[_builtins.str] price_class: Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
        :param pulumi.Input[_builtins.bool] retain_on_delete: Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
        :param pulumi.Input[_builtins.bool] staging: A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.bool] wait_for_deployment: If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
        :param pulumi.Input[_builtins.str] web_acl_id: Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
        """
        pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "origins", origins)
        pulumi.set(__self__, "restrictions", restrictions)
        pulumi.set(__self__, "viewer_certificate", viewer_certificate)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if anycast_ip_list_id is not None:
            pulumi.set(__self__, "anycast_ip_list_id", anycast_ip_list_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if continuous_deployment_policy_id is not None:
            pulumi.set(__self__, "continuous_deployment_policy_id", continuous_deployment_policy_id)
        if custom_error_responses is not None:
            pulumi.set(__self__, "custom_error_responses", custom_error_responses)
        if default_root_object is not None:
            pulumi.set(__self__, "default_root_object", default_root_object)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if is_ipv6_enabled is not None:
            pulumi.set(__self__, "is_ipv6_enabled", is_ipv6_enabled)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if ordered_cache_behaviors is not None:
            pulumi.set(__self__, "ordered_cache_behaviors", ordered_cache_behaviors)
        if origin_groups is not None:
            pulumi.set(__self__, "origin_groups", origin_groups)
        if price_class is not None:
            pulumi.set(__self__, "price_class", price_class)
        if retain_on_delete is not None:
            pulumi.set(__self__, "retain_on_delete", retain_on_delete)
        if staging is not None:
            pulumi.set(__self__, "staging", staging)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @_builtins.property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> pulumi.Input['DistributionDefaultCacheBehaviorArgs']:
        """
        Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
        """
        return pulumi.get(self, "default_cache_behavior")

    @default_cache_behavior.setter
    def default_cache_behavior(self, value: pulumi.Input['DistributionDefaultCacheBehaviorArgs']):
        pulumi.set(self, "default_cache_behavior", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the distribution is enabled to accept end user requests for content.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def origins(self) -> pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]]:
        """
        One or more origins for this distribution (multiples allowed).
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]]):
        pulumi.set(self, "origins", value)

    @_builtins.property
    @pulumi.getter
    def restrictions(self) -> pulumi.Input['DistributionRestrictionsArgs']:
        """
        The restriction configuration for this distribution (maximum one).
        """
        return pulumi.get(self, "restrictions")

    @restrictions.setter
    def restrictions(self, value: pulumi.Input['DistributionRestrictionsArgs']):
        pulumi.set(self, "restrictions", value)

    @_builtins.property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> pulumi.Input['DistributionViewerCertificateArgs']:
        """
        The SSL configuration for this distribution (maximum one).
        """
        return pulumi.get(self, "viewer_certificate")

    @viewer_certificate.setter
    def viewer_certificate(self, value: pulumi.Input['DistributionViewerCertificateArgs']):
        pulumi.set(self, "viewer_certificate", value)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Extra CNAMEs (alternate domain names), if any, for this distribution.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "aliases", value)

    @_builtins.property
    @pulumi.getter(name="anycastIpListId")
    def anycast_ip_list_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Anycast static IP list that is associated with the distribution.
        """
        return pulumi.get(self, "anycast_ip_list_id")

    @anycast_ip_list_id.setter
    def anycast_ip_list_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "anycast_ip_list_id", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any comments you want to include about the distribution.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="continuousDeploymentPolicyId")
    def continuous_deployment_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `cloudfront.ContinuousDeploymentPolicy` resource for additional details.
        """
        return pulumi.get(self, "continuous_deployment_policy_id")

    @continuous_deployment_policy_id.setter
    def continuous_deployment_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "continuous_deployment_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]]]:
        """
        One or more custom error response elements (multiples allowed).
        """
        return pulumi.get(self, "custom_error_responses")

    @custom_error_responses.setter
    def custom_error_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]]]):
        pulumi.set(self, "custom_error_responses", value)

    @_builtins.property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        """
        return pulumi.get(self, "default_root_object")

    @default_root_object.setter
    def default_root_object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_root_object", value)

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
        """
        return pulumi.get(self, "http_version")

    @http_version.setter
    def http_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_version", value)

    @_builtins.property
    @pulumi.getter(name="isIpv6Enabled")
    def is_ipv6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IPv6 is enabled for the distribution.
        """
        return pulumi.get(self, "is_ipv6_enabled")

    @is_ipv6_enabled.setter
    def is_ipv6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ipv6_enabled", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['DistributionLoggingConfigArgs']]:
        """
        The logging configuration that controls how logs are written to your distribution (maximum one). AWS provides two versions of access logs for CloudFront: Legacy and v2. This argument configures legacy version standard logs.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['DistributionLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter(name="orderedCacheBehaviors")
    def ordered_cache_behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorArgs']]]]:
        """
        Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
        """
        return pulumi.get(self, "ordered_cache_behaviors")

    @ordered_cache_behaviors.setter
    def ordered_cache_behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorArgs']]]]):
        pulumi.set(self, "ordered_cache_behaviors", value)

    @_builtins.property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]]]:
        """
        One or more origin_group for this distribution (multiples allowed).
        """
        return pulumi.get(self, "origin_groups")

    @origin_groups.setter
    def origin_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]]]):
        pulumi.set(self, "origin_groups", value)

    @_builtins.property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
        """
        return pulumi.get(self, "price_class")

    @price_class.setter
    def price_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "price_class", value)

    @_builtins.property
    @pulumi.getter(name="retainOnDelete")
    def retain_on_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
        """
        return pulumi.get(self, "retain_on_delete")

    @retain_on_delete.setter
    def retain_on_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_on_delete", value)

    @_builtins.property
    @pulumi.getter
    def staging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
        """
        return pulumi.get(self, "staging")

    @staging.setter
    def staging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "staging", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_deployment", value)

    @_builtins.property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
        """
        return pulumi.get(self, "web_acl_id")

    @web_acl_id.setter
    def web_acl_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_acl_id", value)


@pulumi.input_type
class _DistributionState:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 anycast_ip_list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 caller_reference: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 continuous_deployment_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]]] = None,
                 default_cache_behavior: Optional[pulumi.Input['DistributionDefaultCacheBehaviorArgs']] = None,
                 default_root_object: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 hosted_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 in_progress_validation_batches: Optional[pulumi.Input[_builtins.int]] = None,
                 is_ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['DistributionLoggingConfigArgs']] = None,
                 ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorArgs']]]] = None,
                 origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]]] = None,
                 price_class: Optional[pulumi.Input[_builtins.str]] = None,
                 restrictions: Optional[pulumi.Input['DistributionRestrictionsArgs']] = None,
                 retain_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 staging: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_key_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedKeyGroupArgs']]]] = None,
                 trusted_signers: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedSignerArgs']]]] = None,
                 viewer_certificate: Optional[pulumi.Input['DistributionViewerCertificateArgs']] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 web_acl_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Distribution resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: Extra CNAMEs (alternate domain names), if any, for this distribution.
        :param pulumi.Input[_builtins.str] anycast_ip_list_id: ID of the Anycast static IP list that is associated with the distribution.
        :param pulumi.Input[_builtins.str] arn: ARN for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your AWS account ID.
        :param pulumi.Input[_builtins.str] caller_reference: Internal value used by CloudFront to allow future updates to the distribution configuration.
        :param pulumi.Input[_builtins.str] comment: Any comments you want to include about the distribution.
        :param pulumi.Input[_builtins.str] continuous_deployment_policy_id: Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `cloudfront.ContinuousDeploymentPolicy` resource for additional details.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]] custom_error_responses: One or more custom error response elements (multiples allowed).
        :param pulumi.Input['DistributionDefaultCacheBehaviorArgs'] default_cache_behavior: Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
        :param pulumi.Input[_builtins.str] default_root_object: Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        :param pulumi.Input[_builtins.str] domain_name: Domain name corresponding to the distribution. For example: `d604721fxaaqy9.cloudfront.net`.
        :param pulumi.Input[_builtins.bool] enabled: Whether the distribution is enabled to accept end user requests for content.
        :param pulumi.Input[_builtins.str] etag: Current version of the distribution's information. For example: `E2QWRUHAPOMQZL`.
        :param pulumi.Input[_builtins.str] hosted_zone_id: CloudFront Route 53 zone ID that can be used to route an [Alias Resource Record Set](http://docs.aws.amazon.com/Route53/latest/APIReference/CreateAliasRRSAPI.html) to. This attribute is simply an alias for the zone ID `Z2FDTNDATAQYW2`.
        :param pulumi.Input[_builtins.str] http_version: Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
        :param pulumi.Input[_builtins.int] in_progress_validation_batches: Number of invalidation batches currently in progress.
        :param pulumi.Input[_builtins.bool] is_ipv6_enabled: Whether the IPv6 is enabled for the distribution.
        :param pulumi.Input[_builtins.str] last_modified_time: Date and time the distribution was last modified.
        :param pulumi.Input['DistributionLoggingConfigArgs'] logging_config: The logging configuration that controls how logs are written to your distribution (maximum one). AWS provides two versions of access logs for CloudFront: Legacy and v2. This argument configures legacy version standard logs.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorArgs']]] ordered_cache_behaviors: Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]] origin_groups: One or more origin_group for this distribution (multiples allowed).
        :param pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]] origins: One or more origins for this distribution (multiples allowed).
        :param pulumi.Input[_builtins.str] price_class: Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
        :param pulumi.Input['DistributionRestrictionsArgs'] restrictions: The restriction configuration for this distribution (maximum one).
        :param pulumi.Input[_builtins.bool] retain_on_delete: Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
        :param pulumi.Input[_builtins.bool] staging: A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
        :param pulumi.Input[_builtins.str] status: Current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionTrustedKeyGroupArgs']]] trusted_key_groups: List of nested attributes for active trusted key groups, if the distribution is set up to serve private content with signed URLs.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionTrustedSignerArgs']]] trusted_signers: List of nested attributes for active trusted signers, if the distribution is set up to serve private content with signed URLs.
        :param pulumi.Input['DistributionViewerCertificateArgs'] viewer_certificate: The SSL configuration for this distribution (maximum one).
        :param pulumi.Input[_builtins.bool] wait_for_deployment: If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
        :param pulumi.Input[_builtins.str] web_acl_id: Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if anycast_ip_list_id is not None:
            pulumi.set(__self__, "anycast_ip_list_id", anycast_ip_list_id)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if caller_reference is not None:
            pulumi.set(__self__, "caller_reference", caller_reference)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if continuous_deployment_policy_id is not None:
            pulumi.set(__self__, "continuous_deployment_policy_id", continuous_deployment_policy_id)
        if custom_error_responses is not None:
            pulumi.set(__self__, "custom_error_responses", custom_error_responses)
        if default_cache_behavior is not None:
            pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        if default_root_object is not None:
            pulumi.set(__self__, "default_root_object", default_root_object)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if in_progress_validation_batches is not None:
            pulumi.set(__self__, "in_progress_validation_batches", in_progress_validation_batches)
        if is_ipv6_enabled is not None:
            pulumi.set(__self__, "is_ipv6_enabled", is_ipv6_enabled)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if ordered_cache_behaviors is not None:
            pulumi.set(__self__, "ordered_cache_behaviors", ordered_cache_behaviors)
        if origin_groups is not None:
            pulumi.set(__self__, "origin_groups", origin_groups)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if price_class is not None:
            pulumi.set(__self__, "price_class", price_class)
        if restrictions is not None:
            pulumi.set(__self__, "restrictions", restrictions)
        if retain_on_delete is not None:
            pulumi.set(__self__, "retain_on_delete", retain_on_delete)
        if staging is not None:
            pulumi.set(__self__, "staging", staging)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if trusted_key_groups is not None:
            pulumi.set(__self__, "trusted_key_groups", trusted_key_groups)
        if trusted_signers is not None:
            pulumi.set(__self__, "trusted_signers", trusted_signers)
        if viewer_certificate is not None:
            pulumi.set(__self__, "viewer_certificate", viewer_certificate)
        if wait_for_deployment is not None:
            pulumi.set(__self__, "wait_for_deployment", wait_for_deployment)
        if web_acl_id is not None:
            pulumi.set(__self__, "web_acl_id", web_acl_id)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Extra CNAMEs (alternate domain names), if any, for this distribution.
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "aliases", value)

    @_builtins.property
    @pulumi.getter(name="anycastIpListId")
    def anycast_ip_list_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Anycast static IP list that is associated with the distribution.
        """
        return pulumi.get(self, "anycast_ip_list_id")

    @anycast_ip_list_id.setter
    def anycast_ip_list_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "anycast_ip_list_id", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your AWS account ID.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Internal value used by CloudFront to allow future updates to the distribution configuration.
        """
        return pulumi.get(self, "caller_reference")

    @caller_reference.setter
    def caller_reference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "caller_reference", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any comments you want to include about the distribution.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="continuousDeploymentPolicyId")
    def continuous_deployment_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `cloudfront.ContinuousDeploymentPolicy` resource for additional details.
        """
        return pulumi.get(self, "continuous_deployment_policy_id")

    @continuous_deployment_policy_id.setter
    def continuous_deployment_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "continuous_deployment_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]]]:
        """
        One or more custom error response elements (multiples allowed).
        """
        return pulumi.get(self, "custom_error_responses")

    @custom_error_responses.setter
    def custom_error_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCustomErrorResponseArgs']]]]):
        pulumi.set(self, "custom_error_responses", value)

    @_builtins.property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> Optional[pulumi.Input['DistributionDefaultCacheBehaviorArgs']]:
        """
        Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
        """
        return pulumi.get(self, "default_cache_behavior")

    @default_cache_behavior.setter
    def default_cache_behavior(self, value: Optional[pulumi.Input['DistributionDefaultCacheBehaviorArgs']]):
        pulumi.set(self, "default_cache_behavior", value)

    @_builtins.property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        """
        return pulumi.get(self, "default_root_object")

    @default_root_object.setter
    def default_root_object(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_root_object", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Domain name corresponding to the distribution. For example: `d604721fxaaqy9.cloudfront.net`.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the distribution is enabled to accept end user requests for content.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current version of the distribution's information. For example: `E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CloudFront Route 53 zone ID that can be used to route an [Alias Resource Record Set](http://docs.aws.amazon.com/Route53/latest/APIReference/CreateAliasRRSAPI.html) to. This attribute is simply an alias for the zone ID `Z2FDTNDATAQYW2`.
        """
        return pulumi.get(self, "hosted_zone_id")

    @hosted_zone_id.setter
    def hosted_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hosted_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
        """
        return pulumi.get(self, "http_version")

    @http_version.setter
    def http_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_version", value)

    @_builtins.property
    @pulumi.getter(name="inProgressValidationBatches")
    def in_progress_validation_batches(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of invalidation batches currently in progress.
        """
        return pulumi.get(self, "in_progress_validation_batches")

    @in_progress_validation_batches.setter
    def in_progress_validation_batches(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "in_progress_validation_batches", value)

    @_builtins.property
    @pulumi.getter(name="isIpv6Enabled")
    def is_ipv6_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IPv6 is enabled for the distribution.
        """
        return pulumi.get(self, "is_ipv6_enabled")

    @is_ipv6_enabled.setter
    def is_ipv6_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_ipv6_enabled", value)

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time the distribution was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @last_modified_time.setter
    def last_modified_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modified_time", value)

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['DistributionLoggingConfigArgs']]:
        """
        The logging configuration that controls how logs are written to your distribution (maximum one). AWS provides two versions of access logs for CloudFront: Legacy and v2. This argument configures legacy version standard logs.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['DistributionLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @_builtins.property
    @pulumi.getter(name="orderedCacheBehaviors")
    def ordered_cache_behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorArgs']]]]:
        """
        Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
        """
        return pulumi.get(self, "ordered_cache_behaviors")

    @ordered_cache_behaviors.setter
    def ordered_cache_behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOrderedCacheBehaviorArgs']]]]):
        pulumi.set(self, "ordered_cache_behaviors", value)

    @_builtins.property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]]]:
        """
        One or more origin_group for this distribution (multiples allowed).
        """
        return pulumi.get(self, "origin_groups")

    @origin_groups.setter
    def origin_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginGroupArgs']]]]):
        pulumi.set(self, "origin_groups", value)

    @_builtins.property
    @pulumi.getter
    def origins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]]]:
        """
        One or more origins for this distribution (multiples allowed).
        """
        return pulumi.get(self, "origins")

    @origins.setter
    def origins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionOriginArgs']]]]):
        pulumi.set(self, "origins", value)

    @_builtins.property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
        """
        return pulumi.get(self, "price_class")

    @price_class.setter
    def price_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "price_class", value)

    @_builtins.property
    @pulumi.getter
    def restrictions(self) -> Optional[pulumi.Input['DistributionRestrictionsArgs']]:
        """
        The restriction configuration for this distribution (maximum one).
        """
        return pulumi.get(self, "restrictions")

    @restrictions.setter
    def restrictions(self, value: Optional[pulumi.Input['DistributionRestrictionsArgs']]):
        pulumi.set(self, "restrictions", value)

    @_builtins.property
    @pulumi.getter(name="retainOnDelete")
    def retain_on_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
        """
        return pulumi.get(self, "retain_on_delete")

    @retain_on_delete.setter
    def retain_on_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retain_on_delete", value)

    @_builtins.property
    @pulumi.getter
    def staging(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
        """
        return pulumi.get(self, "staging")

    @staging.setter
    def staging(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "staging", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedKeyGroupArgs']]]]:
        """
        List of nested attributes for active trusted key groups, if the distribution is set up to serve private content with signed URLs.
        """
        return pulumi.get(self, "trusted_key_groups")

    @trusted_key_groups.setter
    def trusted_key_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedKeyGroupArgs']]]]):
        pulumi.set(self, "trusted_key_groups", value)

    @_builtins.property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedSignerArgs']]]]:
        """
        List of nested attributes for active trusted signers, if the distribution is set up to serve private content with signed URLs.
        """
        return pulumi.get(self, "trusted_signers")

    @trusted_signers.setter
    def trusted_signers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTrustedSignerArgs']]]]):
        pulumi.set(self, "trusted_signers", value)

    @_builtins.property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> Optional[pulumi.Input['DistributionViewerCertificateArgs']]:
        """
        The SSL configuration for this distribution (maximum one).
        """
        return pulumi.get(self, "viewer_certificate")

    @viewer_certificate.setter
    def viewer_certificate(self, value: Optional[pulumi.Input['DistributionViewerCertificateArgs']]):
        pulumi.set(self, "viewer_certificate", value)

    @_builtins.property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @wait_for_deployment.setter
    def wait_for_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_deployment", value)

    @_builtins.property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
        """
        return pulumi.get(self, "web_acl_id")

    @web_acl_id.setter
    def web_acl_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "web_acl_id", value)


@pulumi.type_token("aws:cloudfront/distribution:Distribution")
class Distribution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 anycast_ip_list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 continuous_deployment_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionCustomErrorResponseArgs', 'DistributionCustomErrorResponseArgsDict']]]]] = None,
                 default_cache_behavior: Optional[pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']]] = None,
                 default_root_object: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_config: Optional[pulumi.Input[Union['DistributionLoggingConfigArgs', 'DistributionLoggingConfigArgsDict']]] = None,
                 ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionOrderedCacheBehaviorArgs', 'DistributionOrderedCacheBehaviorArgsDict']]]]] = None,
                 origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginGroupArgs', 'DistributionOriginGroupArgsDict']]]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']]]]] = None,
                 price_class: Optional[pulumi.Input[_builtins.str]] = None,
                 restrictions: Optional[pulumi.Input[Union['DistributionRestrictionsArgs', 'DistributionRestrictionsArgsDict']]] = None,
                 retain_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 staging: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 viewer_certificate: Optional[pulumi.Input[Union['DistributionViewerCertificateArgs', 'DistributionViewerCertificateArgsDict']]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 web_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates an Amazon CloudFront web distribution.

        For information about CloudFront distributions, see the [Amazon CloudFront Developer Guide](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html). For specific information about creating CloudFront web distributions, see the [POST Distribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html) page in the Amazon CloudFront API Reference.

        > **NOTE:** CloudFront distributions take about 15 minutes to reach a deployed state after creation or modification. During this time, deletes to resources will be blocked. If you need to delete a distribution that is enabled and you do not want to wait, you need to use the `retain_on_delete` flag.

        ## Example Usage

        ### S3 Origin

        The example below creates a CloudFront distribution with an S3 origin.

        ```python
        import pulumi
        import pulumi_aws as aws

        b = aws.s3.Bucket("b",
            bucket="mybucket",
            tags={
                "Name": "My bucket",
            })
        b_acl = aws.s3.BucketAcl("b_acl",
            bucket=b.id,
            acl="private")
        s3_origin_id = "myS3Origin"
        s3_distribution = aws.cloudfront.Distribution("s3_distribution",
            origins=[{
                "domain_name": b.bucket_regional_domain_name,
                "origin_access_control_id": default["id"],
                "origin_id": s3_origin_id,
            }],
            enabled=True,
            is_ipv6_enabled=True,
            comment="Some comment",
            default_root_object="index.html",
            logging_config={
                "include_cookies": False,
                "bucket": "mylogs.s3.amazonaws.com",
                "prefix": "myprefix",
            },
            aliases=[
                "mysite.example.com",
                "yoursite.example.com",
            ],
            default_cache_behavior={
                "allowed_methods": [
                    "DELETE",
                    "GET",
                    "HEAD",
                    "OPTIONS",
                    "PATCH",
                    "POST",
                    "PUT",
                ],
                "cached_methods": [
                    "GET",
                    "HEAD",
                ],
                "target_origin_id": s3_origin_id,
                "forwarded_values": {
                    "query_string": False,
                    "cookies": {
                        "forward": "none",
                    },
                },
                "viewer_protocol_policy": "allow-all",
                "min_ttl": 0,
                "default_ttl": 3600,
                "max_ttl": 86400,
            },
            ordered_cache_behaviors=[
                {
                    "path_pattern": "/content/immutable/*",
                    "allowed_methods": [
                        "GET",
                        "HEAD",
                        "OPTIONS",
                    ],
                    "cached_methods": [
                        "GET",
                        "HEAD",
                        "OPTIONS",
                    ],
                    "target_origin_id": s3_origin_id,
                    "forwarded_values": {
                        "query_string": False,
                        "headers": ["Origin"],
                        "cookies": {
                            "forward": "none",
                        },
                    },
                    "min_ttl": 0,
                    "default_ttl": 86400,
                    "max_ttl": 31536000,
                    "compress": True,
                    "viewer_protocol_policy": "redirect-to-https",
                },
                {
                    "path_pattern": "/content/*",
                    "allowed_methods": [
                        "GET",
                        "HEAD",
                        "OPTIONS",
                    ],
                    "cached_methods": [
                        "GET",
                        "HEAD",
                    ],
                    "target_origin_id": s3_origin_id,
                    "forwarded_values": {
                        "query_string": False,
                        "cookies": {
                            "forward": "none",
                        },
                    },
                    "min_ttl": 0,
                    "default_ttl": 3600,
                    "max_ttl": 86400,
                    "compress": True,
                    "viewer_protocol_policy": "redirect-to-https",
                },
            ],
            price_class="PriceClass_200",
            restrictions={
                "geo_restriction": {
                    "restriction_type": "whitelist",
                    "locations": [
                        "US",
                        "CA",
                        "GB",
                        "DE",
                    ],
                },
            },
            tags={
                "Environment": "production",
            },
            viewer_certificate={
                "cloudfront_default_certificate": True,
            })
        ```

        ### With Failover Routing

        The example below creates a CloudFront distribution with an origin group for failover routing.

        ```python
        import pulumi
        import pulumi_aws as aws

        s3_distribution = aws.cloudfront.Distribution("s3_distribution",
            origin_groups=[{
                "origin_id": "groupS3",
                "failover_criteria": {
                    "status_codes": [
                        403,
                        404,
                        500,
                        502,
                    ],
                },
                "members": [
                    {
                        "origin_id": "primaryS3",
                    },
                    {
                        "origin_id": "failoverS3",
                    },
                ],
            }],
            origins=[
                {
                    "domain_name": primary["bucketRegionalDomainName"],
                    "origin_id": "primaryS3",
                    "s3_origin_config": {
                        "origin_access_identity": default["cloudfrontAccessIdentityPath"],
                    },
                },
                {
                    "domain_name": failover["bucketRegionalDomainName"],
                    "origin_id": "failoverS3",
                    "s3_origin_config": {
                        "origin_access_identity": default["cloudfrontAccessIdentityPath"],
                    },
                },
            ],
            default_cache_behavior={
                "target_origin_id": "groupS3",
            })
        ```

        ### With Managed Caching Policy

        The example below creates a CloudFront distribution with an [AWS managed caching policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        s3_origin_id = "myS3Origin"
        s3_distribution = aws.cloudfront.Distribution("s3_distribution",
            origins=[{
                "domain_name": primary["bucketRegionalDomainName"],
                "origin_id": "myS3Origin",
                "s3_origin_config": {
                    "origin_access_identity": default["cloudfrontAccessIdentityPath"],
                },
            }],
            enabled=True,
            is_ipv6_enabled=True,
            comment="Some comment",
            default_root_object="index.html",
            default_cache_behavior={
                "cache_policy_id": "4135ea2d-6df8-44a3-9df3-4b5a84be39ad",
                "allowed_methods": [
                    "GET",
                    "HEAD",
                    "OPTIONS",
                ],
                "cached_methods": [
                    "GET",
                    "HEAD",
                ],
                "target_origin_id": s3_origin_id,
                "viewer_protocol_policy": "allow-all",
            },
            restrictions={
                "geo_restriction": {
                    "restriction_type": "whitelist",
                    "locations": [
                        "US",
                        "CA",
                        "GB",
                        "DE",
                    ],
                },
            },
            viewer_certificate={
                "cloudfront_default_certificate": True,
            })
        ```

        ### With V2 logging to S3

        The example below creates a CloudFront distribution with [standard logging V2 to S3](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/standard-logging.html#enable-access-logging-api).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.Distribution("example")
        example_log_delivery_source = aws.cloudwatch.LogDeliverySource("example",
            region="us-east-1",
            name="example",
            log_type="ACCESS_LOGS",
            resource_arn=example.arn)
        example_bucket = aws.s3.Bucket("example",
            bucket="testbucket",
            force_destroy=True)
        example_log_delivery_destination = aws.cloudwatch.LogDeliveryDestination("example",
            region="us-east-1",
            name="s3-destination",
            output_format="parquet",
            delivery_destination_configuration={
                "destination_resource_arn": example_bucket.arn.apply(lambda arn: f"{arn}/prefix"),
            })
        example_log_delivery = aws.cloudwatch.LogDelivery("example",
            region="us-east-1",
            delivery_source_name=example_log_delivery_source.name,
            delivery_destination_arn=example_log_delivery_destination.arn,
            s3_delivery_configurations=[{
                "suffix_path": "/123456678910/{DistributionId}/{yyyy}/{MM}/{dd}/{HH}",
            }])
        ```

        ### With V2 logging to Data Firehose

        The example below creates a CloudFront distribution with [standard logging V2 to Data Firehose](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/standard-logging.html#enable-access-logging-api).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.Distribution("example")
        cloudfront_logs = aws.kinesis.FirehoseDeliveryStream("cloudfront_logs",
            region="us-east-1",
            tags={
                "LogDeliveryEnabled": "true",
            })
        example_log_delivery_source = aws.cloudwatch.LogDeliverySource("example",
            region="us-east-1",
            name="cloudfront-logs-source",
            log_type="ACCESS_LOGS",
            resource_arn=example.arn)
        example_log_delivery_destination = aws.cloudwatch.LogDeliveryDestination("example",
            region="us-east-1",
            name="firehose-destination",
            output_format="json",
            delivery_destination_configuration={
                "destination_resource_arn": cloudfront_logs.arn,
            })
        example_log_delivery = aws.cloudwatch.LogDelivery("example",
            region="us-east-1",
            delivery_source_name=example_log_delivery_source.name,
            delivery_destination_arn=example_log_delivery_destination.arn)
        ```

        ## Import

        Using `pulumi import`, import CloudFront Distributions using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/distribution:Distribution distribution E74FTE3EXAMPLE
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: Extra CNAMEs (alternate domain names), if any, for this distribution.
        :param pulumi.Input[_builtins.str] anycast_ip_list_id: ID of the Anycast static IP list that is associated with the distribution.
        :param pulumi.Input[_builtins.str] comment: Any comments you want to include about the distribution.
        :param pulumi.Input[_builtins.str] continuous_deployment_policy_id: Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `cloudfront.ContinuousDeploymentPolicy` resource for additional details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionCustomErrorResponseArgs', 'DistributionCustomErrorResponseArgsDict']]]] custom_error_responses: One or more custom error response elements (multiples allowed).
        :param pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']] default_cache_behavior: Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
        :param pulumi.Input[_builtins.str] default_root_object: Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        :param pulumi.Input[_builtins.bool] enabled: Whether the distribution is enabled to accept end user requests for content.
        :param pulumi.Input[_builtins.str] http_version: Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
        :param pulumi.Input[_builtins.bool] is_ipv6_enabled: Whether the IPv6 is enabled for the distribution.
        :param pulumi.Input[Union['DistributionLoggingConfigArgs', 'DistributionLoggingConfigArgsDict']] logging_config: The logging configuration that controls how logs are written to your distribution (maximum one). AWS provides two versions of access logs for CloudFront: Legacy and v2. This argument configures legacy version standard logs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionOrderedCacheBehaviorArgs', 'DistributionOrderedCacheBehaviorArgsDict']]]] ordered_cache_behaviors: Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginGroupArgs', 'DistributionOriginGroupArgsDict']]]] origin_groups: One or more origin_group for this distribution (multiples allowed).
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']]]] origins: One or more origins for this distribution (multiples allowed).
        :param pulumi.Input[_builtins.str] price_class: Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
        :param pulumi.Input[Union['DistributionRestrictionsArgs', 'DistributionRestrictionsArgsDict']] restrictions: The restriction configuration for this distribution (maximum one).
        :param pulumi.Input[_builtins.bool] retain_on_delete: Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
        :param pulumi.Input[_builtins.bool] staging: A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['DistributionViewerCertificateArgs', 'DistributionViewerCertificateArgsDict']] viewer_certificate: The SSL configuration for this distribution (maximum one).
        :param pulumi.Input[_builtins.bool] wait_for_deployment: If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
        :param pulumi.Input[_builtins.str] web_acl_id: Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DistributionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Amazon CloudFront web distribution.

        For information about CloudFront distributions, see the [Amazon CloudFront Developer Guide](http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Introduction.html). For specific information about creating CloudFront web distributions, see the [POST Distribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html) page in the Amazon CloudFront API Reference.

        > **NOTE:** CloudFront distributions take about 15 minutes to reach a deployed state after creation or modification. During this time, deletes to resources will be blocked. If you need to delete a distribution that is enabled and you do not want to wait, you need to use the `retain_on_delete` flag.

        ## Example Usage

        ### S3 Origin

        The example below creates a CloudFront distribution with an S3 origin.

        ```python
        import pulumi
        import pulumi_aws as aws

        b = aws.s3.Bucket("b",
            bucket="mybucket",
            tags={
                "Name": "My bucket",
            })
        b_acl = aws.s3.BucketAcl("b_acl",
            bucket=b.id,
            acl="private")
        s3_origin_id = "myS3Origin"
        s3_distribution = aws.cloudfront.Distribution("s3_distribution",
            origins=[{
                "domain_name": b.bucket_regional_domain_name,
                "origin_access_control_id": default["id"],
                "origin_id": s3_origin_id,
            }],
            enabled=True,
            is_ipv6_enabled=True,
            comment="Some comment",
            default_root_object="index.html",
            logging_config={
                "include_cookies": False,
                "bucket": "mylogs.s3.amazonaws.com",
                "prefix": "myprefix",
            },
            aliases=[
                "mysite.example.com",
                "yoursite.example.com",
            ],
            default_cache_behavior={
                "allowed_methods": [
                    "DELETE",
                    "GET",
                    "HEAD",
                    "OPTIONS",
                    "PATCH",
                    "POST",
                    "PUT",
                ],
                "cached_methods": [
                    "GET",
                    "HEAD",
                ],
                "target_origin_id": s3_origin_id,
                "forwarded_values": {
                    "query_string": False,
                    "cookies": {
                        "forward": "none",
                    },
                },
                "viewer_protocol_policy": "allow-all",
                "min_ttl": 0,
                "default_ttl": 3600,
                "max_ttl": 86400,
            },
            ordered_cache_behaviors=[
                {
                    "path_pattern": "/content/immutable/*",
                    "allowed_methods": [
                        "GET",
                        "HEAD",
                        "OPTIONS",
                    ],
                    "cached_methods": [
                        "GET",
                        "HEAD",
                        "OPTIONS",
                    ],
                    "target_origin_id": s3_origin_id,
                    "forwarded_values": {
                        "query_string": False,
                        "headers": ["Origin"],
                        "cookies": {
                            "forward": "none",
                        },
                    },
                    "min_ttl": 0,
                    "default_ttl": 86400,
                    "max_ttl": 31536000,
                    "compress": True,
                    "viewer_protocol_policy": "redirect-to-https",
                },
                {
                    "path_pattern": "/content/*",
                    "allowed_methods": [
                        "GET",
                        "HEAD",
                        "OPTIONS",
                    ],
                    "cached_methods": [
                        "GET",
                        "HEAD",
                    ],
                    "target_origin_id": s3_origin_id,
                    "forwarded_values": {
                        "query_string": False,
                        "cookies": {
                            "forward": "none",
                        },
                    },
                    "min_ttl": 0,
                    "default_ttl": 3600,
                    "max_ttl": 86400,
                    "compress": True,
                    "viewer_protocol_policy": "redirect-to-https",
                },
            ],
            price_class="PriceClass_200",
            restrictions={
                "geo_restriction": {
                    "restriction_type": "whitelist",
                    "locations": [
                        "US",
                        "CA",
                        "GB",
                        "DE",
                    ],
                },
            },
            tags={
                "Environment": "production",
            },
            viewer_certificate={
                "cloudfront_default_certificate": True,
            })
        ```

        ### With Failover Routing

        The example below creates a CloudFront distribution with an origin group for failover routing.

        ```python
        import pulumi
        import pulumi_aws as aws

        s3_distribution = aws.cloudfront.Distribution("s3_distribution",
            origin_groups=[{
                "origin_id": "groupS3",
                "failover_criteria": {
                    "status_codes": [
                        403,
                        404,
                        500,
                        502,
                    ],
                },
                "members": [
                    {
                        "origin_id": "primaryS3",
                    },
                    {
                        "origin_id": "failoverS3",
                    },
                ],
            }],
            origins=[
                {
                    "domain_name": primary["bucketRegionalDomainName"],
                    "origin_id": "primaryS3",
                    "s3_origin_config": {
                        "origin_access_identity": default["cloudfrontAccessIdentityPath"],
                    },
                },
                {
                    "domain_name": failover["bucketRegionalDomainName"],
                    "origin_id": "failoverS3",
                    "s3_origin_config": {
                        "origin_access_identity": default["cloudfrontAccessIdentityPath"],
                    },
                },
            ],
            default_cache_behavior={
                "target_origin_id": "groupS3",
            })
        ```

        ### With Managed Caching Policy

        The example below creates a CloudFront distribution with an [AWS managed caching policy](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/using-managed-cache-policies.html).

        ```python
        import pulumi
        import pulumi_aws as aws

        s3_origin_id = "myS3Origin"
        s3_distribution = aws.cloudfront.Distribution("s3_distribution",
            origins=[{
                "domain_name": primary["bucketRegionalDomainName"],
                "origin_id": "myS3Origin",
                "s3_origin_config": {
                    "origin_access_identity": default["cloudfrontAccessIdentityPath"],
                },
            }],
            enabled=True,
            is_ipv6_enabled=True,
            comment="Some comment",
            default_root_object="index.html",
            default_cache_behavior={
                "cache_policy_id": "4135ea2d-6df8-44a3-9df3-4b5a84be39ad",
                "allowed_methods": [
                    "GET",
                    "HEAD",
                    "OPTIONS",
                ],
                "cached_methods": [
                    "GET",
                    "HEAD",
                ],
                "target_origin_id": s3_origin_id,
                "viewer_protocol_policy": "allow-all",
            },
            restrictions={
                "geo_restriction": {
                    "restriction_type": "whitelist",
                    "locations": [
                        "US",
                        "CA",
                        "GB",
                        "DE",
                    ],
                },
            },
            viewer_certificate={
                "cloudfront_default_certificate": True,
            })
        ```

        ### With V2 logging to S3

        The example below creates a CloudFront distribution with [standard logging V2 to S3](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/standard-logging.html#enable-access-logging-api).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.Distribution("example")
        example_log_delivery_source = aws.cloudwatch.LogDeliverySource("example",
            region="us-east-1",
            name="example",
            log_type="ACCESS_LOGS",
            resource_arn=example.arn)
        example_bucket = aws.s3.Bucket("example",
            bucket="testbucket",
            force_destroy=True)
        example_log_delivery_destination = aws.cloudwatch.LogDeliveryDestination("example",
            region="us-east-1",
            name="s3-destination",
            output_format="parquet",
            delivery_destination_configuration={
                "destination_resource_arn": example_bucket.arn.apply(lambda arn: f"{arn}/prefix"),
            })
        example_log_delivery = aws.cloudwatch.LogDelivery("example",
            region="us-east-1",
            delivery_source_name=example_log_delivery_source.name,
            delivery_destination_arn=example_log_delivery_destination.arn,
            s3_delivery_configurations=[{
                "suffix_path": "/123456678910/{DistributionId}/{yyyy}/{MM}/{dd}/{HH}",
            }])
        ```

        ### With V2 logging to Data Firehose

        The example below creates a CloudFront distribution with [standard logging V2 to Data Firehose](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/standard-logging.html#enable-access-logging-api).

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudfront.Distribution("example")
        cloudfront_logs = aws.kinesis.FirehoseDeliveryStream("cloudfront_logs",
            region="us-east-1",
            tags={
                "LogDeliveryEnabled": "true",
            })
        example_log_delivery_source = aws.cloudwatch.LogDeliverySource("example",
            region="us-east-1",
            name="cloudfront-logs-source",
            log_type="ACCESS_LOGS",
            resource_arn=example.arn)
        example_log_delivery_destination = aws.cloudwatch.LogDeliveryDestination("example",
            region="us-east-1",
            name="firehose-destination",
            output_format="json",
            delivery_destination_configuration={
                "destination_resource_arn": cloudfront_logs.arn,
            })
        example_log_delivery = aws.cloudwatch.LogDelivery("example",
            region="us-east-1",
            delivery_source_name=example_log_delivery_source.name,
            delivery_destination_arn=example_log_delivery_destination.arn)
        ```

        ## Import

        Using `pulumi import`, import CloudFront Distributions using the `id`. For example:

        ```sh
        $ pulumi import aws:cloudfront/distribution:Distribution distribution E74FTE3EXAMPLE
        ```

        :param str resource_name: The name of the resource.
        :param DistributionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DistributionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 anycast_ip_list_id: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 continuous_deployment_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionCustomErrorResponseArgs', 'DistributionCustomErrorResponseArgsDict']]]]] = None,
                 default_cache_behavior: Optional[pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']]] = None,
                 default_root_object: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 is_ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 logging_config: Optional[pulumi.Input[Union['DistributionLoggingConfigArgs', 'DistributionLoggingConfigArgsDict']]] = None,
                 ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionOrderedCacheBehaviorArgs', 'DistributionOrderedCacheBehaviorArgsDict']]]]] = None,
                 origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginGroupArgs', 'DistributionOriginGroupArgsDict']]]]] = None,
                 origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']]]]] = None,
                 price_class: Optional[pulumi.Input[_builtins.str]] = None,
                 restrictions: Optional[pulumi.Input[Union['DistributionRestrictionsArgs', 'DistributionRestrictionsArgsDict']]] = None,
                 retain_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 staging: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 viewer_certificate: Optional[pulumi.Input[Union['DistributionViewerCertificateArgs', 'DistributionViewerCertificateArgsDict']]] = None,
                 wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 web_acl_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DistributionArgs.__new__(DistributionArgs)

            __props__.__dict__["aliases"] = aliases
            __props__.__dict__["anycast_ip_list_id"] = anycast_ip_list_id
            __props__.__dict__["comment"] = comment
            __props__.__dict__["continuous_deployment_policy_id"] = continuous_deployment_policy_id
            __props__.__dict__["custom_error_responses"] = custom_error_responses
            if default_cache_behavior is None and not opts.urn:
                raise TypeError("Missing required property 'default_cache_behavior'")
            __props__.__dict__["default_cache_behavior"] = default_cache_behavior
            __props__.__dict__["default_root_object"] = default_root_object
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["http_version"] = http_version
            __props__.__dict__["is_ipv6_enabled"] = is_ipv6_enabled
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["ordered_cache_behaviors"] = ordered_cache_behaviors
            __props__.__dict__["origin_groups"] = origin_groups
            if origins is None and not opts.urn:
                raise TypeError("Missing required property 'origins'")
            __props__.__dict__["origins"] = origins
            __props__.__dict__["price_class"] = price_class
            if restrictions is None and not opts.urn:
                raise TypeError("Missing required property 'restrictions'")
            __props__.__dict__["restrictions"] = restrictions
            __props__.__dict__["retain_on_delete"] = retain_on_delete
            __props__.__dict__["staging"] = staging
            __props__.__dict__["tags"] = tags
            if viewer_certificate is None and not opts.urn:
                raise TypeError("Missing required property 'viewer_certificate'")
            __props__.__dict__["viewer_certificate"] = viewer_certificate
            __props__.__dict__["wait_for_deployment"] = wait_for_deployment
            __props__.__dict__["web_acl_id"] = web_acl_id
            __props__.__dict__["arn"] = None
            __props__.__dict__["caller_reference"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["hosted_zone_id"] = None
            __props__.__dict__["in_progress_validation_batches"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tags_all"] = None
            __props__.__dict__["trusted_key_groups"] = None
            __props__.__dict__["trusted_signers"] = None
        super(Distribution, __self__).__init__(
            'aws:cloudfront/distribution:Distribution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliases: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            anycast_ip_list_id: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            caller_reference: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            continuous_deployment_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            custom_error_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionCustomErrorResponseArgs', 'DistributionCustomErrorResponseArgsDict']]]]] = None,
            default_cache_behavior: Optional[pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']]] = None,
            default_root_object: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            hosted_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            http_version: Optional[pulumi.Input[_builtins.str]] = None,
            in_progress_validation_batches: Optional[pulumi.Input[_builtins.int]] = None,
            is_ipv6_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            last_modified_time: Optional[pulumi.Input[_builtins.str]] = None,
            logging_config: Optional[pulumi.Input[Union['DistributionLoggingConfigArgs', 'DistributionLoggingConfigArgsDict']]] = None,
            ordered_cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionOrderedCacheBehaviorArgs', 'DistributionOrderedCacheBehaviorArgsDict']]]]] = None,
            origin_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginGroupArgs', 'DistributionOriginGroupArgsDict']]]]] = None,
            origins: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']]]]] = None,
            price_class: Optional[pulumi.Input[_builtins.str]] = None,
            restrictions: Optional[pulumi.Input[Union['DistributionRestrictionsArgs', 'DistributionRestrictionsArgsDict']]] = None,
            retain_on_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            staging: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            trusted_key_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionTrustedKeyGroupArgs', 'DistributionTrustedKeyGroupArgsDict']]]]] = None,
            trusted_signers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DistributionTrustedSignerArgs', 'DistributionTrustedSignerArgsDict']]]]] = None,
            viewer_certificate: Optional[pulumi.Input[Union['DistributionViewerCertificateArgs', 'DistributionViewerCertificateArgsDict']]] = None,
            wait_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
            web_acl_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Distribution':
        """
        Get an existing Distribution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] aliases: Extra CNAMEs (alternate domain names), if any, for this distribution.
        :param pulumi.Input[_builtins.str] anycast_ip_list_id: ID of the Anycast static IP list that is associated with the distribution.
        :param pulumi.Input[_builtins.str] arn: ARN for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your AWS account ID.
        :param pulumi.Input[_builtins.str] caller_reference: Internal value used by CloudFront to allow future updates to the distribution configuration.
        :param pulumi.Input[_builtins.str] comment: Any comments you want to include about the distribution.
        :param pulumi.Input[_builtins.str] continuous_deployment_policy_id: Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `cloudfront.ContinuousDeploymentPolicy` resource for additional details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionCustomErrorResponseArgs', 'DistributionCustomErrorResponseArgsDict']]]] custom_error_responses: One or more custom error response elements (multiples allowed).
        :param pulumi.Input[Union['DistributionDefaultCacheBehaviorArgs', 'DistributionDefaultCacheBehaviorArgsDict']] default_cache_behavior: Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
        :param pulumi.Input[_builtins.str] default_root_object: Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        :param pulumi.Input[_builtins.str] domain_name: Domain name corresponding to the distribution. For example: `d604721fxaaqy9.cloudfront.net`.
        :param pulumi.Input[_builtins.bool] enabled: Whether the distribution is enabled to accept end user requests for content.
        :param pulumi.Input[_builtins.str] etag: Current version of the distribution's information. For example: `E2QWRUHAPOMQZL`.
        :param pulumi.Input[_builtins.str] hosted_zone_id: CloudFront Route 53 zone ID that can be used to route an [Alias Resource Record Set](http://docs.aws.amazon.com/Route53/latest/APIReference/CreateAliasRRSAPI.html) to. This attribute is simply an alias for the zone ID `Z2FDTNDATAQYW2`.
        :param pulumi.Input[_builtins.str] http_version: Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
        :param pulumi.Input[_builtins.int] in_progress_validation_batches: Number of invalidation batches currently in progress.
        :param pulumi.Input[_builtins.bool] is_ipv6_enabled: Whether the IPv6 is enabled for the distribution.
        :param pulumi.Input[_builtins.str] last_modified_time: Date and time the distribution was last modified.
        :param pulumi.Input[Union['DistributionLoggingConfigArgs', 'DistributionLoggingConfigArgsDict']] logging_config: The logging configuration that controls how logs are written to your distribution (maximum one). AWS provides two versions of access logs for CloudFront: Legacy and v2. This argument configures legacy version standard logs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionOrderedCacheBehaviorArgs', 'DistributionOrderedCacheBehaviorArgsDict']]]] ordered_cache_behaviors: Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginGroupArgs', 'DistributionOriginGroupArgsDict']]]] origin_groups: One or more origin_group for this distribution (multiples allowed).
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionOriginArgs', 'DistributionOriginArgsDict']]]] origins: One or more origins for this distribution (multiples allowed).
        :param pulumi.Input[_builtins.str] price_class: Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
        :param pulumi.Input[Union['DistributionRestrictionsArgs', 'DistributionRestrictionsArgsDict']] restrictions: The restriction configuration for this distribution (maximum one).
        :param pulumi.Input[_builtins.bool] retain_on_delete: Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
        :param pulumi.Input[_builtins.bool] staging: A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
        :param pulumi.Input[_builtins.str] status: Current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionTrustedKeyGroupArgs', 'DistributionTrustedKeyGroupArgsDict']]]] trusted_key_groups: List of nested attributes for active trusted key groups, if the distribution is set up to serve private content with signed URLs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DistributionTrustedSignerArgs', 'DistributionTrustedSignerArgsDict']]]] trusted_signers: List of nested attributes for active trusted signers, if the distribution is set up to serve private content with signed URLs.
        :param pulumi.Input[Union['DistributionViewerCertificateArgs', 'DistributionViewerCertificateArgsDict']] viewer_certificate: The SSL configuration for this distribution (maximum one).
        :param pulumi.Input[_builtins.bool] wait_for_deployment: If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
        :param pulumi.Input[_builtins.str] web_acl_id: Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DistributionState.__new__(_DistributionState)

        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["anycast_ip_list_id"] = anycast_ip_list_id
        __props__.__dict__["arn"] = arn
        __props__.__dict__["caller_reference"] = caller_reference
        __props__.__dict__["comment"] = comment
        __props__.__dict__["continuous_deployment_policy_id"] = continuous_deployment_policy_id
        __props__.__dict__["custom_error_responses"] = custom_error_responses
        __props__.__dict__["default_cache_behavior"] = default_cache_behavior
        __props__.__dict__["default_root_object"] = default_root_object
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["etag"] = etag
        __props__.__dict__["hosted_zone_id"] = hosted_zone_id
        __props__.__dict__["http_version"] = http_version
        __props__.__dict__["in_progress_validation_batches"] = in_progress_validation_batches
        __props__.__dict__["is_ipv6_enabled"] = is_ipv6_enabled
        __props__.__dict__["last_modified_time"] = last_modified_time
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["ordered_cache_behaviors"] = ordered_cache_behaviors
        __props__.__dict__["origin_groups"] = origin_groups
        __props__.__dict__["origins"] = origins
        __props__.__dict__["price_class"] = price_class
        __props__.__dict__["restrictions"] = restrictions
        __props__.__dict__["retain_on_delete"] = retain_on_delete
        __props__.__dict__["staging"] = staging
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["trusted_key_groups"] = trusted_key_groups
        __props__.__dict__["trusted_signers"] = trusted_signers
        __props__.__dict__["viewer_certificate"] = viewer_certificate
        __props__.__dict__["wait_for_deployment"] = wait_for_deployment
        __props__.__dict__["web_acl_id"] = web_acl_id
        return Distribution(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Extra CNAMEs (alternate domain names), if any, for this distribution.
        """
        return pulumi.get(self, "aliases")

    @_builtins.property
    @pulumi.getter(name="anycastIpListId")
    def anycast_ip_list_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the Anycast static IP list that is associated with the distribution.
        """
        return pulumi.get(self, "anycast_ip_list_id")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN for the distribution. For example: `arn:aws:cloudfront::123456789012:distribution/EDFDVBD632BHDS5`, where `123456789012` is your AWS account ID.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="callerReference")
    def caller_reference(self) -> pulumi.Output[_builtins.str]:
        """
        Internal value used by CloudFront to allow future updates to the distribution configuration.
        """
        return pulumi.get(self, "caller_reference")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Any comments you want to include about the distribution.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="continuousDeploymentPolicyId")
    def continuous_deployment_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of a continuous deployment policy. This argument should only be set on a production distribution. See the `cloudfront.ContinuousDeploymentPolicy` resource for additional details.
        """
        return pulumi.get(self, "continuous_deployment_policy_id")

    @_builtins.property
    @pulumi.getter(name="customErrorResponses")
    def custom_error_responses(self) -> pulumi.Output[Optional[Sequence['outputs.DistributionCustomErrorResponse']]]:
        """
        One or more custom error response elements (multiples allowed).
        """
        return pulumi.get(self, "custom_error_responses")

    @_builtins.property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> pulumi.Output['outputs.DistributionDefaultCacheBehavior']:
        """
        Default cache behavior for this distribution (maximum one). Requires either `cache_policy_id` (preferred) or `forwarded_values` (deprecated) be set.
        """
        return pulumi.get(self, "default_cache_behavior")

    @_builtins.property
    @pulumi.getter(name="defaultRootObject")
    def default_root_object(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Object that you want CloudFront to return (for example, index.html) when an end user requests the root URL.
        """
        return pulumi.get(self, "default_root_object")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Domain name corresponding to the distribution. For example: `d604721fxaaqy9.cloudfront.net`.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the distribution is enabled to accept end user requests for content.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Current version of the distribution's information. For example: `E2QWRUHAPOMQZL`.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        CloudFront Route 53 zone ID that can be used to route an [Alias Resource Record Set](http://docs.aws.amazon.com/Route53/latest/APIReference/CreateAliasRRSAPI.html) to. This attribute is simply an alias for the zone ID `Z2FDTNDATAQYW2`.
        """
        return pulumi.get(self, "hosted_zone_id")

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Maximum HTTP version to support on the distribution. Allowed values are `http1.1`, `http2`, `http2and3` and `http3`. The default is `http2`.
        """
        return pulumi.get(self, "http_version")

    @_builtins.property
    @pulumi.getter(name="inProgressValidationBatches")
    def in_progress_validation_batches(self) -> pulumi.Output[_builtins.int]:
        """
        Number of invalidation batches currently in progress.
        """
        return pulumi.get(self, "in_progress_validation_batches")

    @_builtins.property
    @pulumi.getter(name="isIpv6Enabled")
    def is_ipv6_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the IPv6 is enabled for the distribution.
        """
        return pulumi.get(self, "is_ipv6_enabled")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time the distribution was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.DistributionLoggingConfig']]:
        """
        The logging configuration that controls how logs are written to your distribution (maximum one). AWS provides two versions of access logs for CloudFront: Legacy and v2. This argument configures legacy version standard logs.
        """
        return pulumi.get(self, "logging_config")

    @_builtins.property
    @pulumi.getter(name="orderedCacheBehaviors")
    def ordered_cache_behaviors(self) -> pulumi.Output[Optional[Sequence['outputs.DistributionOrderedCacheBehavior']]]:
        """
        Ordered list of cache behaviors resource for this distribution. List from top to bottom in order of precedence. The topmost cache behavior will have precedence 0.
        """
        return pulumi.get(self, "ordered_cache_behaviors")

    @_builtins.property
    @pulumi.getter(name="originGroups")
    def origin_groups(self) -> pulumi.Output[Optional[Sequence['outputs.DistributionOriginGroup']]]:
        """
        One or more origin_group for this distribution (multiples allowed).
        """
        return pulumi.get(self, "origin_groups")

    @_builtins.property
    @pulumi.getter
    def origins(self) -> pulumi.Output[Sequence['outputs.DistributionOrigin']]:
        """
        One or more origins for this distribution (multiples allowed).
        """
        return pulumi.get(self, "origins")

    @_builtins.property
    @pulumi.getter(name="priceClass")
    def price_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Price class for this distribution. One of `PriceClass_All`, `PriceClass_200`, `PriceClass_100`.
        """
        return pulumi.get(self, "price_class")

    @_builtins.property
    @pulumi.getter
    def restrictions(self) -> pulumi.Output['outputs.DistributionRestrictions']:
        """
        The restriction configuration for this distribution (maximum one).
        """
        return pulumi.get(self, "restrictions")

    @_builtins.property
    @pulumi.getter(name="retainOnDelete")
    def retain_on_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disables the distribution instead of deleting it when destroying the resource through the provider. If this is set, the distribution needs to be deleted manually afterwards. Default: `false`.
        """
        return pulumi.get(self, "retain_on_delete")

    @_builtins.property
    @pulumi.getter
    def staging(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A Boolean that indicates whether this is a staging distribution. Defaults to `false`.
        """
        return pulumi.get(self, "staging")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Current status of the distribution. `Deployed` if the distribution's information is fully propagated throughout the Amazon CloudFront system.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="trustedKeyGroups")
    def trusted_key_groups(self) -> pulumi.Output[Sequence['outputs.DistributionTrustedKeyGroup']]:
        """
        List of nested attributes for active trusted key groups, if the distribution is set up to serve private content with signed URLs.
        """
        return pulumi.get(self, "trusted_key_groups")

    @_builtins.property
    @pulumi.getter(name="trustedSigners")
    def trusted_signers(self) -> pulumi.Output[Sequence['outputs.DistributionTrustedSigner']]:
        """
        List of nested attributes for active trusted signers, if the distribution is set up to serve private content with signed URLs.
        """
        return pulumi.get(self, "trusted_signers")

    @_builtins.property
    @pulumi.getter(name="viewerCertificate")
    def viewer_certificate(self) -> pulumi.Output['outputs.DistributionViewerCertificate']:
        """
        The SSL configuration for this distribution (maximum one).
        """
        return pulumi.get(self, "viewer_certificate")

    @_builtins.property
    @pulumi.getter(name="waitForDeployment")
    def wait_for_deployment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If enabled, the resource will wait for the distribution status to change from `InProgress` to `Deployed`. Setting this to`false` will skip the process. Default: `true`.
        """
        return pulumi.get(self, "wait_for_deployment")

    @_builtins.property
    @pulumi.getter(name="webAclId")
    def web_acl_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Unique identifier that specifies the AWS WAF web ACL, if any, to associate with this distribution. To specify a web ACL created using the latest version of AWS WAF (WAFv2), use the ACL ARN, for example `aws_wafv2_web_acl.example.arn`. To specify a web ACL created using AWS WAF Classic, use the ACL ID, for example `aws_waf_web_acl.example.id`. The WAF Web ACL must exist in the WAF Global (CloudFront) region and the credentials configuring this argument must have `waf:GetWebACL` permissions assigned.
        """
        return pulumi.get(self, "web_acl_id")

