# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CompositeAlarmArgs', 'CompositeAlarm']

@pulumi.input_type
class CompositeAlarmArgs:
    def __init__(__self__, *,
                 alarm_name: pulumi.Input[_builtins.str],
                 alarm_rule: pulumi.Input[_builtins.str],
                 actions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 actions_suppressor: Optional[pulumi.Input['CompositeAlarmActionsSuppressorArgs']] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a CompositeAlarm resource.
        :param pulumi.Input[_builtins.str] alarm_name: The name for the composite alarm. This name must be unique within the region.
        :param pulumi.Input[_builtins.str] alarm_rule: An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
        :param pulumi.Input[_builtins.bool] actions_enabled: Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
        :param pulumi.Input['CompositeAlarmActionsSuppressorArgs'] actions_suppressor: Actions will be suppressed if the suppressor alarm is in the ALARM state.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alarm_actions: The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[_builtins.str] alarm_description: The description for the composite alarm.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] insufficient_data_actions: The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ok_actions: The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "alarm_name", alarm_name)
        pulumi.set(__self__, "alarm_rule", alarm_rule)
        if actions_enabled is not None:
            pulumi.set(__self__, "actions_enabled", actions_enabled)
        if actions_suppressor is not None:
            pulumi.set(__self__, "actions_suppressor", actions_suppressor)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_description is not None:
            pulumi.set(__self__, "alarm_description", alarm_description)
        if insufficient_data_actions is not None:
            pulumi.set(__self__, "insufficient_data_actions", insufficient_data_actions)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name for the composite alarm. This name must be unique within the region.
        """
        return pulumi.get(self, "alarm_name")

    @alarm_name.setter
    def alarm_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alarm_name", value)

    @_builtins.property
    @pulumi.getter(name="alarmRule")
    def alarm_rule(self) -> pulumi.Input[_builtins.str]:
        """
        An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
        """
        return pulumi.get(self, "alarm_rule")

    @alarm_rule.setter
    def alarm_rule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "alarm_rule", value)

    @_builtins.property
    @pulumi.getter(name="actionsEnabled")
    def actions_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
        """
        return pulumi.get(self, "actions_enabled")

    @actions_enabled.setter
    def actions_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "actions_enabled", value)

    @_builtins.property
    @pulumi.getter(name="actionsSuppressor")
    def actions_suppressor(self) -> Optional[pulumi.Input['CompositeAlarmActionsSuppressorArgs']]:
        """
        Actions will be suppressed if the suppressor alarm is in the ALARM state.
        """
        return pulumi.get(self, "actions_suppressor")

    @actions_suppressor.setter
    def actions_suppressor(self, value: Optional[pulumi.Input['CompositeAlarmActionsSuppressorArgs']]):
        pulumi.set(self, "actions_suppressor", value)

    @_builtins.property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alarm_actions", value)

    @_builtins.property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the composite alarm.
        """
        return pulumi.get(self, "alarm_description")

    @alarm_description.setter
    def alarm_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_description", value)

    @_builtins.property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        """
        return pulumi.get(self, "insufficient_data_actions")

    @insufficient_data_actions.setter
    def insufficient_data_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "insufficient_data_actions", value)

    @_builtins.property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ok_actions", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _CompositeAlarmState:
    def __init__(__self__, *,
                 actions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 actions_suppressor: Optional[pulumi.Input['CompositeAlarmActionsSuppressorArgs']] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CompositeAlarm resources.
        :param pulumi.Input[_builtins.bool] actions_enabled: Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
        :param pulumi.Input['CompositeAlarmActionsSuppressorArgs'] actions_suppressor: Actions will be suppressed if the suppressor alarm is in the ALARM state.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alarm_actions: The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[_builtins.str] alarm_description: The description for the composite alarm.
        :param pulumi.Input[_builtins.str] alarm_name: The name for the composite alarm. This name must be unique within the region.
        :param pulumi.Input[_builtins.str] alarm_rule: An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
        :param pulumi.Input[_builtins.str] arn: The ARN of the composite alarm.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] insufficient_data_actions: The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ok_actions: The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        if actions_enabled is not None:
            pulumi.set(__self__, "actions_enabled", actions_enabled)
        if actions_suppressor is not None:
            pulumi.set(__self__, "actions_suppressor", actions_suppressor)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_description is not None:
            pulumi.set(__self__, "alarm_description", alarm_description)
        if alarm_name is not None:
            pulumi.set(__self__, "alarm_name", alarm_name)
        if alarm_rule is not None:
            pulumi.set(__self__, "alarm_rule", alarm_rule)
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if insufficient_data_actions is not None:
            pulumi.set(__self__, "insufficient_data_actions", insufficient_data_actions)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)

    @_builtins.property
    @pulumi.getter(name="actionsEnabled")
    def actions_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
        """
        return pulumi.get(self, "actions_enabled")

    @actions_enabled.setter
    def actions_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "actions_enabled", value)

    @_builtins.property
    @pulumi.getter(name="actionsSuppressor")
    def actions_suppressor(self) -> Optional[pulumi.Input['CompositeAlarmActionsSuppressorArgs']]:
        """
        Actions will be suppressed if the suppressor alarm is in the ALARM state.
        """
        return pulumi.get(self, "actions_suppressor")

    @actions_suppressor.setter
    def actions_suppressor(self, value: Optional[pulumi.Input['CompositeAlarmActionsSuppressorArgs']]):
        pulumi.set(self, "actions_suppressor", value)

    @_builtins.property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "alarm_actions", value)

    @_builtins.property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the composite alarm.
        """
        return pulumi.get(self, "alarm_description")

    @alarm_description.setter
    def alarm_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_description", value)

    @_builtins.property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the composite alarm. This name must be unique within the region.
        """
        return pulumi.get(self, "alarm_name")

    @alarm_name.setter
    def alarm_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_name", value)

    @_builtins.property
    @pulumi.getter(name="alarmRule")
    def alarm_rule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
        """
        return pulumi.get(self, "alarm_rule")

    @alarm_rule.setter
    def alarm_rule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alarm_rule", value)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the composite alarm.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        """
        return pulumi.get(self, "insufficient_data_actions")

    @insufficient_data_actions.setter
    def insufficient_data_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "insufficient_data_actions", value)

    @_builtins.property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ok_actions", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)


@pulumi.type_token("aws:cloudwatch/compositeAlarm:CompositeAlarm")
class CompositeAlarm(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 actions_suppressor: Optional[pulumi.Input[Union['CompositeAlarmActionsSuppressorArgs', 'CompositeAlarmActionsSuppressorArgsDict']]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a CloudWatch Composite Alarm resource.

        > **NOTE:** An alarm (composite or metric) cannot be destroyed when there are other composite alarms depending on it. This can lead to a cyclical dependency on update, as the provider will unsuccessfully attempt to destroy alarms before updating the rule. Consider using `depends_on`, references to alarm names, and two-stage updates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.CompositeAlarm("example",
            alarm_description="This is a composite alarm!",
            alarm_name="example-composite-alarm",
            alarm_actions=example_aws_sns_topic["arn"],
            ok_actions=example_aws_sns_topic["arn"],
            alarm_rule=f\"\"\"ALARM({alpha["alarmName"]}) OR
        ALARM({bravo["alarmName"]})
        \"\"\",
            actions_suppressor={
                "alarm": "suppressor-alarm",
                "extension_period": 10,
                "wait_period": 20,
            })
        ```

        ## Import

        Using `pulumi import`, import a CloudWatch Composite Alarm using the `alarm_name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/compositeAlarm:CompositeAlarm test my-alarm
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] actions_enabled: Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
        :param pulumi.Input[Union['CompositeAlarmActionsSuppressorArgs', 'CompositeAlarmActionsSuppressorArgsDict']] actions_suppressor: Actions will be suppressed if the suppressor alarm is in the ALARM state.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alarm_actions: The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[_builtins.str] alarm_description: The description for the composite alarm.
        :param pulumi.Input[_builtins.str] alarm_name: The name for the composite alarm. This name must be unique within the region.
        :param pulumi.Input[_builtins.str] alarm_rule: An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] insufficient_data_actions: The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ok_actions: The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CompositeAlarmArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CloudWatch Composite Alarm resource.

        > **NOTE:** An alarm (composite or metric) cannot be destroyed when there are other composite alarms depending on it. This can lead to a cyclical dependency on update, as the provider will unsuccessfully attempt to destroy alarms before updating the rule. Consider using `depends_on`, references to alarm names, and two-stage updates.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cloudwatch.CompositeAlarm("example",
            alarm_description="This is a composite alarm!",
            alarm_name="example-composite-alarm",
            alarm_actions=example_aws_sns_topic["arn"],
            ok_actions=example_aws_sns_topic["arn"],
            alarm_rule=f\"\"\"ALARM({alpha["alarmName"]}) OR
        ALARM({bravo["alarmName"]})
        \"\"\",
            actions_suppressor={
                "alarm": "suppressor-alarm",
                "extension_period": 10,
                "wait_period": 20,
            })
        ```

        ## Import

        Using `pulumi import`, import a CloudWatch Composite Alarm using the `alarm_name`. For example:

        ```sh
        $ pulumi import aws:cloudwatch/compositeAlarm:CompositeAlarm test my-alarm
        ```

        :param str resource_name: The name of the resource.
        :param CompositeAlarmArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CompositeAlarmArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 actions_suppressor: Optional[pulumi.Input[Union['CompositeAlarmActionsSuppressorArgs', 'CompositeAlarmActionsSuppressorArgsDict']]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
                 alarm_rule: Optional[pulumi.Input[_builtins.str]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CompositeAlarmArgs.__new__(CompositeAlarmArgs)

            __props__.__dict__["actions_enabled"] = actions_enabled
            __props__.__dict__["actions_suppressor"] = actions_suppressor
            __props__.__dict__["alarm_actions"] = alarm_actions
            __props__.__dict__["alarm_description"] = alarm_description
            if alarm_name is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_name'")
            __props__.__dict__["alarm_name"] = alarm_name
            if alarm_rule is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_rule'")
            __props__.__dict__["alarm_rule"] = alarm_rule
            __props__.__dict__["insufficient_data_actions"] = insufficient_data_actions
            __props__.__dict__["ok_actions"] = ok_actions
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["tags_all"] = None
        super(CompositeAlarm, __self__).__init__(
            'aws:cloudwatch/compositeAlarm:CompositeAlarm',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            actions_suppressor: Optional[pulumi.Input[Union['CompositeAlarmActionsSuppressorArgs', 'CompositeAlarmActionsSuppressorArgsDict']]] = None,
            alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            alarm_description: Optional[pulumi.Input[_builtins.str]] = None,
            alarm_name: Optional[pulumi.Input[_builtins.str]] = None,
            alarm_rule: Optional[pulumi.Input[_builtins.str]] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'CompositeAlarm':
        """
        Get an existing CompositeAlarm resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] actions_enabled: Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
        :param pulumi.Input[Union['CompositeAlarmActionsSuppressorArgs', 'CompositeAlarmActionsSuppressorArgsDict']] actions_suppressor: Actions will be suppressed if the suppressor alarm is in the ALARM state.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] alarm_actions: The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[_builtins.str] alarm_description: The description for the composite alarm.
        :param pulumi.Input[_builtins.str] alarm_name: The name for the composite alarm. This name must be unique within the region.
        :param pulumi.Input[_builtins.str] alarm_rule: An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
        :param pulumi.Input[_builtins.str] arn: The ARN of the composite alarm.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] insufficient_data_actions: The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ok_actions: The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CompositeAlarmState.__new__(_CompositeAlarmState)

        __props__.__dict__["actions_enabled"] = actions_enabled
        __props__.__dict__["actions_suppressor"] = actions_suppressor
        __props__.__dict__["alarm_actions"] = alarm_actions
        __props__.__dict__["alarm_description"] = alarm_description
        __props__.__dict__["alarm_name"] = alarm_name
        __props__.__dict__["alarm_rule"] = alarm_rule
        __props__.__dict__["arn"] = arn
        __props__.__dict__["insufficient_data_actions"] = insufficient_data_actions
        __props__.__dict__["ok_actions"] = ok_actions
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        return CompositeAlarm(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="actionsEnabled")
    def actions_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. Defaults to `true`.
        """
        return pulumi.get(self, "actions_enabled")

    @_builtins.property
    @pulumi.getter(name="actionsSuppressor")
    def actions_suppressor(self) -> pulumi.Output[Optional['outputs.CompositeAlarmActionsSuppressor']]:
        """
        Actions will be suppressed if the suppressor alarm is in the ALARM state.
        """
        return pulumi.get(self, "actions_suppressor")

    @_builtins.property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The set of actions to execute when this alarm transitions to the `ALARM` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        """
        return pulumi.get(self, "alarm_actions")

    @_builtins.property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the composite alarm.
        """
        return pulumi.get(self, "alarm_description")

    @_builtins.property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the composite alarm. This name must be unique within the region.
        """
        return pulumi.get(self, "alarm_name")

    @_builtins.property
    @pulumi.getter(name="alarmRule")
    def alarm_rule(self) -> pulumi.Output[_builtins.str]:
        """
        An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. For syntax, see [Creating a Composite Alarm](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Create_Composite_Alarm.html). The maximum length is 10240 characters.
        """
        return pulumi.get(self, "alarm_rule")

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of the composite alarm.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The set of actions to execute when this alarm transitions to the `INSUFFICIENT_DATA` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        """
        return pulumi.get(self, "insufficient_data_actions")

    @_builtins.property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The set of actions to execute when this alarm transitions to an `OK` state from any other state. Each action is specified as an ARN. Up to 5 actions are allowed.
        """
        return pulumi.get(self, "ok_actions")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of tags to associate with the alarm. Up to 50 tags are allowed. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

