# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLogGroupsResult',
    'AwaitableGetLogGroupsResult',
    'get_log_groups',
    'get_log_groups_output',
]

@pulumi.output_type
class GetLogGroupsResult:
    """
    A collection of values returned by getLogGroups.
    """
    def __init__(__self__, arns=None, id=None, log_group_name_prefix=None, log_group_names=None, region=None):
        if arns and not isinstance(arns, list):
            raise TypeError("Expected argument 'arns' to be a list")
        pulumi.set(__self__, "arns", arns)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_group_name_prefix and not isinstance(log_group_name_prefix, str):
            raise TypeError("Expected argument 'log_group_name_prefix' to be a str")
        pulumi.set(__self__, "log_group_name_prefix", log_group_name_prefix)
        if log_group_names and not isinstance(log_group_names, list):
            raise TypeError("Expected argument 'log_group_names' to be a list")
        pulumi.set(__self__, "log_group_names", log_group_names)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def arns(self) -> Sequence[_builtins.str]:
        """
        Set of ARNs of the Cloudwatch log groups
        """
        return pulumi.get(self, "arns")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="logGroupNamePrefix")
    def log_group_name_prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "log_group_name_prefix")

    @_builtins.property
    @pulumi.getter(name="logGroupNames")
    def log_group_names(self) -> Sequence[_builtins.str]:
        """
        Set of names of the Cloudwatch log groups
        """
        return pulumi.get(self, "log_group_names")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetLogGroupsResult(GetLogGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogGroupsResult(
            arns=self.arns,
            id=self.id,
            log_group_name_prefix=self.log_group_name_prefix,
            log_group_names=self.log_group_names,
            region=self.region)


def get_log_groups(log_group_name_prefix: Optional[_builtins.str] = None,
                   region: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogGroupsResult:
    """
    Use this data source to get a list of AWS Cloudwatch Log Groups

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudwatch.get_log_groups(log_group_name_prefix="/MyImportantLogs")
    ```


    :param _builtins.str log_group_name_prefix: Group prefix of the Cloudwatch log groups to list
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['logGroupNamePrefix'] = log_group_name_prefix
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cloudwatch/getLogGroups:getLogGroups', __args__, opts=opts, typ=GetLogGroupsResult).value

    return AwaitableGetLogGroupsResult(
        arns=pulumi.get(__ret__, 'arns'),
        id=pulumi.get(__ret__, 'id'),
        log_group_name_prefix=pulumi.get(__ret__, 'log_group_name_prefix'),
        log_group_names=pulumi.get(__ret__, 'log_group_names'),
        region=pulumi.get(__ret__, 'region'))
def get_log_groups_output(log_group_name_prefix: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogGroupsResult]:
    """
    Use this data source to get a list of AWS Cloudwatch Log Groups

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.cloudwatch.get_log_groups(log_group_name_prefix="/MyImportantLogs")
    ```


    :param _builtins.str log_group_name_prefix: Group prefix of the Cloudwatch log groups to list
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['logGroupNamePrefix'] = log_group_name_prefix
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cloudwatch/getLogGroups:getLogGroups', __args__, opts=opts, typ=GetLogGroupsResult)
    return __ret__.apply(lambda __response__: GetLogGroupsResult(
        arns=pulumi.get(__response__, 'arns'),
        id=pulumi.get(__response__, 'id'),
        log_group_name_prefix=pulumi.get(__response__, 'log_group_name_prefix'),
        log_group_names=pulumi.get(__response__, 'log_group_names'),
        region=pulumi.get(__response__, 'region')))
