# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CompositeAlarmActionsSuppressor',
    'EventBusDeadLetterConfig',
    'EventBusLogConfig',
    'EventConnectionAuthParameters',
    'EventConnectionAuthParametersApiKey',
    'EventConnectionAuthParametersBasic',
    'EventConnectionAuthParametersInvocationHttpParameters',
    'EventConnectionAuthParametersInvocationHttpParametersBody',
    'EventConnectionAuthParametersInvocationHttpParametersHeader',
    'EventConnectionAuthParametersInvocationHttpParametersQueryString',
    'EventConnectionAuthParametersOauth',
    'EventConnectionAuthParametersOauthClientParameters',
    'EventConnectionAuthParametersOauthOauthHttpParameters',
    'EventConnectionAuthParametersOauthOauthHttpParametersBody',
    'EventConnectionAuthParametersOauthOauthHttpParametersHeader',
    'EventConnectionAuthParametersOauthOauthHttpParametersQueryString',
    'EventConnectionInvocationConnectivityParameters',
    'EventConnectionInvocationConnectivityParametersResourceParameters',
    'EventEndpointEventBus',
    'EventEndpointReplicationConfig',
    'EventEndpointRoutingConfig',
    'EventEndpointRoutingConfigFailoverConfig',
    'EventEndpointRoutingConfigFailoverConfigPrimary',
    'EventEndpointRoutingConfigFailoverConfigSecondary',
    'EventPermissionCondition',
    'EventTargetAppsyncTarget',
    'EventTargetBatchTarget',
    'EventTargetDeadLetterConfig',
    'EventTargetEcsTarget',
    'EventTargetEcsTargetCapacityProviderStrategy',
    'EventTargetEcsTargetNetworkConfiguration',
    'EventTargetEcsTargetOrderedPlacementStrategy',
    'EventTargetEcsTargetPlacementConstraint',
    'EventTargetHttpTarget',
    'EventTargetInputTransformer',
    'EventTargetKinesisTarget',
    'EventTargetRedshiftTarget',
    'EventTargetRetryPolicy',
    'EventTargetRunCommandTarget',
    'EventTargetSagemakerPipelineTarget',
    'EventTargetSagemakerPipelineTargetPipelineParameterList',
    'EventTargetSqsTarget',
    'InternetMonitorHealthEventsConfig',
    'InternetMonitorInternetMeasurementsLogDelivery',
    'InternetMonitorInternetMeasurementsLogDeliveryS3Config',
    'LogDeliveryDestinationDeliveryDestinationConfiguration',
    'LogDeliveryS3DeliveryConfiguration',
    'LogMetricFilterMetricTransformation',
    'MetricAlarmMetricQuery',
    'MetricAlarmMetricQueryMetric',
    'MetricStreamExcludeFilter',
    'MetricStreamIncludeFilter',
    'MetricStreamStatisticsConfiguration',
    'MetricStreamStatisticsConfigurationIncludeMetric',
    'GetContributorManagedInsightRulesManagedRuleResult',
    'GetContributorManagedInsightRulesManagedRuleRuleStateResult',
    'GetEventBusDeadLetterConfigResult',
    'GetEventBusLogConfigResult',
    'GetEventBusesEventBusResult',
    'GetLogDataProtectionPolicyDocumentConfigurationResult',
    'GetLogDataProtectionPolicyDocumentConfigurationCustomDataIdentifierResult',
    'GetLogDataProtectionPolicyDocumentStatementResult',
    'GetLogDataProtectionPolicyDocumentStatementOperationResult',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditResult',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationResult',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsResult',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseResult',
    'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Result',
    'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyResult',
    'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigResult',
]

@pulumi.output_type
class CompositeAlarmActionsSuppressor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "extensionPeriod":
            suggest = "extension_period"
        elif key == "waitPeriod":
            suggest = "wait_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CompositeAlarmActionsSuppressor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CompositeAlarmActionsSuppressor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CompositeAlarmActionsSuppressor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alarm: _builtins.str,
                 extension_period: _builtins.int,
                 wait_period: _builtins.int):
        """
        :param _builtins.str alarm: Can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
        :param _builtins.int extension_period: The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
        :param _builtins.int wait_period: The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
        """
        pulumi.set(__self__, "alarm", alarm)
        pulumi.set(__self__, "extension_period", extension_period)
        pulumi.set(__self__, "wait_period", wait_period)

    @_builtins.property
    @pulumi.getter
    def alarm(self) -> _builtins.str:
        """
        Can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
        """
        return pulumi.get(self, "alarm")

    @_builtins.property
    @pulumi.getter(name="extensionPeriod")
    def extension_period(self) -> _builtins.int:
        """
        The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the `ALARM` state. After this time, the composite alarm performs its actions.
        """
        return pulumi.get(self, "extension_period")

    @_builtins.property
    @pulumi.getter(name="waitPeriod")
    def wait_period(self) -> _builtins.int:
        """
        The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the `ALARM` state. After this time, the composite alarm performs its actions.
        """
        return pulumi.get(self, "wait_period")


@pulumi.output_type
class EventBusDeadLetterConfig(dict):
    def __init__(__self__, *,
                 arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str arn: The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[_builtins.str]:
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class EventBusLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeDetail":
            suggest = "include_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventBusLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventBusLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventBusLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 include_detail: Optional[_builtins.str] = None,
                 level: Optional[_builtins.str] = None):
        """
        :param _builtins.str include_detail: Whether EventBridge include detailed event information in the records it generates. Valid values are `NONE` and `FULL`.
        :param _builtins.str level: Level of logging detail to include. Valid values are `OFF`, `ERROR`, `INFO`, and `TRACE`.
        """
        if include_detail is not None:
            pulumi.set(__self__, "include_detail", include_detail)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @_builtins.property
    @pulumi.getter(name="includeDetail")
    def include_detail(self) -> Optional[_builtins.str]:
        """
        Whether EventBridge include detailed event information in the records it generates. Valid values are `NONE` and `FULL`.
        """
        return pulumi.get(self, "include_detail")

    @_builtins.property
    @pulumi.getter
    def level(self) -> Optional[_builtins.str]:
        """
        Level of logging detail to include. Valid values are `OFF`, `ERROR`, `INFO`, and `TRACE`.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class EventConnectionAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKey":
            suggest = "api_key"
        elif key == "invocationHttpParameters":
            suggest = "invocation_http_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key: Optional['outputs.EventConnectionAuthParametersApiKey'] = None,
                 basic: Optional['outputs.EventConnectionAuthParametersBasic'] = None,
                 invocation_http_parameters: Optional['outputs.EventConnectionAuthParametersInvocationHttpParameters'] = None,
                 oauth: Optional['outputs.EventConnectionAuthParametersOauth'] = None):
        """
        :param 'EventConnectionAuthParametersApiKeyArgs' api_key: Parameters used for API_KEY authorization. An API key to include in the header for each authentication request. A maximum of 1 are allowed. Conflicts with `basic` and `oauth`. Documented below.
        :param 'EventConnectionAuthParametersBasicArgs' basic: Parameters used for BASIC authorization. A maximum of 1 are allowed. Conflicts with `api_key` and `oauth`. Documented below.
        :param 'EventConnectionAuthParametersInvocationHttpParametersArgs' invocation_http_parameters: Invocation Http Parameters are additional credentials used to sign each Invocation of the ApiDestination created from this Connection. If the ApiDestination Rule Target has additional HttpParameters, the values will be merged together, with the Connection Invocation Http Parameters taking precedence. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
        :param 'EventConnectionAuthParametersOauthArgs' oauth: Parameters used for OAUTH_CLIENT_CREDENTIALS authorization. A maximum of 1 are allowed. Conflicts with `basic` and `api_key`. Documented below.
        """
        if api_key is not None:
            pulumi.set(__self__, "api_key", api_key)
        if basic is not None:
            pulumi.set(__self__, "basic", basic)
        if invocation_http_parameters is not None:
            pulumi.set(__self__, "invocation_http_parameters", invocation_http_parameters)
        if oauth is not None:
            pulumi.set(__self__, "oauth", oauth)

    @_builtins.property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> Optional['outputs.EventConnectionAuthParametersApiKey']:
        """
        Parameters used for API_KEY authorization. An API key to include in the header for each authentication request. A maximum of 1 are allowed. Conflicts with `basic` and `oauth`. Documented below.
        """
        return pulumi.get(self, "api_key")

    @_builtins.property
    @pulumi.getter
    def basic(self) -> Optional['outputs.EventConnectionAuthParametersBasic']:
        """
        Parameters used for BASIC authorization. A maximum of 1 are allowed. Conflicts with `api_key` and `oauth`. Documented below.
        """
        return pulumi.get(self, "basic")

    @_builtins.property
    @pulumi.getter(name="invocationHttpParameters")
    def invocation_http_parameters(self) -> Optional['outputs.EventConnectionAuthParametersInvocationHttpParameters']:
        """
        Invocation Http Parameters are additional credentials used to sign each Invocation of the ApiDestination created from this Connection. If the ApiDestination Rule Target has additional HttpParameters, the values will be merged together, with the Connection Invocation Http Parameters taking precedence. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
        """
        return pulumi.get(self, "invocation_http_parameters")

    @_builtins.property
    @pulumi.getter
    def oauth(self) -> Optional['outputs.EventConnectionAuthParametersOauth']:
        """
        Parameters used for OAUTH_CLIENT_CREDENTIALS authorization. A maximum of 1 are allowed. Conflicts with `basic` and `api_key`. Documented below.
        """
        return pulumi.get(self, "oauth")


@pulumi.output_type
class EventConnectionAuthParametersApiKey(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Header Name.
        :param _builtins.str value: Header Value. Created and stored in AWS Secrets Manager.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Header Name.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Header Value. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventConnectionAuthParametersBasic(dict):
    def __init__(__self__, *,
                 password: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str password: A password for the authorization. Created and stored in AWS Secrets Manager.
        :param _builtins.str username: A username for the authorization.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        A password for the authorization. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        A username for the authorization.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class EventConnectionAuthParametersInvocationHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStrings":
            suggest = "query_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersInvocationHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersInvocationHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersInvocationHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bodies: Optional[Sequence['outputs.EventConnectionAuthParametersInvocationHttpParametersBody']] = None,
                 headers: Optional[Sequence['outputs.EventConnectionAuthParametersInvocationHttpParametersHeader']] = None,
                 query_strings: Optional[Sequence['outputs.EventConnectionAuthParametersInvocationHttpParametersQueryString']] = None):
        """
        :param Sequence['EventConnectionAuthParametersInvocationHttpParametersBodyArgs'] bodies: Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        :param Sequence['EventConnectionAuthParametersInvocationHttpParametersHeaderArgs'] headers: Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        :param Sequence['EventConnectionAuthParametersInvocationHttpParametersQueryStringArgs'] query_strings: Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        if bodies is not None:
            pulumi.set(__self__, "bodies", bodies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @_builtins.property
    @pulumi.getter
    def bodies(self) -> Optional[Sequence['outputs.EventConnectionAuthParametersInvocationHttpParametersBody']]:
        """
        Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "bodies")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.EventConnectionAuthParametersInvocationHttpParametersHeader']]:
        """
        Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence['outputs.EventConnectionAuthParametersInvocationHttpParametersQueryString']]:
        """
        Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "query_strings")


@pulumi.output_type
class EventConnectionAuthParametersInvocationHttpParametersBody(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersInvocationHttpParametersBody. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersInvocationHttpParametersBody.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersInvocationHttpParametersBody.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[_builtins.bool] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.bool is_value_secret: Specified whether the value is secret.
        :param _builtins.str key: The key for the parameter.
        :param _builtins.str value: The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[_builtins.bool]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key for the parameter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventConnectionAuthParametersInvocationHttpParametersHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersInvocationHttpParametersHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersInvocationHttpParametersHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersInvocationHttpParametersHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[_builtins.bool] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.bool is_value_secret: Specified whether the value is secret.
        :param _builtins.str key: The key for the parameter.
        :param _builtins.str value: The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[_builtins.bool]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key for the parameter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventConnectionAuthParametersInvocationHttpParametersQueryString(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersInvocationHttpParametersQueryString. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersInvocationHttpParametersQueryString.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersInvocationHttpParametersQueryString.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[_builtins.bool] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.bool is_value_secret: Specified whether the value is secret.
        :param _builtins.str key: The key for the parameter.
        :param _builtins.str value: The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[_builtins.bool]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key for the parameter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventConnectionAuthParametersOauth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "oauthHttpParameters":
            suggest = "oauth_http_parameters"
        elif key == "clientParameters":
            suggest = "client_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersOauth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersOauth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersOauth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: _builtins.str,
                 http_method: _builtins.str,
                 oauth_http_parameters: 'outputs.EventConnectionAuthParametersOauthOauthHttpParameters',
                 client_parameters: Optional['outputs.EventConnectionAuthParametersOauthClientParameters'] = None):
        """
        :param _builtins.str authorization_endpoint: The URL to the authorization endpoint.
        :param _builtins.str http_method: A password for the authorization. Created and stored in AWS Secrets Manager.
        :param 'EventConnectionAuthParametersOauthOauthHttpParametersArgs' oauth_http_parameters: OAuth Http Parameters are additional credentials used to sign the request to the authorization endpoint to exchange the OAuth Client information for an access token. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
        :param 'EventConnectionAuthParametersOauthClientParametersArgs' client_parameters: Contains the client parameters for OAuth authorization. Contains the following two parameters.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "oauth_http_parameters", oauth_http_parameters)
        if client_parameters is not None:
            pulumi.set(__self__, "client_parameters", client_parameters)

    @_builtins.property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> _builtins.str:
        """
        The URL to the authorization endpoint.
        """
        return pulumi.get(self, "authorization_endpoint")

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> _builtins.str:
        """
        A password for the authorization. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "http_method")

    @_builtins.property
    @pulumi.getter(name="oauthHttpParameters")
    def oauth_http_parameters(self) -> 'outputs.EventConnectionAuthParametersOauthOauthHttpParameters':
        """
        OAuth Http Parameters are additional credentials used to sign the request to the authorization endpoint to exchange the OAuth Client information for an access token. Secret values are stored and managed by AWS Secrets Manager. A maximum of 1 are allowed. Documented below.
        """
        return pulumi.get(self, "oauth_http_parameters")

    @_builtins.property
    @pulumi.getter(name="clientParameters")
    def client_parameters(self) -> Optional['outputs.EventConnectionAuthParametersOauthClientParameters']:
        """
        Contains the client parameters for OAuth authorization. Contains the following two parameters.
        """
        return pulumi.get(self, "client_parameters")


@pulumi.output_type
class EventConnectionAuthParametersOauthClientParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersOauthClientParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersOauthClientParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersOauthClientParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 client_secret: _builtins.str):
        """
        :param _builtins.str client_id: The client ID for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
        :param _builtins.str client_secret: The client secret for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        The client ID for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> _builtins.str:
        """
        The client secret for the credentials to use for authorization. Created and stored in AWS Secrets Manager.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class EventConnectionAuthParametersOauthOauthHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryStrings":
            suggest = "query_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersOauthOauthHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersOauthOauthHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersOauthOauthHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bodies: Optional[Sequence['outputs.EventConnectionAuthParametersOauthOauthHttpParametersBody']] = None,
                 headers: Optional[Sequence['outputs.EventConnectionAuthParametersOauthOauthHttpParametersHeader']] = None,
                 query_strings: Optional[Sequence['outputs.EventConnectionAuthParametersOauthOauthHttpParametersQueryString']] = None):
        """
        :param Sequence['EventConnectionAuthParametersOauthOauthHttpParametersBodyArgs'] bodies: Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        :param Sequence['EventConnectionAuthParametersOauthOauthHttpParametersHeaderArgs'] headers: Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        :param Sequence['EventConnectionAuthParametersOauthOauthHttpParametersQueryStringArgs'] query_strings: Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        if bodies is not None:
            pulumi.set(__self__, "bodies", bodies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_strings is not None:
            pulumi.set(__self__, "query_strings", query_strings)

    @_builtins.property
    @pulumi.getter
    def bodies(self) -> Optional[Sequence['outputs.EventConnectionAuthParametersOauthOauthHttpParametersBody']]:
        """
        Contains additional body string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "bodies")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.EventConnectionAuthParametersOauthOauthHttpParametersHeader']]:
        """
        Contains additional header parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter(name="queryStrings")
    def query_strings(self) -> Optional[Sequence['outputs.EventConnectionAuthParametersOauthOauthHttpParametersQueryString']]:
        """
        Contains additional query string parameters for the connection. You can include up to 100 additional body string parameters per request. Each additional parameter counts towards the event payload size, which cannot exceed 64 KB. Each parameter can contain the following:
        """
        return pulumi.get(self, "query_strings")


@pulumi.output_type
class EventConnectionAuthParametersOauthOauthHttpParametersBody(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersOauthOauthHttpParametersBody. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersOauthOauthHttpParametersBody.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersOauthOauthHttpParametersBody.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[_builtins.bool] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.bool is_value_secret: Specified whether the value is secret.
        :param _builtins.str key: The key for the parameter.
        :param _builtins.str value: The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[_builtins.bool]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key for the parameter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventConnectionAuthParametersOauthOauthHttpParametersHeader(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersOauthOauthHttpParametersHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersOauthOauthHttpParametersHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersOauthOauthHttpParametersHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[_builtins.bool] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.bool is_value_secret: Specified whether the value is secret.
        :param _builtins.str key: The key for the parameter.
        :param _builtins.str value: The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[_builtins.bool]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key for the parameter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventConnectionAuthParametersOauthOauthHttpParametersQueryString(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionAuthParametersOauthOauthHttpParametersQueryString. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionAuthParametersOauthOauthHttpParametersQueryString.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionAuthParametersOauthOauthHttpParametersQueryString.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[_builtins.bool] = None,
                 key: Optional[_builtins.str] = None,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.bool is_value_secret: Specified whether the value is secret.
        :param _builtins.str key: The key for the parameter.
        :param _builtins.str value: The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[_builtins.bool]:
        """
        Specified whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key for the parameter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The value associated with the key. Created and stored in AWS Secrets Manager if is secret.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventConnectionInvocationConnectivityParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceParameters":
            suggest = "resource_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionInvocationConnectivityParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionInvocationConnectivityParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionInvocationConnectivityParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_parameters: 'outputs.EventConnectionInvocationConnectivityParametersResourceParameters'):
        """
        :param 'EventConnectionInvocationConnectivityParametersResourceParametersArgs' resource_parameters: The parameters for EventBridge to use when invoking the resource endpoint. Documented below.
        """
        pulumi.set(__self__, "resource_parameters", resource_parameters)

    @_builtins.property
    @pulumi.getter(name="resourceParameters")
    def resource_parameters(self) -> 'outputs.EventConnectionInvocationConnectivityParametersResourceParameters':
        """
        The parameters for EventBridge to use when invoking the resource endpoint. Documented below.
        """
        return pulumi.get(self, "resource_parameters")


@pulumi.output_type
class EventConnectionInvocationConnectivityParametersResourceParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceConfigurationArn":
            suggest = "resource_configuration_arn"
        elif key == "resourceAssociationArn":
            suggest = "resource_association_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventConnectionInvocationConnectivityParametersResourceParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventConnectionInvocationConnectivityParametersResourceParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventConnectionInvocationConnectivityParametersResourceParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_configuration_arn: _builtins.str,
                 resource_association_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str resource_configuration_arn: ARN of the Amazon VPC Lattice resource configuration for the resource endpoint.
        """
        pulumi.set(__self__, "resource_configuration_arn", resource_configuration_arn)
        if resource_association_arn is not None:
            pulumi.set(__self__, "resource_association_arn", resource_association_arn)

    @_builtins.property
    @pulumi.getter(name="resourceConfigurationArn")
    def resource_configuration_arn(self) -> _builtins.str:
        """
        ARN of the Amazon VPC Lattice resource configuration for the resource endpoint.
        """
        return pulumi.get(self, "resource_configuration_arn")

    @_builtins.property
    @pulumi.getter(name="resourceAssociationArn")
    def resource_association_arn(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "resource_association_arn")


@pulumi.output_type
class EventEndpointEventBus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBusArn":
            suggest = "event_bus_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventEndpointEventBus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventEndpointEventBus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventEndpointEventBus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_bus_arn: _builtins.str):
        """
        :param _builtins.str event_bus_arn: The ARN of the event bus the endpoint is associated with.
        """
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @_builtins.property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> _builtins.str:
        """
        The ARN of the event bus the endpoint is associated with.
        """
        return pulumi.get(self, "event_bus_arn")


@pulumi.output_type
class EventEndpointReplicationConfig(dict):
    def __init__(__self__, *,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str state: The state of event replication. Valid values: `ENABLED`, `DISABLED`. The default state is `ENABLED`, which means you must supply a `role_arn`. If you don't have a `role_arn` or you don't want event replication enabled, set `state` to `DISABLED`.
        """
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of event replication. Valid values: `ENABLED`, `DISABLED`. The default state is `ENABLED`, which means you must supply a `role_arn`. If you don't have a `role_arn` or you don't want event replication enabled, set `state` to `DISABLED`.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class EventEndpointRoutingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failoverConfig":
            suggest = "failover_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventEndpointRoutingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventEndpointRoutingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventEndpointRoutingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failover_config: 'outputs.EventEndpointRoutingConfigFailoverConfig'):
        """
        :param 'EventEndpointRoutingConfigFailoverConfigArgs' failover_config: Parameters used for failover. This includes what triggers failover and what happens when it's triggered. Documented below.
        """
        pulumi.set(__self__, "failover_config", failover_config)

    @_builtins.property
    @pulumi.getter(name="failoverConfig")
    def failover_config(self) -> 'outputs.EventEndpointRoutingConfigFailoverConfig':
        """
        Parameters used for failover. This includes what triggers failover and what happens when it's triggered. Documented below.
        """
        return pulumi.get(self, "failover_config")


@pulumi.output_type
class EventEndpointRoutingConfigFailoverConfig(dict):
    def __init__(__self__, *,
                 primary: 'outputs.EventEndpointRoutingConfigFailoverConfigPrimary',
                 secondary: 'outputs.EventEndpointRoutingConfigFailoverConfigSecondary'):
        """
        :param 'EventEndpointRoutingConfigFailoverConfigPrimaryArgs' primary: Parameters used for the primary Region. Documented below.
        :param 'EventEndpointRoutingConfigFailoverConfigSecondaryArgs' secondary: Parameters used for the secondary Region, the Region that events are routed to when failover is triggered or event replication is enabled. Documented below.
        """
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "secondary", secondary)

    @_builtins.property
    @pulumi.getter
    def primary(self) -> 'outputs.EventEndpointRoutingConfigFailoverConfigPrimary':
        """
        Parameters used for the primary Region. Documented below.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter
    def secondary(self) -> 'outputs.EventEndpointRoutingConfigFailoverConfigSecondary':
        """
        Parameters used for the secondary Region, the Region that events are routed to when failover is triggered or event replication is enabled. Documented below.
        """
        return pulumi.get(self, "secondary")


@pulumi.output_type
class EventEndpointRoutingConfigFailoverConfigPrimary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheck":
            suggest = "health_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventEndpointRoutingConfigFailoverConfigPrimary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventEndpointRoutingConfigFailoverConfigPrimary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventEndpointRoutingConfigFailoverConfigPrimary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check: Optional[_builtins.str] = None):
        """
        :param _builtins.str health_check: The ARN of the health check used by the endpoint to determine whether failover is triggered.
        """
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)

    @_builtins.property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional[_builtins.str]:
        """
        The ARN of the health check used by the endpoint to determine whether failover is triggered.
        """
        return pulumi.get(self, "health_check")


@pulumi.output_type
class EventEndpointRoutingConfigFailoverConfigSecondary(dict):
    def __init__(__self__, *,
                 route: Optional[_builtins.str] = None):
        """
        :param _builtins.str route: The name of the secondary Region.
        """
        if route is not None:
            pulumi.set(__self__, "route", route)

    @_builtins.property
    @pulumi.getter
    def route(self) -> Optional[_builtins.str]:
        """
        The name of the secondary Region.
        """
        return pulumi.get(self, "route")


@pulumi.output_type
class EventPermissionCondition(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str key: Key for the condition. Valid values: `aws:PrincipalOrgID`.
        :param _builtins.str type: Type of condition. Value values: `StringEquals`.
        :param _builtins.str value: Value for the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key for the condition. Valid values: `aws:PrincipalOrgID`.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of condition. Value values: `StringEquals`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value for the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventTargetAppsyncTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "graphqlOperation":
            suggest = "graphql_operation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetAppsyncTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetAppsyncTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetAppsyncTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 graphql_operation: Optional[_builtins.str] = None):
        """
        :param _builtins.str graphql_operation: Contains the GraphQL mutation to be parsed and executed.
        """
        if graphql_operation is not None:
            pulumi.set(__self__, "graphql_operation", graphql_operation)

    @_builtins.property
    @pulumi.getter(name="graphqlOperation")
    def graphql_operation(self) -> Optional[_builtins.str]:
        """
        Contains the GraphQL mutation to be parsed and executed.
        """
        return pulumi.get(self, "graphql_operation")


@pulumi.output_type
class EventTargetBatchTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobDefinition":
            suggest = "job_definition"
        elif key == "jobName":
            suggest = "job_name"
        elif key == "arraySize":
            suggest = "array_size"
        elif key == "jobAttempts":
            suggest = "job_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetBatchTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetBatchTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetBatchTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_definition: _builtins.str,
                 job_name: _builtins.str,
                 array_size: Optional[_builtins.int] = None,
                 job_attempts: Optional[_builtins.int] = None):
        """
        :param _builtins.str job_definition: The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
        :param _builtins.str job_name: The name to use for this execution of the job, if the target is an AWS Batch job.
        :param _builtins.int array_size: The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
        :param _builtins.int job_attempts: The number of times to attempt to retry, if the job fails. Valid values are 1 to 10.
        """
        pulumi.set(__self__, "job_definition", job_definition)
        pulumi.set(__self__, "job_name", job_name)
        if array_size is not None:
            pulumi.set(__self__, "array_size", array_size)
        if job_attempts is not None:
            pulumi.set(__self__, "job_attempts", job_attempts)

    @_builtins.property
    @pulumi.getter(name="jobDefinition")
    def job_definition(self) -> _builtins.str:
        """
        The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
        """
        return pulumi.get(self, "job_definition")

    @_builtins.property
    @pulumi.getter(name="jobName")
    def job_name(self) -> _builtins.str:
        """
        The name to use for this execution of the job, if the target is an AWS Batch job.
        """
        return pulumi.get(self, "job_name")

    @_builtins.property
    @pulumi.getter(name="arraySize")
    def array_size(self) -> Optional[_builtins.int]:
        """
        The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
        """
        return pulumi.get(self, "array_size")

    @_builtins.property
    @pulumi.getter(name="jobAttempts")
    def job_attempts(self) -> Optional[_builtins.int]:
        """
        The number of times to attempt to retry, if the job fails. Valid values are 1 to 10.
        """
        return pulumi.get(self, "job_attempts")


@pulumi.output_type
class EventTargetDeadLetterConfig(dict):
    def __init__(__self__, *,
                 arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str arn: ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[_builtins.str]:
        """
        ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class EventTargetEcsTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskDefinitionArn":
            suggest = "task_definition_arn"
        elif key == "capacityProviderStrategies":
            suggest = "capacity_provider_strategies"
        elif key == "enableEcsManagedTags":
            suggest = "enable_ecs_managed_tags"
        elif key == "enableExecuteCommand":
            suggest = "enable_execute_command"
        elif key == "launchType":
            suggest = "launch_type"
        elif key == "networkConfiguration":
            suggest = "network_configuration"
        elif key == "orderedPlacementStrategies":
            suggest = "ordered_placement_strategies"
        elif key == "placementConstraints":
            suggest = "placement_constraints"
        elif key == "platformVersion":
            suggest = "platform_version"
        elif key == "propagateTags":
            suggest = "propagate_tags"
        elif key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetEcsTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetEcsTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetEcsTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 task_definition_arn: _builtins.str,
                 capacity_provider_strategies: Optional[Sequence['outputs.EventTargetEcsTargetCapacityProviderStrategy']] = None,
                 enable_ecs_managed_tags: Optional[_builtins.bool] = None,
                 enable_execute_command: Optional[_builtins.bool] = None,
                 group: Optional[_builtins.str] = None,
                 launch_type: Optional[_builtins.str] = None,
                 network_configuration: Optional['outputs.EventTargetEcsTargetNetworkConfiguration'] = None,
                 ordered_placement_strategies: Optional[Sequence['outputs.EventTargetEcsTargetOrderedPlacementStrategy']] = None,
                 placement_constraints: Optional[Sequence['outputs.EventTargetEcsTargetPlacementConstraint']] = None,
                 platform_version: Optional[_builtins.str] = None,
                 propagate_tags: Optional[_builtins.str] = None,
                 tags: Optional[Mapping[str, _builtins.str]] = None,
                 task_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str task_definition_arn: The ARN of the task definition to use if the event target is an Amazon ECS cluster.
        :param Sequence['EventTargetEcsTargetCapacityProviderStrategyArgs'] capacity_provider_strategies: The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
        :param _builtins.bool enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the task.
        :param _builtins.bool enable_execute_command: Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        :param _builtins.str group: Specifies an ECS task group for the task. The maximum length is 255 characters.
        :param _builtins.str launch_type: Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. Valid values include: `EC2`, `EXTERNAL`, or `FARGATE`.
        :param 'EventTargetEcsTargetNetworkConfigurationArgs' network_configuration: Use this if the ECS task uses the awsvpc network mode. This specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. Required if `launch_type` is `FARGATE` because the awsvpc mode is required for Fargate tasks.
        :param Sequence['EventTargetEcsTargetOrderedPlacementStrategyArgs'] ordered_placement_strategies: An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        :param Sequence['EventTargetEcsTargetPlacementConstraintArgs'] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
        :param _builtins.str platform_version: Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`. This is used only if LaunchType is FARGATE. For more information about valid platform versions, see [AWS Fargate Platform Versions](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        :param _builtins.str propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. The only valid value is: `TASK_DEFINITION`.
        :param Mapping[str, _builtins.str] tags: A map of tags to assign to ecs resources.
        :param _builtins.int task_count: The number of tasks to create based on the TaskDefinition. Defaults to `1`.
        """
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategies is not None:
            pulumi.set(__self__, "capacity_provider_strategies", capacity_provider_strategies)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if ordered_placement_strategies is not None:
            pulumi.set(__self__, "ordered_placement_strategies", ordered_placement_strategies)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @_builtins.property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> _builtins.str:
        """
        The ARN of the task definition to use if the event target is an Amazon ECS cluster.
        """
        return pulumi.get(self, "task_definition_arn")

    @_builtins.property
    @pulumi.getter(name="capacityProviderStrategies")
    def capacity_provider_strategies(self) -> Optional[Sequence['outputs.EventTargetEcsTargetCapacityProviderStrategy']]:
        """
        The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
        """
        return pulumi.get(self, "capacity_provider_strategies")

    @_builtins.property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable Amazon ECS managed tags for the task.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @_builtins.property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[_builtins.bool]:
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[_builtins.str]:
        """
        Specifies an ECS task group for the task. The maximum length is 255 characters.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[_builtins.str]:
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. Valid values include: `EC2`, `EXTERNAL`, or `FARGATE`.
        """
        return pulumi.get(self, "launch_type")

    @_builtins.property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.EventTargetEcsTargetNetworkConfiguration']:
        """
        Use this if the ECS task uses the awsvpc network mode. This specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. Required if `launch_type` is `FARGATE` because the awsvpc mode is required for Fargate tasks.
        """
        return pulumi.get(self, "network_configuration")

    @_builtins.property
    @pulumi.getter(name="orderedPlacementStrategies")
    def ordered_placement_strategies(self) -> Optional[Sequence['outputs.EventTargetEcsTargetOrderedPlacementStrategy']]:
        """
        An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        """
        return pulumi.get(self, "ordered_placement_strategies")

    @_builtins.property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[Sequence['outputs.EventTargetEcsTargetPlacementConstraint']]:
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
        """
        return pulumi.get(self, "placement_constraints")

    @_builtins.property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[_builtins.str]:
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`. This is used only if LaunchType is FARGATE. For more information about valid platform versions, see [AWS Fargate Platform Versions](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
        """
        return pulumi.get(self, "platform_version")

    @_builtins.property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[_builtins.str]:
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. The only valid value is: `TASK_DEFINITION`.
        """
        return pulumi.get(self, "propagate_tags")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of tags to assign to ecs resources.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[_builtins.int]:
        """
        The number of tasks to create based on the TaskDefinition. Defaults to `1`.
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class EventTargetEcsTargetCapacityProviderStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityProvider":
            suggest = "capacity_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetEcsTargetCapacityProviderStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetEcsTargetCapacityProviderStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetEcsTargetCapacityProviderStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_provider: _builtins.str,
                 base: Optional[_builtins.int] = None,
                 weight: Optional[_builtins.int] = None):
        """
        :param _builtins.str capacity_provider: Short name of the capacity provider.
        :param _builtins.int base: The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
        :param _builtins.int weight: The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @_builtins.property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> _builtins.str:
        """
        Short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @_builtins.property
    @pulumi.getter
    def base(self) -> Optional[_builtins.int]:
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Defaults to `0`.
        """
        return pulumi.get(self, "base")

    @_builtins.property
    @pulumi.getter
    def weight(self) -> Optional[_builtins.int]:
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class EventTargetEcsTargetNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "assignPublicIp":
            suggest = "assign_public_ip"
        elif key == "securityGroups":
            suggest = "security_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetEcsTargetNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetEcsTargetNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetEcsTargetNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnets: Sequence[_builtins.str],
                 assign_public_ip: Optional[_builtins.bool] = None,
                 security_groups: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] subnets: The subnets associated with the task or service.
        :param _builtins.bool assign_public_ip: Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Defaults to `false`.
               
               For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
        :param Sequence[_builtins.str] security_groups: The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @_builtins.property
    @pulumi.getter
    def subnets(self) -> Sequence[_builtins.str]:
        """
        The subnets associated with the task or service.
        """
        return pulumi.get(self, "subnets")

    @_builtins.property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[_builtins.bool]:
        """
        Assign a public IP address to the ENI (Fargate launch type only). Valid values are `true` or `false`. Defaults to `false`.

        For more information, see [Task Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
        """
        return pulumi.get(self, "assign_public_ip")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[_builtins.str]]:
        """
        The security groups associated with the task or service. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")


@pulumi.output_type
class EventTargetEcsTargetOrderedPlacementStrategy(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 field: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of placement strategy. The only valid values at this time are `binpack`, `random` and `spread`.
        :param _builtins.str field: The field to apply the placement strategy against. For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`. For the `binpack` placement strategy, valid values are `cpu` and `memory`. For the `random` placement strategy, this field is not used. For more information, see [Amazon ECS task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
        """
        pulumi.set(__self__, "type", type)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of placement strategy. The only valid values at this time are `binpack`, `random` and `spread`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def field(self) -> Optional[_builtins.str]:
        """
        The field to apply the placement strategy against. For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`. For the `binpack` placement strategy, valid values are `cpu` and `memory`. For the `random` placement strategy, this field is not used. For more information, see [Amazon ECS task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
        """
        return pulumi.get(self, "field")


@pulumi.output_type
class EventTargetEcsTargetPlacementConstraint(dict):
    def __init__(__self__, *,
                 type: _builtins.str,
                 expression: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
        :param _builtins.str expression: Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        pulumi.set(__self__, "type", type)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
        """
        return pulumi.get(self, "expression")


@pulumi.output_type
class EventTargetHttpTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerParameters":
            suggest = "header_parameters"
        elif key == "pathParameterValues":
            suggest = "path_parameter_values"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetHttpTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetHttpTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetHttpTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_parameters: Optional[Mapping[str, _builtins.str]] = None,
                 path_parameter_values: Optional[Sequence[_builtins.str]] = None,
                 query_string_parameters: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] header_parameters: Enables you to specify HTTP headers to add to the request.
        :param Sequence[_builtins.str] path_parameter_values: The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
        :param Mapping[str, _builtins.str] query_string_parameters: Represents keys/values of query string parameters that are appended to the invoked endpoint.
        """
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if path_parameter_values is not None:
            pulumi.set(__self__, "path_parameter_values", path_parameter_values)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @_builtins.property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Enables you to specify HTTP headers to add to the request.
        """
        return pulumi.get(self, "header_parameters")

    @_builtins.property
    @pulumi.getter(name="pathParameterValues")
    def path_parameter_values(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of values that correspond sequentially to any path variables in your endpoint ARN (for example `arn:aws:execute-api:us-east-1:123456:myapi/*/POST/pets/*`).
        """
        return pulumi.get(self, "path_parameter_values")

    @_builtins.property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Represents keys/values of query string parameters that are appended to the invoked endpoint.
        """
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class EventTargetInputTransformer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputTemplate":
            suggest = "input_template"
        elif key == "inputPaths":
            suggest = "input_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetInputTransformer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetInputTransformer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetInputTransformer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_template: _builtins.str,
                 input_paths: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str input_template: Template to customize data sent to the target. Must be valid JSON. To send a string value, the string value must include double quotes.
        :param Mapping[str, _builtins.str] input_paths: Key value pairs specified in the form of JSONPath (for example, time = $.time)
               * You can have as many as 100 key-value pairs.
               * You must use JSON dot notation, not bracket notation.
               * The keys can't start with "AWS".
        """
        pulumi.set(__self__, "input_template", input_template)
        if input_paths is not None:
            pulumi.set(__self__, "input_paths", input_paths)

    @_builtins.property
    @pulumi.getter(name="inputTemplate")
    def input_template(self) -> _builtins.str:
        """
        Template to customize data sent to the target. Must be valid JSON. To send a string value, the string value must include double quotes.
        """
        return pulumi.get(self, "input_template")

    @_builtins.property
    @pulumi.getter(name="inputPaths")
    def input_paths(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Key value pairs specified in the form of JSONPath (for example, time = $.time)
        * You can have as many as 100 key-value pairs.
        * You must use JSON dot notation, not bracket notation.
        * The keys can't start with "AWS".
        """
        return pulumi.get(self, "input_paths")


@pulumi.output_type
class EventTargetKinesisTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "partitionKeyPath":
            suggest = "partition_key_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetKinesisTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetKinesisTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetKinesisTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 partition_key_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str partition_key_path: The JSON path to be extracted from the event and used as the partition key.
        """
        if partition_key_path is not None:
            pulumi.set(__self__, "partition_key_path", partition_key_path)

    @_builtins.property
    @pulumi.getter(name="partitionKeyPath")
    def partition_key_path(self) -> Optional[_builtins.str]:
        """
        The JSON path to be extracted from the event and used as the partition key.
        """
        return pulumi.get(self, "partition_key_path")


@pulumi.output_type
class EventTargetRedshiftTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dbUser":
            suggest = "db_user"
        elif key == "secretsManagerArn":
            suggest = "secrets_manager_arn"
        elif key == "statementName":
            suggest = "statement_name"
        elif key == "withEvent":
            suggest = "with_event"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetRedshiftTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetRedshiftTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetRedshiftTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database: _builtins.str,
                 db_user: Optional[_builtins.str] = None,
                 secrets_manager_arn: Optional[_builtins.str] = None,
                 sql: Optional[_builtins.str] = None,
                 statement_name: Optional[_builtins.str] = None,
                 with_event: Optional[_builtins.bool] = None):
        """
        :param _builtins.str database: The name of the database.
        :param _builtins.str db_user: The database user name.
        :param _builtins.str secrets_manager_arn: The name or ARN of the secret that enables access to the database.
        :param _builtins.str sql: The SQL statement text to run.
        :param _builtins.str statement_name: The name of the SQL statement.
        :param _builtins.bool with_event: Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        pulumi.set(__self__, "database", database)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if secrets_manager_arn is not None:
            pulumi.set(__self__, "secrets_manager_arn", secrets_manager_arn)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if with_event is not None:
            pulumi.set(__self__, "with_event", with_event)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        """
        The name of the database.
        """
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[_builtins.str]:
        """
        The database user name.
        """
        return pulumi.get(self, "db_user")

    @_builtins.property
    @pulumi.getter(name="secretsManagerArn")
    def secrets_manager_arn(self) -> Optional[_builtins.str]:
        """
        The name or ARN of the secret that enables access to the database.
        """
        return pulumi.get(self, "secrets_manager_arn")

    @_builtins.property
    @pulumi.getter
    def sql(self) -> Optional[_builtins.str]:
        """
        The SQL statement text to run.
        """
        return pulumi.get(self, "sql")

    @_builtins.property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[_builtins.str]:
        """
        The name of the SQL statement.
        """
        return pulumi.get(self, "statement_name")

    @_builtins.property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> Optional[_builtins.bool]:
        """
        Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        return pulumi.get(self, "with_event")


@pulumi.output_type
class EventTargetRetryPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumEventAgeInSeconds":
            suggest = "maximum_event_age_in_seconds"
        elif key == "maximumRetryAttempts":
            suggest = "maximum_retry_attempts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetRetryPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetRetryPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetRetryPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_event_age_in_seconds: Optional[_builtins.int] = None,
                 maximum_retry_attempts: Optional[_builtins.int] = None):
        """
        :param _builtins.int maximum_event_age_in_seconds: The age in seconds to continue to make retry attempts.
        :param _builtins.int maximum_retry_attempts: maximum number of retry attempts to make before the request fails
        """
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)

    @_builtins.property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[_builtins.int]:
        """
        The age in seconds to continue to make retry attempts.
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @_builtins.property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[_builtins.int]:
        """
        maximum number of retry attempts to make before the request fails
        """
        return pulumi.get(self, "maximum_retry_attempts")


@pulumi.output_type
class EventTargetRunCommandTarget(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str key: Can be either `tag:tag-key` or `InstanceIds`.
        :param Sequence[_builtins.str] values: If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Can be either `tag:tag-key` or `InstanceIds`.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        If Key is `tag:tag-key`, Values is a list of tag values. If Key is `InstanceIds`, Values is a list of Amazon EC2 instance IDs.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EventTargetSagemakerPipelineTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pipelineParameterLists":
            suggest = "pipeline_parameter_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetSagemakerPipelineTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetSagemakerPipelineTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetSagemakerPipelineTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pipeline_parameter_lists: Optional[Sequence['outputs.EventTargetSagemakerPipelineTargetPipelineParameterList']] = None):
        """
        :param Sequence['EventTargetSagemakerPipelineTargetPipelineParameterListArgs'] pipeline_parameter_lists: List of Parameter names and values for SageMaker AI Model Building Pipeline execution.
        """
        if pipeline_parameter_lists is not None:
            pulumi.set(__self__, "pipeline_parameter_lists", pipeline_parameter_lists)

    @_builtins.property
    @pulumi.getter(name="pipelineParameterLists")
    def pipeline_parameter_lists(self) -> Optional[Sequence['outputs.EventTargetSagemakerPipelineTargetPipelineParameterList']]:
        """
        List of Parameter names and values for SageMaker AI Model Building Pipeline execution.
        """
        return pulumi.get(self, "pipeline_parameter_lists")


@pulumi.output_type
class EventTargetSagemakerPipelineTargetPipelineParameterList(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of parameter to start execution of a SageMaker AI Model Building Pipeline.
        :param _builtins.str value: Value of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Value of parameter to start execution of a SageMaker AI Model Building Pipeline.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EventTargetSqsTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageGroupId":
            suggest = "message_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventTargetSqsTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventTargetSqsTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventTargetSqsTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_group_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str message_group_id: The FIFO message group ID to use as the target.
        """
        if message_group_id is not None:
            pulumi.set(__self__, "message_group_id", message_group_id)

    @_builtins.property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> Optional[_builtins.str]:
        """
        The FIFO message group ID to use as the target.
        """
        return pulumi.get(self, "message_group_id")


@pulumi.output_type
class InternetMonitorHealthEventsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityScoreThreshold":
            suggest = "availability_score_threshold"
        elif key == "performanceScoreThreshold":
            suggest = "performance_score_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternetMonitorHealthEventsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternetMonitorHealthEventsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternetMonitorHealthEventsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_score_threshold: Optional[_builtins.float] = None,
                 performance_score_threshold: Optional[_builtins.float] = None):
        """
        :param _builtins.float availability_score_threshold: The health event threshold percentage set for availability scores.
        :param _builtins.float performance_score_threshold: The health event threshold percentage set for performance scores.
        """
        if availability_score_threshold is not None:
            pulumi.set(__self__, "availability_score_threshold", availability_score_threshold)
        if performance_score_threshold is not None:
            pulumi.set(__self__, "performance_score_threshold", performance_score_threshold)

    @_builtins.property
    @pulumi.getter(name="availabilityScoreThreshold")
    def availability_score_threshold(self) -> Optional[_builtins.float]:
        """
        The health event threshold percentage set for availability scores.
        """
        return pulumi.get(self, "availability_score_threshold")

    @_builtins.property
    @pulumi.getter(name="performanceScoreThreshold")
    def performance_score_threshold(self) -> Optional[_builtins.float]:
        """
        The health event threshold percentage set for performance scores.
        """
        return pulumi.get(self, "performance_score_threshold")


@pulumi.output_type
class InternetMonitorInternetMeasurementsLogDelivery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Config":
            suggest = "s3_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternetMonitorInternetMeasurementsLogDelivery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternetMonitorInternetMeasurementsLogDelivery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternetMonitorInternetMeasurementsLogDelivery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_config: Optional['outputs.InternetMonitorInternetMeasurementsLogDeliveryS3Config'] = None):
        if s3_config is not None:
            pulumi.set(__self__, "s3_config", s3_config)

    @_builtins.property
    @pulumi.getter(name="s3Config")
    def s3_config(self) -> Optional['outputs.InternetMonitorInternetMeasurementsLogDeliveryS3Config']:
        return pulumi.get(self, "s3_config")


@pulumi.output_type
class InternetMonitorInternetMeasurementsLogDeliveryS3Config(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "logDeliveryStatus":
            suggest = "log_delivery_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InternetMonitorInternetMeasurementsLogDeliveryS3Config. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InternetMonitorInternetMeasurementsLogDeliveryS3Config.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InternetMonitorInternetMeasurementsLogDeliveryS3Config.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 bucket_prefix: Optional[_builtins.str] = None,
                 log_delivery_status: Optional[_builtins.str] = None):
        pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if log_delivery_status is not None:
            pulumi.set(__self__, "log_delivery_status", log_delivery_status)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "bucket_prefix")

    @_builtins.property
    @pulumi.getter(name="logDeliveryStatus")
    def log_delivery_status(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "log_delivery_status")


@pulumi.output_type
class LogDeliveryDestinationDeliveryDestinationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationResourceArn":
            suggest = "destination_resource_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogDeliveryDestinationDeliveryDestinationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogDeliveryDestinationDeliveryDestinationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogDeliveryDestinationDeliveryDestinationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_resource_arn: _builtins.str):
        """
        :param _builtins.str destination_resource_arn: The ARN of the AWS destination that this delivery destination represents.
        """
        pulumi.set(__self__, "destination_resource_arn", destination_resource_arn)

    @_builtins.property
    @pulumi.getter(name="destinationResourceArn")
    def destination_resource_arn(self) -> _builtins.str:
        """
        The ARN of the AWS destination that this delivery destination represents.
        """
        return pulumi.get(self, "destination_resource_arn")


@pulumi.output_type
class LogDeliveryS3DeliveryConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableHiveCompatiblePath":
            suggest = "enable_hive_compatible_path"
        elif key == "suffixPath":
            suggest = "suffix_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogDeliveryS3DeliveryConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogDeliveryS3DeliveryConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogDeliveryS3DeliveryConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_hive_compatible_path: _builtins.bool,
                 suffix_path: _builtins.str):
        """
        :param _builtins.bool enable_hive_compatible_path: This parameter causes the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
        :param _builtins.str suffix_path: This string allows re-configuring the S3 object prefix to contain either static or variable sections. The valid variables to use in the suffix path will vary by each log source.
        """
        pulumi.set(__self__, "enable_hive_compatible_path", enable_hive_compatible_path)
        pulumi.set(__self__, "suffix_path", suffix_path)

    @_builtins.property
    @pulumi.getter(name="enableHiveCompatiblePath")
    def enable_hive_compatible_path(self) -> _builtins.bool:
        """
        This parameter causes the S3 objects that contain delivered logs to use a prefix structure that allows for integration with Apache Hive.
        """
        return pulumi.get(self, "enable_hive_compatible_path")

    @_builtins.property
    @pulumi.getter(name="suffixPath")
    def suffix_path(self) -> _builtins.str:
        """
        This string allows re-configuring the S3 object prefix to contain either static or variable sections. The valid variables to use in the suffix path will vary by each log source.
        """
        return pulumi.get(self, "suffix_path")


@pulumi.output_type
class LogMetricFilterMetricTransformation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogMetricFilterMetricTransformation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogMetricFilterMetricTransformation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogMetricFilterMetricTransformation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 namespace: _builtins.str,
                 value: _builtins.str,
                 default_value: Optional[_builtins.str] = None,
                 dimensions: Optional[Mapping[str, _builtins.str]] = None,
                 unit: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the CloudWatch metric to which the monitored log information should be published (e.g., `ErrorCount`)
        :param _builtins.str namespace: The destination namespace of the CloudWatch metric.
        :param _builtins.str value: What to publish to the metric. For example, if you're counting the occurrences of a particular term like "Error", the value will be "1" for each occurrence. If you're counting the bytes transferred the published value will be the value in the log event.
        :param _builtins.str default_value: The value to emit when a filter pattern does not match a log event. Conflicts with `dimensions`.
        :param Mapping[str, _builtins.str] dimensions: Map of fields to use as dimensions for the metric. Up to 3 dimensions are allowed. Conflicts with `default_value`.
        :param _builtins.str unit: The unit to assign to the metric. If you omit this, the unit is set as `None`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "value", value)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the CloudWatch metric to which the monitored log information should be published (e.g., `ErrorCount`)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The destination namespace of the CloudWatch metric.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        What to publish to the metric. For example, if you're counting the occurrences of a particular term like "Error", the value will be "1" for each occurrence. If you're counting the bytes transferred the published value will be the value in the log event.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[_builtins.str]:
        """
        The value to emit when a filter pattern does not match a log event. Conflicts with `dimensions`.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Map of fields to use as dimensions for the metric. Up to 3 dimensions are allowed. Conflicts with `default_value`.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def unit(self) -> Optional[_builtins.str]:
        """
        The unit to assign to the metric. If you omit this, the unit is set as `None`.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class MetricAlarmMetricQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "returnData":
            suggest = "return_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricAlarmMetricQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricAlarmMetricQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricAlarmMetricQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 account_id: Optional[_builtins.str] = None,
                 expression: Optional[_builtins.str] = None,
                 label: Optional[_builtins.str] = None,
                 metric: Optional['outputs.MetricAlarmMetricQueryMetric'] = None,
                 period: Optional[_builtins.int] = None,
                 return_data: Optional[_builtins.bool] = None):
        """
        :param _builtins.str id: A short name used to tie this object to the results in the response. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
        :param _builtins.str account_id: The ID of the account where the metrics are located, if this is a cross-account alarm.
        :param _builtins.str expression: The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the id of the other metrics to refer to those metrics, and can also use the id of other expressions to use the result of those expressions. For more information about metric math expressions, see Metric Math Syntax and Functions in the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax).
        :param _builtins.str label: A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents.
        :param 'MetricAlarmMetricQueryMetricArgs' metric: The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
        :param _builtins.int period: Granularity in seconds of returned data points.
               For metrics with regular resolution, valid values are any multiple of `60`.
               For high-resolution metrics, valid values are `1`, `5`, `10`, `20`, `30`, or any multiple of `60`.
        :param _builtins.bool return_data: Specify exactly one `metric_query` to be `true` to use that `metric_query` result as the alarm.
               
               > **NOTE:**  You must specify either `metric` or `expression`. Not both.
        """
        pulumi.set(__self__, "id", id)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if return_data is not None:
            pulumi.set(__self__, "return_data", return_data)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        A short name used to tie this object to the results in the response. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The ID of the account where the metrics are located, if this is a cross-account alarm.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def expression(self) -> Optional[_builtins.str]:
        """
        The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the id of the other metrics to refer to those metrics, and can also use the id of other expressions to use the result of those expressions. For more information about metric math expressions, see Metric Math Syntax and Functions in the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax).
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[_builtins.str]:
        """
        A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def metric(self) -> Optional['outputs.MetricAlarmMetricQueryMetric']:
        """
        The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[_builtins.int]:
        """
        Granularity in seconds of returned data points.
        For metrics with regular resolution, valid values are any multiple of `60`.
        For high-resolution metrics, valid values are `1`, `5`, `10`, `20`, `30`, or any multiple of `60`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="returnData")
    def return_data(self) -> Optional[_builtins.bool]:
        """
        Specify exactly one `metric_query` to be `true` to use that `metric_query` result as the alarm.

        > **NOTE:**  You must specify either `metric` or `expression`. Not both.
        """
        return pulumi.get(self, "return_data")


@pulumi.output_type
class MetricAlarmMetricQueryMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricAlarmMetricQueryMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricAlarmMetricQueryMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricAlarmMetricQueryMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: _builtins.str,
                 period: _builtins.int,
                 stat: _builtins.str,
                 dimensions: Optional[Mapping[str, _builtins.str]] = None,
                 namespace: Optional[_builtins.str] = None,
                 unit: Optional[_builtins.str] = None):
        """
        :param _builtins.str metric_name: The name for this metric.
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param _builtins.int period: Granularity in seconds of returned data points.
               For metrics with regular resolution, valid values are any multiple of `60`.
               For high-resolution metrics, valid values are `1`, `5`, `10`, `20`, `30`, or any multiple of `60`.
        :param _builtins.str stat: The statistic to apply to this metric.
               See docs for [supported statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
        :param Mapping[str, _builtins.str] dimensions: The dimensions for this metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param _builtins.str namespace: The namespace for this metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
               See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        :param _builtins.str unit: The unit for this metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "stat", stat)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> _builtins.str:
        """
        The name for this metric.
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> _builtins.int:
        """
        Granularity in seconds of returned data points.
        For metrics with regular resolution, valid values are any multiple of `60`.
        For high-resolution metrics, valid values are `1`, `5`, `10`, `20`, `30`, or any multiple of `60`.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter
    def stat(self) -> _builtins.str:
        """
        The statistic to apply to this metric.
        See docs for [supported statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
        """
        return pulumi.get(self, "stat")

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The dimensions for this metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        """
        The namespace for this metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
        See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def unit(self) -> Optional[_builtins.str]:
        """
        The unit for this metric.
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class MetricStreamExcludeFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricNames":
            suggest = "metric_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStreamExcludeFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStreamExcludeFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStreamExcludeFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: _builtins.str,
                 metric_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str namespace: Name of the metric namespace in the filter.
        :param Sequence[_builtins.str] metric_names: An array that defines the metrics you want to exclude for this metric namespace
        """
        pulumi.set(__self__, "namespace", namespace)
        if metric_names is not None:
            pulumi.set(__self__, "metric_names", metric_names)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Name of the metric namespace in the filter.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="metricNames")
    def metric_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array that defines the metrics you want to exclude for this metric namespace
        """
        return pulumi.get(self, "metric_names")


@pulumi.output_type
class MetricStreamIncludeFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricNames":
            suggest = "metric_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStreamIncludeFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStreamIncludeFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStreamIncludeFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: _builtins.str,
                 metric_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str namespace: Name of the metric namespace in the filter.
        :param Sequence[_builtins.str] metric_names: An array that defines the metrics you want to include for this metric namespace
        """
        pulumi.set(__self__, "namespace", namespace)
        if metric_names is not None:
            pulumi.set(__self__, "metric_names", metric_names)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        Name of the metric namespace in the filter.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="metricNames")
    def metric_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array that defines the metrics you want to include for this metric namespace
        """
        return pulumi.get(self, "metric_names")


@pulumi.output_type
class MetricStreamStatisticsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalStatistics":
            suggest = "additional_statistics"
        elif key == "includeMetrics":
            suggest = "include_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStreamStatisticsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStreamStatisticsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStreamStatisticsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_statistics: Sequence[_builtins.str],
                 include_metrics: Sequence['outputs.MetricStreamStatisticsConfigurationIncludeMetric']):
        """
        :param Sequence[_builtins.str] additional_statistics: The additional statistics to stream for the metrics listed in `include_metrics`.
        :param Sequence['MetricStreamStatisticsConfigurationIncludeMetricArgs'] include_metrics: An array that defines the metrics that are to have additional statistics streamed. See details below.
        """
        pulumi.set(__self__, "additional_statistics", additional_statistics)
        pulumi.set(__self__, "include_metrics", include_metrics)

    @_builtins.property
    @pulumi.getter(name="additionalStatistics")
    def additional_statistics(self) -> Sequence[_builtins.str]:
        """
        The additional statistics to stream for the metrics listed in `include_metrics`.
        """
        return pulumi.get(self, "additional_statistics")

    @_builtins.property
    @pulumi.getter(name="includeMetrics")
    def include_metrics(self) -> Sequence['outputs.MetricStreamStatisticsConfigurationIncludeMetric']:
        """
        An array that defines the metrics that are to have additional statistics streamed. See details below.
        """
        return pulumi.get(self, "include_metrics")


@pulumi.output_type
class MetricStreamStatisticsConfigurationIncludeMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetricStreamStatisticsConfigurationIncludeMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetricStreamStatisticsConfigurationIncludeMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetricStreamStatisticsConfigurationIncludeMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: _builtins.str,
                 namespace: _builtins.str):
        """
        :param _builtins.str metric_name: The name of the metric.
        """
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> _builtins.str:
        """
        The name of the metric.
        """
        return pulumi.get(self, "metric_name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        return pulumi.get(self, "namespace")


@pulumi.output_type
class GetContributorManagedInsightRulesManagedRuleResult(dict):
    def __init__(__self__, *,
                 resource_arn: _builtins.str,
                 rule_states: Sequence['outputs.GetContributorManagedInsightRulesManagedRuleRuleStateResult'],
                 template_name: _builtins.str):
        """
        :param _builtins.str resource_arn: ARN of an Amazon Web Services resource that has managed Contributor Insights rules.
        :param Sequence['GetContributorManagedInsightRulesManagedRuleRuleStateArgs'] rule_states: Describes the state of a managed rule. If the rule is enabled, it contains information about the Contributor Insights rule that contains information about the related Amazon Web Services resource. See `rule_state reference` below for details.
        :param _builtins.str template_name: Template name for the managed rule. Used to enable managed rules using `PutManagedInsightRules`.
        """
        pulumi.set(__self__, "resource_arn", resource_arn)
        pulumi.set(__self__, "rule_states", rule_states)
        pulumi.set(__self__, "template_name", template_name)

    @_builtins.property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> _builtins.str:
        """
        ARN of an Amazon Web Services resource that has managed Contributor Insights rules.
        """
        return pulumi.get(self, "resource_arn")

    @_builtins.property
    @pulumi.getter(name="ruleStates")
    def rule_states(self) -> Sequence['outputs.GetContributorManagedInsightRulesManagedRuleRuleStateResult']:
        """
        Describes the state of a managed rule. If the rule is enabled, it contains information about the Contributor Insights rule that contains information about the related Amazon Web Services resource. See `rule_state reference` below for details.
        """
        return pulumi.get(self, "rule_states")

    @_builtins.property
    @pulumi.getter(name="templateName")
    def template_name(self) -> _builtins.str:
        """
        Template name for the managed rule. Used to enable managed rules using `PutManagedInsightRules`.
        """
        return pulumi.get(self, "template_name")


@pulumi.output_type
class GetContributorManagedInsightRulesManagedRuleRuleStateResult(dict):
    def __init__(__self__, *,
                 rule_name: _builtins.str,
                 state: _builtins.str):
        """
        :param _builtins.str rule_name: Name of the Contributor Insights rule that contains data for the specified Amazon Web Services resource.
        :param _builtins.str state: Indicates whether the rule is enabled or disabled.
        """
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> _builtins.str:
        """
        Name of the Contributor Insights rule that contains data for the specified Amazon Web Services resource.
        """
        return pulumi.get(self, "rule_name")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Indicates whether the rule is enabled or disabled.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetEventBusDeadLetterConfigResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str):
        """
        :param _builtins.str arn: The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        pulumi.set(__self__, "arn", arn)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class GetEventBusLogConfigResult(dict):
    def __init__(__self__, *,
                 include_detail: _builtins.str,
                 level: _builtins.str):
        """
        :param _builtins.str include_detail: Whether EventBridge include detailed event information in the records it generates.
        :param _builtins.str level: Level of logging detail to include.
        """
        pulumi.set(__self__, "include_detail", include_detail)
        pulumi.set(__self__, "level", level)

    @_builtins.property
    @pulumi.getter(name="includeDetail")
    def include_detail(self) -> _builtins.str:
        """
        Whether EventBridge include detailed event information in the records it generates.
        """
        return pulumi.get(self, "include_detail")

    @_builtins.property
    @pulumi.getter
    def level(self) -> _builtins.str:
        """
        Level of logging detail to include.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class GetEventBusesEventBusResult(dict):
    def __init__(__self__, *,
                 arn: _builtins.str,
                 creation_time: _builtins.str,
                 description: _builtins.str,
                 last_modified_time: _builtins.str,
                 name: _builtins.str,
                 policy: _builtins.str):
        """
        :param _builtins.str arn: The ARN of the event bus.
        :param _builtins.str creation_time: The time the event bus was created.
        :param _builtins.str description: The event bus description.
        :param _builtins.str last_modified_time: The time the event bus was last modified.
        :param _builtins.str name: The name of the event bus.
        :param _builtins.str policy: The permissions policy of the event bus, describing which other AWS accounts can write events to this event bus.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policy", policy)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> _builtins.str:
        """
        The ARN of the event bus.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> _builtins.str:
        """
        The time the event bus was created.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The event bus description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> _builtins.str:
        """
        The time the event bus was last modified.
        """
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the event bus.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The permissions policy of the event bus, describing which other AWS accounts can write events to this event bus.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentConfigurationResult(dict):
    def __init__(__self__, *,
                 custom_data_identifiers: Optional[Sequence['outputs.GetLogDataProtectionPolicyDocumentConfigurationCustomDataIdentifierResult']] = None):
        """
        :param Sequence['GetLogDataProtectionPolicyDocumentConfigurationCustomDataIdentifierArgs'] custom_data_identifiers: Configures custom regular expressions to detect sensitive data. Read more in [Custom data identifiers](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL-custom-data-identifiers.html).
        """
        if custom_data_identifiers is not None:
            pulumi.set(__self__, "custom_data_identifiers", custom_data_identifiers)

    @_builtins.property
    @pulumi.getter(name="customDataIdentifiers")
    def custom_data_identifiers(self) -> Optional[Sequence['outputs.GetLogDataProtectionPolicyDocumentConfigurationCustomDataIdentifierResult']]:
        """
        Configures custom regular expressions to detect sensitive data. Read more in [Custom data identifiers](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL-custom-data-identifiers.html).
        """
        return pulumi.get(self, "custom_data_identifiers")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentConfigurationCustomDataIdentifierResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 regex: _builtins.str):
        """
        :param _builtins.str name: Name of the custom data idenfitier
        :param _builtins.str regex: Regular expression to match sensitive data
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the custom data idenfitier
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> _builtins.str:
        """
        Regular expression to match sensitive data
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentStatementResult(dict):
    def __init__(__self__, *,
                 data_identifiers: Sequence[_builtins.str],
                 operation: 'outputs.GetLogDataProtectionPolicyDocumentStatementOperationResult',
                 sid: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] data_identifiers: Set of at least 1 sensitive data identifiers that you want to mask. Read more in [Types of data that you can protect](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/protect-sensitive-log-data-types.html).
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationArgs' operation: Configures the data protection operation applied by this statement.
        :param _builtins.str sid: Name of this statement.
        """
        pulumi.set(__self__, "data_identifiers", data_identifiers)
        pulumi.set(__self__, "operation", operation)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)

    @_builtins.property
    @pulumi.getter(name="dataIdentifiers")
    def data_identifiers(self) -> Sequence[_builtins.str]:
        """
        Set of at least 1 sensitive data identifiers that you want to mask. Read more in [Types of data that you can protect](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/protect-sensitive-log-data-types.html).
        """
        return pulumi.get(self, "data_identifiers")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> 'outputs.GetLogDataProtectionPolicyDocumentStatementOperationResult':
        """
        Configures the data protection operation applied by this statement.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def sid(self) -> Optional[_builtins.str]:
        """
        Name of this statement.
        """
        return pulumi.get(self, "sid")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentStatementOperationResult(dict):
    def __init__(__self__, *,
                 audit: Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditResult'] = None,
                 deidentify: Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyResult'] = None):
        """
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditArgs' audit: Configures the detection of sensitive data.
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyArgs' deidentify: Configures the masking of sensitive data.
               
               > Every policy statement must specify exactly one operation.
        """
        if audit is not None:
            pulumi.set(__self__, "audit", audit)
        if deidentify is not None:
            pulumi.set(__self__, "deidentify", deidentify)

    @_builtins.property
    @pulumi.getter
    def audit(self) -> Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditResult']:
        """
        Configures the detection of sensitive data.
        """
        return pulumi.get(self, "audit")

    @_builtins.property
    @pulumi.getter
    def deidentify(self) -> Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyResult']:
        """
        Configures the masking of sensitive data.

        > Every policy statement must specify exactly one operation.
        """
        return pulumi.get(self, "deidentify")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditResult(dict):
    def __init__(__self__, *,
                 findings_destination: 'outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationResult'):
        """
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationArgs' findings_destination: Configures destinations to send audit findings to.
        """
        pulumi.set(__self__, "findings_destination", findings_destination)

    @_builtins.property
    @pulumi.getter(name="findingsDestination")
    def findings_destination(self) -> 'outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationResult':
        """
        Configures destinations to send audit findings to.
        """
        return pulumi.get(self, "findings_destination")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationResult(dict):
    def __init__(__self__, *,
                 cloudwatch_logs: Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsResult'] = None,
                 firehose: Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseResult'] = None,
                 s3: Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Result'] = None):
        """
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsArgs' cloudwatch_logs: Configures CloudWatch Logs as a findings destination.
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseArgs' firehose: Configures Kinesis Firehose as a findings destination.
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Args' s3: Configures S3 as a findings destination.
        """
        if cloudwatch_logs is not None:
            pulumi.set(__self__, "cloudwatch_logs", cloudwatch_logs)
        if firehose is not None:
            pulumi.set(__self__, "firehose", firehose)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @_builtins.property
    @pulumi.getter(name="cloudwatchLogs")
    def cloudwatch_logs(self) -> Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsResult']:
        """
        Configures CloudWatch Logs as a findings destination.
        """
        return pulumi.get(self, "cloudwatch_logs")

    @_builtins.property
    @pulumi.getter
    def firehose(self) -> Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseResult']:
        """
        Configures Kinesis Firehose as a findings destination.
        """
        return pulumi.get(self, "firehose")

    @_builtins.property
    @pulumi.getter
    def s3(self) -> Optional['outputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Result']:
        """
        Configures S3 as a findings destination.
        """
        return pulumi.get(self, "s3")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsResult(dict):
    def __init__(__self__, *,
                 log_group: _builtins.str):
        """
        :param _builtins.str log_group: Name of the CloudWatch Log Group to send findings to.
        """
        pulumi.set(__self__, "log_group", log_group)

    @_builtins.property
    @pulumi.getter(name="logGroup")
    def log_group(self) -> _builtins.str:
        """
        Name of the CloudWatch Log Group to send findings to.
        """
        return pulumi.get(self, "log_group")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseResult(dict):
    def __init__(__self__, *,
                 delivery_stream: _builtins.str):
        """
        :param _builtins.str delivery_stream: Name of the Kinesis Firehose Delivery Stream to send findings to.
        """
        pulumi.set(__self__, "delivery_stream", delivery_stream)

    @_builtins.property
    @pulumi.getter(name="deliveryStream")
    def delivery_stream(self) -> _builtins.str:
        """
        Name of the Kinesis Firehose Delivery Stream to send findings to.
        """
        return pulumi.get(self, "delivery_stream")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Result(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str):
        """
        :param _builtins.str bucket: Name of the S3 Bucket to send findings to.
        """
        pulumi.set(__self__, "bucket", bucket)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Name of the S3 Bucket to send findings to.
        """
        return pulumi.get(self, "bucket")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyResult(dict):
    def __init__(__self__, *,
                 mask_config: 'outputs.GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigResult'):
        """
        :param 'GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigArgs' mask_config: An empty object that configures masking.
        """
        pulumi.set(__self__, "mask_config", mask_config)

    @_builtins.property
    @pulumi.getter(name="maskConfig")
    def mask_config(self) -> 'outputs.GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigResult':
        """
        An empty object that configures masking.
        """
        return pulumi.get(self, "mask_config")


@pulumi.output_type
class GetLogDataProtectionPolicyDocumentStatementOperationDeidentifyMaskConfigResult(dict):
    def __init__(__self__):
        pass


