# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 artifacts: pulumi.Input['ProjectArtifactsArgs'],
                 environment: pulumi.Input['ProjectEnvironmentArgs'],
                 service_role: pulumi.Input[_builtins.str],
                 source: pulumi.Input['ProjectSourceArgs'],
                 badge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 build_batch_config: Optional[pulumi.Input['ProjectBuildBatchConfigArgs']] = None,
                 build_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cache: Optional[pulumi.Input['ProjectCacheArgs']] = None,
                 concurrent_build_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]] = None,
                 logs_config: Optional[pulumi.Input['ProjectLogsConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 queued_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_access_role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]] = None,
                 secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]] = None,
                 secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]] = None,
                 source_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input['ProjectVpcConfigArgs']] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input['ProjectArtifactsArgs'] artifacts: Configuration block. Detailed below.
        :param pulumi.Input['ProjectEnvironmentArgs'] environment: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] service_role: Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
               enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
        :param pulumi.Input['ProjectSourceArgs'] source: Configuration block. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.bool] badge_enabled: Generates a publicly-accessible URL for the projects build badge. Available as
               `badge_url` attribute when enabled.
        :param pulumi.Input['ProjectBuildBatchConfigArgs'] build_batch_config: Defines the batch build options for the project.
        :param pulumi.Input[_builtins.int] build_timeout: Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out
               any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is
               not available on the `Lambda` compute type.
        :param pulumi.Input['ProjectCacheArgs'] cache: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.int] concurrent_build_limit: Specify a maximum number of concurrent builds for the project. The value
               specified must be greater than 0 and less than the account concurrent running builds limit.
        :param pulumi.Input[_builtins.str] description: Short description of the project.
        :param pulumi.Input[_builtins.str] encryption_key: AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting
               the build project's build output artifacts.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]] file_system_locations: A set of file system locations to mount inside the build. File system locations
               are documented below.
        :param pulumi.Input['ProjectLogsConfigArgs'] logs_config: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] name: Project's name.
        :param pulumi.Input[_builtins.str] project_visibility: Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ`
               and `PRIVATE`. Default value is `PRIVATE`.
        :param pulumi.Input[_builtins.int] queued_timeout: Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it
               times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_access_role: The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and
               Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if
               `project_visibility` is `PUBLIC_READ`.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]] secondary_artifacts: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]] secondary_source_versions: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]] secondary_sources: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] source_version: Version of the build input to be built for this project. If not specified, the latest
               version is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider 
               `default_tags` configuration block
               present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input['ProjectVpcConfigArgs'] vpc_config: Configuration block. Detailed below.
        """
        pulumi.set(__self__, "artifacts", artifacts)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "service_role", service_role)
        pulumi.set(__self__, "source", source)
        if badge_enabled is not None:
            pulumi.set(__self__, "badge_enabled", badge_enabled)
        if build_batch_config is not None:
            pulumi.set(__self__, "build_batch_config", build_batch_config)
        if build_timeout is not None:
            pulumi.set(__self__, "build_timeout", build_timeout)
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if concurrent_build_limit is not None:
            pulumi.set(__self__, "concurrent_build_limit", concurrent_build_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if file_system_locations is not None:
            pulumi.set(__self__, "file_system_locations", file_system_locations)
        if logs_config is not None:
            pulumi.set(__self__, "logs_config", logs_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_visibility is not None:
            pulumi.set(__self__, "project_visibility", project_visibility)
        if queued_timeout is not None:
            pulumi.set(__self__, "queued_timeout", queued_timeout)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_access_role is not None:
            pulumi.set(__self__, "resource_access_role", resource_access_role)
        if secondary_artifacts is not None:
            pulumi.set(__self__, "secondary_artifacts", secondary_artifacts)
        if secondary_source_versions is not None:
            pulumi.set(__self__, "secondary_source_versions", secondary_source_versions)
        if secondary_sources is not None:
            pulumi.set(__self__, "secondary_sources", secondary_sources)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @_builtins.property
    @pulumi.getter
    def artifacts(self) -> pulumi.Input['ProjectArtifactsArgs']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: pulumi.Input['ProjectArtifactsArgs']):
        pulumi.set(self, "artifacts", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['ProjectEnvironmentArgs']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['ProjectEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Input[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_role", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input['ProjectSourceArgs']:
        """
        Configuration block. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input['ProjectSourceArgs']):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="badgeEnabled")
    def badge_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Generates a publicly-accessible URL for the projects build badge. Available as
        `badge_url` attribute when enabled.
        """
        return pulumi.get(self, "badge_enabled")

    @badge_enabled.setter
    def badge_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "badge_enabled", value)

    @_builtins.property
    @pulumi.getter(name="buildBatchConfig")
    def build_batch_config(self) -> Optional[pulumi.Input['ProjectBuildBatchConfigArgs']]:
        """
        Defines the batch build options for the project.
        """
        return pulumi.get(self, "build_batch_config")

    @build_batch_config.setter
    def build_batch_config(self, value: Optional[pulumi.Input['ProjectBuildBatchConfigArgs']]):
        pulumi.set(self, "build_batch_config", value)

    @_builtins.property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out
        any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is
        not available on the `Lambda` compute type.
        """
        return pulumi.get(self, "build_timeout")

    @build_timeout.setter
    def build_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "build_timeout", value)

    @_builtins.property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input['ProjectCacheArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input['ProjectCacheArgs']]):
        pulumi.set(self, "cache", value)

    @_builtins.property
    @pulumi.getter(name="concurrentBuildLimit")
    def concurrent_build_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify a maximum number of concurrent builds for the project. The value
        specified must be greater than 0 and less than the account concurrent running builds limit.
        """
        return pulumi.get(self, "concurrent_build_limit")

    @concurrent_build_limit.setter
    def concurrent_build_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrent_build_limit", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Short description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting
        the build project's build output artifacts.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemLocations")
    def file_system_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]]:
        """
        A set of file system locations to mount inside the build. File system locations
        are documented below.
        """
        return pulumi.get(self, "file_system_locations")

    @file_system_locations.setter
    def file_system_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]]):
        pulumi.set(self, "file_system_locations", value)

    @_builtins.property
    @pulumi.getter(name="logsConfig")
    def logs_config(self) -> Optional[pulumi.Input['ProjectLogsConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "logs_config")

    @logs_config.setter
    def logs_config(self, value: Optional[pulumi.Input['ProjectLogsConfigArgs']]):
        pulumi.set(self, "logs_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectVisibility")
    def project_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ`
        and `PRIVATE`. Default value is `PRIVATE`.
        """
        return pulumi.get(self, "project_visibility")

    @project_visibility.setter
    def project_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_visibility", value)

    @_builtins.property
    @pulumi.getter(name="queuedTimeout")
    def queued_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it
        times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
        """
        return pulumi.get(self, "queued_timeout")

    @queued_timeout.setter
    def queued_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queued_timeout", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceAccessRole")
    def resource_access_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and
        Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if
        `project_visibility` is `PUBLIC_READ`.
        """
        return pulumi.get(self, "resource_access_role")

    @resource_access_role.setter
    def resource_access_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_access_role", value)

    @_builtins.property
    @pulumi.getter(name="secondaryArtifacts")
    def secondary_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_artifacts")

    @secondary_artifacts.setter
    def secondary_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]]):
        pulumi.set(self, "secondary_artifacts", value)

    @_builtins.property
    @pulumi.getter(name="secondarySourceVersions")
    def secondary_source_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_source_versions")

    @secondary_source_versions.setter
    def secondary_source_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]]):
        pulumi.set(self, "secondary_source_versions", value)

    @_builtins.property
    @pulumi.getter(name="secondarySources")
    def secondary_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_sources")

    @secondary_sources.setter
    def secondary_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]]):
        pulumi.set(self, "secondary_sources", value)

    @_builtins.property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the build input to be built for this project. If not specified, the latest
        version is used.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider 
        `default_tags` configuration block
        present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['ProjectVpcConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['ProjectVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 artifacts: Optional[pulumi.Input['ProjectArtifactsArgs']] = None,
                 badge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 badge_url: Optional[pulumi.Input[_builtins.str]] = None,
                 build_batch_config: Optional[pulumi.Input['ProjectBuildBatchConfigArgs']] = None,
                 build_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cache: Optional[pulumi.Input['ProjectCacheArgs']] = None,
                 concurrent_build_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input['ProjectEnvironmentArgs']] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]] = None,
                 logs_config: Optional[pulumi.Input['ProjectLogsConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 public_project_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 queued_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_access_role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]] = None,
                 secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]] = None,
                 secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input['ProjectSourceArgs']] = None,
                 source_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input['ProjectVpcConfigArgs']] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[_builtins.str] arn: ARN of the CodeBuild project.
        :param pulumi.Input['ProjectArtifactsArgs'] artifacts: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.bool] badge_enabled: Generates a publicly-accessible URL for the projects build badge. Available as
               `badge_url` attribute when enabled.
        :param pulumi.Input[_builtins.str] badge_url: URL of the build badge when `badge_enabled` is enabled.
        :param pulumi.Input['ProjectBuildBatchConfigArgs'] build_batch_config: Defines the batch build options for the project.
        :param pulumi.Input[_builtins.int] build_timeout: Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out
               any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is
               not available on the `Lambda` compute type.
        :param pulumi.Input['ProjectCacheArgs'] cache: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.int] concurrent_build_limit: Specify a maximum number of concurrent builds for the project. The value
               specified must be greater than 0 and less than the account concurrent running builds limit.
        :param pulumi.Input[_builtins.str] description: Short description of the project.
        :param pulumi.Input[_builtins.str] encryption_key: AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting
               the build project's build output artifacts.
        :param pulumi.Input['ProjectEnvironmentArgs'] environment: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]] file_system_locations: A set of file system locations to mount inside the build. File system locations
               are documented below.
        :param pulumi.Input['ProjectLogsConfigArgs'] logs_config: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] name: Project's name.
        :param pulumi.Input[_builtins.str] project_visibility: Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ`
               and `PRIVATE`. Default value is `PRIVATE`.
        :param pulumi.Input[_builtins.str] public_project_alias: The project identifier used with the public build APIs.
        :param pulumi.Input[_builtins.int] queued_timeout: Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it
               times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_access_role: The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and
               Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if
               `project_visibility` is `PUBLIC_READ`.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]] secondary_artifacts: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]] secondary_source_versions: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]] secondary_sources: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] service_role: Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
               enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
        :param pulumi.Input['ProjectSourceArgs'] source: Configuration block. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] source_version: Version of the build input to be built for this project. If not specified, the latest
               version is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider 
               `default_tags` configuration block
               present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider 
               `default_tags` configuration block.
        :param pulumi.Input['ProjectVpcConfigArgs'] vpc_config: Configuration block. Detailed below.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if badge_enabled is not None:
            pulumi.set(__self__, "badge_enabled", badge_enabled)
        if badge_url is not None:
            pulumi.set(__self__, "badge_url", badge_url)
        if build_batch_config is not None:
            pulumi.set(__self__, "build_batch_config", build_batch_config)
        if build_timeout is not None:
            pulumi.set(__self__, "build_timeout", build_timeout)
        if cache is not None:
            pulumi.set(__self__, "cache", cache)
        if concurrent_build_limit is not None:
            pulumi.set(__self__, "concurrent_build_limit", concurrent_build_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if file_system_locations is not None:
            pulumi.set(__self__, "file_system_locations", file_system_locations)
        if logs_config is not None:
            pulumi.set(__self__, "logs_config", logs_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_visibility is not None:
            pulumi.set(__self__, "project_visibility", project_visibility)
        if public_project_alias is not None:
            pulumi.set(__self__, "public_project_alias", public_project_alias)
        if queued_timeout is not None:
            pulumi.set(__self__, "queued_timeout", queued_timeout)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_access_role is not None:
            pulumi.set(__self__, "resource_access_role", resource_access_role)
        if secondary_artifacts is not None:
            pulumi.set(__self__, "secondary_artifacts", secondary_artifacts)
        if secondary_source_versions is not None:
            pulumi.set(__self__, "secondary_source_versions", secondary_source_versions)
        if secondary_sources is not None:
            pulumi.set(__self__, "secondary_sources", secondary_sources)
        if service_role is not None:
            pulumi.set(__self__, "service_role", service_role)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_version is not None:
            pulumi.set(__self__, "source_version", source_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ARN of the CodeBuild project.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input['ProjectArtifactsArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input['ProjectArtifactsArgs']]):
        pulumi.set(self, "artifacts", value)

    @_builtins.property
    @pulumi.getter(name="badgeEnabled")
    def badge_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Generates a publicly-accessible URL for the projects build badge. Available as
        `badge_url` attribute when enabled.
        """
        return pulumi.get(self, "badge_enabled")

    @badge_enabled.setter
    def badge_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "badge_enabled", value)

    @_builtins.property
    @pulumi.getter(name="badgeUrl")
    def badge_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the build badge when `badge_enabled` is enabled.
        """
        return pulumi.get(self, "badge_url")

    @badge_url.setter
    def badge_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "badge_url", value)

    @_builtins.property
    @pulumi.getter(name="buildBatchConfig")
    def build_batch_config(self) -> Optional[pulumi.Input['ProjectBuildBatchConfigArgs']]:
        """
        Defines the batch build options for the project.
        """
        return pulumi.get(self, "build_batch_config")

    @build_batch_config.setter
    def build_batch_config(self, value: Optional[pulumi.Input['ProjectBuildBatchConfigArgs']]):
        pulumi.set(self, "build_batch_config", value)

    @_builtins.property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out
        any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is
        not available on the `Lambda` compute type.
        """
        return pulumi.get(self, "build_timeout")

    @build_timeout.setter
    def build_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "build_timeout", value)

    @_builtins.property
    @pulumi.getter
    def cache(self) -> Optional[pulumi.Input['ProjectCacheArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "cache")

    @cache.setter
    def cache(self, value: Optional[pulumi.Input['ProjectCacheArgs']]):
        pulumi.set(self, "cache", value)

    @_builtins.property
    @pulumi.getter(name="concurrentBuildLimit")
    def concurrent_build_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify a maximum number of concurrent builds for the project. The value
        specified must be greater than 0 and less than the account concurrent running builds limit.
        """
        return pulumi.get(self, "concurrent_build_limit")

    @concurrent_build_limit.setter
    def concurrent_build_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "concurrent_build_limit", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Short description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting
        the build project's build output artifacts.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['ProjectEnvironmentArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['ProjectEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="fileSystemLocations")
    def file_system_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]]:
        """
        A set of file system locations to mount inside the build. File system locations
        are documented below.
        """
        return pulumi.get(self, "file_system_locations")

    @file_system_locations.setter
    def file_system_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectFileSystemLocationArgs']]]]):
        pulumi.set(self, "file_system_locations", value)

    @_builtins.property
    @pulumi.getter(name="logsConfig")
    def logs_config(self) -> Optional[pulumi.Input['ProjectLogsConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "logs_config")

    @logs_config.setter
    def logs_config(self, value: Optional[pulumi.Input['ProjectLogsConfigArgs']]):
        pulumi.set(self, "logs_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectVisibility")
    def project_visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ`
        and `PRIVATE`. Default value is `PRIVATE`.
        """
        return pulumi.get(self, "project_visibility")

    @project_visibility.setter
    def project_visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_visibility", value)

    @_builtins.property
    @pulumi.getter(name="publicProjectAlias")
    def public_project_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project identifier used with the public build APIs.
        """
        return pulumi.get(self, "public_project_alias")

    @public_project_alias.setter
    def public_project_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_project_alias", value)

    @_builtins.property
    @pulumi.getter(name="queuedTimeout")
    def queued_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it
        times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
        """
        return pulumi.get(self, "queued_timeout")

    @queued_timeout.setter
    def queued_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queued_timeout", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceAccessRole")
    def resource_access_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and
        Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if
        `project_visibility` is `PUBLIC_READ`.
        """
        return pulumi.get(self, "resource_access_role")

    @resource_access_role.setter
    def resource_access_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_access_role", value)

    @_builtins.property
    @pulumi.getter(name="secondaryArtifacts")
    def secondary_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_artifacts")

    @secondary_artifacts.setter
    def secondary_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondaryArtifactArgs']]]]):
        pulumi.set(self, "secondary_artifacts", value)

    @_builtins.property
    @pulumi.getter(name="secondarySourceVersions")
    def secondary_source_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_source_versions")

    @secondary_source_versions.setter
    def secondary_source_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceVersionArgs']]]]):
        pulumi.set(self, "secondary_source_versions", value)

    @_builtins.property
    @pulumi.getter(name="secondarySources")
    def secondary_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_sources")

    @secondary_sources.setter
    def secondary_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProjectSecondarySourceArgs']]]]):
        pulumi.set(self, "secondary_sources", value)

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
        """
        return pulumi.get(self, "service_role")

    @service_role.setter
    def service_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_role", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['ProjectSourceArgs']]:
        """
        Configuration block. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['ProjectSourceArgs']]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of the build input to be built for this project. If not specified, the latest
        version is used.
        """
        return pulumi.get(self, "source_version")

    @source_version.setter
    def source_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Map of tags to assign to the resource. If configured with a provider 
        `default_tags` configuration block
        present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider 
        `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional[pulumi.Input['ProjectVpcConfigArgs']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

    @vpc_config.setter
    def vpc_config(self, value: Optional[pulumi.Input['ProjectVpcConfigArgs']]):
        pulumi.set(self, "vpc_config", value)


@pulumi.type_token("aws:codebuild/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifacts: Optional[pulumi.Input[Union['ProjectArtifactsArgs', 'ProjectArtifactsArgsDict']]] = None,
                 badge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 build_batch_config: Optional[pulumi.Input[Union['ProjectBuildBatchConfigArgs', 'ProjectBuildBatchConfigArgsDict']]] = None,
                 build_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cache: Optional[pulumi.Input[Union['ProjectCacheArgs', 'ProjectCacheArgsDict']]] = None,
                 concurrent_build_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['ProjectEnvironmentArgs', 'ProjectEnvironmentArgsDict']]] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectFileSystemLocationArgs', 'ProjectFileSystemLocationArgsDict']]]]] = None,
                 logs_config: Optional[pulumi.Input[Union['ProjectLogsConfigArgs', 'ProjectLogsConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 queued_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_access_role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondaryArtifactArgs', 'ProjectSecondaryArtifactArgsDict']]]]] = None,
                 secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceVersionArgs', 'ProjectSecondarySourceVersionArgsDict']]]]] = None,
                 secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceArgs', 'ProjectSecondarySourceArgsDict']]]]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['ProjectSourceArgs', 'ProjectSourceArgsDict']]] = None,
                 source_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['ProjectVpcConfigArgs', 'ProjectVpcConfigArgsDict']]] = None,
                 __props__=None):
        """
        Provides a CodeBuild Project resource. See also the
        `codebuild.Webhook` resource, which manages the webhook to the
        source (e.g., the "rebuild every time a code change is pushed" option in the CodeBuild web console).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example", bucket="example")
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example_bucket.id,
            acl="private")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["codebuild.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role.json)
        example = pulumi.Output.all(
            exampleBucketArn=example_bucket.arn,
            exampleBucketArn1=example_bucket.arn
        ).apply(lambda resolved_outputs: aws.iam.get_policy_document_output(statements=[
            {
                "effect": "Allow",
                "actions": [
                    "logs:CreateLogGroup",
                    "logs:CreateLogStream",
                    "logs:PutLogEvents",
                ],
                "resources": ["*"],
            },
            {
                "effect": "Allow",
                "actions": [
                    "ec2:CreateNetworkInterface",
                    "ec2:DescribeDhcpOptions",
                    "ec2:DescribeNetworkInterfaces",
                    "ec2:DeleteNetworkInterface",
                    "ec2:DescribeSubnets",
                    "ec2:DescribeSecurityGroups",
                    "ec2:DescribeVpcs",
                ],
                "resources": ["*"],
            },
            {
                "effect": "Allow",
                "actions": ["ec2:CreateNetworkInterfacePermission"],
                "resources": ["arn:aws:ec2:us-east-1:123456789012:network-interface/*"],
                "conditions": [
                    {
                        "test": "StringEquals",
                        "variable": "ec2:Subnet",
                        "values": [
                            example1["arn"],
                            example2["arn"],
                        ],
                    },
                    {
                        "test": "StringEquals",
                        "variable": "ec2:AuthorizedService",
                        "values": ["codebuild.amazonaws.com"],
                    },
                ],
            },
            {
                "effect": "Allow",
                "actions": ["s3:*"],
                "resources": [
                    resolved_outputs['exampleBucketArn'],
                    f"{resolved_outputs['exampleBucketArn1']}/*",
                ],
            },
            {
                "effect": "Allow",
                "actions": [
                    "codeconnections:GetConnectionToken",
                    "codeconnections:GetConnection",
                ],
                "resources": ["arn:aws:codestar-connections:us-east-1:123456789012:connection/guid-string"],
            },
        ]))

        example_role_policy = aws.iam.RolePolicy("example",
            role=example_role.name,
            policy=example.json)
        example_project = aws.codebuild.Project("example",
            name="test-project",
            description="test_codebuild_project",
            build_timeout=5,
            service_role=example_role.arn,
            artifacts={
                "type": "NO_ARTIFACTS",
            },
            cache={
                "type": "S3",
                "location": example_bucket.bucket,
            },
            environment={
                "compute_type": "BUILD_GENERAL1_SMALL",
                "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
                "type": "LINUX_CONTAINER",
                "image_pull_credentials_type": "CODEBUILD",
                "environment_variables": [
                    {
                        "name": "SOME_KEY1",
                        "value": "SOME_VALUE1",
                    },
                    {
                        "name": "SOME_KEY2",
                        "value": "SOME_VALUE2",
                        "type": "PARAMETER_STORE",
                    },
                ],
            },
            logs_config={
                "cloudwatch_logs": {
                    "group_name": "log-group",
                    "stream_name": "log-stream",
                },
                "s3_logs": {
                    "status": "ENABLED",
                    "location": example_bucket.id.apply(lambda id: f"{id}/build-log"),
                },
            },
            source={
                "type": "GITHUB",
                "location": "https://github.com/mitchellh/packer.git",
                "git_clone_depth": 1,
                "git_submodules_config": {
                    "fetch_submodules": True,
                },
            },
            source_version="master",
            vpc_config={
                "vpc_id": example_aws_vpc["id"],
                "subnets": [
                    example1["id"],
                    example2["id"],
                ],
                "security_group_ids": [
                    example1_aws_security_group["id"],
                    example2_aws_security_group["id"],
                ],
            },
            tags={
                "Environment": "Test",
            })
        project_with_cache = aws.codebuild.Project("project-with-cache",
            name="test-project-cache",
            description="test_codebuild_project_cache",
            build_timeout=5,
            queued_timeout=5,
            service_role=example_role.arn,
            artifacts={
                "type": "NO_ARTIFACTS",
            },
            cache={
                "type": "LOCAL",
                "modes": [
                    "LOCAL_DOCKER_LAYER_CACHE",
                    "LOCAL_SOURCE_CACHE",
                ],
            },
            environment={
                "compute_type": "BUILD_GENERAL1_SMALL",
                "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
                "type": "LINUX_CONTAINER",
                "image_pull_credentials_type": "CODEBUILD",
                "environment_variables": [{
                    "name": "SOME_KEY1",
                    "value": "SOME_VALUE1",
                }],
            },
            source={
                "type": "GITHUB",
                "location": "https://github.com/mitchellh/packer.git",
                "git_clone_depth": 1,
            },
            tags={
                "Environment": "Test",
            })
        project_using_github_app = aws.codebuild.Project("project-using-github-app",
            name="project-using-github-app",
            description="gets_source_from_github_via_the_github_app",
            service_role=example_role.arn,
            artifacts={
                "type": "NO_ARTIFACTS",
            },
            environment={
                "compute_type": "BUILD_GENERAL1_SMALL",
                "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
                "type": "LINUX_CONTAINER",
                "image_pull_credentials_type": "CODEBUILD",
            },
            source={
                "type": "GITHUB",
                "location": "https://github.com/example/example.git",
                "auth": {
                    "type": "CODECONNECTIONS",
                    "resource": "arn:aws:codestar-connections:us-east-1:123456789012:connection/guid-string",
                },
            })
        ```

        ### Runner Project

        While no special configuration is required for `codebuild.Project` to create a project as a Runner Project, an `codebuild.Webhook` resource with an appropriate `filter_group` is required.
        See the `codebuild.Webhook` resource documentation example for more details.

        ## Import

        Using `pulumi import`, import CodeBuild Project using the `name`. For example:

        ```sh
        $ pulumi import aws:codebuild/project:Project name project-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProjectArtifactsArgs', 'ProjectArtifactsArgsDict']] artifacts: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.bool] badge_enabled: Generates a publicly-accessible URL for the projects build badge. Available as
               `badge_url` attribute when enabled.
        :param pulumi.Input[Union['ProjectBuildBatchConfigArgs', 'ProjectBuildBatchConfigArgsDict']] build_batch_config: Defines the batch build options for the project.
        :param pulumi.Input[_builtins.int] build_timeout: Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out
               any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is
               not available on the `Lambda` compute type.
        :param pulumi.Input[Union['ProjectCacheArgs', 'ProjectCacheArgsDict']] cache: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.int] concurrent_build_limit: Specify a maximum number of concurrent builds for the project. The value
               specified must be greater than 0 and less than the account concurrent running builds limit.
        :param pulumi.Input[_builtins.str] description: Short description of the project.
        :param pulumi.Input[_builtins.str] encryption_key: AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting
               the build project's build output artifacts.
        :param pulumi.Input[Union['ProjectEnvironmentArgs', 'ProjectEnvironmentArgsDict']] environment: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectFileSystemLocationArgs', 'ProjectFileSystemLocationArgsDict']]]] file_system_locations: A set of file system locations to mount inside the build. File system locations
               are documented below.
        :param pulumi.Input[Union['ProjectLogsConfigArgs', 'ProjectLogsConfigArgsDict']] logs_config: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] name: Project's name.
        :param pulumi.Input[_builtins.str] project_visibility: Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ`
               and `PRIVATE`. Default value is `PRIVATE`.
        :param pulumi.Input[_builtins.int] queued_timeout: Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it
               times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_access_role: The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and
               Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if
               `project_visibility` is `PUBLIC_READ`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondaryArtifactArgs', 'ProjectSecondaryArtifactArgsDict']]]] secondary_artifacts: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceVersionArgs', 'ProjectSecondarySourceVersionArgsDict']]]] secondary_source_versions: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceArgs', 'ProjectSecondarySourceArgsDict']]]] secondary_sources: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] service_role: Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
               enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
        :param pulumi.Input[Union['ProjectSourceArgs', 'ProjectSourceArgsDict']] source: Configuration block. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] source_version: Version of the build input to be built for this project. If not specified, the latest
               version is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider 
               `default_tags` configuration block
               present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Union['ProjectVpcConfigArgs', 'ProjectVpcConfigArgsDict']] vpc_config: Configuration block. Detailed below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CodeBuild Project resource. See also the
        `codebuild.Webhook` resource, which manages the webhook to the
        source (e.g., the "rebuild every time a code change is pushed" option in the CodeBuild web console).

        ## Example Usage

        ### Basic Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        example_bucket = aws.s3.Bucket("example", bucket="example")
        example_bucket_acl = aws.s3.BucketAcl("example",
            bucket=example_bucket.id,
            acl="private")
        assume_role = aws.iam.get_policy_document(statements=[{
            "effect": "Allow",
            "principals": [{
                "type": "Service",
                "identifiers": ["codebuild.amazonaws.com"],
            }],
            "actions": ["sts:AssumeRole"],
        }])
        example_role = aws.iam.Role("example",
            name="example",
            assume_role_policy=assume_role.json)
        example = pulumi.Output.all(
            exampleBucketArn=example_bucket.arn,
            exampleBucketArn1=example_bucket.arn
        ).apply(lambda resolved_outputs: aws.iam.get_policy_document_output(statements=[
            {
                "effect": "Allow",
                "actions": [
                    "logs:CreateLogGroup",
                    "logs:CreateLogStream",
                    "logs:PutLogEvents",
                ],
                "resources": ["*"],
            },
            {
                "effect": "Allow",
                "actions": [
                    "ec2:CreateNetworkInterface",
                    "ec2:DescribeDhcpOptions",
                    "ec2:DescribeNetworkInterfaces",
                    "ec2:DeleteNetworkInterface",
                    "ec2:DescribeSubnets",
                    "ec2:DescribeSecurityGroups",
                    "ec2:DescribeVpcs",
                ],
                "resources": ["*"],
            },
            {
                "effect": "Allow",
                "actions": ["ec2:CreateNetworkInterfacePermission"],
                "resources": ["arn:aws:ec2:us-east-1:123456789012:network-interface/*"],
                "conditions": [
                    {
                        "test": "StringEquals",
                        "variable": "ec2:Subnet",
                        "values": [
                            example1["arn"],
                            example2["arn"],
                        ],
                    },
                    {
                        "test": "StringEquals",
                        "variable": "ec2:AuthorizedService",
                        "values": ["codebuild.amazonaws.com"],
                    },
                ],
            },
            {
                "effect": "Allow",
                "actions": ["s3:*"],
                "resources": [
                    resolved_outputs['exampleBucketArn'],
                    f"{resolved_outputs['exampleBucketArn1']}/*",
                ],
            },
            {
                "effect": "Allow",
                "actions": [
                    "codeconnections:GetConnectionToken",
                    "codeconnections:GetConnection",
                ],
                "resources": ["arn:aws:codestar-connections:us-east-1:123456789012:connection/guid-string"],
            },
        ]))

        example_role_policy = aws.iam.RolePolicy("example",
            role=example_role.name,
            policy=example.json)
        example_project = aws.codebuild.Project("example",
            name="test-project",
            description="test_codebuild_project",
            build_timeout=5,
            service_role=example_role.arn,
            artifacts={
                "type": "NO_ARTIFACTS",
            },
            cache={
                "type": "S3",
                "location": example_bucket.bucket,
            },
            environment={
                "compute_type": "BUILD_GENERAL1_SMALL",
                "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
                "type": "LINUX_CONTAINER",
                "image_pull_credentials_type": "CODEBUILD",
                "environment_variables": [
                    {
                        "name": "SOME_KEY1",
                        "value": "SOME_VALUE1",
                    },
                    {
                        "name": "SOME_KEY2",
                        "value": "SOME_VALUE2",
                        "type": "PARAMETER_STORE",
                    },
                ],
            },
            logs_config={
                "cloudwatch_logs": {
                    "group_name": "log-group",
                    "stream_name": "log-stream",
                },
                "s3_logs": {
                    "status": "ENABLED",
                    "location": example_bucket.id.apply(lambda id: f"{id}/build-log"),
                },
            },
            source={
                "type": "GITHUB",
                "location": "https://github.com/mitchellh/packer.git",
                "git_clone_depth": 1,
                "git_submodules_config": {
                    "fetch_submodules": True,
                },
            },
            source_version="master",
            vpc_config={
                "vpc_id": example_aws_vpc["id"],
                "subnets": [
                    example1["id"],
                    example2["id"],
                ],
                "security_group_ids": [
                    example1_aws_security_group["id"],
                    example2_aws_security_group["id"],
                ],
            },
            tags={
                "Environment": "Test",
            })
        project_with_cache = aws.codebuild.Project("project-with-cache",
            name="test-project-cache",
            description="test_codebuild_project_cache",
            build_timeout=5,
            queued_timeout=5,
            service_role=example_role.arn,
            artifacts={
                "type": "NO_ARTIFACTS",
            },
            cache={
                "type": "LOCAL",
                "modes": [
                    "LOCAL_DOCKER_LAYER_CACHE",
                    "LOCAL_SOURCE_CACHE",
                ],
            },
            environment={
                "compute_type": "BUILD_GENERAL1_SMALL",
                "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
                "type": "LINUX_CONTAINER",
                "image_pull_credentials_type": "CODEBUILD",
                "environment_variables": [{
                    "name": "SOME_KEY1",
                    "value": "SOME_VALUE1",
                }],
            },
            source={
                "type": "GITHUB",
                "location": "https://github.com/mitchellh/packer.git",
                "git_clone_depth": 1,
            },
            tags={
                "Environment": "Test",
            })
        project_using_github_app = aws.codebuild.Project("project-using-github-app",
            name="project-using-github-app",
            description="gets_source_from_github_via_the_github_app",
            service_role=example_role.arn,
            artifacts={
                "type": "NO_ARTIFACTS",
            },
            environment={
                "compute_type": "BUILD_GENERAL1_SMALL",
                "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
                "type": "LINUX_CONTAINER",
                "image_pull_credentials_type": "CODEBUILD",
            },
            source={
                "type": "GITHUB",
                "location": "https://github.com/example/example.git",
                "auth": {
                    "type": "CODECONNECTIONS",
                    "resource": "arn:aws:codestar-connections:us-east-1:123456789012:connection/guid-string",
                },
            })
        ```

        ### Runner Project

        While no special configuration is required for `codebuild.Project` to create a project as a Runner Project, an `codebuild.Webhook` resource with an appropriate `filter_group` is required.
        See the `codebuild.Webhook` resource documentation example for more details.

        ## Import

        Using `pulumi import`, import CodeBuild Project using the `name`. For example:

        ```sh
        $ pulumi import aws:codebuild/project:Project name project-name
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 artifacts: Optional[pulumi.Input[Union['ProjectArtifactsArgs', 'ProjectArtifactsArgsDict']]] = None,
                 badge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 build_batch_config: Optional[pulumi.Input[Union['ProjectBuildBatchConfigArgs', 'ProjectBuildBatchConfigArgsDict']]] = None,
                 build_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 cache: Optional[pulumi.Input[Union['ProjectCacheArgs', 'ProjectCacheArgsDict']]] = None,
                 concurrent_build_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['ProjectEnvironmentArgs', 'ProjectEnvironmentArgsDict']]] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectFileSystemLocationArgs', 'ProjectFileSystemLocationArgsDict']]]]] = None,
                 logs_config: Optional[pulumi.Input[Union['ProjectLogsConfigArgs', 'ProjectLogsConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 queued_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_access_role: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondaryArtifactArgs', 'ProjectSecondaryArtifactArgsDict']]]]] = None,
                 secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceVersionArgs', 'ProjectSecondarySourceVersionArgsDict']]]]] = None,
                 secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceArgs', 'ProjectSecondarySourceArgsDict']]]]] = None,
                 service_role: Optional[pulumi.Input[_builtins.str]] = None,
                 source: Optional[pulumi.Input[Union['ProjectSourceArgs', 'ProjectSourceArgsDict']]] = None,
                 source_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_config: Optional[pulumi.Input[Union['ProjectVpcConfigArgs', 'ProjectVpcConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            if artifacts is None and not opts.urn:
                raise TypeError("Missing required property 'artifacts'")
            __props__.__dict__["artifacts"] = artifacts
            __props__.__dict__["badge_enabled"] = badge_enabled
            __props__.__dict__["build_batch_config"] = build_batch_config
            __props__.__dict__["build_timeout"] = build_timeout
            __props__.__dict__["cache"] = cache
            __props__.__dict__["concurrent_build_limit"] = concurrent_build_limit
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_key"] = encryption_key
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["file_system_locations"] = file_system_locations
            __props__.__dict__["logs_config"] = logs_config
            __props__.__dict__["name"] = name
            __props__.__dict__["project_visibility"] = project_visibility
            __props__.__dict__["queued_timeout"] = queued_timeout
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_access_role"] = resource_access_role
            __props__.__dict__["secondary_artifacts"] = secondary_artifacts
            __props__.__dict__["secondary_source_versions"] = secondary_source_versions
            __props__.__dict__["secondary_sources"] = secondary_sources
            if service_role is None and not opts.urn:
                raise TypeError("Missing required property 'service_role'")
            __props__.__dict__["service_role"] = service_role
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["source_version"] = source_version
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_config"] = vpc_config
            __props__.__dict__["arn"] = None
            __props__.__dict__["badge_url"] = None
            __props__.__dict__["public_project_alias"] = None
            __props__.__dict__["tags_all"] = None
        super(Project, __self__).__init__(
            'aws:codebuild/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            artifacts: Optional[pulumi.Input[Union['ProjectArtifactsArgs', 'ProjectArtifactsArgsDict']]] = None,
            badge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            badge_url: Optional[pulumi.Input[_builtins.str]] = None,
            build_batch_config: Optional[pulumi.Input[Union['ProjectBuildBatchConfigArgs', 'ProjectBuildBatchConfigArgsDict']]] = None,
            build_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            cache: Optional[pulumi.Input[Union['ProjectCacheArgs', 'ProjectCacheArgsDict']]] = None,
            concurrent_build_limit: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['ProjectEnvironmentArgs', 'ProjectEnvironmentArgsDict']]] = None,
            file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectFileSystemLocationArgs', 'ProjectFileSystemLocationArgsDict']]]]] = None,
            logs_config: Optional[pulumi.Input[Union['ProjectLogsConfigArgs', 'ProjectLogsConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_visibility: Optional[pulumi.Input[_builtins.str]] = None,
            public_project_alias: Optional[pulumi.Input[_builtins.str]] = None,
            queued_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_access_role: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondaryArtifactArgs', 'ProjectSecondaryArtifactArgsDict']]]]] = None,
            secondary_source_versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceVersionArgs', 'ProjectSecondarySourceVersionArgsDict']]]]] = None,
            secondary_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceArgs', 'ProjectSecondarySourceArgsDict']]]]] = None,
            service_role: Optional[pulumi.Input[_builtins.str]] = None,
            source: Optional[pulumi.Input[Union['ProjectSourceArgs', 'ProjectSourceArgsDict']]] = None,
            source_version: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_config: Optional[pulumi.Input[Union['ProjectVpcConfigArgs', 'ProjectVpcConfigArgsDict']]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: ARN of the CodeBuild project.
        :param pulumi.Input[Union['ProjectArtifactsArgs', 'ProjectArtifactsArgsDict']] artifacts: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.bool] badge_enabled: Generates a publicly-accessible URL for the projects build badge. Available as
               `badge_url` attribute when enabled.
        :param pulumi.Input[_builtins.str] badge_url: URL of the build badge when `badge_enabled` is enabled.
        :param pulumi.Input[Union['ProjectBuildBatchConfigArgs', 'ProjectBuildBatchConfigArgsDict']] build_batch_config: Defines the batch build options for the project.
        :param pulumi.Input[_builtins.int] build_timeout: Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out
               any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is
               not available on the `Lambda` compute type.
        :param pulumi.Input[Union['ProjectCacheArgs', 'ProjectCacheArgsDict']] cache: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.int] concurrent_build_limit: Specify a maximum number of concurrent builds for the project. The value
               specified must be greater than 0 and less than the account concurrent running builds limit.
        :param pulumi.Input[_builtins.str] description: Short description of the project.
        :param pulumi.Input[_builtins.str] encryption_key: AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting
               the build project's build output artifacts.
        :param pulumi.Input[Union['ProjectEnvironmentArgs', 'ProjectEnvironmentArgsDict']] environment: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectFileSystemLocationArgs', 'ProjectFileSystemLocationArgsDict']]]] file_system_locations: A set of file system locations to mount inside the build. File system locations
               are documented below.
        :param pulumi.Input[Union['ProjectLogsConfigArgs', 'ProjectLogsConfigArgsDict']] logs_config: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] name: Project's name.
        :param pulumi.Input[_builtins.str] project_visibility: Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ`
               and `PRIVATE`. Default value is `PRIVATE`.
        :param pulumi.Input[_builtins.str] public_project_alias: The project identifier used with the public build APIs.
        :param pulumi.Input[_builtins.int] queued_timeout: Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it
               times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[_builtins.str] resource_access_role: The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and
               Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if
               `project_visibility` is `PUBLIC_READ`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondaryArtifactArgs', 'ProjectSecondaryArtifactArgsDict']]]] secondary_artifacts: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceVersionArgs', 'ProjectSecondarySourceVersionArgsDict']]]] secondary_source_versions: Configuration block. Detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProjectSecondarySourceArgs', 'ProjectSecondarySourceArgsDict']]]] secondary_sources: Configuration block. Detailed below.
        :param pulumi.Input[_builtins.str] service_role: Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
               enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
        :param pulumi.Input[Union['ProjectSourceArgs', 'ProjectSourceArgsDict']] source: Configuration block. Detailed below.
               
               The following arguments are optional:
        :param pulumi.Input[_builtins.str] source_version: Version of the build input to be built for this project. If not specified, the latest
               version is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Map of tags to assign to the resource. If configured with a provider 
               `default_tags` configuration block
               present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider 
               `default_tags` configuration block.
        :param pulumi.Input[Union['ProjectVpcConfigArgs', 'ProjectVpcConfigArgsDict']] vpc_config: Configuration block. Detailed below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["artifacts"] = artifacts
        __props__.__dict__["badge_enabled"] = badge_enabled
        __props__.__dict__["badge_url"] = badge_url
        __props__.__dict__["build_batch_config"] = build_batch_config
        __props__.__dict__["build_timeout"] = build_timeout
        __props__.__dict__["cache"] = cache
        __props__.__dict__["concurrent_build_limit"] = concurrent_build_limit
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["environment"] = environment
        __props__.__dict__["file_system_locations"] = file_system_locations
        __props__.__dict__["logs_config"] = logs_config
        __props__.__dict__["name"] = name
        __props__.__dict__["project_visibility"] = project_visibility
        __props__.__dict__["public_project_alias"] = public_project_alias
        __props__.__dict__["queued_timeout"] = queued_timeout
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_access_role"] = resource_access_role
        __props__.__dict__["secondary_artifacts"] = secondary_artifacts
        __props__.__dict__["secondary_source_versions"] = secondary_source_versions
        __props__.__dict__["secondary_sources"] = secondary_sources
        __props__.__dict__["service_role"] = service_role
        __props__.__dict__["source"] = source
        __props__.__dict__["source_version"] = source_version
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["vpc_config"] = vpc_config
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        ARN of the CodeBuild project.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def artifacts(self) -> pulumi.Output['outputs.ProjectArtifacts']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "artifacts")

    @_builtins.property
    @pulumi.getter(name="badgeEnabled")
    def badge_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Generates a publicly-accessible URL for the projects build badge. Available as
        `badge_url` attribute when enabled.
        """
        return pulumi.get(self, "badge_enabled")

    @_builtins.property
    @pulumi.getter(name="badgeUrl")
    def badge_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the build badge when `badge_enabled` is enabled.
        """
        return pulumi.get(self, "badge_url")

    @_builtins.property
    @pulumi.getter(name="buildBatchConfig")
    def build_batch_config(self) -> pulumi.Output[Optional['outputs.ProjectBuildBatchConfig']]:
        """
        Defines the batch build options for the project.
        """
        return pulumi.get(self, "build_batch_config")

    @_builtins.property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out
        any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is
        not available on the `Lambda` compute type.
        """
        return pulumi.get(self, "build_timeout")

    @_builtins.property
    @pulumi.getter
    def cache(self) -> pulumi.Output[Optional['outputs.ProjectCache']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "cache")

    @_builtins.property
    @pulumi.getter(name="concurrentBuildLimit")
    def concurrent_build_limit(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specify a maximum number of concurrent builds for the project. The value
        specified must be greater than 0 and less than the account concurrent running builds limit.
        """
        return pulumi.get(self, "concurrent_build_limit")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Short description of the project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[_builtins.str]:
        """
        AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting
        the build project's build output artifacts.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.ProjectEnvironment']:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="fileSystemLocations")
    def file_system_locations(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectFileSystemLocation']]]:
        """
        A set of file system locations to mount inside the build. File system locations
        are documented below.
        """
        return pulumi.get(self, "file_system_locations")

    @_builtins.property
    @pulumi.getter(name="logsConfig")
    def logs_config(self) -> pulumi.Output[Optional['outputs.ProjectLogsConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "logs_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Project's name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectVisibility")
    def project_visibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ`
        and `PRIVATE`. Default value is `PRIVATE`.
        """
        return pulumi.get(self, "project_visibility")

    @_builtins.property
    @pulumi.getter(name="publicProjectAlias")
    def public_project_alias(self) -> pulumi.Output[_builtins.str]:
        """
        The project identifier used with the public build APIs.
        """
        return pulumi.get(self, "public_project_alias")

    @_builtins.property
    @pulumi.getter(name="queuedTimeout")
    def queued_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it
        times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
        """
        return pulumi.get(self, "queued_timeout")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceAccessRole")
    def resource_access_role(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and
        Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if
        `project_visibility` is `PUBLIC_READ`.
        """
        return pulumi.get(self, "resource_access_role")

    @_builtins.property
    @pulumi.getter(name="secondaryArtifacts")
    def secondary_artifacts(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectSecondaryArtifact']]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_artifacts")

    @_builtins.property
    @pulumi.getter(name="secondarySourceVersions")
    def secondary_source_versions(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectSecondarySourceVersion']]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_source_versions")

    @_builtins.property
    @pulumi.getter(name="secondarySources")
    def secondary_sources(self) -> pulumi.Output[Optional[Sequence['outputs.ProjectSecondarySource']]]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "secondary_sources")

    @_builtins.property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Output[_builtins.str]:
        """
        Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that
        enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
        """
        return pulumi.get(self, "service_role")

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Output['outputs.ProjectSource']:
        """
        Configuration block. Detailed below.

        The following arguments are optional:
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter(name="sourceVersion")
    def source_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Version of the build input to be built for this project. If not specified, the latest
        version is used.
        """
        return pulumi.get(self, "source_version")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Map of tags to assign to the resource. If configured with a provider 
        `default_tags` configuration block
        present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider 
        `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> pulumi.Output[Optional['outputs.ProjectVpcConfig']]:
        """
        Configuration block. Detailed below.
        """
        return pulumi.get(self, "vpc_config")

