# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReportGroupArgs', 'ReportGroup']

@pulumi.input_type
class ReportGroupArgs:
    def __init__(__self__, *,
                 export_config: pulumi.Input['ReportGroupExportConfigArgs'],
                 type: pulumi.Input[_builtins.str],
                 delete_reports: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ReportGroup resource.
        :param pulumi.Input['ReportGroupExportConfigArgs'] export_config: Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
        :param pulumi.Input[_builtins.str] type: The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
        :param pulumi.Input[_builtins.bool] delete_reports: If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
        :param pulumi.Input[_builtins.str] name: The name of a Report Group.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        pulumi.set(__self__, "export_config", export_config)
        pulumi.set(__self__, "type", type)
        if delete_reports is not None:
            pulumi.set(__self__, "delete_reports", delete_reports)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="exportConfig")
    def export_config(self) -> pulumi.Input['ReportGroupExportConfigArgs']:
        """
        Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
        """
        return pulumi.get(self, "export_config")

    @export_config.setter
    def export_config(self, value: pulumi.Input['ReportGroupExportConfigArgs']):
        pulumi.set(self, "export_config", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="deleteReports")
    def delete_reports(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
        """
        return pulumi.get(self, "delete_reports")

    @delete_reports.setter
    def delete_reports(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_reports", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Report Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ReportGroupState:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_reports: Optional[pulumi.Input[_builtins.bool]] = None,
                 export_config: Optional[pulumi.Input['ReportGroupExportConfigArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReportGroup resources.
        :param pulumi.Input[_builtins.str] arn: The ARN of Report Group.
        :param pulumi.Input[_builtins.str] created: The date and time this Report Group was created.
        :param pulumi.Input[_builtins.bool] delete_reports: If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
        :param pulumi.Input['ReportGroupExportConfigArgs'] export_config: Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
        :param pulumi.Input[_builtins.str] name: The name of a Report Group.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if delete_reports is not None:
            pulumi.set(__self__, "delete_reports", delete_reports)
        if export_config is not None:
            pulumi.set(__self__, "export_config", export_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_all is not None:
            pulumi.set(__self__, "tags_all", tags_all)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARN of Report Group.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arn", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time this Report Group was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="deleteReports")
    def delete_reports(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
        """
        return pulumi.get(self, "delete_reports")

    @delete_reports.setter
    def delete_reports(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_reports", value)

    @_builtins.property
    @pulumi.getter(name="exportConfig")
    def export_config(self) -> Optional[pulumi.Input['ReportGroupExportConfigArgs']]:
        """
        Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
        """
        return pulumi.get(self, "export_config")

    @export_config.setter
    def export_config(self, value: Optional[pulumi.Input['ReportGroupExportConfigArgs']]):
        pulumi.set(self, "export_config", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Report Group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @tags_all.setter
    def tags_all(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags_all", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("aws:codebuild/reportGroup:ReportGroup")
class ReportGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_reports: Optional[pulumi.Input[_builtins.bool]] = None,
                 export_config: Optional[pulumi.Input[Union['ReportGroupExportConfigArgs', 'ReportGroupExportConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a CodeBuild Report Groups Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.iam.get_policy_document(statements=[{
            "sid": "Enable IAM User Permissions",
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [f"arn:aws:iam::{current.account_id}:root"],
            }],
            "actions": ["kms:*"],
            "resources": ["*"],
        }])
        example_key = aws.kms.Key("example",
            description="my test kms key",
            deletion_window_in_days=7,
            policy=example.json)
        example_bucket = aws.s3.Bucket("example", bucket="my-test")
        example_report_group = aws.codebuild.ReportGroup("example",
            name="my test report group",
            type="TEST",
            export_config={
                "type": "S3",
                "s3_destination": {
                    "bucket": example_bucket.id,
                    "encryption_disabled": False,
                    "encryption_key": example_key.arn,
                    "packaging": "NONE",
                    "path": "/some",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import CodeBuild Report Group using the CodeBuild Report Group arn. For example:

        ```sh
        $ pulumi import aws:codebuild/reportGroup:ReportGroup example arn:aws:codebuild:us-west-2:123456789:report-group/report-group-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] delete_reports: If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
        :param pulumi.Input[Union['ReportGroupExportConfigArgs', 'ReportGroupExportConfigArgsDict']] export_config: Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
        :param pulumi.Input[_builtins.str] name: The name of a Report Group.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[_builtins.str] type: The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReportGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a CodeBuild Report Groups Resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        current = aws.get_caller_identity()
        example = aws.iam.get_policy_document(statements=[{
            "sid": "Enable IAM User Permissions",
            "effect": "Allow",
            "principals": [{
                "type": "AWS",
                "identifiers": [f"arn:aws:iam::{current.account_id}:root"],
            }],
            "actions": ["kms:*"],
            "resources": ["*"],
        }])
        example_key = aws.kms.Key("example",
            description="my test kms key",
            deletion_window_in_days=7,
            policy=example.json)
        example_bucket = aws.s3.Bucket("example", bucket="my-test")
        example_report_group = aws.codebuild.ReportGroup("example",
            name="my test report group",
            type="TEST",
            export_config={
                "type": "S3",
                "s3_destination": {
                    "bucket": example_bucket.id,
                    "encryption_disabled": False,
                    "encryption_key": example_key.arn,
                    "packaging": "NONE",
                    "path": "/some",
                },
            })
        ```

        ## Import

        Using `pulumi import`, import CodeBuild Report Group using the CodeBuild Report Group arn. For example:

        ```sh
        $ pulumi import aws:codebuild/reportGroup:ReportGroup example arn:aws:codebuild:us-west-2:123456789:report-group/report-group-name
        ```

        :param str resource_name: The name of the resource.
        :param ReportGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReportGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_reports: Optional[pulumi.Input[_builtins.bool]] = None,
                 export_config: Optional[pulumi.Input[Union['ReportGroupExportConfigArgs', 'ReportGroupExportConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReportGroupArgs.__new__(ReportGroupArgs)

            __props__.__dict__["delete_reports"] = delete_reports
            if export_config is None and not opts.urn:
                raise TypeError("Missing required property 'export_config'")
            __props__.__dict__["export_config"] = export_config
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["tags_all"] = None
        super(ReportGroup, __self__).__init__(
            'aws:codebuild/reportGroup:ReportGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arn: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            delete_reports: Optional[pulumi.Input[_builtins.bool]] = None,
            export_config: Optional[pulumi.Input[Union['ReportGroupExportConfigArgs', 'ReportGroupExportConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags_all: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReportGroup':
        """
        Get an existing ReportGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arn: The ARN of Report Group.
        :param pulumi.Input[_builtins.str] created: The date and time this Report Group was created.
        :param pulumi.Input[_builtins.bool] delete_reports: If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
        :param pulumi.Input[Union['ReportGroupExportConfigArgs', 'ReportGroupExportConfigArgsDict']] export_config: Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
        :param pulumi.Input[_builtins.str] name: The name of a Report Group.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags_all: A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        :param pulumi.Input[_builtins.str] type: The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReportGroupState.__new__(_ReportGroupState)

        __props__.__dict__["arn"] = arn
        __props__.__dict__["created"] = created
        __props__.__dict__["delete_reports"] = delete_reports
        __props__.__dict__["export_config"] = export_config
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_all"] = tags_all
        __props__.__dict__["type"] = type
        return ReportGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def arn(self) -> pulumi.Output[_builtins.str]:
        """
        The ARN of Report Group.
        """
        return pulumi.get(self, "arn")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time this Report Group was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="deleteReports")
    def delete_reports(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
        """
        return pulumi.get(self, "delete_reports")

    @_builtins.property
    @pulumi.getter(name="exportConfig")
    def export_config(self) -> pulumi.Output['outputs.ReportGroupExportConfig']:
        """
        Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
        """
        return pulumi.get(self, "export_config")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of a Report Group.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tagsAll")
    def tags_all(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
        """
        return pulumi.get(self, "tags_all")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
        """
        return pulumi.get(self, "type")

