# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DevEnvironmentArgs', 'DevEnvironment']

@pulumi.input_type
class DevEnvironmentArgs:
    def __init__(__self__, *,
                 ides: pulumi.Input['DevEnvironmentIdesArgs'],
                 instance_type: pulumi.Input[_builtins.str],
                 persistent_storage: pulumi.Input['DevEnvironmentPersistentStorageArgs'],
                 project_name: pulumi.Input[_builtins.str],
                 space_name: pulumi.Input[_builtins.str],
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 inactivity_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]] = None):
        """
        The set of arguments for constructing a DevEnvironment resource.
        :param pulumi.Input['DevEnvironmentIdesArgs'] ides: Information about the integrated development environment (IDE) configured for a Dev Environment.
        :param pulumi.Input[_builtins.str] instance_type: The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
               
               The following arguments are optional:
        :param pulumi.Input['DevEnvironmentPersistentStorageArgs'] persistent_storage: Information about the amount of storage allocated to the Dev Environment.
        :param pulumi.Input[_builtins.str] project_name: The name of the project in the space.
        :param pulumi.Input[_builtins.str] space_name: The name of the space.
        :param pulumi.Input[_builtins.int] inactivity_timeout_minutes: The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]] repositories: The source repository that contains the branch to clone into the Dev Environment.
        """
        pulumi.set(__self__, "ides", ides)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "persistent_storage", persistent_storage)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "space_name", space_name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if inactivity_timeout_minutes is not None:
            pulumi.set(__self__, "inactivity_timeout_minutes", inactivity_timeout_minutes)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)

    @_builtins.property
    @pulumi.getter
    def ides(self) -> pulumi.Input['DevEnvironmentIdesArgs']:
        """
        Information about the integrated development environment (IDE) configured for a Dev Environment.
        """
        return pulumi.get(self, "ides")

    @ides.setter
    def ides(self, value: pulumi.Input['DevEnvironmentIdesArgs']):
        pulumi.set(self, "ides", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge

        The following arguments are optional:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="persistentStorage")
    def persistent_storage(self) -> pulumi.Input['DevEnvironmentPersistentStorageArgs']:
        """
        Information about the amount of storage allocated to the Dev Environment.
        """
        return pulumi.get(self, "persistent_storage")

    @persistent_storage.setter
    def persistent_storage(self, value: pulumi.Input['DevEnvironmentPersistentStorageArgs']):
        pulumi.set(self, "persistent_storage", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the project in the space.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the space.
        """
        return pulumi.get(self, "space_name")

    @space_name.setter
    def space_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "space_name", value)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="inactivityTimeoutMinutes")
    def inactivity_timeout_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        """
        return pulumi.get(self, "inactivity_timeout_minutes")

    @inactivity_timeout_minutes.setter
    def inactivity_timeout_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "inactivity_timeout_minutes", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]]:
        """
        The source repository that contains the branch to clone into the Dev Environment.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]]):
        pulumi.set(self, "repositories", value)


@pulumi.input_type
class _DevEnvironmentState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 ides: Optional[pulumi.Input['DevEnvironmentIdesArgs']] = None,
                 inactivity_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistent_storage: Optional[pulumi.Input['DevEnvironmentPersistentStorageArgs']] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]] = None,
                 space_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DevEnvironment resources.
        :param pulumi.Input['DevEnvironmentIdesArgs'] ides: Information about the integrated development environment (IDE) configured for a Dev Environment.
        :param pulumi.Input[_builtins.int] inactivity_timeout_minutes: The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        :param pulumi.Input[_builtins.str] instance_type: The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
               
               The following arguments are optional:
        :param pulumi.Input['DevEnvironmentPersistentStorageArgs'] persistent_storage: Information about the amount of storage allocated to the Dev Environment.
        :param pulumi.Input[_builtins.str] project_name: The name of the project in the space.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]] repositories: The source repository that contains the branch to clone into the Dev Environment.
        :param pulumi.Input[_builtins.str] space_name: The name of the space.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if ides is not None:
            pulumi.set(__self__, "ides", ides)
        if inactivity_timeout_minutes is not None:
            pulumi.set(__self__, "inactivity_timeout_minutes", inactivity_timeout_minutes)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if persistent_storage is not None:
            pulumi.set(__self__, "persistent_storage", persistent_storage)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if repositories is not None:
            pulumi.set(__self__, "repositories", repositories)
        if space_name is not None:
            pulumi.set(__self__, "space_name", space_name)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter
    def ides(self) -> Optional[pulumi.Input['DevEnvironmentIdesArgs']]:
        """
        Information about the integrated development environment (IDE) configured for a Dev Environment.
        """
        return pulumi.get(self, "ides")

    @ides.setter
    def ides(self, value: Optional[pulumi.Input['DevEnvironmentIdesArgs']]):
        pulumi.set(self, "ides", value)

    @_builtins.property
    @pulumi.getter(name="inactivityTimeoutMinutes")
    def inactivity_timeout_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        """
        return pulumi.get(self, "inactivity_timeout_minutes")

    @inactivity_timeout_minutes.setter
    def inactivity_timeout_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "inactivity_timeout_minutes", value)

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge

        The following arguments are optional:
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_type", value)

    @_builtins.property
    @pulumi.getter(name="persistentStorage")
    def persistent_storage(self) -> Optional[pulumi.Input['DevEnvironmentPersistentStorageArgs']]:
        """
        Information about the amount of storage allocated to the Dev Environment.
        """
        return pulumi.get(self, "persistent_storage")

    @persistent_storage.setter
    def persistent_storage(self, value: Optional[pulumi.Input['DevEnvironmentPersistentStorageArgs']]):
        pulumi.set(self, "persistent_storage", value)

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the project in the space.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def repositories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]]:
        """
        The source repository that contains the branch to clone into the Dev Environment.
        """
        return pulumi.get(self, "repositories")

    @repositories.setter
    def repositories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DevEnvironmentRepositoryArgs']]]]):
        pulumi.set(self, "repositories", value)

    @_builtins.property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the space.
        """
        return pulumi.get(self, "space_name")

    @space_name.setter
    def space_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "space_name", value)


@pulumi.type_token("aws:codecatalyst/devEnvironment:DevEnvironment")
class DevEnvironment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 ides: Optional[pulumi.Input[Union['DevEnvironmentIdesArgs', 'DevEnvironmentIdesArgsDict']]] = None,
                 inactivity_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistent_storage: Optional[pulumi.Input[Union['DevEnvironmentPersistentStorageArgs', 'DevEnvironmentPersistentStorageArgsDict']]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DevEnvironmentRepositoryArgs', 'DevEnvironmentRepositoryArgsDict']]]]] = None,
                 space_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for managing an AWS CodeCatalyst Dev Environment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codecatalyst.DevEnvironment("test",
            alias="devenv",
            space_name="myspace",
            project_name="myproject",
            instance_type="dev.standard1.small",
            persistent_storage={
                "size": 16,
            },
            ides={
                "name": "PyCharm",
                "runtime": "public.ecr.aws/jetbrains/py",
            },
            inactivity_timeout_minutes=40,
            repositories=[{
                "repository_name": "pulumi-provider-aws",
                "branch_name": "main",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DevEnvironmentIdesArgs', 'DevEnvironmentIdesArgsDict']] ides: Information about the integrated development environment (IDE) configured for a Dev Environment.
        :param pulumi.Input[_builtins.int] inactivity_timeout_minutes: The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        :param pulumi.Input[_builtins.str] instance_type: The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
               
               The following arguments are optional:
        :param pulumi.Input[Union['DevEnvironmentPersistentStorageArgs', 'DevEnvironmentPersistentStorageArgsDict']] persistent_storage: Information about the amount of storage allocated to the Dev Environment.
        :param pulumi.Input[_builtins.str] project_name: The name of the project in the space.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DevEnvironmentRepositoryArgs', 'DevEnvironmentRepositoryArgsDict']]]] repositories: The source repository that contains the branch to clone into the Dev Environment.
        :param pulumi.Input[_builtins.str] space_name: The name of the space.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DevEnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for managing an AWS CodeCatalyst Dev Environment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws

        test = aws.codecatalyst.DevEnvironment("test",
            alias="devenv",
            space_name="myspace",
            project_name="myproject",
            instance_type="dev.standard1.small",
            persistent_storage={
                "size": 16,
            },
            ides={
                "name": "PyCharm",
                "runtime": "public.ecr.aws/jetbrains/py",
            },
            inactivity_timeout_minutes=40,
            repositories=[{
                "repository_name": "pulumi-provider-aws",
                "branch_name": "main",
            }])
        ```

        :param str resource_name: The name of the resource.
        :param DevEnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DevEnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 ides: Optional[pulumi.Input[Union['DevEnvironmentIdesArgs', 'DevEnvironmentIdesArgsDict']]] = None,
                 inactivity_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                 persistent_storage: Optional[pulumi.Input[Union['DevEnvironmentPersistentStorageArgs', 'DevEnvironmentPersistentStorageArgsDict']]] = None,
                 project_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DevEnvironmentRepositoryArgs', 'DevEnvironmentRepositoryArgsDict']]]]] = None,
                 space_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DevEnvironmentArgs.__new__(DevEnvironmentArgs)

            __props__.__dict__["alias"] = alias
            if ides is None and not opts.urn:
                raise TypeError("Missing required property 'ides'")
            __props__.__dict__["ides"] = ides
            __props__.__dict__["inactivity_timeout_minutes"] = inactivity_timeout_minutes
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            if persistent_storage is None and not opts.urn:
                raise TypeError("Missing required property 'persistent_storage'")
            __props__.__dict__["persistent_storage"] = persistent_storage
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["region"] = region
            __props__.__dict__["repositories"] = repositories
            if space_name is None and not opts.urn:
                raise TypeError("Missing required property 'space_name'")
            __props__.__dict__["space_name"] = space_name
        super(DevEnvironment, __self__).__init__(
            'aws:codecatalyst/devEnvironment:DevEnvironment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[_builtins.str]] = None,
            ides: Optional[pulumi.Input[Union['DevEnvironmentIdesArgs', 'DevEnvironmentIdesArgsDict']]] = None,
            inactivity_timeout_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            instance_type: Optional[pulumi.Input[_builtins.str]] = None,
            persistent_storage: Optional[pulumi.Input[Union['DevEnvironmentPersistentStorageArgs', 'DevEnvironmentPersistentStorageArgsDict']]] = None,
            project_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            repositories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DevEnvironmentRepositoryArgs', 'DevEnvironmentRepositoryArgsDict']]]]] = None,
            space_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'DevEnvironment':
        """
        Get an existing DevEnvironment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DevEnvironmentIdesArgs', 'DevEnvironmentIdesArgsDict']] ides: Information about the integrated development environment (IDE) configured for a Dev Environment.
        :param pulumi.Input[_builtins.int] inactivity_timeout_minutes: The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        :param pulumi.Input[_builtins.str] instance_type: The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge
               
               The following arguments are optional:
        :param pulumi.Input[Union['DevEnvironmentPersistentStorageArgs', 'DevEnvironmentPersistentStorageArgsDict']] persistent_storage: Information about the amount of storage allocated to the Dev Environment.
        :param pulumi.Input[_builtins.str] project_name: The name of the project in the space.
        :param pulumi.Input[_builtins.str] region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DevEnvironmentRepositoryArgs', 'DevEnvironmentRepositoryArgsDict']]]] repositories: The source repository that contains the branch to clone into the Dev Environment.
        :param pulumi.Input[_builtins.str] space_name: The name of the space.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DevEnvironmentState.__new__(_DevEnvironmentState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["ides"] = ides
        __props__.__dict__["inactivity_timeout_minutes"] = inactivity_timeout_minutes
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["persistent_storage"] = persistent_storage
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["region"] = region
        __props__.__dict__["repositories"] = repositories
        __props__.__dict__["space_name"] = space_name
        return DevEnvironment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter
    def ides(self) -> pulumi.Output['outputs.DevEnvironmentIdes']:
        """
        Information about the integrated development environment (IDE) configured for a Dev Environment.
        """
        return pulumi.get(self, "ides")

    @_builtins.property
    @pulumi.getter(name="inactivityTimeoutMinutes")
    def inactivity_timeout_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.
        """
        return pulumi.get(self, "inactivity_timeout_minutes")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Amazon EC2 instace type to use for the Dev Environment. Valid values include dev.standard1.small,dev.standard1.medium,dev.standard1.large,dev.standard1.xlarge

        The following arguments are optional:
        """
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="persistentStorage")
    def persistent_storage(self) -> pulumi.Output['outputs.DevEnvironmentPersistentStorage']:
        """
        Information about the amount of storage allocated to the Dev Environment.
        """
        return pulumi.get(self, "persistent_storage")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the project in the space.
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def repositories(self) -> pulumi.Output[Optional[Sequence['outputs.DevEnvironmentRepository']]]:
        """
        The source repository that contains the branch to clone into the Dev Environment.
        """
        return pulumi.get(self, "repositories")

    @_builtins.property
    @pulumi.getter(name="spaceName")
    def space_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the space.
        """
        return pulumi.get(self, "space_name")

