# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetApprovalRuleTemplateResult',
    'AwaitableGetApprovalRuleTemplateResult',
    'get_approval_rule_template',
    'get_approval_rule_template_output',
]

@pulumi.output_type
class GetApprovalRuleTemplateResult:
    """
    A collection of values returned by getApprovalRuleTemplate.
    """
    def __init__(__self__, approval_rule_template_id=None, content=None, creation_date=None, description=None, id=None, last_modified_date=None, last_modified_user=None, name=None, region=None, rule_content_sha256=None):
        if approval_rule_template_id and not isinstance(approval_rule_template_id, str):
            raise TypeError("Expected argument 'approval_rule_template_id' to be a str")
        pulumi.set(__self__, "approval_rule_template_id", approval_rule_template_id)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_modified_date and not isinstance(last_modified_date, str):
            raise TypeError("Expected argument 'last_modified_date' to be a str")
        pulumi.set(__self__, "last_modified_date", last_modified_date)
        if last_modified_user and not isinstance(last_modified_user, str):
            raise TypeError("Expected argument 'last_modified_user' to be a str")
        pulumi.set(__self__, "last_modified_user", last_modified_user)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rule_content_sha256 and not isinstance(rule_content_sha256, str):
            raise TypeError("Expected argument 'rule_content_sha256' to be a str")
        pulumi.set(__self__, "rule_content_sha256", rule_content_sha256)

    @_builtins.property
    @pulumi.getter(name="approvalRuleTemplateId")
    def approval_rule_template_id(self) -> _builtins.str:
        """
        The ID of the approval rule template.
        """
        return pulumi.get(self, "approval_rule_template_id")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Content of the approval rule template.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        Date the approval rule template was created, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the approval rule template.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lastModifiedDate")
    def last_modified_date(self) -> _builtins.str:
        """
        Date the approval rule template was most recently changed, in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
        """
        return pulumi.get(self, "last_modified_date")

    @_builtins.property
    @pulumi.getter(name="lastModifiedUser")
    def last_modified_user(self) -> _builtins.str:
        """
        ARN of the user who made the most recent changes to the approval rule template.
        """
        return pulumi.get(self, "last_modified_user")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="ruleContentSha256")
    def rule_content_sha256(self) -> _builtins.str:
        """
        SHA-256 hash signature for the content of the approval rule template.
        """
        return pulumi.get(self, "rule_content_sha256")


class AwaitableGetApprovalRuleTemplateResult(GetApprovalRuleTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApprovalRuleTemplateResult(
            approval_rule_template_id=self.approval_rule_template_id,
            content=self.content,
            creation_date=self.creation_date,
            description=self.description,
            id=self.id,
            last_modified_date=self.last_modified_date,
            last_modified_user=self.last_modified_user,
            name=self.name,
            region=self.region,
            rule_content_sha256=self.rule_content_sha256)


def get_approval_rule_template(name: Optional[_builtins.str] = None,
                               region: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApprovalRuleTemplateResult:
    """
    Provides details about a specific CodeCommit Approval Rule Template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.codecommit.get_approval_rule_template(name="MyExampleApprovalRuleTemplate")
    ```


    :param _builtins.str name: Name for the approval rule template. This needs to be less than 100 characters.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:codecommit/getApprovalRuleTemplate:getApprovalRuleTemplate', __args__, opts=opts, typ=GetApprovalRuleTemplateResult).value

    return AwaitableGetApprovalRuleTemplateResult(
        approval_rule_template_id=pulumi.get(__ret__, 'approval_rule_template_id'),
        content=pulumi.get(__ret__, 'content'),
        creation_date=pulumi.get(__ret__, 'creation_date'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        last_modified_date=pulumi.get(__ret__, 'last_modified_date'),
        last_modified_user=pulumi.get(__ret__, 'last_modified_user'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        rule_content_sha256=pulumi.get(__ret__, 'rule_content_sha256'))
def get_approval_rule_template_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                      region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetApprovalRuleTemplateResult]:
    """
    Provides details about a specific CodeCommit Approval Rule Template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    example = aws.codecommit.get_approval_rule_template(name="MyExampleApprovalRuleTemplate")
    ```


    :param _builtins.str name: Name for the approval rule template. This needs to be less than 100 characters.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:codecommit/getApprovalRuleTemplate:getApprovalRuleTemplate', __args__, opts=opts, typ=GetApprovalRuleTemplateResult)
    return __ret__.apply(lambda __response__: GetApprovalRuleTemplateResult(
        approval_rule_template_id=pulumi.get(__response__, 'approval_rule_template_id'),
        content=pulumi.get(__response__, 'content'),
        creation_date=pulumi.get(__response__, 'creation_date'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        last_modified_date=pulumi.get(__response__, 'last_modified_date'),
        last_modified_user=pulumi.get(__response__, 'last_modified_user'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        rule_content_sha256=pulumi.get(__response__, 'rule_content_sha256')))
