# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserPoolClientResult',
    'AwaitableGetUserPoolClientResult',
    'get_user_pool_client',
    'get_user_pool_client_output',
]

@pulumi.output_type
class GetUserPoolClientResult:
    """
    A collection of values returned by getUserPoolClient.
    """
    def __init__(__self__, access_token_validity=None, allowed_oauth_flows=None, allowed_oauth_flows_user_pool_client=None, allowed_oauth_scopes=None, analytics_configurations=None, callback_urls=None, client_id=None, client_secret=None, default_redirect_uri=None, enable_propagate_additional_user_context_data=None, enable_token_revocation=None, explicit_auth_flows=None, generate_secret=None, id=None, id_token_validity=None, logout_urls=None, name=None, prevent_user_existence_errors=None, read_attributes=None, refresh_token_rotations=None, refresh_token_validity=None, region=None, supported_identity_providers=None, token_validity_units=None, user_pool_id=None, write_attributes=None):
        if access_token_validity and not isinstance(access_token_validity, int):
            raise TypeError("Expected argument 'access_token_validity' to be a int")
        pulumi.set(__self__, "access_token_validity", access_token_validity)
        if allowed_oauth_flows and not isinstance(allowed_oauth_flows, list):
            raise TypeError("Expected argument 'allowed_oauth_flows' to be a list")
        pulumi.set(__self__, "allowed_oauth_flows", allowed_oauth_flows)
        if allowed_oauth_flows_user_pool_client and not isinstance(allowed_oauth_flows_user_pool_client, bool):
            raise TypeError("Expected argument 'allowed_oauth_flows_user_pool_client' to be a bool")
        pulumi.set(__self__, "allowed_oauth_flows_user_pool_client", allowed_oauth_flows_user_pool_client)
        if allowed_oauth_scopes and not isinstance(allowed_oauth_scopes, list):
            raise TypeError("Expected argument 'allowed_oauth_scopes' to be a list")
        pulumi.set(__self__, "allowed_oauth_scopes", allowed_oauth_scopes)
        if analytics_configurations and not isinstance(analytics_configurations, list):
            raise TypeError("Expected argument 'analytics_configurations' to be a list")
        pulumi.set(__self__, "analytics_configurations", analytics_configurations)
        if callback_urls and not isinstance(callback_urls, list):
            raise TypeError("Expected argument 'callback_urls' to be a list")
        pulumi.set(__self__, "callback_urls", callback_urls)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if client_secret and not isinstance(client_secret, str):
            raise TypeError("Expected argument 'client_secret' to be a str")
        pulumi.set(__self__, "client_secret", client_secret)
        if default_redirect_uri and not isinstance(default_redirect_uri, str):
            raise TypeError("Expected argument 'default_redirect_uri' to be a str")
        pulumi.set(__self__, "default_redirect_uri", default_redirect_uri)
        if enable_propagate_additional_user_context_data and not isinstance(enable_propagate_additional_user_context_data, bool):
            raise TypeError("Expected argument 'enable_propagate_additional_user_context_data' to be a bool")
        pulumi.set(__self__, "enable_propagate_additional_user_context_data", enable_propagate_additional_user_context_data)
        if enable_token_revocation and not isinstance(enable_token_revocation, bool):
            raise TypeError("Expected argument 'enable_token_revocation' to be a bool")
        pulumi.set(__self__, "enable_token_revocation", enable_token_revocation)
        if explicit_auth_flows and not isinstance(explicit_auth_flows, list):
            raise TypeError("Expected argument 'explicit_auth_flows' to be a list")
        pulumi.set(__self__, "explicit_auth_flows", explicit_auth_flows)
        if generate_secret and not isinstance(generate_secret, bool):
            raise TypeError("Expected argument 'generate_secret' to be a bool")
        pulumi.set(__self__, "generate_secret", generate_secret)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if id_token_validity and not isinstance(id_token_validity, int):
            raise TypeError("Expected argument 'id_token_validity' to be a int")
        pulumi.set(__self__, "id_token_validity", id_token_validity)
        if logout_urls and not isinstance(logout_urls, list):
            raise TypeError("Expected argument 'logout_urls' to be a list")
        pulumi.set(__self__, "logout_urls", logout_urls)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if prevent_user_existence_errors and not isinstance(prevent_user_existence_errors, str):
            raise TypeError("Expected argument 'prevent_user_existence_errors' to be a str")
        pulumi.set(__self__, "prevent_user_existence_errors", prevent_user_existence_errors)
        if read_attributes and not isinstance(read_attributes, list):
            raise TypeError("Expected argument 'read_attributes' to be a list")
        pulumi.set(__self__, "read_attributes", read_attributes)
        if refresh_token_rotations and not isinstance(refresh_token_rotations, list):
            raise TypeError("Expected argument 'refresh_token_rotations' to be a list")
        pulumi.set(__self__, "refresh_token_rotations", refresh_token_rotations)
        if refresh_token_validity and not isinstance(refresh_token_validity, int):
            raise TypeError("Expected argument 'refresh_token_validity' to be a int")
        pulumi.set(__self__, "refresh_token_validity", refresh_token_validity)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if supported_identity_providers and not isinstance(supported_identity_providers, list):
            raise TypeError("Expected argument 'supported_identity_providers' to be a list")
        pulumi.set(__self__, "supported_identity_providers", supported_identity_providers)
        if token_validity_units and not isinstance(token_validity_units, list):
            raise TypeError("Expected argument 'token_validity_units' to be a list")
        pulumi.set(__self__, "token_validity_units", token_validity_units)
        if user_pool_id and not isinstance(user_pool_id, str):
            raise TypeError("Expected argument 'user_pool_id' to be a str")
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if write_attributes and not isinstance(write_attributes, list):
            raise TypeError("Expected argument 'write_attributes' to be a list")
        pulumi.set(__self__, "write_attributes", write_attributes)

    @_builtins.property
    @pulumi.getter(name="accessTokenValidity")
    def access_token_validity(self) -> _builtins.int:
        """
        (Optional) Time limit, between 5 minutes and 1 day, after which the access token is no longer valid and cannot be used. This value will be overridden if you have entered a value in `token_validity_units`.
        """
        return pulumi.get(self, "access_token_validity")

    @_builtins.property
    @pulumi.getter(name="allowedOauthFlows")
    def allowed_oauth_flows(self) -> Sequence[_builtins.str]:
        """
        (Optional) List of allowed OAuth flows (code, implicit, client_credentials).
        """
        return pulumi.get(self, "allowed_oauth_flows")

    @_builtins.property
    @pulumi.getter(name="allowedOauthFlowsUserPoolClient")
    def allowed_oauth_flows_user_pool_client(self) -> _builtins.bool:
        """
        (Optional) Whether the client is allowed to follow the OAuth protocol when interacting with Cognito user pools.
        """
        return pulumi.get(self, "allowed_oauth_flows_user_pool_client")

    @_builtins.property
    @pulumi.getter(name="allowedOauthScopes")
    def allowed_oauth_scopes(self) -> Sequence[_builtins.str]:
        """
        (Optional) List of allowed OAuth scopes (phone, email, openid, profile, and aws.cognito.signin.user.admin).
        """
        return pulumi.get(self, "allowed_oauth_scopes")

    @_builtins.property
    @pulumi.getter(name="analyticsConfigurations")
    def analytics_configurations(self) -> Sequence['outputs.GetUserPoolClientAnalyticsConfigurationResult']:
        """
        (Optional) Configuration block for Amazon Pinpoint analytics for collecting metrics for this user pool. Detailed below.
        """
        return pulumi.get(self, "analytics_configurations")

    @_builtins.property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> Sequence[_builtins.str]:
        """
        (Optional) List of allowed callback URLs for the identity providers.
        """
        return pulumi.get(self, "callback_urls")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> _builtins.str:
        """
        Client secret of the user pool client.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="defaultRedirectUri")
    def default_redirect_uri(self) -> _builtins.str:
        """
        (Optional) Default redirect URI. Must be in the list of callback URLs.
        """
        return pulumi.get(self, "default_redirect_uri")

    @_builtins.property
    @pulumi.getter(name="enablePropagateAdditionalUserContextData")
    def enable_propagate_additional_user_context_data(self) -> _builtins.bool:
        return pulumi.get(self, "enable_propagate_additional_user_context_data")

    @_builtins.property
    @pulumi.getter(name="enableTokenRevocation")
    def enable_token_revocation(self) -> _builtins.bool:
        """
        (Optional) Enables or disables token revocation.
        """
        return pulumi.get(self, "enable_token_revocation")

    @_builtins.property
    @pulumi.getter(name="explicitAuthFlows")
    def explicit_auth_flows(self) -> Sequence[_builtins.str]:
        """
        (Optional) List of authentication flows (ADMIN_NO_SRP_AUTH, CUSTOM_AUTH_FLOW_ONLY, USER_PASSWORD_AUTH, ALLOW_ADMIN_USER_PASSWORD_AUTH, ALLOW_CUSTOM_AUTH, ALLOW_USER_PASSWORD_AUTH, ALLOW_USER_SRP_AUTH, ALLOW_REFRESH_TOKEN_AUTH).
        """
        return pulumi.get(self, "explicit_auth_flows")

    @_builtins.property
    @pulumi.getter(name="generateSecret")
    def generate_secret(self) -> _builtins.bool:
        """
        (Optional) Should an application secret be generated.
        """
        return pulumi.get(self, "generate_secret")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idTokenValidity")
    def id_token_validity(self) -> _builtins.int:
        """
        (Optional) Time limit, between 5 minutes and 1 day, after which the ID token is no longer valid and cannot be used. This value will be overridden if you have entered a value in `token_validity_units`.
        """
        return pulumi.get(self, "id_token_validity")

    @_builtins.property
    @pulumi.getter(name="logoutUrls")
    def logout_urls(self) -> Sequence[_builtins.str]:
        """
        (Optional) List of allowed logout URLs for the identity providers.
        """
        return pulumi.get(self, "logout_urls")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="preventUserExistenceErrors")
    def prevent_user_existence_errors(self) -> _builtins.str:
        """
        (Optional) Choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to `ENABLED` and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs will return a `UserNotFoundException` exception if the user does not exist in the user pool.
        """
        return pulumi.get(self, "prevent_user_existence_errors")

    @_builtins.property
    @pulumi.getter(name="readAttributes")
    def read_attributes(self) -> Sequence[_builtins.str]:
        """
        (Optional) List of user pool attributes the application client can read from.
        """
        return pulumi.get(self, "read_attributes")

    @_builtins.property
    @pulumi.getter(name="refreshTokenRotations")
    def refresh_token_rotations(self) -> Sequence['outputs.GetUserPoolClientRefreshTokenRotationResult']:
        """
        (Optional) A block that specifies the configuration of refresh token rotation. Detailed below.
        """
        return pulumi.get(self, "refresh_token_rotations")

    @_builtins.property
    @pulumi.getter(name="refreshTokenValidity")
    def refresh_token_validity(self) -> _builtins.int:
        """
        (Optional) Time limit in days refresh tokens are valid for.
        """
        return pulumi.get(self, "refresh_token_validity")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="supportedIdentityProviders")
    def supported_identity_providers(self) -> Sequence[_builtins.str]:
        """
        (Optional) List of provider names for the identity providers that are supported on this client. Uses the `provider_name` attribute of `cognito.IdentityProvider` resource(s), or the equivalent string(s).
        """
        return pulumi.get(self, "supported_identity_providers")

    @_builtins.property
    @pulumi.getter(name="tokenValidityUnits")
    def token_validity_units(self) -> Sequence['outputs.GetUserPoolClientTokenValidityUnitResult']:
        """
        (Optional) Configuration block for units in which the validity times are represented in. Detailed below.
        """
        return pulumi.get(self, "token_validity_units")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> _builtins.str:
        return pulumi.get(self, "user_pool_id")

    @_builtins.property
    @pulumi.getter(name="writeAttributes")
    def write_attributes(self) -> Sequence[_builtins.str]:
        """
        (Optional) List of user pool attributes the application client can write to.
        """
        return pulumi.get(self, "write_attributes")


class AwaitableGetUserPoolClientResult(GetUserPoolClientResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserPoolClientResult(
            access_token_validity=self.access_token_validity,
            allowed_oauth_flows=self.allowed_oauth_flows,
            allowed_oauth_flows_user_pool_client=self.allowed_oauth_flows_user_pool_client,
            allowed_oauth_scopes=self.allowed_oauth_scopes,
            analytics_configurations=self.analytics_configurations,
            callback_urls=self.callback_urls,
            client_id=self.client_id,
            client_secret=self.client_secret,
            default_redirect_uri=self.default_redirect_uri,
            enable_propagate_additional_user_context_data=self.enable_propagate_additional_user_context_data,
            enable_token_revocation=self.enable_token_revocation,
            explicit_auth_flows=self.explicit_auth_flows,
            generate_secret=self.generate_secret,
            id=self.id,
            id_token_validity=self.id_token_validity,
            logout_urls=self.logout_urls,
            name=self.name,
            prevent_user_existence_errors=self.prevent_user_existence_errors,
            read_attributes=self.read_attributes,
            refresh_token_rotations=self.refresh_token_rotations,
            refresh_token_validity=self.refresh_token_validity,
            region=self.region,
            supported_identity_providers=self.supported_identity_providers,
            token_validity_units=self.token_validity_units,
            user_pool_id=self.user_pool_id,
            write_attributes=self.write_attributes)


def get_user_pool_client(client_id: Optional[_builtins.str] = None,
                         region: Optional[_builtins.str] = None,
                         user_pool_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserPoolClientResult:
    """
    Provides a Cognito User Pool Client resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    client = aws.cognito.get_user_pool_client(client_id="38fjsnc484p94kpqsnet7mpld0",
        user_pool_id="us-west-2_aaaaaaaaa")
    ```


    :param _builtins.str client_id: Client Id of the user pool.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str user_pool_id: User pool the client belongs to.
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    __args__['region'] = region
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws:cognito/getUserPoolClient:getUserPoolClient', __args__, opts=opts, typ=GetUserPoolClientResult).value

    return AwaitableGetUserPoolClientResult(
        access_token_validity=pulumi.get(__ret__, 'access_token_validity'),
        allowed_oauth_flows=pulumi.get(__ret__, 'allowed_oauth_flows'),
        allowed_oauth_flows_user_pool_client=pulumi.get(__ret__, 'allowed_oauth_flows_user_pool_client'),
        allowed_oauth_scopes=pulumi.get(__ret__, 'allowed_oauth_scopes'),
        analytics_configurations=pulumi.get(__ret__, 'analytics_configurations'),
        callback_urls=pulumi.get(__ret__, 'callback_urls'),
        client_id=pulumi.get(__ret__, 'client_id'),
        client_secret=pulumi.get(__ret__, 'client_secret'),
        default_redirect_uri=pulumi.get(__ret__, 'default_redirect_uri'),
        enable_propagate_additional_user_context_data=pulumi.get(__ret__, 'enable_propagate_additional_user_context_data'),
        enable_token_revocation=pulumi.get(__ret__, 'enable_token_revocation'),
        explicit_auth_flows=pulumi.get(__ret__, 'explicit_auth_flows'),
        generate_secret=pulumi.get(__ret__, 'generate_secret'),
        id=pulumi.get(__ret__, 'id'),
        id_token_validity=pulumi.get(__ret__, 'id_token_validity'),
        logout_urls=pulumi.get(__ret__, 'logout_urls'),
        name=pulumi.get(__ret__, 'name'),
        prevent_user_existence_errors=pulumi.get(__ret__, 'prevent_user_existence_errors'),
        read_attributes=pulumi.get(__ret__, 'read_attributes'),
        refresh_token_rotations=pulumi.get(__ret__, 'refresh_token_rotations'),
        refresh_token_validity=pulumi.get(__ret__, 'refresh_token_validity'),
        region=pulumi.get(__ret__, 'region'),
        supported_identity_providers=pulumi.get(__ret__, 'supported_identity_providers'),
        token_validity_units=pulumi.get(__ret__, 'token_validity_units'),
        user_pool_id=pulumi.get(__ret__, 'user_pool_id'),
        write_attributes=pulumi.get(__ret__, 'write_attributes'))
def get_user_pool_client_output(client_id: Optional[pulumi.Input[_builtins.str]] = None,
                                region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUserPoolClientResult]:
    """
    Provides a Cognito User Pool Client resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws

    client = aws.cognito.get_user_pool_client(client_id="38fjsnc484p94kpqsnet7mpld0",
        user_pool_id="us-west-2_aaaaaaaaa")
    ```


    :param _builtins.str client_id: Client Id of the user pool.
    :param _builtins.str region: Region where this resource will be [managed](https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints). Defaults to the Region set in the provider configuration.
    :param _builtins.str user_pool_id: User pool the client belongs to.
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    __args__['region'] = region
    __args__['userPoolId'] = user_pool_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws:cognito/getUserPoolClient:getUserPoolClient', __args__, opts=opts, typ=GetUserPoolClientResult)
    return __ret__.apply(lambda __response__: GetUserPoolClientResult(
        access_token_validity=pulumi.get(__response__, 'access_token_validity'),
        allowed_oauth_flows=pulumi.get(__response__, 'allowed_oauth_flows'),
        allowed_oauth_flows_user_pool_client=pulumi.get(__response__, 'allowed_oauth_flows_user_pool_client'),
        allowed_oauth_scopes=pulumi.get(__response__, 'allowed_oauth_scopes'),
        analytics_configurations=pulumi.get(__response__, 'analytics_configurations'),
        callback_urls=pulumi.get(__response__, 'callback_urls'),
        client_id=pulumi.get(__response__, 'client_id'),
        client_secret=pulumi.get(__response__, 'client_secret'),
        default_redirect_uri=pulumi.get(__response__, 'default_redirect_uri'),
        enable_propagate_additional_user_context_data=pulumi.get(__response__, 'enable_propagate_additional_user_context_data'),
        enable_token_revocation=pulumi.get(__response__, 'enable_token_revocation'),
        explicit_auth_flows=pulumi.get(__response__, 'explicit_auth_flows'),
        generate_secret=pulumi.get(__response__, 'generate_secret'),
        id=pulumi.get(__response__, 'id'),
        id_token_validity=pulumi.get(__response__, 'id_token_validity'),
        logout_urls=pulumi.get(__response__, 'logout_urls'),
        name=pulumi.get(__response__, 'name'),
        prevent_user_existence_errors=pulumi.get(__response__, 'prevent_user_existence_errors'),
        read_attributes=pulumi.get(__response__, 'read_attributes'),
        refresh_token_rotations=pulumi.get(__response__, 'refresh_token_rotations'),
        refresh_token_validity=pulumi.get(__response__, 'refresh_token_validity'),
        region=pulumi.get(__response__, 'region'),
        supported_identity_providers=pulumi.get(__response__, 'supported_identity_providers'),
        token_validity_units=pulumi.get(__response__, 'token_validity_units'),
        user_pool_id=pulumi.get(__response__, 'user_pool_id'),
        write_attributes=pulumi.get(__response__, 'write_attributes')))
