# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LogDeliveryConfigurationArgs', 'LogDeliveryConfiguration']

@pulumi.input_type
class LogDeliveryConfigurationArgs:
    def __init__(__self__, *,
                 user_pool_id: pulumi.Input[_builtins.str],
                 log_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LogDeliveryConfiguration resource.
        :param pulumi.Input[_builtins.str] user_pool_id: The ID of the user pool for which to configure log delivery.
               
               The following arguments are optional:
        :param pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]] log_configurations: Configuration block for log delivery. At least one configuration block is required. See Log Configurations below.
        :param pulumi.Input[_builtins.str] region: The AWS region.
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if log_configurations is not None:
            pulumi.set(__self__, "log_configurations", log_configurations)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the user pool for which to configure log delivery.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="logConfigurations")
    def log_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]]]:
        """
        Configuration block for log delivery. At least one configuration block is required. See Log Configurations below.
        """
        return pulumi.get(self, "log_configurations")

    @log_configurations.setter
    def log_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]]]):
        pulumi.set(self, "log_configurations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _LogDeliveryConfigurationState:
    def __init__(__self__, *,
                 log_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LogDeliveryConfiguration resources.
        :param pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]] log_configurations: Configuration block for log delivery. At least one configuration block is required. See Log Configurations below.
        :param pulumi.Input[_builtins.str] region: The AWS region.
        :param pulumi.Input[_builtins.str] user_pool_id: The ID of the user pool for which to configure log delivery.
               
               The following arguments are optional:
        """
        if log_configurations is not None:
            pulumi.set(__self__, "log_configurations", log_configurations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if user_pool_id is not None:
            pulumi.set(__self__, "user_pool_id", user_pool_id)

    @_builtins.property
    @pulumi.getter(name="logConfigurations")
    def log_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]]]:
        """
        Configuration block for log delivery. At least one configuration block is required. See Log Configurations below.
        """
        return pulumi.get(self, "log_configurations")

    @log_configurations.setter
    def log_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LogDeliveryConfigurationLogConfigurationArgs']]]]):
        pulumi.set(self, "log_configurations", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The AWS region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the user pool for which to configure log delivery.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pool_id", value)


@pulumi.type_token("aws:cognito/logDeliveryConfiguration:LogDeliveryConfiguration")
class LogDeliveryConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogDeliveryConfigurationLogConfigurationArgs', 'LogDeliveryConfigurationLogConfigurationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an AWS Cognito IDP (Identity Provider) Log Delivery Configuration.

        ## Example Usage

        ### Basic Usage with CloudWatch Logs

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="example")
        example_log_group = aws.cloudwatch.LogGroup("example", name="example")
        example_log_delivery_configuration = aws.cognito.LogDeliveryConfiguration("example",
            user_pool_id=example.id,
            log_configurations=[{
                "event_source": "userNotification",
                "log_level": "ERROR",
                "cloud_watch_logs_configuration": {
                    "log_group_arn": example_log_group.arn,
                },
            }])
        ```

        ### Multiple Log Configurations with Different Destinations

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="example")
        example_log_group = aws.cloudwatch.LogGroup("example", name="example")
        example_bucket = aws.s3.Bucket("example",
            bucket="example-bucket",
            force_destroy=True)
        firehose = aws.iam.Role("firehose",
            name="firehose-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "firehose.amazonaws.com",
                    },
                }],
            }))
        firehose_role_policy = aws.iam.RolePolicy("firehose",
            name="firehose-policy",
            role=firehose.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Action": [
                        "s3:AbortMultipartUpload",
                        "s3:GetBucketLocation",
                        "s3:GetObject",
                        "s3:ListBucket",
                        "s3:ListBucketMultipartUploads",
                        "s3:PutObject",
                    ],
                    "Resource": [
                        example_bucket.arn,
                        example_bucket.arn.apply(lambda arn: f"{arn}/*"),
                    ],
                }],
            }))
        example_firehose_delivery_stream = aws.kinesis.FirehoseDeliveryStream("example",
            name="example-stream",
            destination="extended_s3",
            extended_s3_configuration={
                "role_arn": firehose.arn,
                "bucket_arn": example_bucket.arn,
            })
        example_log_delivery_configuration = aws.cognito.LogDeliveryConfiguration("example",
            user_pool_id=example.id,
            log_configurations=[
                {
                    "event_source": "userNotification",
                    "log_level": "INFO",
                    "cloud_watch_logs_configuration": {
                        "log_group_arn": example_log_group.arn,
                    },
                },
                {
                    "event_source": "userAuthEvents",
                    "log_level": "ERROR",
                    "firehose_configuration": {
                        "stream_arn": example_firehose_delivery_stream.arn,
                    },
                },
            ])
        ```

        ### S3 Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="example")
        example_bucket = aws.s3.Bucket("example",
            bucket="example-bucket",
            force_destroy=True)
        example_log_delivery_configuration = aws.cognito.LogDeliveryConfiguration("example",
            user_pool_id=example.id,
            log_configurations=[{
                "event_source": "userNotification",
                "log_level": "ERROR",
                "s3_configuration": {
                    "bucket_arn": example_bucket.arn,
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import Cognito IDP (Identity Provider) Log Delivery Configuration using the `user_pool_id`. For example:

        ```sh
        $ pulumi import aws:cognito/logDeliveryConfiguration:LogDeliveryConfiguration example us-west-2_example123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogDeliveryConfigurationLogConfigurationArgs', 'LogDeliveryConfigurationLogConfigurationArgsDict']]]] log_configurations: Configuration block for log delivery. At least one configuration block is required. See Log Configurations below.
        :param pulumi.Input[_builtins.str] region: The AWS region.
        :param pulumi.Input[_builtins.str] user_pool_id: The ID of the user pool for which to configure log delivery.
               
               The following arguments are optional:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogDeliveryConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AWS Cognito IDP (Identity Provider) Log Delivery Configuration.

        ## Example Usage

        ### Basic Usage with CloudWatch Logs

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="example")
        example_log_group = aws.cloudwatch.LogGroup("example", name="example")
        example_log_delivery_configuration = aws.cognito.LogDeliveryConfiguration("example",
            user_pool_id=example.id,
            log_configurations=[{
                "event_source": "userNotification",
                "log_level": "ERROR",
                "cloud_watch_logs_configuration": {
                    "log_group_arn": example_log_group.arn,
                },
            }])
        ```

        ### Multiple Log Configurations with Different Destinations

        ```python
        import pulumi
        import json
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="example")
        example_log_group = aws.cloudwatch.LogGroup("example", name="example")
        example_bucket = aws.s3.Bucket("example",
            bucket="example-bucket",
            force_destroy=True)
        firehose = aws.iam.Role("firehose",
            name="firehose-role",
            assume_role_policy=json.dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                        "Service": "firehose.amazonaws.com",
                    },
                }],
            }))
        firehose_role_policy = aws.iam.RolePolicy("firehose",
            name="firehose-policy",
            role=firehose.id,
            policy=pulumi.Output.json_dumps({
                "Version": "2012-10-17",
                "Statement": [{
                    "Effect": "Allow",
                    "Action": [
                        "s3:AbortMultipartUpload",
                        "s3:GetBucketLocation",
                        "s3:GetObject",
                        "s3:ListBucket",
                        "s3:ListBucketMultipartUploads",
                        "s3:PutObject",
                    ],
                    "Resource": [
                        example_bucket.arn,
                        example_bucket.arn.apply(lambda arn: f"{arn}/*"),
                    ],
                }],
            }))
        example_firehose_delivery_stream = aws.kinesis.FirehoseDeliveryStream("example",
            name="example-stream",
            destination="extended_s3",
            extended_s3_configuration={
                "role_arn": firehose.arn,
                "bucket_arn": example_bucket.arn,
            })
        example_log_delivery_configuration = aws.cognito.LogDeliveryConfiguration("example",
            user_pool_id=example.id,
            log_configurations=[
                {
                    "event_source": "userNotification",
                    "log_level": "INFO",
                    "cloud_watch_logs_configuration": {
                        "log_group_arn": example_log_group.arn,
                    },
                },
                {
                    "event_source": "userAuthEvents",
                    "log_level": "ERROR",
                    "firehose_configuration": {
                        "stream_arn": example_firehose_delivery_stream.arn,
                    },
                },
            ])
        ```

        ### S3 Configuration

        ```python
        import pulumi
        import pulumi_aws as aws

        example = aws.cognito.UserPool("example", name="example")
        example_bucket = aws.s3.Bucket("example",
            bucket="example-bucket",
            force_destroy=True)
        example_log_delivery_configuration = aws.cognito.LogDeliveryConfiguration("example",
            user_pool_id=example.id,
            log_configurations=[{
                "event_source": "userNotification",
                "log_level": "ERROR",
                "s3_configuration": {
                    "bucket_arn": example_bucket.arn,
                },
            }])
        ```

        ## Import

        Using `pulumi import`, import Cognito IDP (Identity Provider) Log Delivery Configuration using the `user_pool_id`. For example:

        ```sh
        $ pulumi import aws:cognito/logDeliveryConfiguration:LogDeliveryConfiguration example us-west-2_example123
        ```

        :param str resource_name: The name of the resource.
        :param LogDeliveryConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogDeliveryConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 log_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogDeliveryConfigurationLogConfigurationArgs', 'LogDeliveryConfigurationLogConfigurationArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogDeliveryConfigurationArgs.__new__(LogDeliveryConfigurationArgs)

            __props__.__dict__["log_configurations"] = log_configurations
            __props__.__dict__["region"] = region
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
        super(LogDeliveryConfiguration, __self__).__init__(
            'aws:cognito/logDeliveryConfiguration:LogDeliveryConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            log_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LogDeliveryConfigurationLogConfigurationArgs', 'LogDeliveryConfigurationLogConfigurationArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            user_pool_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'LogDeliveryConfiguration':
        """
        Get an existing LogDeliveryConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LogDeliveryConfigurationLogConfigurationArgs', 'LogDeliveryConfigurationLogConfigurationArgsDict']]]] log_configurations: Configuration block for log delivery. At least one configuration block is required. See Log Configurations below.
        :param pulumi.Input[_builtins.str] region: The AWS region.
        :param pulumi.Input[_builtins.str] user_pool_id: The ID of the user pool for which to configure log delivery.
               
               The following arguments are optional:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogDeliveryConfigurationState.__new__(_LogDeliveryConfigurationState)

        __props__.__dict__["log_configurations"] = log_configurations
        __props__.__dict__["region"] = region
        __props__.__dict__["user_pool_id"] = user_pool_id
        return LogDeliveryConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="logConfigurations")
    def log_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.LogDeliveryConfigurationLogConfiguration']]]:
        """
        Configuration block for log delivery. At least one configuration block is required. See Log Configurations below.
        """
        return pulumi.get(self, "log_configurations")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The AWS region.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the user pool for which to configure log delivery.

        The following arguments are optional:
        """
        return pulumi.get(self, "user_pool_id")

